/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;

public class JmsMapMessageImpl
extends JmsMessageImpl
implements MapMessage {
    private static final long serialVersionUID = -5270211659893353729L;
    private JsJmsMapMessage mapMsg;
    private transient String cachedMapToString = null;
    private static TraceComponent tc = Tr.register((Class)JmsMapMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = Tr.register((Class)JmsMapMessageImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsMapMessageImpl() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsMapMessageImpl");
        }
        this.messageClass = "jms_map";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMapMessageImpl");
        }
    }

    JmsMapMessageImpl(JsJmsMapMessage jsJmsMapMessage, JmsSessionImpl jmsSessionImpl) {
        super(jsJmsMapMessage, jmsSessionImpl);
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsMapMessageImpl(JsJmsMapMessage, JmsSessionImpl)");
        }
        this.mapMsg = jsJmsMapMessage;
        this.messageClass = "jms_map";
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMapMessageImpl(JsJmsMapMessage, JmsSessionImpl)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsMapMessageImpl(MapMessage mapMessage) throws JMSException {
        super((Message)mapMessage);
        try {
            Enumeration enumeration;
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "JmsMapMessageImpl(MapMessage)");
            }
            if ((enumeration = mapMessage.getMapNames()) != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Object object = mapMessage.getObject(string);
                    this.setObject(string, object);
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "JmsMapMessageImpl(MapMessage)");
            }
            throw throwable;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsMapMessageImpl(MapMessage)");
        }
    }

    public boolean getBoolean(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBoolean");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        boolean bl = false;
        try {
            bl = JmsMessageImpl.parseBoolean(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getBoolean");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBoolean");
        }
        return bl;
    }

    public byte getByte(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getByte");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        byte by = 0;
        try {
            by = JmsMessageImpl.parseByte(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getByte");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getByte");
        }
        return by;
    }

    public short getShort(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getShort");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        short s = 0;
        try {
            s = JmsMessageImpl.parseShort(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getShort");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getShort");
        }
        return s;
    }

    public char getChar(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getChar");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        char c = '\u0000';
        if (!(object instanceof Character)) {
            if (object == null) {
                RuntimeException runtimeException = (RuntimeException)JmsErrorUtils.newThrowable(NullPointerException.class, "FIELD_NOT_SET_CWSIA0105", new Object[]{string}, tc);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Field has not been set", runtimeException);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "getChar");
                }
                throw runtimeException;
            }
            MessageFormatException messageFormatException = JmsMapMessageImpl.newBadConvertException(object, string, "Character", tc);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid convert", messageFormatException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getChar");
            }
            throw messageFormatException;
        }
        c = ((Character)object).charValue();
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + c);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getChar");
        }
        return c;
    }

    public int getInt(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInt");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        int n = 0;
        try {
            n = JmsMessageImpl.parseInt(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getInt");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInt");
        }
        return n;
    }

    public long getLong(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getLong");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        long l = 0L;
        try {
            l = JmsMessageImpl.parseLong(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getLong");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getLong");
        }
        return l;
    }

    public float getFloat(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getFloat");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        float f = 0.0f;
        try {
            f = JmsMessageImpl.parseFloat(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getFloat");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getFloat");
        }
        return f;
    }

    public double getDouble(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getDouble");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        double d = 0.0;
        try {
            d = JmsMessageImpl.parseDouble(object, string);
        }
        catch (JMSException jMSException) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Error parsing object", (Object)jMSException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getDouble");
            }
            throw jMSException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getDouble");
        }
        return d;
    }

    public String getString(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getString");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        String string2 = null;
        if (object instanceof String || object == null) {
            string2 = (String)object;
        } else {
            if (object instanceof byte[]) {
                MessageFormatException messageFormatException = JmsMapMessageImpl.newBadConvertException(object, string, "String", tc);
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "invalid convert", messageFormatException);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "getString");
                }
                throw messageFormatException;
            }
            string2 = object.toString();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getString");
        }
        return string2;
    }

    public byte[] getBytes(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBytes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        Object object = this.mapMsg.getObject(string);
        byte[] byArray = null;
        if (object instanceof byte[]) {
            byte[] byArray2 = (byte[])object;
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        } else if (object == null) {
            byArray = null;
        } else {
            MessageFormatException messageFormatException = JmsMapMessageImpl.newBadConvertException(object, string, "Byte[]", tc);
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Invalid convert", messageFormatException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getBytes");
            }
            throw messageFormatException;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "value: " + byArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBytes");
        }
        return byArray;
    }

    public Object getObject(String string) throws JMSException {
        Object object;
        Object object2 = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getObject");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        if ((object = this.mapMsg.getObject(string)) instanceof byte[]) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            object2 = byArray2;
        } else {
            object2 = object;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "returning: " + object2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getObject");
        }
        return object2;
    }

    public Enumeration getMapNames() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getMapNames");
        }
        Enumeration enumeration = this.mapMsg.getMapNames();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMapNames");
        }
        return enumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(String string, boolean bl) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBoolean(String, boolean)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + bl);
        }
        try {
            this.checkBodyWriteable("setBoolean");
            this.checkPropName(string, "setBoolean");
            this.mapMsg.setBoolean(string, bl);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setBoolean(String, boolean)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBoolean(String, boolean)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(String string, byte by) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setByte(String, byte)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + by);
        }
        try {
            this.checkBodyWriteable("setByte");
            this.checkPropName(string, "setByte");
            this.mapMsg.setByte(string, by);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setByte(String, byte)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setByte(String, byte)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBytes(String, byte[])");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + byArray);
        }
        try {
            this.checkBodyWriteable("setBytes");
            this.checkPropName(string, "setBytes(String, byte[])");
            int n = 0;
            if (byArray != null) {
                n = byArray.length;
            }
            this.setBytes(string, byArray, 0, n);
            this.cachedMapToString = null;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setBytes(String, byte[])");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBytes(String, byte[])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setBytes(String, byte[], int, int)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + byArray);
        }
        try {
            this.checkBodyWriteable("setBytes");
            this.checkPropName(string, "setBytes(String, byte[], int, int)");
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
            this.mapMsg.setBytes(string, byArray2);
            this.cachedMapToString = null;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setBytes(String, byte[], int, int)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setBytes(String, byte[], int, int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChar(String string, char c) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setChar(String, char)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + c);
        }
        try {
            this.checkBodyWriteable("setChar");
            this.checkPropName(string, "setChar");
            this.mapMsg.setChar(string, c);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setChar(String, char)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setChar(String, char)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(String string, double d) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setDouble(String, double)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + d);
        }
        try {
            this.checkBodyWriteable("setDouble");
            this.checkPropName(string, "setDouble");
            this.mapMsg.setDouble(string, d);
            this.cachedMapToString = null;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setDouble(String, double)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setDouble(String, double)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(String string, float f) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setFloat(String, float)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + f);
        }
        try {
            this.checkBodyWriteable("setFloat");
            this.checkPropName(string, "setFloat");
            this.mapMsg.setFloat(string, f);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setFloat(String, float)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setFloat(String, float)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(String string, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setInt(String, int)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + n);
        }
        try {
            this.checkBodyWriteable("setInt");
            this.checkPropName(string, "setInt");
            this.mapMsg.setInt(string, n);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setInt(String, int)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setInt(String, int)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(String string, long l) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setLong(String, long)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + l);
        }
        try {
            this.checkBodyWriteable("setLong");
            this.checkPropName(string, "setLong");
            this.mapMsg.setLong(string, l);
            this.cachedMapToString = null;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setLong(String, long)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setLong(String, long)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String string, Object object) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setObject(String, object)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + object);
        }
        try {
            this.checkBodyWriteable("setObject");
            this.checkPropName(string, "setObject");
            if (!(object == null || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "value is bad type: " + object.getClass().getName());
                }
                throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0188", new Object[]{object.getClass().getName()}, tc);
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                object = byArray2;
            }
            this.mapMsg.setObject(string, object);
            this.cachedMapToString = null;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setObject(String, object)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setObject(String, object)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(String string, short s) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setShort(String, short)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + s);
        }
        try {
            this.checkBodyWriteable("setShort");
            this.checkPropName(string, "setShort");
            this.mapMsg.setShort(string, s);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setShort(String, short)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setShort(String, short)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(String string, String string2) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setString(String, String)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name=" + string);
            SibTr.debug(tc, "value=" + string2);
        }
        try {
            this.checkBodyWriteable("setString");
            this.checkPropName(string, "setString");
            this.mapMsg.setString(string, string2);
            this.cachedMapToString = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setString(String, String)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setString(String, String)");
        }
    }

    public boolean itemExists(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "itemExists");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "name: " + string);
        }
        boolean bl = this.mapMsg.itemExists(string);
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "exists: " + bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "itemExists");
        }
        return bl;
    }

    public String toString() {
        String string = super.toString();
        if (this.cachedMapToString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Enumeration enumeration = this.getMapNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Object object = this.getObject(string2);
                    if (object == null) {
                        object = "<null>";
                    }
                    stringBuffer.append("\n" + string2 + " = " + object);
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.cachedMapToString = stringBuffer.toString();
        }
        string = string + this.cachedMapToString;
        return string;
    }

    protected JsJmsMessage instantiateMessage() throws Exception {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "instantiateMessage");
        }
        JsJmsMapMessage jsJmsMapMessage = null;
        try {
            jsJmsMapMessage = jmfact.createJmsMapMessage();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "instantiateMessage");
            }
            throw messageCreateFailedException;
        }
        this.mapMsg = jsJmsMapMessage;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateMessage");
        }
        return jsJmsMapMessage;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsMapMessageImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.45");
        }
    }
}

