/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.api.jms.JmsConnInternals;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.JmsTemporaryDestinationInternal;
import com.ibm.ws.sib.api.jms.impl.ConnectionListenerImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.api.jms.ute.UTEHelperFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnection;
import com.ibm.ws.sib.api.jmsra.JmsJcaSession;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class JmsConnectionImpl
implements Connection,
JmsConnInternals,
ApiJmsConstants,
JmsInternalConstants {
    private static TraceComponent tc = SibTr.register(JmsConnectionImpl.class, "SIBJms_External", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceComponent tcInt = SibTr.register(JmsConnectionImpl.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    static int DEFAULT_DUPS_THRESHOLD;
    protected static SICoreConnectionFactory coreFact;
    private JmsJcaConnection jcaConnection;
    private SICoreConnection coreConnection;
    private boolean clientIDFixed;
    private boolean isManaged;
    private Map passThruProps = null;
    private List sessions;
    private List temporaryDestinations;
    private int state = 1;
    private final Object stateLock = new Object();
    private ExceptionListener el = null;
    private ConnectionListenerImpl connListener = null;
    private static Boolean isCloned;

    JmsConnectionImpl(JmsJcaConnection jmsJcaConnection, boolean bl, Map map) throws JMSException {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "JmsConnectionImpl(JmsJcaConnection, boolean, Map)");
        }
        this.passThruProps = map;
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "jcaConnection : " + jmsJcaConnection);
            SibTr.debug(tcInt, "isManaged : " + bl);
            SibTr.debug(tcInt, "clientId : " + this.passThruProps.get("clientID"));
            SibTr.debug(tcInt, "nonPersistentMapping : " + this.passThruProps.get("nonPersistentMapping"));
        }
        this.jcaConnection = jmsJcaConnection;
        String string = (String)this.passThruProps.get("clientID");
        if (string != null && !"".equals(string)) {
            this.fixClientID();
        }
        this.isManaged = bl;
        this.sessions = new ArrayList();
        this.temporaryDestinations = new ArrayList();
        this.setState(1);
        try {
            this.coreConnection = jmsJcaConnection.getSICoreConnection();
            if (this.coreConnection == null) {
                JMSException jMSException = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_RESOURCE_EXC_CWSIA0005", null, tcInt);
                JmsErrorUtils.processThrowable(jMSException, "JmsConnectionImpl#1", this, tcInt);
                throw jMSException;
            }
        }
        catch (javax.resource.spi.IllegalStateException illegalStateException) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{illegalStateException, "JmsConnectionImpl.getSICoreConnection"}, illegalStateException, "JmsConnectionImpl#2", this, tcInt);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "JmsConnectionImpl(JmsJcaConnection, boolean, Map)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        Object object;
        JmsSessionImpl jmsSessionImpl = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "createSession(boolean, int)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "transacted : " + bl);
                SibTr.debug(tc, "acknowledgeMode : " + n);
            }
            this.checkClosed();
            this.fixClientID();
            if (bl) {
                n = 0;
            }
            if (!bl && this.isManaged) {
                n = 1;
            }
            boolean bl2 = bl || n == 2 || n == 3;
            JmsJcaSession jmsJcaSession = this.createJcaSession(bl2);
            jmsSessionImpl = this.instantiateSession(bl, n, this.coreConnection, jmsJcaSession);
            object = this.stateLock;
            synchronized (object) {
                this.sessions.add(jmsSessionImpl);
            }
            object = jmsSessionImpl;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object var9_9 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "return Session : " + jmsSessionImpl);
                }
                if (!tc.isEntryEnabled()) break block12;
                SibTr.exit(tc, "createSession(boolean, int)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "return Session : " + jmsSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createSession(boolean, int)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() throws JMSException {
        Object object;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getClientID");
            }
            this.checkClosed();
            String string = null;
            object = this.stateLock;
            synchronized (object) {
                string = (String)this.passThruProps.get("clientID");
            }
            object = string;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var5_5 = null;
                if (!tc.isEntryEnabled()) break block7;
                SibTr.exit(tc, "getClientID");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getClientID");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientID(String string) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "setClientID");
        }
        this.checkClosed();
        if (this.isManaged) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"setClientID"}, tc);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (string == null || "".equals(string)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Ignoring null or empty clientID - does not affect fixed state.");
                }
            } else if (!this.clientIDFixed) {
                this.passThruProps.put("clientID", string);
                this.fixClientID();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "clientID set to " + string);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "Attempted to set clientID after it has been fixed.");
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "setClientID");
                }
                throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CLIENT_ID_FIXED_CWSIA0023", null, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setClientID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionMetaData getMetaData() throws JMSException {
        ConnectionMetaData connectionMetaData;
        try {
            ConnectionMetaData connectionMetaData2;
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getMetaData()");
            }
            this.checkClosed();
            connectionMetaData = connectionMetaData2 = JmsFactoryFactory.getInstance().getMetaData();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "getMetaData()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getMetaData()");
        }
        return connectionMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExceptionListener getExceptionListener() throws JMSException {
        ExceptionListener exceptionListener;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "getExceptionListener");
            }
            this.checkClosed();
            exceptionListener = this.el;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exit(tc, "getExceptionListener");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getExceptionListener");
        }
        return exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "setExceptionListener");
            }
            this.checkClosed();
            this.fixClientID();
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "listener: " + exceptionListener);
            }
            if (this.isManaged) {
                InvocationHandler invocationHandler;
                String string;
                boolean bl = true;
                if (exceptionListener instanceof Proxy && (string = (invocationHandler = Proxy.getInvocationHandler(exceptionListener)).getClass().getName()).startsWith("com.ibm")) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "async beans: exceptionListener accepted");
                    }
                    bl = false;
                }
                if (bl) {
                    throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"setExceptionListener"}, tc);
                }
            }
            this.el = exceptionListener;
            if (exceptionListener != null && this.connListener == null) {
                this.connListener = new ConnectionListenerImpl(this);
                try {
                    this.coreConnection.addConnectionListener(this.connListener);
                }
                catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIConnectionUnavailableException, "JmsConnectionImpl.setExceptionListener"}, sIConnectionUnavailableException, null, this, tc);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "setExceptionListener");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "setExceptionListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "start");
        }
        this.fixClientID();
        Object object = this.stateLock;
        synchronized (object) {
            int n = this.getState();
            if (n == 2 || n == 1) {
                Object[] objectArray = this.sessions.toArray();
                int n2 = 0;
                if (objectArray != null) {
                    n2 = objectArray.length;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "sessionCopy is null.");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "About to start " + n2 + " sessions.");
                }
                for (int i = 0; i < n2; ++i) {
                    ((JmsSessionImpl)objectArray[i]).start();
                }
                this.setState(2);
            } else if (n == 3) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "start");
                }
                this.checkClosed();
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "unknown state: " + n);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "stop");
        }
        if (this.isManaged) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"stop"}, tc);
        }
        this.fixClientID();
        Object object = this.stateLock;
        synchronized (object) {
            int n = this.getState();
            if (n == 2 || n == 1) {
                Object[] objectArray = this.sessions.toArray();
                int n2 = 0;
                if (objectArray != null) {
                    n2 = objectArray.length;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "sessionCopy is null.");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "About to stop " + n2 + " sessions.");
                }
                for (int i = 0; i < n2; ++i) {
                    ((JmsSessionImpl)objectArray[i]).stop();
                }
                this.setState(1);
            } else if (n == 3) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit(tc, "stop");
                }
                this.checkClosed();
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "Unknown state: " + n);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry(tc, "close()");
            }
            if (this.getState() != 3) {
                this.setState(3);
                this.fixClientID();
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "connection " + this + " aquiring sessions lock");
                }
                Object object = this.stateLock;
                synchronized (object) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug(tc, "connection " + this + " acquired sessions lock");
                    }
                    Object[] objectArray = this.sessions.toArray();
                    for (int i = 0; i < objectArray.length; ++i) {
                        ((Session)objectArray[i]).close();
                    }
                    this.sessions.clear();
                    Object[] objectArray2 = this.temporaryDestinations.toArray();
                    for (int i = 0; i < objectArray2.length; ++i) {
                        ((JmsTemporaryDestinationInternal)objectArray2[i]).delete();
                    }
                    this.temporaryDestinations.clear();
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "connection " + this + " released sessions lock");
                }
                if (this.connListener != null && this.coreConnection != null) {
                    try {
                        this.coreConnection.removeConnectionListener(this.connListener);
                    }
                    catch (SIConnectionUnavailableException sIConnectionUnavailableException) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIConnectionUnavailableException, "JmsConnectionImpl.close"}, sIConnectionUnavailableException, null, this, tc);
                    }
                }
                if (this.coreConnection != null) {
                    try {
                        this.coreConnection.close();
                    }
                    catch (SIException sIException) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIException, "JmsConnectionImpl.close"}, sIException, null, this, tc);
                    }
                    catch (SIErrorException sIErrorException) {
                        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIErrorException, "JmsConnectionImpl.close"}, sIErrorException, "JmsConnectionImpl.close#1", this, tc);
                    }
                }
                try {
                    this.jcaConnection.close();
                }
                catch (SIException sIException) {
                    throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{sIException, "JmsConnectionImpl.close"}, sIException, "JmsConnectionImpl.close#2", this, tc);
                }
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "close()");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close()");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createConnectionConsumer");
        }
        if (this.isManaged) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"createConnectionConsumer"}, tc);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Not supported.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createConnectionConsumer");
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createConnectionConsumer()"}, tc);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createDurableConnectionConsumer");
        }
        if (this.isManaged) {
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "MGD_ENV_CWSIA0025", new Object[]{"createDurableConnectionConsumer"}, tc);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Not supported.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createDurableConnectionConsumer");
        }
        throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "UNSUPPORTED_FUNC_CWSIA0026", new Object[]{"JmsConnectionImpl.createDurableConnectionConsumer()"}, tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportException(JMSException jMSException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "reportException");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Exception to be delivered to ExceptionListener", (Object)jMSException);
        }
        if (this.el != null) {
            Object object = this.stateLock;
            synchronized (object) {
                block10: {
                    try {
                        this.el.onException(jMSException);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!tc.isDebugEnabled()) break block10;
                        SibTr.debug(tc, "User ExceptionListener threw exception", runtimeException);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "No exception listener has been set for this connection.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "reportException");
        }
    }

    public String getConnectedMEName() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getConnectedMEName");
        }
        String string = this.coreConnection.getMeName();
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "meName: " + string);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "getConnectedMEName");
        }
        return string;
    }

    public void createDestination(Destination destination) throws JMSException {
        UTEHelperFactory.getHelperInstance().createDestination(destination);
    }

    public void deleteDestination(Destination destination) throws JMSException {
        UTEHelperFactory.getHelperInstance().deleteDestination(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JmsSessionImpl instantiateSession(boolean bl, int n, SICoreConnection sICoreConnection, JmsJcaSession jmsJcaSession) throws JMSException {
        JmsSessionImpl jmsSessionImpl;
        JmsSessionImpl jmsSessionImpl2 = null;
        try {
            if (tcInt.isEntryEnabled()) {
                SibTr.entry(tcInt, "instantiateSession(boolean, int, SICoreConnection, JmsJcaSession)");
            }
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "transacted : " + bl);
                SibTr.debug(tcInt, "acknowledgeMode : " + n);
                SibTr.debug(tcInt, "coreConnection : " + sICoreConnection);
                SibTr.debug(tcInt, "jcaSession : " + jmsJcaSession);
            }
            jmsSessionImpl = jmsSessionImpl2 = new JmsSessionImpl(bl, n, sICoreConnection, this, jmsJcaSession);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var8_8 = null;
                if (tcInt.isDebugEnabled()) {
                    SibTr.debug(tcInt, "return JmsSessionImpl : " + jmsSessionImpl2);
                }
                if (!tcInt.isEntryEnabled()) break block7;
                SibTr.exit(tcInt, "instantiateSession(boolean, int, SICoreConnection, JmsJcaSession)");
            }
            throw throwable;
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "return JmsSessionImpl : " + jmsSessionImpl2);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "instantiateSession(boolean, int, SICoreConnection, JmsJcaSession)");
        }
        return jmsSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(JmsSessionImpl jmsSessionImpl) {
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = this.sessions.remove(jmsSessionImpl);
            if (!bl && tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "session not found in list");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionCount() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.sessions.size();
        }
    }

    protected SICoreConnection getCoreConnection() {
        return this.coreConnection;
    }

    public List getSessionList() {
        return this.sessions;
    }

    public Object getStateLock() {
        return this.stateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getState() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "getState");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (tcInt.isDebugEnabled()) {
                SibTr.debug(tcInt, "state: " + this.state);
            }
            if (tcInt.isEntryEnabled()) {
                SibTr.exit(tcInt, "getState");
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int n) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setState(int)");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "newState : " + n);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (n == 3 || n == 1 || n == 2) {
                this.state = n;
                this.stateLock.notifyAll();
            }
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setState(int)");
        }
    }

    protected void checkClosed() throws JMSException {
        if (this.isClosed()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "This Connection is closed.");
            }
            throw (IllegalStateException)JmsErrorUtils.newThrowable(IllegalStateException.class, "CONNECTION_CLOSED_CWSIA0021", null, tcInt);
        }
    }

    protected boolean isClosed() {
        return this.getState() == 3;
    }

    boolean isManaged() {
        return this.isManaged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixClientID() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "fixClientID");
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.clientIDFixed = true;
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "fixClientID");
        }
    }

    JmsJcaConnection getJCACon() {
        return this.jcaConnection;
    }

    int getTempDestCount() {
        return this.temporaryDestinations.size();
    }

    protected JmsJcaSession createJcaSession(boolean bl) throws JMSException {
        JmsJcaSession jmsJcaSession = null;
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "createJcaSession");
        }
        if (this.jcaConnection != null) {
            try {
                jmsJcaSession = this.jcaConnection.createSession(bl);
            }
            catch (Exception exception) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "JCA_CREATE_SESS_CWSIA0024", null, exception, "JmsConnectionImpl.createSession#1", this, tcInt);
            }
        } else if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "jcaConnection is null, returning null jcaSess");
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "createJcaSession");
        }
        return jmsJcaSession;
    }

    protected Map getPassThruProps() {
        return this.passThruProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemporaryDestination(JmsTemporaryDestinationInternal jmsTemporaryDestinationInternal) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "addTemporaryDestination");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "adding " + System.identityHashCode(jmsTemporaryDestinationInternal));
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.temporaryDestinations.add(jmsTemporaryDestinationInternal);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "addTemporaryDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTemporaryDestination(JmsTemporaryDestinationInternal jmsTemporaryDestinationInternal) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "removeTemporaryDestination");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "removing " + System.identityHashCode(jmsTemporaryDestinationInternal));
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.temporaryDestinations.remove(jmsTemporaryDestinationInternal);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "removeTemporaryDestination");
        }
    }

    public static boolean isClonedServer() {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "isClonedServer");
        }
        if (isCloned == null) {
            isCloned = new Boolean(RuntimeInfo.isClusteredServer());
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "returns: " + isCloned);
        }
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "isClonedServer");
        }
        return isCloned;
    }

    public static void setIsClonedServer(Boolean bl) {
        if (tcInt.isEntryEnabled()) {
            SibTr.entry(tcInt, "setIsClonedServer");
        }
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "param: " + bl);
        }
        isCloned = bl;
        if (tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "setIsClonedServer");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ConnectionId: " + Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append(", MEName: " + this.coreConnection.getMeName());
        stringBuffer.append(", Sessions: " + this.sessions.size());
        stringBuffer.append(", TemporaryDestinations: " + this.temporaryDestinations.size());
        return stringBuffer.toString();
    }

    static {
        if (tcInt.isDebugEnabled()) {
            SibTr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms.impl/src/com/ibm/ws/sib/api/jms/impl/JmsConnectionImpl.java, SIB.api.jms, WAS602.SIB, o0610.11 1.81");
        }
        DEFAULT_DUPS_THRESHOLD = 20;
        isCloned = null;
    }
}

