/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms;

import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.jms.JMSException;

public class StringArrayWrapper
implements Serializable {
    private static final long serialVersionUID = 3870265914027831694L;
    private List fullMsgPath = null;
    public static final String BUS_SEPARATOR = ":";

    public StringArrayWrapper(List list) throws JMSException {
        this.fullMsgPath = list;
    }

    public static StringArrayWrapper create(String[] stringArray, String string) throws JMSException {
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        ArrayList<SIDestinationAddress> arrayList = new ArrayList<SIDestinationAddress>(n + 1);
        if (n > 0) {
            Object object;
            for (int i = 0; i < n; ++i) {
                object = stringArray[i];
                String string2 = null;
                if (((String)object).indexOf(BUS_SEPARATOR) != -1) {
                    string2 = ((String)object).substring(((String)object).indexOf(BUS_SEPARATOR) + 1);
                    object = ((String)object).substring(0, ((String)object).indexOf(BUS_SEPARATOR));
                }
                try {
                    SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress((String)object, string2);
                    arrayList.add(sIDestinationAddress);
                    continue;
                }
                catch (Exception exception) {
                    JMSException jMSException = new JMSException(exception.getMessage());
                    jMSException.setLinkedException(exception);
                    jMSException.initCause((Throwable)exception);
                }
            }
            if (string != null) {
                try {
                    SIDestinationAddress sIDestinationAddress = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(string, null);
                    arrayList.add(sIDestinationAddress);
                }
                catch (Exception exception) {
                    object = new JMSException(exception.getMessage());
                    object.setLinkedException(exception);
                    object.initCause((Throwable)exception);
                }
            }
        }
        StringArrayWrapper stringArrayWrapper = new StringArrayWrapper(arrayList);
        return stringArrayWrapper;
    }

    public List getMsgForwardRoutingPath() {
        return this.fullMsgPath.subList(1, this.fullMsgPath.size());
    }

    public String[] getArray() {
        String[] stringArray = null;
        stringArray = new String[this.fullMsgPath.size() - 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((SIDestinationAddress)this.fullMsgPath.get(i)).getDestinationName();
        }
        return stringArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof StringArrayWrapper) {
            StringArrayWrapper stringArrayWrapper = (StringArrayWrapper)object;
            if (stringArrayWrapper.fullMsgPath == this.fullMsgPath) {
                return true;
            }
            if (stringArrayWrapper.fullMsgPath.size() != this.fullMsgPath.size()) {
                return false;
            }
            for (int i = 0; i < this.fullMsgPath.size(); ++i) {
                if (stringArrayWrapper.fullMsgPath.get(i).equals(this.fullMsgPath.get(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public List getCorePath() {
        return this.fullMsgPath.subList(0, this.fullMsgPath.size() - 1);
    }

    public SIDestinationAddress getProducerSIDestAddress() {
        return (SIDestinationAddress)this.fullMsgPath.get(0);
    }

    public String toString() {
        List list = this.getCorePath();
        ListIterator listIterator = list.listIterator();
        String string = "";
        while (listIterator.hasNext()) {
            SIDestinationAddress sIDestinationAddress = (SIDestinationAddress)listIterator.next();
            string = string + sIDestinationAddress.getDestinationName();
            if (sIDestinationAddress.getBusName() != null && !"".equals(sIDestinationAddress.getBusName())) {
                string = string + BUS_SEPARATOR + sIDestinationAddress.getBusName();
            }
            if (!listIterator.hasNext()) continue;
            string = string + "<#>";
        }
        return string;
    }
}

