/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityAdminHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityBusCommandProvider;
import com.ibm.ws.security.commands.sib.SIBSecurityCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBSecurityForeignBusCommandProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBSecurityBusCommandProvider.class, "CWSJD", "com.ibm.ws.security.commands.sib.CWSJDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.security.commands.sib.CWSJDMessages");
    private ConfigService configService = ConfigServiceFactory.getConfigService();

    public ObjectName addUserToForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addUserToForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createUserIfRequired(session, string5, objectName3);
        ObjectName objectName5 = this.getRoleForForeignBus(session, string3, string4, objectName3);
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
        arrayList.add(objectName4);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
        this.configService.setAttributes(session, objectName5, attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public ObjectName addGroupToForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addGroupToForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createGroupIfRequired(session, string5, objectName3);
        ObjectName objectName5 = this.getRoleForForeignBus(session, string3, string4, objectName3);
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
        arrayList.add(objectName4);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
        this.configService.setAttributes(session, objectName5, attributeList);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public void removeUserFromForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        Object object;
        String string = "removeUserFromForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        String string5 = (String)abstractAdminCommand.getParameter("user");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
            if (!((String)object).equals(string3)) continue;
            objectName5 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NAME_NOT_FOUND_CWSJD0301", new Object[]{string3}, null));
        }
        ObjectName objectName6 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName6 = SIBSecurityAdminHelper.getSenderRole(session, objectName5, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName5, string4);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0300", new Object[]{string4}, null));
        }
        object = (ArrayList)this.configService.getAttribute(session, objectName6, "user");
        Iterator iterator = ((ArrayList)object).iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string6 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string6.equalsIgnoreCase(string5)) continue;
            bl2 = true;
            ((ArrayList)object).remove(serializable);
            break;
        }
        if (!bl2) {
            throw new SIBSecurityCommandException("CWSJD0102: User name '" + string5 + "' is unknown.");
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)object);
        this.configService.setAttributes(session, objectName6, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeUserIfOrphaned(string5, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName6);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName5)) {
            this.configService.deleteConfigData(session, objectName5);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeGroupFromForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        String string;
        String string2 = "removeGroupFromForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("role");
        String string6 = (String)abstractAdminCommand.getParameter("group");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            string = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
            if (!string.equals(string4)) continue;
            objectName5 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NAME_NOT_FOUND_CWSJD0301", new Object[]{string4}, null));
        }
        Object var15_16 = null;
        string = null;
        ObjectName objectName6 = null;
        if (string5.equalsIgnoreCase("sender")) {
            objectName6 = SIBSecurityAdminHelper.getSenderRole(session, objectName5, string5);
        } else if (string5.equalsIgnoreCase("identityAdopter")) {
            objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName5, string5);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0300", new Object[]{string5}, null));
        }
        ArrayList arrayList = (ArrayList)this.configService.getAttribute(session, objectName6, "group");
        Iterator iterator = arrayList.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            serializable = (ObjectName)iterator.next();
            String string7 = (String)this.configService.getAttribute(session, serializable, "identifier");
            if (!string7.equalsIgnoreCase(string6)) continue;
            bl2 = true;
            arrayList.remove(serializable);
            break;
        }
        if (!bl2) {
            throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string6 + "' is unknown.");
        }
        serializable = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
        this.configService.setAttributes(session, objectName6, (AttributeList)serializable);
        SIBSecurityAdminHelper.removeGroupIfOrphaned(string6, session, objectName3);
        SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName6);
        if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName5)) {
            this.configService.deleteConfigData(session, objectName5);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, null);
        }
    }

    public String[] listUsersInForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        String string = "listUsersInForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
            if (!((String)object).equals(string3)) continue;
            objectName5 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NAME_NOT_FOUND_CWSJD0301", new Object[]{string3}, null));
        }
        ObjectName objectName6 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName6 = SIBSecurityAdminHelper.getSenderRole(session, objectName5, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName5, string4);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0300", new Object[]{string4}, null));
        }
        object = (List)this.configService.getAttribute(session, objectName6, "user");
        ObjectName[] objectNameArray2 = new ObjectName[object.size()];
        objectNameArray2 = object.toArray(objectNameArray2);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    public String[] listGroupsInForeignBusRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        String string = "listGroupsInForeignBusRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string4 = (String)abstractAdminCommand.getParameter("role");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string2);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
        ObjectName objectName5 = null;
        boolean bl = false;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
            if (!((String)object).equals(string3)) continue;
            objectName5 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NAME_NOT_FOUND_CWSJD0301", new Object[]{string3}, null));
        }
        ObjectName objectName6 = null;
        if (string4.equalsIgnoreCase("sender")) {
            objectName6 = SIBSecurityAdminHelper.getSenderRole(session, objectName5, string4);
        } else if (string4.equalsIgnoreCase("identityAdopter")) {
            objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName5, string4);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0300", new Object[]{string4}, null));
        }
        object = (List)this.configService.getAttribute(session, objectName6, "group");
        ObjectName[] objectNameArray2 = new ObjectName[object.size()];
        objectNameArray2 = object.toArray(objectNameArray2);
        String[] stringArray = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return stringArray;
    }

    private ObjectName getRoleForForeignBus(Session session, String string, String string2, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createForeignBusIfRequired(session, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string2.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0300", new Object[]{string2}, null));
        }
        return objectName4;
    }
}

