/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityAdminHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityBusCommandProvider;
import com.ibm.ws.security.commands.sib.SIBSecurityCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBSecurityDestinationCommandProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBSecurityBusCommandProvider.class, "CWSJD", "com.ibm.ws.security.commands.sib.CWSJDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.security.commands.sib.CWSJDMessages");
    private ConfigService configService = ConfigServiceFactory.getConfigService();

    public ObjectName addUserToDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addUserToDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        String string7 = (String)abstractAdminCommand.getParameter("user");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createUserIfRequired(session, string7, objectName3);
        Object var15_15 = null;
        Object var16_16 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Serializable serializable;
            ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string5, objectName3);
            ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
            ObjectName objectName7 = null;
            if (objectNameArray.length == 0) {
                serializable = new AttributeList();
                objectName7 = this.configService.createConfigData(session, objectName5, "topicSpaceBase", "SIBAuthTopicSpaceBase", serializable);
            } else {
                objectName7 = objectNameArray[0];
            }
            serializable = this.getRoleForTopicSpaceBase(session, string6, objectName7);
            arrayList = (ArrayList)this.configService.getAttribute(session, (ObjectName)serializable, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, (ObjectName)serializable, attributeList);
        } else if (string2.equalsIgnoreCase("queue")) {
            ObjectName objectName8 = this.getRoleForQueue(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName8, attributeList);
        } else if (string2.equalsIgnoreCase("webService")) {
            ObjectName objectName9 = this.getRoleForWebService(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName9, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName9, attributeList);
        } else if (string2.equalsIgnoreCase("port")) {
            ObjectName objectName10 = this.getRoleForPort(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName10, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName10, attributeList);
        } else if (string2.equalsIgnoreCase("alias")) {
            ObjectName objectName11 = this.getRoleForAlias(session, string3, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName11, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName11, attributeList);
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            ObjectName objectName12 = this.getRoleForForeignDestination(session, string4, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName12, "user");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName12, attributeList);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public ObjectName addGroupToDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addGroupToDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        String string7 = (String)abstractAdminCommand.getParameter("group");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = SIBSecurityAdminHelper.createGroupIfRequired(session, string7, objectName3);
        Object var15_15 = null;
        Object var16_16 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Serializable serializable;
            ObjectName objectName5 = SIBSecurityAdminHelper.createTopicSpaceIfRequired(session, string5, objectName3);
            ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName5, objectName6, null);
            ObjectName objectName7 = null;
            if (objectNameArray.length == 0) {
                serializable = new AttributeList();
                objectName7 = this.configService.createConfigData(session, objectName5, "topicSpaceBase", "SIBAuthTopicSpaceBase", serializable);
            } else {
                objectName7 = objectNameArray[0];
            }
            serializable = this.getRoleForTopicSpaceBase(session, string6, objectName7);
            arrayList = (ArrayList)this.configService.getAttribute(session, (ObjectName)serializable, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, (ObjectName)serializable, attributeList);
        } else if (string2.equalsIgnoreCase("queue")) {
            ObjectName objectName8 = this.getRoleForQueue(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName8, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName8, attributeList);
        } else if (string2.equalsIgnoreCase("webService")) {
            ObjectName objectName9 = this.getRoleForWebService(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName9, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName9, attributeList);
        } else if (string2.equalsIgnoreCase("port")) {
            ObjectName objectName10 = this.getRoleForPort(session, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName10, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName10, attributeList);
        } else if (string2.equalsIgnoreCase("alias")) {
            ObjectName objectName11 = this.getRoleForAlias(session, string3, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName11, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName11, attributeList);
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            ObjectName objectName12 = this.getRoleForForeignDestination(session, string4, string5, string6, objectName3);
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName12, "group");
            arrayList.add(objectName4);
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName12, attributeList);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return objectName4;
    }

    public void removeUserFromDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeUserFromDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        String string7 = (String)abstractAdminCommand.getParameter("user");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName5 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Serializable serializable;
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName6 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!((String)object).equals(string5)) continue;
                objectName6 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string5}, null));
            }
            ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            object = this.configService.queryConfigObjects(session, objectName6, objectName7, null)[0];
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string8 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string8.equalsIgnoreCase(string7)) continue;
                bl2 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl2) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName6)) {
                this.configService.deleteConfigData(session, objectName6);
            }
        } else if (string2.equalsIgnoreCase("queue")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName8 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string9.equals(string5)) continue;
                objectName8 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName8, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl3 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string10 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string10.equalsIgnoreCase(string7)) continue;
                bl3 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl3) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName8)) {
                this.configService.deleteConfigData(session, objectName8);
            }
        } else if (string2.equalsIgnoreCase("webService")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName9 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string11 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string11.equals(string5)) continue;
                objectName9 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName9, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl4 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string12 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string12.equalsIgnoreCase(string7)) continue;
                bl4 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl4) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName9)) {
                this.configService.deleteConfigData(session, objectName9);
            }
        } else if (string2.equalsIgnoreCase("port")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName10 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string13 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string13.equals(string5)) continue;
                objectName10 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName10, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl5 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string14 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string14.equalsIgnoreCase(string7)) continue;
                bl5 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl5) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName10)) {
                this.configService.deleteConfigData(session, objectName10);
            }
        } else if (string2.equalsIgnoreCase("alias")) {
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName11 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string15 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string15.equals(string5) || !((String)object).equals(string3)) continue;
                objectName11 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName11, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl6 = false;
            while (iterator.hasNext()) {
                object = (ObjectName)iterator.next();
                String string16 = (String)this.configService.getAttribute(session, (ObjectName)object, "identifier");
                if (!string16.equalsIgnoreCase(string7)) continue;
                bl6 = true;
                arrayList.remove(object);
                break;
            }
            if (!bl6) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)object);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName11)) {
                this.configService.deleteConfigData(session, objectName11);
            }
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName12 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string17 = (String)this.configService.getAttribute(session, objectNameArray[i], "destinationName");
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string17.equals(string5) || !((String)object).equals(string4)) continue;
                objectName12 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_DEST_NOT_FOUND_CWSJD0207", new Object[]{string3, string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName12, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName12, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "user");
            Iterator iterator = arrayList.iterator();
            boolean bl7 = false;
            while (iterator.hasNext()) {
                object = (ObjectName)iterator.next();
                String string18 = (String)this.configService.getAttribute(session, (ObjectName)object, "identifier");
                if (!string18.equalsIgnoreCase(string7)) continue;
                bl7 = true;
                arrayList.remove(object);
                break;
            }
            if (!bl7) {
                throw new SIBSecurityCommandException("CWSJD0102: User name '" + string7 + "' is unknown.");
            }
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"user", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)object);
            SIBSecurityAdminHelper.removeUserIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName12)) {
                this.configService.deleteConfigData(session, objectName12);
            }
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public void removeGroupFromDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeGroupFromDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ArrayList arrayList = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        String string7 = (String)abstractAdminCommand.getParameter("group");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName5 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Serializable serializable;
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName6 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!((String)object).equals(string5)) continue;
                objectName6 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string5}, null));
            }
            ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            object = this.configService.queryConfigObjects(session, objectName6, objectName7, null)[0];
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string8 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string8.equalsIgnoreCase(string7)) continue;
                bl2 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl2) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName6)) {
                this.configService.deleteConfigData(session, objectName6);
            }
        } else if (string2.equalsIgnoreCase("queue")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName8 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string9.equals(string5)) continue;
                objectName8 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName8, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName8, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl3 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string10 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string10.equalsIgnoreCase(string7)) continue;
                bl3 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl3) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName8)) {
                this.configService.deleteConfigData(session, objectName8);
            }
        } else if (string2.equalsIgnoreCase("webService")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName9 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string11 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string11.equals(string5)) continue;
                objectName9 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName9, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName9, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl4 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string12 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string12.equalsIgnoreCase(string7)) continue;
                bl4 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl4) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName9)) {
                this.configService.deleteConfigData(session, objectName9);
            }
        } else if (string2.equalsIgnoreCase("port")) {
            Serializable serializable;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName10 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string13 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string13.equals(string5)) continue;
                objectName10 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName10, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                objectName5 = SIBSecurityAdminHelper.getCreatorRole(session, objectName10, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl5 = false;
            while (iterator.hasNext()) {
                serializable = (ObjectName)iterator.next();
                String string14 = (String)this.configService.getAttribute(session, serializable, "identifier");
                if (!string14.equalsIgnoreCase(string7)) continue;
                bl5 = true;
                arrayList.remove(serializable);
                break;
            }
            if (!bl5) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)serializable);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName10)) {
                this.configService.deleteConfigData(session, objectName10);
            }
        } else if (string2.equalsIgnoreCase("alias")) {
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName11 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string15 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string15.equals(string5) || !((String)object).equals(string3)) continue;
                objectName11 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName5 = SIBSecurityAdminHelper.getReceiverRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName11, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                objectName5 = SIBSecurityAdminHelper.getBrowserRole(session, objectName11, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl6 = false;
            while (iterator.hasNext()) {
                object = (ObjectName)iterator.next();
                String string16 = (String)this.configService.getAttribute(session, (ObjectName)object, "identifier");
                if (!string16.equalsIgnoreCase(string7)) continue;
                bl6 = true;
                arrayList.remove(object);
                break;
            }
            if (!bl6) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)object);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName11)) {
                this.configService.deleteConfigData(session, objectName11);
            }
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            Object object;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName12 = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string17 = (String)this.configService.getAttribute(session, objectNameArray[i], "destinationName");
                object = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string17.equals(string5) || !((String)object).equals(string4)) continue;
                objectName12 = objectNameArray[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_DEST_NOT_FOUND_CWSJD0207", new Object[]{string3, string5}, null));
            }
            if (string6.equalsIgnoreCase("sender")) {
                objectName5 = SIBSecurityAdminHelper.getSenderRole(session, objectName12, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName5 = SIBSecurityAdminHelper.getIdAdopterRole(session, objectName12, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            arrayList = (ArrayList)this.configService.getAttribute(session, objectName5, "group");
            Iterator iterator = arrayList.iterator();
            boolean bl7 = false;
            while (iterator.hasNext()) {
                object = (ObjectName)iterator.next();
                String string18 = (String)this.configService.getAttribute(session, (ObjectName)object, "identifier");
                if (!string18.equalsIgnoreCase(string7)) continue;
                bl7 = true;
                arrayList.remove(object);
                break;
            }
            if (!bl7) {
                throw new SIBSecurityCommandException("CWSJD0103: Group name '" + string7 + "' is unknown.");
            }
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"group", (Object)arrayList);
            this.configService.setAttributes(session, objectName5, (AttributeList)object);
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string7, session, objectName3);
            SIBSecurityAdminHelper.removeRoleIfOrphaned(session, objectName5);
            if (SIBSecurityAdminHelper.destinationIsEmpty(session, objectName12)) {
                this.configService.deleteConfigData(session, objectName12);
            }
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
    }

    public String[] listUsersInDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        String string = "listUsersInDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        List list = null;
        ObjectName[] objectNameArray = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray2 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Object object2;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object2 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object2).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string5}, null));
            }
            ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            object2 = this.configService.queryConfigObjects(session, object, objectName5, null)[0];
            Object var20_41 = null;
            ObjectName objectName6 = null;
            if (string6.equalsIgnoreCase("sender")) {
                objectName6 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object2, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName6 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object2, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object2, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, objectName6, "user");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("queue")) {
            Object object3;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object3 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object3).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string5}, null));
            }
            Object var18_26 = null;
            object3 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object3 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object3 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object3 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object3 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object3 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object3, "user");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("webService")) {
            Object object4;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object4 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object4).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string5}, null));
            }
            Object var18_28 = null;
            object4 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object4 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object4 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object4 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object4 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object4 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object4, "user");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("port")) {
            Object object5;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object5 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object5).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string5}, null));
            }
            Object var18_30 = null;
            object5 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object5 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object5 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object5 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object5 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object5 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object5, "user");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("alias")) {
            Object object6;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object6 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                String string7 = (String)this.configService.getAttribute(session, objectNameArray2[i], "busName");
                if (!((String)object6).equals(string5) || !string7.equals(string3)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string5}, null));
            }
            Object var18_32 = null;
            object6 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object6 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object6 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object6 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object6 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object6, "user");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            Object object7;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object7 = (String)this.configService.getAttribute(session, objectNameArray2[i], "destinationName");
                String string8 = (String)this.configService.getAttribute(session, objectNameArray2[i], "busName");
                if (!((String)object7).equals(string5) || !string8.equals(string4)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_DEST_NOT_FOUND_CWSJD0207", new Object[]{string3, string5}, null));
            }
            Object var18_34 = null;
            object7 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object7 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object7 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object7, "user");
            objectNameArray = new ObjectName[list.size()];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        objectNameArray = list.toArray(objectNameArray);
        object = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return object;
    }

    public String[] listGroupsInDestinationRole(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        String string = "listGroupsInDestinationRole";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        List list = null;
        ObjectName[] objectNameArray = null;
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("foreignBus");
        String string5 = (String)abstractAdminCommand.getParameter("destination");
        String string6 = (String)abstractAdminCommand.getParameter("role");
        if (string2.equalsIgnoreCase("foreignDestination") && (string4 == null || "".equals(string4))) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_BUS_NOT_SPECIFIED_CWSJD0206", null, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray2 = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            Object object2;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object2 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object2).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string5}, null));
            }
            ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpaceBase", null);
            object2 = this.configService.queryConfigObjects(session, object, objectName5, null)[0];
            Object var20_41 = null;
            ObjectName objectName6 = null;
            if (string6.equalsIgnoreCase("sender")) {
                objectName6 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object2, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                objectName6 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object2, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                objectName6 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object2, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, objectName6, "group");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("queue")) {
            Object object3;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object3 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object3).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string5}, null));
            }
            Object var18_26 = null;
            object3 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object3 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object3 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object3 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object3 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object3 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object3, "group");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("webService")) {
            Object object4;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object4 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object4).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string5}, null));
            }
            Object var18_28 = null;
            object4 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object4 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object4 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object4 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object4 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object4 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object4, "group");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("port")) {
            Object object5;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object5 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                if (!((String)object5).equals(string5)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string5}, null));
            }
            Object var18_30 = null;
            object5 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object5 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object5 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object5 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object5 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("creator")) {
                object5 = SIBSecurityAdminHelper.getCreatorRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object5, "group");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("alias")) {
            Object object6;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object6 = (String)this.configService.getAttribute(session, objectNameArray2[i], "identifier");
                String string7 = (String)this.configService.getAttribute(session, objectNameArray2[i], "busName");
                if (!((String)object6).equals(string5) || !string7.equals(string3)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string5}, null));
            }
            Object var18_32 = null;
            object6 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object6 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("receiver")) {
                object6 = SIBSecurityAdminHelper.getReceiverRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object6 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("browser")) {
                object6 = SIBSecurityAdminHelper.getBrowserRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object6, "group");
            objectNameArray = new ObjectName[list.size()];
        } else if (string2.equalsIgnoreCase("foreignDestination")) {
            Object object7;
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
            objectNameArray2 = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            object = null;
            boolean bl = false;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                object7 = (String)this.configService.getAttribute(session, objectNameArray2[i], "destinationName");
                String string8 = (String)this.configService.getAttribute(session, objectNameArray2[i], "busName");
                if (!((String)object7).equals(string5) || !string8.equals(string4)) continue;
                object = objectNameArray2[i];
                bl = true;
                break;
            }
            if (!bl) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("FOREIGN_DEST_NOT_FOUND_CWSJD0207", new Object[]{string3, string5}, null));
            }
            Object var18_34 = null;
            object7 = null;
            if (string6.equalsIgnoreCase("sender")) {
                object7 = SIBSecurityAdminHelper.getSenderRole(session, (ObjectName)object, string6);
            } else if (string6.equalsIgnoreCase("identityAdopter")) {
                object7 = SIBSecurityAdminHelper.getIdAdopterRole(session, (ObjectName)object, string6);
            } else {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string6}, null));
            }
            list = (List)this.configService.getAttribute(session, (ObjectName)object7, "group");
            objectNameArray = new ObjectName[list.size()];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        objectNameArray = list.toArray(objectNameArray);
        object = SIBSecurityAdminHelper.convertToStringArray(session, objectNameArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return object;
    }

    public ObjectName setInheritDefaultsForDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "setInheritDefaultsForDestination";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("destination");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("inherit");
        if (string2.equalsIgnoreCase("foreignDestination")) {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_TYPE_PARAM_CWSJD0200", new Object[]{string2}, null));
        }
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName5 = null;
            boolean bl2 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string5 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string5.equals(string4)) continue;
                objectName5 = objectNameArray[i];
                bl2 = true;
                break;
            }
            if (!bl2) {
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string4);
                objectName5 = this.configService.createConfigData(session, objectName3, "topicSpace", "SIBAuthTopicSpace", attributeList);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritDefaults", (Object)bl);
            this.configService.setAttributes(session, objectName5, attributeList);
        } else if (string2.equalsIgnoreCase("queue")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName6 = null;
            boolean bl3 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string6 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string6.equals(string4)) continue;
                objectName6 = objectNameArray[i];
                bl3 = true;
                break;
            }
            if (!bl3) {
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string4);
                objectName6 = this.configService.createConfigData(session, objectName3, "queue", "SIBAuthQueue", attributeList);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritDefaults", (Object)bl);
            this.configService.setAttributes(session, objectName6, attributeList);
        } else if (string2.equalsIgnoreCase("webService")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName7 = null;
            boolean bl4 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string7 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string7.equals(string4)) continue;
                objectName7 = objectNameArray[i];
                bl4 = true;
                break;
            }
            if (!bl4) {
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string4);
                objectName7 = this.configService.createConfigData(session, objectName3, "queue", "SIBAuthWebService", attributeList);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritDefaults", (Object)bl);
            this.configService.setAttributes(session, objectName7, attributeList);
        } else if (string2.equalsIgnoreCase("port")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName8 = null;
            boolean bl5 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string8 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string8.equals(string4)) continue;
                objectName8 = objectNameArray[i];
                bl5 = true;
                break;
            }
            if (!bl5) {
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string4);
                objectName8 = this.configService.createConfigData(session, objectName3, "queue", "SIBAuthPort", attributeList);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritDefaults", (Object)bl);
            this.configService.setAttributes(session, objectName8, attributeList);
        } else if (string2.equalsIgnoreCase("alias")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName9 = null;
            boolean bl6 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                String string10 = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string9.equals(string4) || !string10.equals(string3)) continue;
                objectName9 = objectNameArray[i];
                bl6 = true;
                break;
            }
            if (!bl6) {
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string4);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busName", (Object)string3);
                objectName9 = this.configService.createConfigData(session, objectName3, "alias", "SIBAuthAlias", attributeList);
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"inheritDefaults", (Object)bl);
            this.configService.setAttributes(session, objectName9, attributeList);
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return null;
    }

    public String listInheritDefaultsForDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listInheritDefaultsForDestination";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Boolean bl = null;
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("bus");
        String string4 = (String)abstractAdminCommand.getParameter("destination");
        ObjectName objectName = SIBSecurityAdminHelper.lookupBus(session, string3);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace", null);
        ObjectName objectName3 = this.configService.queryConfigObjects(session, objectName, objectName2, null)[0];
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        if (string2.equalsIgnoreCase("topicSpace")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName5 = null;
            boolean bl2 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string5 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string5.equals(string4)) continue;
                objectName5 = objectNameArray[i];
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("TOPIC_SPACE_NOT_FOUND_CWSJD0500", new Object[]{string4}, null));
            }
            bl = (Boolean)this.configService.getAttribute(session, objectName5, "inheritDefaults");
        } else if (string2.equalsIgnoreCase("queue")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName6 = null;
            boolean bl3 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string6 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string6.equals(string4)) continue;
                objectName6 = objectNameArray[i];
                bl3 = true;
                break;
            }
            if (!bl3) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("QUEUE_NOT_FOUND_CWSJD0201", new Object[]{string4}, null));
            }
            bl = (Boolean)this.configService.getAttribute(session, objectName6, "inheritDefaults");
        } else if (string2.equalsIgnoreCase("webService")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName7 = null;
            boolean bl4 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string7 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string7.equals(string4)) continue;
                objectName7 = objectNameArray[i];
                bl4 = true;
                break;
            }
            if (!bl4) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("WEB_SERVICE_NOT_FOUND_CWSJD0202", new Object[]{string4}, null));
            }
            bl = (Boolean)this.configService.getAttribute(session, objectName7, "inheritDefaults");
        } else if (string2.equalsIgnoreCase("port")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName8 = null;
            boolean bl5 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string8 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string8.equals(string4)) continue;
                objectName8 = objectNameArray[i];
                bl5 = true;
                break;
            }
            if (!bl5) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("PORT_NOT_FOUND_CWSJD0203", new Object[]{string4}, null));
            }
            bl = (Boolean)this.configService.getAttribute(session, objectName8, "inheritDefaults");
        } else if (string2.equalsIgnoreCase("alias")) {
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName3, objectName4, null);
            ObjectName objectName9 = null;
            boolean bl6 = false;
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string9 = (String)this.configService.getAttribute(session, objectNameArray[i], "identifier");
                String string10 = (String)this.configService.getAttribute(session, objectNameArray[i], "busName");
                if (!string9.equals(string4) || !string10.equals(string3)) continue;
                objectName9 = objectNameArray[i];
                bl6 = true;
                break;
            }
            if (!bl6) {
                throw new SIBSecurityCommandException(nls.getFormattedMessage("ALIAS_NOT_FOUND_CWSJD0204", new Object[]{string4}, null));
            }
            bl = (Boolean)this.configService.getAttribute(session, objectName9, "inheritDefaults");
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("UNKNOWN_TYPE_NAME_CWSJD0205", new Object[]{string2}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, null);
        }
        return "Inherit Receiver Defaults are set to: " + bl.toString().toUpperCase();
    }

    private ObjectName getRoleForQueue(Session session, String string, String string2, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createQueueIfRequired(session, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string2.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("receiver")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("browser")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "browser", "SIBAuthBrowser", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("creator")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "creator", "SIBAuthCreator", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string2}, null));
        }
        return objectName4;
    }

    private ObjectName getRoleForPort(Session session, String string, String string2, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createPortIfRequired(session, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string2.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("receiver")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("browser")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "browser", "SIBAuthBrowser", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("creator")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "creator", "SIBAuthCreator", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string2}, null));
        }
        return objectName4;
    }

    private ObjectName getRoleForWebService(Session session, String string, String string2, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createWebServiceIfRequired(session, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string2.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("receiver")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("browser")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "browser", "SIBAuthBrowser", attributeList) : objectNameArray[0];
        } else if (string2.equalsIgnoreCase("creator")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "creator", "SIBAuthCreator", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string2}, null));
        }
        return objectName4;
    }

    private ObjectName getRoleForTopicSpaceBase(Session session, String string, ObjectName objectName) throws Exception {
        ObjectName objectName2 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName3 = null;
        AttributeList attributeList = new AttributeList();
        if (string.equalsIgnoreCase("sender")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
            objectName3 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string.equalsIgnoreCase("receiver")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
            objectName3 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string.equalsIgnoreCase("identityAdopter")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
            objectName3 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string}, null));
        }
        return objectName3;
    }

    private ObjectName getRoleForAlias(Session session, String string, String string2, String string3, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createAliasIfRequired(session, string2, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string3.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string3.equalsIgnoreCase("receiver")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "receiver", "SIBAuthReceiver", attributeList) : objectNameArray[0];
        } else if (string3.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else if (string3.equalsIgnoreCase("browser")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "browser", "SIBAuthBrowser", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string3}, null));
        }
        return objectName4;
    }

    private ObjectName getRoleForForeignDestination(Session session, String string, String string2, String string3, ObjectName objectName) throws Exception {
        ObjectName objectName2 = SIBSecurityAdminHelper.createForeignDestinationIfRequired(session, string2, string, objectName);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName4 = null;
        AttributeList attributeList = new AttributeList();
        if (string3.equalsIgnoreCase("sender")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "sender", "SIBAuthSender", attributeList) : objectNameArray[0];
        } else if (string3.equalsIgnoreCase("identityAdopter")) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray = this.configService.queryConfigObjects(session, objectName2, objectName3, null);
            objectName4 = objectNameArray.length == 0 ? this.configService.createConfigData(session, objectName2, "identityAdopter", "SIBAuthIdentityAdopter", attributeList) : objectNameArray[0];
        } else {
            throw new SIBSecurityCommandException(nls.getFormattedMessage("INVALID_ROLE_NAME_CWSJD0501", new Object[]{string3}, null));
        }
        return objectName4;
    }
}

