/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.commands.sib.SIBSecurityCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBSecurityAdminHelper {
    private static final TraceComponent tc = SibTr.register(SIBSecurityAdminHelper.class, "CWSJD", "com.ibm.ws.security.commands.sib.CWSJDMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.security.commands.sib.CWSJDMessages");

    protected static ObjectName lookupBus(Session session, String string) throws Exception {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "lookupBus", new Object[]{session, string});
        }
        if ((objectNameArray = configService.resolve(session, "SIBus=" + string)).length != 1) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "lookupBus", (Object)"SIBSecurityCommandException - bus not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJD0600", new Object[]{string}, null));
        }
        ObjectName objectName = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "lookupBus", objectName);
        }
        return objectName;
    }

    protected static ObjectName createUserIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createUserIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthUser", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equalsIgnoreCase(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "user", "SIBAuthUser", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createUserIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createGroupIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createGroupIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthGroup", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equalsIgnoreCase(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "group", "SIBAuthGroup", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createGroupIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createQueueIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createQueueIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "queue", "SIBAuthQueue", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createQueueIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createPortIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createPortIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthPort", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "queue", "SIBAuthPort", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createPortIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createWebServiceIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createWebServiceIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthWebService", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "queue", "SIBAuthWebService", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createWebServiceIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createForeignBusIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createForeignBusIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "busName");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busName", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "foreignBus", "SIBAuthForeignBus", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createForeignBusIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createAliasIfRequired(Session session, String string, String string2, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createAliasIfRequired", new Object[]{session, string, string2, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            String string4 = (String)configService.getAttribute(session, objectNameArray[i], "busName");
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busName", (Object)string2);
            objectName2 = configService.createConfigData(session, objectName, "alias", "SIBAuthAlias", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createAliasIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createForeignDestinationIfRequired(Session session, String string, String string2, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createForeignDestinationIfRequired", new Object[]{session, string, string2, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "destinationName");
            String string4 = (String)configService.getAttribute(session, objectNameArray[i], "busName");
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"destinationName", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busName", (Object)string2);
            objectName2 = configService.createConfigData(session, objectName, "foreignDestination", "SIBAuthForeignDestination", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createForeignDestinationIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createTopicSpaceIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createTopicSpaceIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopicSpace", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "topicSpace", "SIBAuthTopicSpace", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTopicSpaceIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName createTopicIfRequired(Session session, String string, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createTopicIfRequired", new Object[]{session, string, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthTopic", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            if (!string.equals(string2)) continue;
            objectName2 = objectNameArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
            objectName2 = configService.createConfigData(session, objectName, "topic", "SIBAuthTopic", attributeList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createTopicIfRequired", objectName2);
        }
        return objectName2;
    }

    protected static void checkAllUsersForOrphans(Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkAllUsersForOrphans", new Object[]{session, objectName});
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthUser", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            SIBSecurityAdminHelper.removeUserIfOrphaned(string, session, objectName);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkAllUsersForOrphans");
        }
    }

    protected static void checkAllGroupsForOrphans(Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "checkAllGroupsForOrphans", new Object[]{session, objectName});
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthGroup", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
            SIBSecurityAdminHelper.removeGroupIfOrphaned(string, session, objectName);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "checkAllGroupsForOrphans");
        }
    }

    protected static void removeUserIfOrphaned(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeUserIfOrphaned", new Object[]{string, session, objectName});
        }
        if (!(SIBSecurityAdminHelper.userStillExistsInQueue(string, session, objectName) || SIBSecurityAdminHelper.userStillExistsInDefaultSpace(string, session, objectName) || SIBSecurityAdminHelper.userStillExistsInForeignBus(string, session, objectName) || SIBSecurityAdminHelper.userStillExistsInForeignDestination(string, session, objectName) || SIBSecurityAdminHelper.userStillExistsInAlias(string, session, objectName))) {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthUser", null);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string.equalsIgnoreCase(string2)) continue;
                configService.deleteConfigData(session, objectNameArray[i]);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeUserIfOrphaned");
        }
    }

    protected static void removeGroupIfOrphaned(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeGroupIfOrphaned", new Object[]{string, session, objectName});
        }
        if (!(SIBSecurityAdminHelper.groupStillExistsInQueue(string, session, objectName) || SIBSecurityAdminHelper.groupStillExistsInDefaultSpace(string, session, objectName) || SIBSecurityAdminHelper.groupStillExistsInForeignBus(string, session, objectName) || SIBSecurityAdminHelper.groupStillExistsInForeignDestination(string, session, objectName) || SIBSecurityAdminHelper.groupStillExistsInAlias(string, session, objectName))) {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthGroup", null);
            ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string2 = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
                if (!string.equalsIgnoreCase(string2)) continue;
                configService.deleteConfigData(session, objectNameArray[i]);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeGroupIfOrphaned");
        }
    }

    protected static void removeRoleIfOrphaned(Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "removeRoleIfOrphaned", new Object[]{session, objectName});
        }
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "user");
        ArrayList arrayList2 = (ArrayList)configService.getAttribute(session, objectName, "group");
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            configService.deleteConfigData(session, objectName);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "removeRoleIfOrphaned");
        }
    }

    protected static boolean destinationIsEmpty(Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "destinationIsEmpty", new Object[]{session, objectName});
        }
        boolean bl = true;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName, objectName3, null);
        ObjectName objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, objectName, objectName4, null);
        ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName[] objectNameArray4 = configService.queryConfigObjects(session, objectName, objectName5, null);
        ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray5 = configService.queryConfigObjects(session, objectName, objectName6, null);
        if (objectNameArray.length != 0 || objectNameArray2.length != 0 || objectNameArray3.length != 0 || objectNameArray4.length != 0 || objectNameArray5.length != 0) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "destinationIsEmpty", new Boolean(bl));
        }
        return bl;
    }

    protected static String[] convertToStringArray(Session session, ObjectName[] objectNameArray) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "convertToStringArray", new Object[]{session, objectNameArray});
        }
        String[] stringArray = new String[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string;
            stringArray[i] = string = (String)configService.getAttribute(session, objectNameArray[i], "identifier");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "convertToStringArray", stringArray);
        }
        return stringArray;
    }

    private static boolean userStillExistsInQueue(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userStillExistsInQueue", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userStillExistsInQueue", new Boolean(bl));
        }
        return bl;
    }

    private static boolean userStillExistsInDefaultSpace(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userStillExistsInDefaultSpace", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthDefault", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userStillExistsInDefaultSpace", new Boolean(bl));
        }
        return bl;
    }

    private static boolean userStillExistsInAlias(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userStillExistsInAlias", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userStillExistsInAlias", new Boolean(bl));
        }
        return bl;
    }

    private static boolean userStillExistsInForeignBus(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userStillExistsInForeignBus", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userStillExistsInForeignBus", new Boolean(bl));
        }
        return bl;
    }

    private static boolean userStillExistsInForeignDestination(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userStillExistsInForeignDestination", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.userExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userStillExistsInForeignDestination", new Boolean(bl));
        }
        return bl;
    }

    private static boolean groupStillExistsInQueue(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupStillExistsInQueue", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthQueue", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupStillExistsInQueue", new Boolean(bl));
        }
        return bl;
    }

    private static boolean groupStillExistsInDefaultSpace(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupStillExistsInDefaultSpace", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthDefault", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupStillExistsInDefaultSpace", new Boolean(bl));
        }
        return bl;
    }

    private static boolean groupStillExistsInAlias(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupStillExistsInAlias", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthAlias", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupStillExistsInAlias", new Boolean(bl));
        }
        return bl;
    }

    private static boolean groupStillExistsInForeignBus(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupStillExistsInForeignBus", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignBus", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupStillExistsInForeignBus", new Boolean(bl));
        }
        return bl;
    }

    private static boolean groupStillExistsInForeignDestination(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupStillExistsInForeignDestination", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthForeignDestination", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        ObjectName objectName3 = null;
        ObjectName[] objectNameArray2 = null;
        ObjectName objectName4 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length > 0 && SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) {
                bl = true;
                break;
            }
            objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2.length <= 0 || !SIBSecurityAdminHelper.groupExistsInRole(string, session, objectName4 = objectNameArray2[0])) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupStillExistsInForeignDestination", new Boolean(bl));
        }
        return bl;
    }

    protected static boolean groupExistsInRole(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "groupExistsInRole", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "group");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string2 = (String)configService.getAttribute(session, objectName2, "identifier");
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "groupExistsInRole", new Boolean(bl));
        }
        return bl;
    }

    protected static boolean userExistsInRole(String string, Session session, ObjectName objectName) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "userExistsInRole", new Object[]{string, session, objectName});
        }
        boolean bl = false;
        ArrayList arrayList = (ArrayList)configService.getAttribute(session, objectName, "user");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string2 = (String)configService.getAttribute(session, objectName2, "identifier");
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "userExistsInRole", new Boolean(bl));
        }
        return bl;
    }

    protected static ObjectName getSenderRole(Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getSenderRole", new Object[]{session, objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSender", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getSenderRole", (Object)"SIBSecurityCommandException - sender role not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("SENDER_ROLE_NOT_FOUND_CWSJD0601", new Object[]{string}, null));
        }
        objectName2 = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getSenderRole", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName getReceiverRole(Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getReceiverRole", new Object[]{session, objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthReceiver", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getReceiverRole", (Object)"SIBSecurityCommandException - sender role not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("RECEIVER_ROLE_NOT_FOUND_CWSJD0602", new Object[]{string}, null));
        }
        objectName2 = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getReceiverRole", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName getBrowserRole(Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getBrowserRole", new Object[]{session, objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthBrowser", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getBrowserRole", (Object)"SIBSecurityCommandException - sender role not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("BROWSER_ROLE_NOT_FOUND_CWSJD0603", new Object[]{string}, null));
        }
        objectName2 = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getBrowserRole", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName getCreatorRole(Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getCreatorRole", new Object[]{session, objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthCreator", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getCreatorRole", (Object)"SIBSecurityCommandException - creator role not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("CREATOR_ROLE_NOT_FOUND_CWSJD0604", new Object[]{string}, null));
        }
        objectName2 = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getCreatorRole", objectName2);
        }
        return objectName2;
    }

    protected static ObjectName getIdAdopterRole(Session session, ObjectName objectName, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getIdAdopterRole", new Object[]{session, objectName, string});
        }
        ObjectName objectName2 = null;
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthIdentityAdopter", null);
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray.length == 0) {
            if (tc.isEntryEnabled()) {
                SibTr.exit(tc, "getIdAdopterRole", (Object)"SIBSecurityCommandException - creator role not found");
            }
            throw new SIBSecurityCommandException(nls.getFormattedMessage("IDADOPTER_ROLE_NOT_FOUND_CWSJD0605", new Object[]{string}, null));
        }
        objectName2 = objectNameArray[0];
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getIdAdopterRole", objectName2);
        }
        return objectName2;
    }
}

