/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.config.repository.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sdo.config.util.Privileged;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class URLRepository {
    private static final TraceComponent tc = SibTr.register(URLRepository.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private HashMap urlMap = new HashMap();
    private Long urlTimestamp = new Long(0L);
    public static URLRepository DEFAULT_INSTANCE = new URLRepository();

    private URLRepository() {
    }

    public InputStream getInputStream(String string) throws RepositoryRuntimeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getInputStream", (Object)string);
        }
        InputStream inputStream = null;
        try {
            URL uRL = (URL)this.urlMap.get(string);
            if (uRL != null) {
                inputStream = Privileged.openStream(uRL);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sdo.config.repository.impl.URLRepository.getInputStream", (String)"73", (Object)this);
            throw new RepositoryRuntimeException(iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getInputStream");
        }
        return inputStream;
    }

    public Long getTimestamp(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "getTimestamp", (Object)string);
        }
        Long l = null;
        URL uRL = (URL)this.urlMap.get(string);
        if (uRL != null) {
            l = this.urlTimestamp;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "getTimestamp", l);
        }
        return l;
    }

    public List listResources() {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "listResources");
        }
        ArrayList arrayList = new ArrayList(this.urlMap.keySet());
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "listResources", arrayList);
        }
        return arrayList;
    }

    public void registerResource(URL uRL, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "registerResource", new Object[]{uRL, string});
        }
        this.urlMap.put(string, uRL);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "registerResource");
        }
    }
}

