/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sdo.config.repository.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sdo.config.repository.impl.CheckedNullPointerException;
import com.ibm.ws.sdo.config.repository.impl.DBRepositoryImpl;
import com.ibm.ws.sdo.config.repository.impl.Repository;
import com.ibm.ws.sdo.config.repository.impl.RepositoryHome;
import com.ibm.ws.sdo.config.repository.impl.RepositoryRuntimeException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sdo.config.repository.RepositoryException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.rmi.PortableRemoteObject;

public class RepositoryOutputStream
extends ByteArrayOutputStream
implements Serializable {
    private static final long serialVersionUID = 2451380025102725123L;
    private static final TraceComponent tc = SibTr.register(RepositoryOutputStream.class, "SIBSdoRepository", "com.ibm.wsspi.sdo.config.CWSJOMessages");
    private HomeHandle facadeHomeHandle;
    private String name;
    private boolean overwrite;
    private byte[] oldValue;

    public RepositoryOutputStream(String string, boolean bl, RepositoryHome repositoryHome) throws RepositoryException {
        super(2048);
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "RepositoryOutputStream", new Object[]{string, new Boolean(bl), repositoryHome});
        }
        this.name = string;
        this.overwrite = bl;
        try {
            this.oldValue = repositoryHome.create().getBytes(string);
            if (!bl && this.oldValue != null) {
                throw new RepositoryException("NAME_ALREADY_USED_CWSJO0004", new Object[]{string});
            }
            this.facadeHomeHandle = repositoryHome.getHomeHandle();
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.RepositoryOutputStream", (String)"94", (Object)this);
            throw new RepositoryRuntimeException(remoteException);
        }
        catch (CreateException createException) {
            FFDCFilter.processException((Throwable)createException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.RepositoryOutputStream", (String)"99", (Object)this);
            throw new RepositoryRuntimeException(createException);
        }
        catch (CheckedNullPointerException checkedNullPointerException) {
            FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.RepositoryOutputStream", (String)"104", (Object)this);
            throw checkedNullPointerException.getOriginalException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "RepositoryOutputStream", this);
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "close");
        }
        if (this.facadeHomeHandle == null) {
            String string = RepositoryException.nlsMessage("STREAM_ALREADY_CLOSED_CWSJO0006E", null);
            throw new IOException(string);
        }
        EJBHome eJBHome = this.facadeHomeHandle.getEJBHome();
        RepositoryHome repositoryHome = (RepositoryHome)PortableRemoteObject.narrow((Object)eJBHome, (Class)RepositoryHome.class);
        try {
            Repository repository = repositoryHome.create();
            byte[] byArray = this.toByteArray();
            byte[] byArray2 = DBRepositoryImpl.compress(byArray);
            byArray = null;
            try {
                repository.registerWithOptimisticUpdate(this.name, byArray2, this.oldValue);
            }
            catch (RepositoryException repositoryException) {
                FFDCFilter.processException((Throwable)repositoryException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.close", (String)"169", (Object)this);
                throw new IOException(repositoryException.getClass().getName() + ": " + repositoryException.getMessage());
            }
            catch (CheckedNullPointerException checkedNullPointerException) {
                FFDCFilter.processException((Throwable)checkedNullPointerException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.close", (String)"175", (Object)this);
                throw checkedNullPointerException.getOriginalException();
            }
            finally {
                repository.remove();
            }
        }
        catch (CreateException createException) {
            FFDCFilter.processException((Throwable)createException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.close", (String)"185", (Object)this);
            throw new RepositoryRuntimeException(createException);
        }
        catch (RemoveException removeException) {
            FFDCFilter.processException((Throwable)removeException, (String)"com.ibm.ws.sdo.config.repository.impl.RepositoryOutputStream.close", (String)"190", (Object)this);
            throw new RepositoryRuntimeException(removeException);
        }
        finally {
            this.facadeHomeHandle = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "close");
        }
    }
}

