/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsFactoryFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.jms.JMSException;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class SIBJMSAdminCommandProvider
extends SimpleCommandProvider {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider";
    private static final TraceComponent tc = SibTr.register(SIBJMSAdminCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static String GENERIC_CF_INTERFACE = "javax.jms.ConnectionFactory";
    private static String QUEUE_CF_INTERFACE = "javax.jms.QueueConnectionFactory";
    private static String TOPIC_CF_INTERFACE = "javax.jms.TopicConnectionFactory";
    private static String QUEUE_INTERFACE = "javax.jms.Queue";
    private static String TOPIC_INTERFACE = "javax.jms.Topic";
    private static String JMS_JCA_RESOURCE_ADAPTER_CLASS = "com.ibm.ws.sib.api.jmsra.impl.JmsJcaResourceAdapterImpl";
    private ConfigService configService = ConfigServiceFactory.getConfigService();
    private static final String DEFAULT_TOPIC_SPACE_NAME = "Default.Topic.Space";
    private JmsConnectionFactory jmsConnectionFactory;
    private JmsQueue jmsQueue;
    private JmsTopic jmsTopic;

    public ObjectName createSIBJMSConnectionFactory(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBJMSConnectionFactory";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        String string2 = (String)abstractAdminCommand.getParameter("type");
        String string3 = (String)abstractAdminCommand.getParameter("authDataAlias");
        String string4 = (String)abstractAdminCommand.getParameter("category");
        String string5 = (String)abstractAdminCommand.getParameter("description");
        String string6 = (String)abstractAdminCommand.getParameter("jndiName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("logMissingTransactionContext");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("manageCachedHandles");
        String string7 = (String)abstractAdminCommand.getParameter("name");
        String string8 = (String)abstractAdminCommand.getParameter("xaRecoveryAuthAlias");
        String string9 = (String)abstractAdminCommand.getParameter("busName");
        String string10 = (String)abstractAdminCommand.getParameter("clientID");
        String string11 = (String)abstractAdminCommand.getParameter("userName");
        String string12 = (String)abstractAdminCommand.getParameter("password");
        String string13 = (String)abstractAdminCommand.getParameter("nonPersistentMapping");
        String string14 = (String)abstractAdminCommand.getParameter("persistentMapping");
        String string15 = (String)abstractAdminCommand.getParameter("durableSubscriptionHome");
        String string16 = (String)abstractAdminCommand.getParameter("readAhead");
        String string17 = (String)abstractAdminCommand.getParameter("target");
        String string18 = (String)abstractAdminCommand.getParameter("targetType");
        String string19 = (String)abstractAdminCommand.getParameter("targetSignificance");
        String string20 = (String)abstractAdminCommand.getParameter("targetTransportChain");
        String string21 = (String)abstractAdminCommand.getParameter("providerEndPoints");
        String string22 = (String)abstractAdminCommand.getParameter("connectionProximity");
        String string23 = (String)abstractAdminCommand.getParameter("tempQueueNamePrefix");
        String string24 = (String)abstractAdminCommand.getParameter("tempTopicNamePrefix");
        Boolean bl3 = (Boolean)abstractAdminCommand.getParameter("shareDataSourceWithCMP");
        String string25 = (String)abstractAdminCommand.getParameter("shareDurableSubscriptions");
        if (string7 == null || string7.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "name"}, null));
        }
        if (string6 == null || string6.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "jndiName"}, null));
        }
        if (string9 == null || string9.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "busName"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string7)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_JMSCF_NAME_CWSJA0206", new Object[]{string7}, null));
        }
        this.validateConnectionFactoryProperties(string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, string25);
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        String string26 = null;
        if (string2 == null) {
            string26 = GENERIC_CF_INTERFACE;
        } else if (string2.equalsIgnoreCase("queue")) {
            string26 = QUEUE_CF_INTERFACE;
            string15 = null;
            string24 = null;
        } else if (string2.equalsIgnoreCase("topic")) {
            string26 = TOPIC_CF_INTERFACE;
            string23 = null;
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TYPE_CWSJA0201", new Object[]{string2}, null));
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("createJ2CConnectionFactory");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName2);
        adminCommand.setParameter("name", (Object)string7);
        adminCommand.setParameter("jndiName", (Object)string6);
        adminCommand.setParameter("connectionFactoryInterface", (Object)string26);
        if (string5 != null) {
            adminCommand.setParameter("description", (Object)string5);
        }
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"createJ2CConnectionFactory"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Exception exception = (Exception)commandResult.getException();
            throw exception;
        }
        ObjectName objectName3 = (ObjectName)commandResult.getResult();
        this.modifyConnectionFactoryAttributes(session, objectName3, string3, string4, string5, string6, bl, bl2, string7, string8);
        this.modifyConnectionFactoryProperties(session, objectName3, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, bl3, string25);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName3);
        }
        return objectName3;
    }

    public ObjectName deleteSIBJMSConnectionFactory(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "deleteSIBJMSConnectionFactory";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!(QUEUE_CF_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "connectionDefinition", false), "connectionFactoryInterface", false)) || TOPIC_CF_INTERFACE.equals(string) || GENERIC_CF_INTERFACE.equals(string))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0203", null, null));
        }
        String string3 = (String)configService.getAttribute(session, objectName, "name", false);
        if (!SIBAdminCommandHelper.nameOkForDelete(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_JMSCF_NAME_CWSJA0207", new Object[]{string3}, null));
        }
        configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public ObjectName[] listSIBJMSConnectionFactories(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName[] objectNameArray;
        ObjectName[] objectNameArray2;
        Object object;
        Object object2;
        Object object3;
        String string = "listSIBJMSConnectionFactories";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        String string2 = (String)abstractAdminCommand.getParameter("type");
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            bl = true;
        } else if (string2.equalsIgnoreCase("queue")) {
            bl2 = true;
        } else if (string2.equalsIgnoreCase("topic")) {
            bl3 = true;
        } else if (string2.equalsIgnoreCase("all")) {
            bl = true;
            bl2 = true;
            bl3 = true;
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TYPE_CWSJA0201", new Object[]{string2}, null));
        }
        List<ObjectName> list = null;
        if (bl) {
            object3 = CommandMgr.getCommandMgr();
            object2 = object3.createCommand("listJ2CConnectionFactories");
            object2.setConfigSession(session);
            object2.setTargetObject((Object)objectName2);
            object2.setConfigSession(session);
            object2.setTargetObject((Object)objectName2);
            object2.setParameter("connectionFactoryInterface", (Object)GENERIC_CF_INTERFACE);
            object2.execute();
            object = object2.getCommandResult();
            if (object == null) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"listJ2CConnectionFactories"}, null));
            }
            if (!object.isSuccessful()) {
                Exception exception = (Exception)object.getException();
                throw exception;
            }
            objectNameArray2 = (ObjectName[])object.getResult();
            list = Arrays.asList(objectNameArray2);
        }
        object3 = null;
        if (bl2) {
            object2 = CommandMgr.getCommandMgr();
            object = object2.createCommand("listJ2CConnectionFactories");
            object.setConfigSession(session);
            object.setTargetObject((Object)objectName2);
            object.setConfigSession(session);
            object.setTargetObject((Object)objectName2);
            object.setParameter("connectionFactoryInterface", (Object)QUEUE_CF_INTERFACE);
            object.execute();
            objectNameArray2 = object.getCommandResult();
            if (objectNameArray2 == null) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"listJ2CConnectionFactories"}, null));
            }
            if (!objectNameArray2.isSuccessful()) {
                Exception exception = (Exception)objectNameArray2.getException();
                throw exception;
            }
            objectNameArray = (ObjectName[])objectNameArray2.getResult();
            object3 = Arrays.asList(objectNameArray);
        }
        object2 = null;
        if (bl3) {
            object = CommandMgr.getCommandMgr();
            objectNameArray2 = object.createCommand("listJ2CConnectionFactories");
            objectNameArray2.setConfigSession(session);
            objectNameArray2.setTargetObject((Object)objectName2);
            objectNameArray2.setConfigSession(session);
            objectNameArray2.setTargetObject((Object)objectName2);
            objectNameArray2.setParameter("connectionFactoryInterface", (Object)TOPIC_CF_INTERFACE);
            objectNameArray2.execute();
            objectNameArray = objectNameArray2.getCommandResult();
            if (objectNameArray == null) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"listJ2CConnectionFactories"}, null));
            }
            if (!objectNameArray.isSuccessful()) {
                Exception exception = (Exception)objectNameArray.getException();
                throw exception;
            }
            ObjectName[] objectNameArray3 = (ObjectName[])objectNameArray.getResult();
            object2 = Arrays.asList(objectNameArray3);
        }
        object = this.merge(list, (List)object3, (List)object2);
        objectNameArray2 = new ObjectName[object.size()];
        object.toArray(objectNameArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectNameArray2);
        }
        return objectNameArray2;
    }

    public ObjectName modifySIBJMSConnectionFactory(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "modifySIBJMSConnectionFactory";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!(QUEUE_CF_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "connectionDefinition", false), "connectionFactoryInterface", false)) || TOPIC_CF_INTERFACE.equals(string) || GENERIC_CF_INTERFACE.equals(string))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0203", null, null));
        }
        String string3 = (String)abstractAdminCommand.getParameter("authDataAlias");
        String string4 = (String)abstractAdminCommand.getParameter("category");
        String string5 = (String)abstractAdminCommand.getParameter("description");
        String string6 = (String)abstractAdminCommand.getParameter("jndiName");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("logMissingTransactionContext");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("manageCachedHandles");
        String string7 = (String)abstractAdminCommand.getParameter("name");
        String string8 = (String)abstractAdminCommand.getParameter("xaRecoveryAuthAlias");
        String string9 = (String)abstractAdminCommand.getParameter("busName");
        String string10 = (String)abstractAdminCommand.getParameter("clientID");
        String string11 = (String)abstractAdminCommand.getParameter("userName");
        String string12 = (String)abstractAdminCommand.getParameter("password");
        String string13 = (String)abstractAdminCommand.getParameter("nonPersistentMapping");
        String string14 = (String)abstractAdminCommand.getParameter("persistentMapping");
        String string15 = (String)abstractAdminCommand.getParameter("durableSubscriptionHome");
        String string16 = (String)abstractAdminCommand.getParameter("readAhead");
        String string17 = (String)abstractAdminCommand.getParameter("target");
        String string18 = (String)abstractAdminCommand.getParameter("targetType");
        String string19 = (String)abstractAdminCommand.getParameter("targetSignificance");
        String string20 = (String)abstractAdminCommand.getParameter("targetTransportChain");
        String string21 = (String)abstractAdminCommand.getParameter("providerEndPoints");
        String string22 = (String)abstractAdminCommand.getParameter("connectionProximity");
        String string23 = (String)abstractAdminCommand.getParameter("tempQueueNamePrefix");
        String string24 = (String)abstractAdminCommand.getParameter("tempTopicNamePrefix");
        Boolean bl3 = (Boolean)abstractAdminCommand.getParameter("shareDataSourceWithCMP");
        String string25 = (String)abstractAdminCommand.getParameter("shareDurableSubscriptions");
        if (QUEUE_CF_INTERFACE.equals(string)) {
            string15 = null;
            string24 = null;
        } else if (TOPIC_CF_INTERFACE.equals(string)) {
            string23 = null;
        }
        this.validateConnectionFactoryProperties(string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, string25);
        this.modifyConnectionFactoryAttributes(session, objectName, string3, string4, string5, string6, bl, bl2, string7, string8);
        this.modifyConnectionFactoryProperties(session, objectName, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20, string21, string22, string23, string24, bl3, string25);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public Hashtable showSIBJMSConnectionFactory(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "showSIBJMSConnectionFactory";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!(QUEUE_CF_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "connectionDefinition", false), "connectionFactoryInterface", false)) || TOPIC_CF_INTERFACE.equals(string) || GENERIC_CF_INTERFACE.equals(string))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0203", null, null));
        }
        Hashtable hashtable = this.getConnectionFactoryAttributes(session, objectName);
        Hashtable hashtable2 = this.getConnectionFactoryProperties(session, objectName, hashtable);
        if (QUEUE_CF_INTERFACE.equals(string)) {
            hashtable2.remove("durableSubscriptionHome");
            hashtable2.remove("DurableSubscriptionHome");
            hashtable2.remove("tempTopicNamePrefix");
            hashtable2.remove("TempTopicNamePrefix");
        } else if (TOPIC_CF_INTERFACE.equals(string)) {
            hashtable2.remove("tempQueueNamePrefix");
            hashtable2.remove("TempQueueNamePrefix");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, hashtable2);
        }
        return hashtable2;
    }

    public ObjectName createSIBJMSQueue(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBJMSQueue";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        String string2 = (String)abstractAdminCommand.getParameter("description");
        String string3 = (String)abstractAdminCommand.getParameter("jndiName");
        String string4 = (String)abstractAdminCommand.getParameter("name");
        String string5 = (String)abstractAdminCommand.getParameter("queueName");
        String string6 = (String)abstractAdminCommand.getParameter("deliveryMode");
        Long l = (Long)abstractAdminCommand.getParameter("timeToLive");
        Integer n = (Integer)abstractAdminCommand.getParameter("priority");
        String string7 = (String)abstractAdminCommand.getParameter("readAhead");
        String string8 = (String)abstractAdminCommand.getParameter("busName");
        if (string4 == null || string4.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "name"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "jndiName"}, null));
        }
        if (string5 == null || string5.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "queueName"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string4)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_JMSQ_NAME_CWSJA0208", new Object[]{string4}, null));
        }
        if (string5 == null) {
            string5 = string4;
        }
        this.validateQueueProperties(string5, string6, l, n, string7, string8);
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("createJ2CAdminObject");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName2);
        adminCommand.setParameter("adminObjectInterface", (Object)QUEUE_INTERFACE);
        adminCommand.setParameter("name", (Object)string4);
        adminCommand.setParameter("jndiName", (Object)string3);
        if (string2 != null) {
            adminCommand.setParameter("description", (Object)string2);
        }
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"createJ2CAdminObject"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Exception exception = (Exception)commandResult.getException();
            throw exception;
        }
        ObjectName objectName3 = (ObjectName)commandResult.getResult();
        this.modifyQueueAttributes(session, objectName3, string4, string3, string2);
        this.modifyQueueProperties(session, objectName3, string5, string6, l, n, string7, string8);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName3);
        }
        return objectName3;
    }

    public ObjectName deleteSIBJMSQueue(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "deleteSIBJMSQueue";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!QUEUE_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0204", null, null));
        }
        String string3 = (String)configService.getAttribute(session, objectName, "name", false);
        if (!SIBAdminCommandHelper.nameOkForDelete(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_JMSQ_NAME_CWSJA0209", new Object[]{string3}, null));
        }
        configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public ObjectName[] listSIBJMSQueues(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBJMSQueues";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listJ2CAdminObjects");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName2);
        adminCommand.setParameter("adminObjectInterface", (Object)QUEUE_INTERFACE);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"listJ2CAdminObjects"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Exception exception = (Exception)commandResult.getException();
            throw exception;
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName modifySIBJMSQueue(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "modifySIBJMSQueue";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!QUEUE_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0204", null, null));
        }
        String string3 = (String)abstractAdminCommand.getParameter("description");
        String string4 = (String)abstractAdminCommand.getParameter("jndiName");
        String string5 = (String)abstractAdminCommand.getParameter("name");
        String string6 = (String)abstractAdminCommand.getParameter("queueName");
        String string7 = (String)abstractAdminCommand.getParameter("deliveryMode");
        Long l = (Long)abstractAdminCommand.getParameter("timeToLive");
        Integer n = (Integer)abstractAdminCommand.getParameter("priority");
        String string8 = (String)abstractAdminCommand.getParameter("readAhead");
        String string9 = (String)abstractAdminCommand.getParameter("busName");
        this.validateQueueProperties(string6, string7, l, n, string8, string9);
        this.modifyQueueAttributes(session, objectName, string5, string4, string3);
        this.modifyQueueProperties(session, objectName, string6, string7, l, n, string8, string9);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public Hashtable showSIBJMSQueue(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "showSIBJMSQueue";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!QUEUE_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0204", null, null));
        }
        Hashtable hashtable = this.getQueueAttributes(session, objectName);
        Hashtable hashtable2 = this.getQueueProperties(session, objectName, hashtable);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, hashtable2);
        }
        return hashtable2;
    }

    public ObjectName createSIBJMSTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBJMSTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        String string2 = (String)abstractAdminCommand.getParameter("description");
        String string3 = (String)abstractAdminCommand.getParameter("jndiName");
        String string4 = (String)abstractAdminCommand.getParameter("name");
        String string5 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string6 = (String)abstractAdminCommand.getParameter("topicName");
        String string7 = (String)abstractAdminCommand.getParameter("deliveryMode");
        Long l = (Long)abstractAdminCommand.getParameter("timeToLive");
        Integer n = (Integer)abstractAdminCommand.getParameter("priority");
        String string8 = (String)abstractAdminCommand.getParameter("readAhead");
        String string9 = (String)abstractAdminCommand.getParameter("busName");
        if (string4 == null || string4.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "name"}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "jndiName"}, null));
        }
        if (string5 == null || string5.length() < 1) {
            string5 = DEFAULT_TOPIC_SPACE_NAME;
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string4)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_JMST_NAME_CWSJA0210", new Object[]{string4}, null));
        }
        if (string6 == null) {
            string6 = string4;
        } else if (string6.equals("")) {
            string6 = string4;
        }
        this.validateTopicProperties(string5, string6, string7, l, n, string8, string9);
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("createJ2CAdminObject");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName2);
        adminCommand.setParameter("adminObjectInterface", (Object)TOPIC_INTERFACE);
        adminCommand.setParameter("name", (Object)string4);
        adminCommand.setParameter("jndiName", (Object)string3);
        if (string2 != null) {
            adminCommand.setParameter("description", (Object)string2);
        }
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"createJ2CAdminObject"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Exception exception = (Exception)commandResult.getException();
            throw exception;
        }
        ObjectName objectName3 = (ObjectName)commandResult.getResult();
        this.modifyTopicAttributes(session, objectName3, string4, string3, string2);
        this.modifyTopicProperties(session, objectName3, string5, string6, string7, l, n, string8, string9);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName3);
        }
        return objectName3;
    }

    public ObjectName deleteSIBJMSTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "deleteSIBJMSTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!TOPIC_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0205", null, null));
        }
        String string3 = (String)configService.getAttribute(session, objectName, "name", false);
        if (!SIBAdminCommandHelper.nameOkForDelete(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_JMST_NAME_CWSJA0211", new Object[]{string3}, null));
        }
        configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public ObjectName[] listSIBJMSTopics(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBJMSTopics";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(session, objectName);
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listJ2CAdminObjects");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName2);
        adminCommand.setParameter("adminObjectInterface", (Object)TOPIC_INTERFACE);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("COMMAND_FAILED_CWSJA0202", new Object[]{"listJ2CAdminObjects"}, null));
        }
        if (!commandResult.isSuccessful()) {
            Exception exception = (Exception)commandResult.getException();
            throw exception;
        }
        ObjectName[] objectNameArray = (ObjectName[])commandResult.getResult();
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName modifySIBJMSTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "modifySIBJMSTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!TOPIC_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0216", null, null));
        }
        String string3 = (String)abstractAdminCommand.getParameter("description");
        String string4 = (String)abstractAdminCommand.getParameter("jndiName");
        String string5 = (String)abstractAdminCommand.getParameter("name");
        String string6 = (String)abstractAdminCommand.getParameter("topicSpace");
        String string7 = (String)abstractAdminCommand.getParameter("topicName");
        String string8 = (String)abstractAdminCommand.getParameter("deliveryMode");
        Long l = (Long)abstractAdminCommand.getParameter("timeToLive");
        Integer n = (Integer)abstractAdminCommand.getParameter("priority");
        String string9 = (String)abstractAdminCommand.getParameter("readAhead");
        String string10 = (String)abstractAdminCommand.getParameter("busName");
        this.validateTopicProperties(string6, string7, string8, l, n, string9, string10);
        this.modifyTopicAttributes(session, objectName, string5, string4, string3);
        this.modifyTopicProperties(session, objectName, string6, string7, string8, l, n, string9, string10);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, objectName);
        }
        return objectName;
    }

    public Hashtable showSIBJMSTopic(AbstractAdminCommand abstractAdminCommand) throws Exception {
        ObjectName objectName;
        ObjectName objectName2;
        Session session;
        CommandProviderHelper commandProviderHelper;
        ConfigService configService;
        String string;
        String string2 = "showSIBJMSTopic";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string2, new Object[]{abstractAdminCommand});
        }
        if (!TOPIC_INTERFACE.equals(string = (String)(configService = (commandProviderHelper = this.getCommandProviderHelper()).getConfigService()).getAttribute(session = abstractAdminCommand.getConfigSession(), objectName2 = (ObjectName)configService.getAttribute(session, objectName = (ObjectName)abstractAdminCommand.getTargetObject(), "adminObject", false), "adminObjectInterface", false))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_TARGET_CWSJA0205", null, null));
        }
        Hashtable hashtable = this.getQueueAttributes(session, objectName);
        Hashtable hashtable2 = this.getQueueProperties(session, objectName, hashtable);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string2, hashtable2);
        }
        return hashtable2;
    }

    private ObjectName getSIBJMSResourceAdapter(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException, SIBAdminCommandException {
        ObjectName[] objectNameArray = this.configService.getRelationship(session, objectName, "J2CResourceAdapter");
        ObjectName objectName2 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3;
            String string;
            ObjectName objectName4 = (ObjectName)this.configService.getAttribute(session, objectNameArray[i], "deploymentDescriptor", false);
            if (objectName4 == null || !JMS_JCA_RESOURCE_ADAPTER_CLASS.equals(string = (String)this.configService.getAttribute(session, objectName3 = (ObjectName)this.configService.getAttribute(session, objectName4, "resourceAdapter", false), "resourceAdapterClass", false))) continue;
            objectName2 = objectNameArray[i];
            break;
        }
        if (objectName2 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_RESOURCE_ADAPTER_CWSJA0200", null, null));
        }
        return objectName2;
    }

    private void modifyConnectionFactoryAttributes(Session session, ObjectName objectName, String string, String string2, String string3, String string4, Boolean bl, Boolean bl2, String string5, String string6) throws ConfigServiceException, ConnectorException {
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"authDataAlias", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"category", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"jndiName", (Object)string4);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"logMissingTransactionContext", (Object)bl);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"manageCachedHandles", (Object)bl2);
        }
        if (string5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)string5);
        }
        if (string6 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"xaRecoveryAuthAlias", (Object)string6);
        }
        if (attributeList.size() > 0) {
            this.configService.setAttributes(session, objectName, attributeList);
        }
    }

    private void modifyConnectionFactoryProperties(Session session, ObjectName objectName, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, Boolean bl, String string17) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        boolean bl19 = false;
        AttributeList attributeList = this.configService.getAttributes(session, objectName, new String[]{"propertySet"}, true);
        AttributeList attributeList2 = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"propertySet");
        List list = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"resourceProperties");
        for (int i = 0; i < list.size(); ++i) {
            boolean bl20 = false;
            AttributeList attributeList3 = (AttributeList)list.get(i);
            String string18 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList3, (String)"name");
            if ("BusName".equalsIgnoreCase(string18) && string != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string);
                bl2 = true;
                bl20 = true;
            } else if ("ClientID".equalsIgnoreCase(string18) && string2 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string2);
                bl3 = true;
                bl20 = true;
            } else if ("UserName".equalsIgnoreCase(string18) && string3 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string3);
                bl4 = true;
                bl20 = true;
            } else if ("Password".equalsIgnoreCase(string18) && string4 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string4);
                bl5 = true;
                bl20 = true;
            } else if ("NonPersistentMapping".equalsIgnoreCase(string18) && string5 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string5);
                bl6 = true;
                bl20 = true;
            } else if ("PersistentMapping".equalsIgnoreCase(string18) && string6 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string6);
                bl7 = true;
                bl20 = true;
            } else if ("DurableSubscriptionHome".equalsIgnoreCase(string18) && string7 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string7);
                bl8 = true;
                bl20 = true;
            } else if ("ReadAhead".equalsIgnoreCase(string18) && string8 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string8);
                bl9 = true;
                bl20 = true;
            } else if ("Target".equalsIgnoreCase(string18) && string9 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string9);
                bl10 = true;
                bl20 = true;
            } else if ("TargetType".equalsIgnoreCase(string18) && string10 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string10);
                bl11 = true;
                bl20 = true;
            } else if ("TargetSignificance".equalsIgnoreCase(string18) && string11 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string11);
                bl12 = true;
                bl20 = true;
            } else if ("TargetTransportChain".equalsIgnoreCase(string18) && string12 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string12);
                bl13 = true;
                bl20 = true;
            } else if ("ProviderEndPoints".equalsIgnoreCase(string18) && string13 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string13);
                bl14 = true;
                bl20 = true;
            } else if ("ConnectionProximity".equalsIgnoreCase(string18) && string14 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string14);
                bl15 = true;
                bl20 = true;
            } else if ("TemporaryQueueNamePrefix".equalsIgnoreCase(string18) && string15 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string15);
                bl16 = true;
                bl20 = true;
            } else if ("TemporaryTopicNamePrefix".equalsIgnoreCase(string18) && string16 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string16);
                bl17 = true;
                bl20 = true;
            } else if ("shareDataSourceWithCMP".equalsIgnoreCase(string18) && bl != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)bl.toString());
                bl18 = true;
                bl20 = true;
            } else if ("shareDurableSubscriptions".equalsIgnoreCase(string18) && string17 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"value", (Object)string17.toString());
                bl19 = true;
                bl20 = true;
            }
            if (!bl20) continue;
            list.set(i, attributeList3);
        }
        if (string != null && !bl2) {
            AttributeList attributeList4 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"name", (Object)"BusName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"value", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"type", (Object)"java.lang.String");
            list.add(attributeList4);
        }
        if (string2 != null && !bl3) {
            AttributeList attributeList5 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList5, (String)"name", (Object)"ClientID");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList5, (String)"value", (Object)string2);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList5, (String)"type", (Object)"java.lang.String");
            list.add(attributeList5);
        }
        if (string3 != null && !bl4) {
            AttributeList attributeList6 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList6, (String)"name", (Object)"UserName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList6, (String)"value", (Object)string3);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList6, (String)"type", (Object)"java.lang.String");
            list.add(attributeList6);
        }
        if (string4 != null && !bl5) {
            AttributeList attributeList7 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList7, (String)"name", (Object)"Password");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList7, (String)"value", (Object)string4);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList7, (String)"type", (Object)"java.lang.String");
            list.add(attributeList7);
        }
        if (string5 != null && !bl6) {
            AttributeList attributeList8 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList8, (String)"name", (Object)"NonPersistentMapping");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList8, (String)"value", (Object)string5);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList8, (String)"type", (Object)"java.lang.String");
            list.add(attributeList8);
        }
        if (string6 != null && !bl7) {
            AttributeList attributeList9 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList9, (String)"name", (Object)"PersistentMapping");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList9, (String)"value", (Object)string6);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList9, (String)"type", (Object)"java.lang.String");
            list.add(attributeList9);
        }
        if (string7 != null && !bl8) {
            AttributeList attributeList10 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList10, (String)"name", (Object)"DurableSubscriptionHome");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList10, (String)"value", (Object)string7);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList10, (String)"type", (Object)"java.lang.String");
            list.add(attributeList10);
        }
        if (string8 != null && !bl9) {
            AttributeList attributeList11 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList11, (String)"name", (Object)"ReadAhead");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList11, (String)"value", (Object)string8);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList11, (String)"type", (Object)"java.lang.String");
            list.add(attributeList11);
        }
        if (string9 != null && !bl10) {
            AttributeList attributeList12 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList12, (String)"name", (Object)"Target");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList12, (String)"value", (Object)string9);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList12, (String)"type", (Object)"java.lang.String");
            list.add(attributeList12);
        }
        if (string10 != null && !bl11) {
            AttributeList attributeList13 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList13, (String)"name", (Object)"TargetType");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList13, (String)"value", (Object)string10);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList13, (String)"type", (Object)"java.lang.String");
            list.add(attributeList13);
        }
        if (string11 != null && !bl12) {
            AttributeList attributeList14 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList14, (String)"name", (Object)"TargetSignificance");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList14, (String)"value", (Object)string11);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList14, (String)"type", (Object)"java.lang.String");
            list.add(attributeList14);
        }
        if (string12 != null && !bl13) {
            AttributeList attributeList15 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList15, (String)"name", (Object)"TargetTransportChain");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList15, (String)"value", (Object)string12);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList15, (String)"type", (Object)"java.lang.String");
            list.add(attributeList15);
        }
        if (string13 != null && !bl14) {
            AttributeList attributeList16 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList16, (String)"name", (Object)"ProviderEndPoints");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList16, (String)"value", (Object)string13);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList16, (String)"type", (Object)"java.lang.String");
            list.add(attributeList16);
        }
        if (string14 != null && !bl15) {
            AttributeList attributeList17 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList17, (String)"name", (Object)"ConnectionProximity");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList17, (String)"value", (Object)string14);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList17, (String)"type", (Object)"java.lang.String");
            list.add(attributeList17);
        }
        if (string15 != null && !bl16) {
            AttributeList attributeList18 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList18, (String)"name", (Object)"TemporaryQueueNamePrefix");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList18, (String)"value", (Object)string15);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList18, (String)"type", (Object)"java.lang.String");
            list.add(attributeList18);
        }
        if (string16 != null && !bl17) {
            AttributeList attributeList19 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList19, (String)"name", (Object)"TemporaryTopicNamePrefix");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList19, (String)"value", (Object)string16);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList19, (String)"type", (Object)"java.lang.String");
            list.add(attributeList19);
        }
        if (bl != null && !bl18) {
            AttributeList attributeList20 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList20, (String)"name", (Object)"ShareDataSourceWithCMP");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList20, (String)"value", (Object)bl.toString());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList20, (String)"type", (Object)"java.lang.Boolean");
            list.add(attributeList20);
        }
        if (string17 != null && !bl19) {
            AttributeList attributeList21 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList21, (String)"name", (Object)"ShareDurableSubscriptions");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList21, (String)"value", (Object)string17);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList21, (String)"type", (Object)"java.lang.String");
            list.add(attributeList21);
        }
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"resourceProperties", (Object)list);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"propertySet", (Object)attributeList2);
        this.configService.setAttributes(session, objectName, attributeList);
    }

    private void modifyQueueAttributes(Session session, ObjectName objectName, String string, String string2, String string3) throws ConfigServiceException, ConnectorException {
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"jndiName", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string3);
        }
        if (attributeList.size() > 0) {
            this.configService.setAttributes(session, objectName, attributeList);
        }
    }

    private void modifyQueueProperties(Session session, ObjectName objectName, String string, String string2, Long l, Integer n, String string3, String string4) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        List list = (List)this.configService.getAttribute(session, objectName, "properties", true);
        for (int i = 0; i < list.size(); ++i) {
            AttributeList attributeList = (AttributeList)list.get(i);
            boolean bl7 = false;
            String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
            if ("QueueName".equalsIgnoreCase(string5) && string != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string);
                bl = true;
                bl7 = true;
            } else if ("DeliveryMode".equalsIgnoreCase(string5) && string2 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string2);
                bl2 = true;
                bl7 = true;
            } else if ("TimeToLive".equalsIgnoreCase(string5) && l != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)l.toString());
                bl3 = true;
                bl7 = true;
            } else if ("Priority".equalsIgnoreCase(string5) && n != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)n.toString());
                bl4 = true;
                bl7 = true;
            } else if ("ReadAhead".equalsIgnoreCase(string5) && string3 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string3);
                bl5 = true;
                bl7 = true;
            } else if ("BusName".equalsIgnoreCase(string5) && string4 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string4);
                bl6 = true;
                bl7 = true;
            }
            if (!bl7) continue;
            list.set(i, attributeList);
        }
        if (string != null && !bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"QueueName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (string2 != null && !bl2) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"DeliveryMode");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string2);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (l != null && !bl3) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"TimeToLive");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)l.toString());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.Long");
            list.add(attributeList);
        }
        if (n != null && !bl4) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"Priority");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)n.toString());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.Integer");
            list.add(attributeList);
        }
        if (string3 != null && !bl5) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"ReadAhead");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string3);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (string4 != null && !bl6) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"BusName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string4);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"properties", (Object)list);
        this.configService.setAttributes(session, objectName, attributeList);
    }

    private void modifyTopicAttributes(Session session, ObjectName objectName, String string, String string2, String string3) throws ConfigServiceException, ConnectorException {
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"jndiName", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string3);
        }
        if (attributeList.size() > 0) {
            this.configService.setAttributes(session, objectName, attributeList);
        }
    }

    private void modifyTopicProperties(Session session, ObjectName objectName, String string, String string2, String string3, Long l, Integer n, String string4, String string5) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        List list = (List)this.configService.getAttribute(session, objectName, "properties", true);
        for (int i = 0; i < list.size(); ++i) {
            boolean bl8 = false;
            AttributeList attributeList = (AttributeList)list.get(i);
            String string6 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
            if ("TopicSpace".equalsIgnoreCase(string6) && string != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string);
                bl = true;
                bl8 = true;
            } else if ("TopicName".equalsIgnoreCase(string6) && string2 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string2);
                bl2 = true;
                bl8 = true;
            } else if ("DeliveryMode".equalsIgnoreCase(string6) && string3 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string3);
                bl3 = true;
                bl8 = true;
            } else if ("TimeToLive".equalsIgnoreCase(string6) && l != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)l.toString());
                bl4 = true;
                bl8 = true;
            } else if ("Priority".equalsIgnoreCase(string6) && n != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)n.toString());
                bl5 = true;
                bl8 = true;
            } else if ("ReadAhead".equalsIgnoreCase(string6) && string4 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string4);
                bl6 = true;
                bl8 = true;
            } else if ("BusName".equalsIgnoreCase(string6) && string5 != null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string5);
                bl7 = true;
                bl8 = true;
            }
            if (!bl8) continue;
            list.set(i, attributeList);
        }
        if (string != null && !bl) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"TopicSpace");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (string2 != null && !bl2) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"TopicName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string2);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (string3 != null && !bl3) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"DeliveryMode");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string3);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (l != null && !bl4) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"TimeToLive");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)l.toString());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.Long");
            list.add(attributeList);
        }
        if (n != null && !bl5) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"Priority");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)n.toString());
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.Integer");
            list.add(attributeList);
        }
        if (string4 != null && !bl6) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"ReadAhead");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string4);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        if (string5 != null && !bl7) {
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"BusName");
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string5);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
            list.add(attributeList);
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"properties", (Object)list);
        this.configService.setAttributes(session, objectName, attributeList);
    }

    private Hashtable getConnectionFactoryAttributes(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        return this.getConnectionFactoryAttributes(session, objectName, null);
    }

    private Hashtable getConnectionFactoryAttributes(Session session, ObjectName objectName, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        Hashtable hashtable2 = null;
        hashtable2 = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        String string = (String)this.configService.getAttribute(session, objectName, "authDataAlias", false);
        String string2 = (String)this.configService.getAttribute(session, objectName, "category", false);
        String string3 = (String)this.configService.getAttribute(session, objectName, "description", false);
        String string4 = (String)this.configService.getAttribute(session, objectName, "jndiName", false);
        Boolean bl = (Boolean)this.configService.getAttribute(session, objectName, "logMissingTransactionContext", false);
        Boolean bl2 = (Boolean)this.configService.getAttribute(session, objectName, "manageCachedHandles", false);
        String string5 = (String)this.configService.getAttribute(session, objectName, "name", false);
        String string6 = (String)this.configService.getAttribute(session, objectName, "xaRecoveryAuthAlias", false);
        if (string != null) {
            hashtable2.put("authDataAlias", string);
        }
        if (string2 != null) {
            hashtable2.put("category", string2);
        }
        if (string3 != null) {
            hashtable2.put("description", string3);
        }
        if (string4 != null) {
            hashtable2.put("jndiName", string4);
        }
        if (bl != null) {
            hashtable2.put("logMissingTransactionContext", bl);
        }
        if (bl2 != null) {
            hashtable2.put("manageCachedHandles", bl2);
        }
        if (string5 != null) {
            hashtable2.put("name", string5);
        }
        if (string6 != null) {
            hashtable2.put("xaRecoveryAuthAlias", string6);
        }
        return hashtable2;
    }

    private Hashtable getConnectionFactoryProperties(Session session, ObjectName objectName) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        return this.getConnectionFactoryAttributes(session, objectName, null);
    }

    private Hashtable getConnectionFactoryProperties(Session session, ObjectName objectName, Hashtable hashtable) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        AttributeList attributeList = this.configService.getAttributes(session, objectName, new String[]{"propertySet"}, true);
        AttributeList attributeList2 = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"propertySet");
        List list = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"resourceProperties");
        Hashtable hashtable2 = this.getProperties(list, hashtable);
        return hashtable2;
    }

    private Hashtable getQueueAttributes(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        return this.getQueueAttributes(session, objectName, null);
    }

    private Hashtable getQueueAttributes(Session session, ObjectName objectName, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        Hashtable hashtable2 = null;
        hashtable2 = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        String string = (String)this.configService.getAttribute(session, objectName, "name", false);
        String string2 = (String)this.configService.getAttribute(session, objectName, "jndiName", false);
        String string3 = (String)this.configService.getAttribute(session, objectName, "description", false);
        if (string != null) {
            hashtable2.put("name", string);
        }
        if (string2 != null) {
            hashtable2.put("jndiName", string2);
        }
        if (string3 != null) {
            hashtable2.put("description", string3);
        }
        return hashtable2;
    }

    private Hashtable getQueueProperties(Session session, ObjectName objectName) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        return this.getQueueProperties(session, objectName, null);
    }

    private Hashtable getQueueProperties(Session session, ObjectName objectName, Hashtable hashtable) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        List list = (List)this.configService.getAttribute(session, objectName, "properties", true);
        Hashtable hashtable2 = this.getProperties(list, hashtable);
        return hashtable2;
    }

    private Hashtable getTopicAttributes(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        return this.getTopicAttributes(session, objectName, null);
    }

    private Hashtable getTopicAttributes(Session session, ObjectName objectName, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        Hashtable hashtable2 = null;
        hashtable2 = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        String string = (String)this.configService.getAttribute(session, objectName, "name", false);
        String string2 = (String)this.configService.getAttribute(session, objectName, "jndiName", false);
        String string3 = (String)this.configService.getAttribute(session, objectName, "description", false);
        if (string != null) {
            hashtable2.put("name", string);
        }
        if (string2 != null) {
            hashtable2.put("jndiName", string2);
        }
        if (string3 != null) {
            hashtable2.put("description", string3);
        }
        return hashtable2;
    }

    private Hashtable getTopicProperties(Session session, ObjectName objectName) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        return this.getTopicProperties(session, objectName, null);
    }

    private Hashtable getTopicProperties(Session session, ObjectName objectName, Hashtable hashtable) throws AttributeNotFoundException, ConfigServiceException, ConnectorException {
        List list = (List)this.configService.getAttribute(session, objectName, "properties", true);
        Hashtable hashtable2 = this.getProperties(list, hashtable);
        return hashtable2;
    }

    private Hashtable getProperties(List list) throws AttributeNotFoundException {
        return this.getProperties(list, null);
    }

    private Hashtable getProperties(List list, Hashtable hashtable) throws AttributeNotFoundException {
        Hashtable hashtable2 = null;
        hashtable2 = hashtable == null ? new Hashtable() : (Hashtable)hashtable.clone();
        for (int i = 0; i < list.size(); ++i) {
            AttributeList attributeList = (AttributeList)list.get(i);
            String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"name");
            String string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"value");
            if ((string = this.formatName(string)) == null) continue;
            if (string2 == null) {
                string2 = new String("");
            }
            hashtable2.put(string, string2);
        }
        return hashtable2;
    }

    private String formatName(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string;
        string2 = "busName".equalsIgnoreCase(string) ? "busName" : ("clientID".equalsIgnoreCase(string) ? "clientID" : ("connectionProximity".equalsIgnoreCase(string) ? "connectionProximity" : ("deliveryMode".equalsIgnoreCase(string) ? "deliveryMode" : ("durableSubscriptionHome".equalsIgnoreCase(string) ? "durableSubscriptionHome" : ("nonPersistentMapping".equalsIgnoreCase(string) ? "nonPersistentMapping" : ("password".equalsIgnoreCase(string) ? "password" : ("persistentMapping".equalsIgnoreCase(string) ? "persistentMapping" : ("priority".equalsIgnoreCase(string) ? "priority" : ("providerEndPoints".equalsIgnoreCase(string) ? "providerEndPoints" : ("queueName".equalsIgnoreCase(string) ? "queueName" : ("readAhead".equalsIgnoreCase(string) ? "readAhead" : ("targetTransportChain".equalsIgnoreCase(string) ? "targetTransportChain" : ("Target".equalsIgnoreCase(string) ? "target" : ("TargetType".equalsIgnoreCase(string) ? "targetType" : ("TargetSignificance".equalsIgnoreCase(string) ? "targetSignificance" : ("shareDataSourceWithCMP".equalsIgnoreCase(string) ? "shareDataSourceWithCMP" : ("shareDurableSubscriptions".equalsIgnoreCase(string) ? "shareDurableSubscriptions" : ("temporaryQueueNamePrefix".equalsIgnoreCase(string) ? "tempQueueNamePrefix" : ("temporaryTopicNamePrefix".equalsIgnoreCase(string) ? "tempTopicNamePrefix" : ("timeToLive".equalsIgnoreCase(string) ? "timeToLive" : ("topicName".equalsIgnoreCase(string) ? "topicName" : ("topicSpace".equalsIgnoreCase(string) ? "topicSpace" : ("userName".equalsIgnoreCase(string) ? "userName" : null)))))))))))))))))))))));
        return string2;
    }

    private List merge(List list, List list2, List list3) {
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if (list3 != null) {
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    private void validateQueueProperties(String string, String string2, Long l, Integer n, String string3, String string4) throws SIBAdminCommandException {
        if (this.jmsQueue == null) {
            try {
                this.jmsQueue = JmsFactoryFactory.getInstance().createQueue(string);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3023", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_CREATE_JMSQUEUE_CWSJA0215", new Object[]{string}, null));
            }
        }
        if (string != null) {
            try {
                this.jmsQueue.setQueueName(string);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3035", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"QueueName", string}, null));
            }
        }
        if (string2 != null) {
            try {
                this.jmsQueue.setDeliveryMode(string2);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3047", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"DeliveryMode", string2}, null));
            }
        }
        if (l != null) {
            try {
                this.jmsQueue.setTimeToLive(l);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3059", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"TimeToLive", l}, null));
            }
        }
        if (n != null) {
            try {
                this.jmsQueue.setPriority(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3071", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"Priority", n}, null));
            }
        }
        if (string3 != null) {
            try {
                this.jmsQueue.setReadAhead(string3);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3083", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"ReadAhead", string3}, null));
            }
        }
        if (string4 != null) {
            try {
                this.jmsQueue.setBusName(string4);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateQueueProperties", (String)"3095", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSQUEUE_PROPERTY_VALUE_CWSJA0212", new Object[]{"BusName", string4}, null));
            }
        }
    }

    private void validateTopicProperties(String string, String string2, String string3, Long l, Integer n, String string4, String string5) throws SIBAdminCommandException {
        if (this.jmsTopic == null) {
            try {
                this.jmsTopic = JmsFactoryFactory.getInstance().createTopic(string2);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3132", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_CREATE_JMSTOPIC_CWSJA0216", new Object[]{string2}, null));
            }
        }
        if (string != null) {
            try {
                this.jmsTopic.setTopicSpace(string);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3144", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"TopicSpace", string}, null));
            }
        }
        if (string2 != null) {
            try {
                this.jmsTopic.setTopicName(string2);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3156", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"TopicName", string2}, null));
            }
        }
        if (string3 != null) {
            try {
                this.jmsTopic.setDeliveryMode(string3);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3168", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"DeliveryMode", string3}, null));
            }
        }
        if (l != null) {
            try {
                this.jmsTopic.setTimeToLive(l);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3180", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"TimeToLive", l}, null));
            }
        }
        if (n != null) {
            try {
                this.jmsTopic.setPriority(n);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3192", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"Priority", n}, null));
            }
        }
        if (string4 != null) {
            try {
                this.jmsTopic.setReadAhead(string4);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3204", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"ReadAhead", string4}, null));
            }
        }
        if (string5 != null) {
            try {
                this.jmsTopic.setBusName(string5);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateTopicProperties", (String)"3216", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_JMSTOPIC_PROPERTY_VALUE_CWSJA0213", new Object[]{"BusName", string5}, null));
            }
        }
    }

    private void validateConnectionFactoryProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17) throws SIBAdminCommandException {
        if (this.jmsConnectionFactory == null) {
            try {
                this.jmsConnectionFactory = JmsFactoryFactory.getInstance().createConnectionFactory();
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3278", (Object)((Object)this));
                throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_CREATE_JMSCF_CWSJA0217", null, null));
            }
        }
        if (string != null) {
            try {
                this.jmsConnectionFactory.setBusName(string);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3290", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string2 != null) {
            try {
                this.jmsConnectionFactory.setClientID(string2);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3302", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string3 != null) {
            try {
                this.jmsConnectionFactory.setUserName(string3);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3314", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string4 != null) {
            try {
                this.jmsConnectionFactory.setPassword(string4);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3326", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string5 != null) {
            try {
                this.jmsConnectionFactory.setNonPersistentMapping(string5);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3338", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string6 != null) {
            try {
                this.jmsConnectionFactory.setPersistentMapping(string6);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3350", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string7 != null) {
            try {
                this.jmsConnectionFactory.setDurableSubscriptionHome(string7);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3362", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string8 != null) {
            try {
                this.jmsConnectionFactory.setReadAhead(string8);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3374", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string9 != null) {
            try {
                this.jmsConnectionFactory.setTarget(string9);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3385", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string10 != null) {
            try {
                this.jmsConnectionFactory.setTargetType(string10);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3397", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string11 != null) {
            try {
                this.jmsConnectionFactory.setTargetSignificance(string11);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3409", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string12 != null) {
            try {
                this.jmsConnectionFactory.setTargetTransportChain(string12);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3421", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string13 != null) {
            try {
                this.jmsConnectionFactory.setProviderEndpoints(string13);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3433", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string14 != null) {
            try {
                this.jmsConnectionFactory.setConnectionProximity(string14);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3445", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string15 != null) {
            try {
                this.jmsConnectionFactory.setTemporaryQueueNamePrefix(string15);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3457", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string16 != null) {
            try {
                this.jmsConnectionFactory.setTemporaryTopicNamePrefix(string16);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3469", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
        if (string17 != null) {
            try {
                this.jmsConnectionFactory.setShareDurableSubscriptions(string17);
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.management.commands.sib.SIBJMSAdminCommandProvider.validateConnectionFactoryProperties", (String)"3481", (Object)((Object)this));
                throw new SIBAdminCommandException(jMSException.getMessage(), jMSException);
            }
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "Source info: @(#)SIB/ws/code/sib.admin.commands/src/com/ibm/ws/management/commands/sib/SIBJMSAdminCommandProvider.java, SIB.admin.config, WAS602.SIB, o0610.11 1.48.1.1");
        }
    }
}

