/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.management.commands.sib.SIBAdminCommandProvider;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import javax.resource.spi.InvalidPropertyException;

public class SIBJMSActSpecCmdProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBAdminCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static final String JMS_JCA_RESOURCE_ADAPTER_CLASS = "com.ibm.ws.sib.api.jmsra.impl.JmsJcaResourceAdapterImpl";
    private static final String JMS_JCA_ACTIVATION_SPEC_CLASS = "com.ibm.ws.sib.api.jmsra.impl.JmsJcaActivationSpecImpl";
    private static final String QUEUE_DESTINATION_TYPE = "javax.jms.Queue";
    private static final String TOPIC_DESTINATION_TYPE = "javax.jms.Topic";
    private static final String QUEUE_INPUT_DESTINATION_TYPE = "Queue";
    private static final String TOPIC_INPUT_DESTINATION_TYPE = "Topic";
    private static final String[] KNOWN_PROPERTIES = new String[]{"acknowledgeMode", "busName", "clientId", "destinationType", "durableSubscriptionHome", "maxBatchSize", "maxConcurrency", "messageSelector", "password", "subscriptionDurability", "subscriptionName", "shareDurableSubscriptions", "userName", "readAhead", "targetTransportChain", "shareDataSourceWithCMP"};
    private static final String JMSAS_NAME = "name";
    private static final String JMSAS_JNDI_NAME = "jndiName";
    private static final String JMSAS_DESTINATION_JNDI_NAME = "destinationJndiName";
    private static final String JMSAS_DESCRIPTION = "description";
    private static final String JMSAS_AUTH_ALIAS = "authenticationAlias";
    private static final String JMSAS_BUS_NAME = "busName";
    private static final String JMSAS_MESSAGE_LISTENER_TYPE = "messageListenerType";
    private static final String JMSAS_MESSAGE_LISTENER = "javax.jms.MessageListener";

    public ObjectName createSIBJMSActivationSpec(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBJMSActivationSpec";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "createSIBJMSActivationSpec", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        String string2 = (String)abstractAdminCommand.getParameter(JMSAS_NAME);
        String string3 = (String)abstractAdminCommand.getParameter(JMSAS_JNDI_NAME);
        String string4 = (String)abstractAdminCommand.getParameter(JMSAS_DESTINATION_JNDI_NAME);
        String string5 = (String)abstractAdminCommand.getParameter(JMSAS_DESCRIPTION);
        String string6 = (String)abstractAdminCommand.getParameter(JMSAS_AUTH_ALIAS);
        String string7 = (String)abstractAdminCommand.getParameter(JMSAS_BUS_NAME);
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, JMSAS_NAME}, null));
        }
        if (string3 == null || string3.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, JMSAS_JNDI_NAME}, null));
        }
        if (string4 == null || string4.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, JMSAS_DESTINATION_JNDI_NAME}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string2)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_ACT_SPEC_NAME_CWSJA0406", new Object[]{string2}, null));
        }
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(configService, session, objectName);
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = null;
        try {
            adminCommand = commandMgr.createCommand("createJ2CActivationSpec");
            adminCommand.setConfigSession(session);
            adminCommand.setTargetObject((Object)objectName2);
            adminCommand.setParameter(JMSAS_MESSAGE_LISTENER_TYPE, (Object)JMSAS_MESSAGE_LISTENER);
            adminCommand.setParameter(JMSAS_NAME, (Object)string2);
            adminCommand.setParameter(JMSAS_JNDI_NAME, (Object)string3);
            if (string4 != null) {
                adminCommand.setParameter(JMSAS_DESTINATION_JNDI_NAME, (Object)string4);
            }
            if (string5 != null) {
                adminCommand.setParameter(JMSAS_DESCRIPTION, (Object)string5);
            }
            if (string6 != null) {
                adminCommand.setParameter(JMSAS_AUTH_ALIAS, (Object)string6);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBJMSActSpecCmdProvider.createSIBJMSActivationSpec", (String)"136", (Object)((Object)this));
            throw new SIBAdminCommandException(nls.getFormattedMessage("CREATE_FAILED_CWSJA0401", new Object[]{objectName}, null), exception);
        }
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("CREATE_FAILED_CWSJA0401", new Object[]{objectName}, null));
        }
        if (!commandResult.isSuccessful()) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("CREATE_FAILED_CWSJA0401", new Object[]{objectName}, null), commandResult.getException());
        }
        ObjectName objectName3 = (ObjectName)commandResult.getResult();
        AttributeList attributeList = new AttributeList();
        if (string6 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_AUTH_ALIAS, (Object)string6);
        }
        if (attributeList.size() > 0) {
            try {
                configService.setAttributes(session, objectName3, attributeList);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBJMSActSpecCmdProvider.createSIBJMSActivationSpec", (String)"245", (Object)((Object)this));
            }
        }
        try {
            this.modifyProperties(abstractAdminCommand, configService, objectName3, session);
        }
        catch (Exception exception) {
            configService.deleteConfigData(session, objectName3);
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "createSIBJMSActivationSpec", objectName3);
        }
        return objectName3;
    }

    public ObjectName deleteSIBJMSActivationSpec(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "deleteSIBJMSActivationSpec", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        this.checkTargetIsActSpec(configService, session, objectName);
        String string = (String)configService.getAttribute(session, objectName, JMSAS_NAME, false);
        if (!SIBAdminCommandHelper.nameOkForDelete(string)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_ACT_SPEC_NAME_CWSJA0407", new Object[]{string}, null));
        }
        configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "deleteSIBJMSActivationSpec", objectName);
        }
        return objectName;
    }

    public ObjectName[] listSIBJMSActivationSpecs(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "listSIBJMSActivationSpecs", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        ObjectName objectName2 = this.getSIBJMSResourceAdapter(configService, session, objectName);
        ObjectName[] objectNameArray = this.listActSpecHelper(session, objectName2);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "listSIBJMSActivationSpecs", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName modifySIBJMSActivationSpec(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "modifySIBJMSActivationSpec", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        this.checkTargetIsActSpec(configService, session, objectName);
        String string = (String)abstractAdminCommand.getParameter(JMSAS_NAME);
        String string2 = (String)abstractAdminCommand.getParameter(JMSAS_JNDI_NAME);
        String string3 = (String)abstractAdminCommand.getParameter(JMSAS_DESCRIPTION);
        String string4 = (String)abstractAdminCommand.getParameter(JMSAS_DESTINATION_JNDI_NAME);
        String string5 = (String)abstractAdminCommand.getParameter(JMSAS_AUTH_ALIAS);
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_NAME, (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_JNDI_NAME, (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_DESCRIPTION, (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_DESTINATION_JNDI_NAME, (Object)string4);
        }
        if (string5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)JMSAS_AUTH_ALIAS, (Object)string5);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
        this.modifyProperties(abstractAdminCommand, configService, objectName, session);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "modifySIBJMSActivationSpec", objectName);
        }
        return objectName;
    }

    public Hashtable showSIBJMSActivationSpec(AbstractAdminCommand abstractAdminCommand) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, "showSIBJMSActivationSpec", new Object[]{abstractAdminCommand});
        }
        CommandProviderHelper commandProviderHelper = this.getCommandProviderHelper();
        ConfigService configService = commandProviderHelper.getConfigService();
        Session session = abstractAdminCommand.getConfigSession();
        ObjectName objectName = (ObjectName)abstractAdminCommand.getTargetObject();
        this.checkTargetIsActSpec(configService, session, objectName);
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object object = configService.getAttribute(session, objectName, JMSAS_NAME, false);
        Object object2 = configService.getAttribute(session, objectName, JMSAS_JNDI_NAME, false);
        Object object3 = configService.getAttribute(session, objectName, JMSAS_DESCRIPTION, false);
        Object object4 = configService.getAttribute(session, objectName, JMSAS_DESTINATION_JNDI_NAME, false);
        Object object5 = configService.getAttribute(session, objectName, JMSAS_AUTH_ALIAS, false);
        if (object == null) {
            object = "";
        }
        if (object2 == null) {
            object2 = "";
        }
        if (object3 == null) {
            object3 = "";
        }
        if (object4 == null) {
            object4 = "";
        }
        if (object5 == null) {
            object5 = "";
        }
        hashtable.put(JMSAS_NAME, object);
        hashtable.put(JMSAS_JNDI_NAME, object2);
        hashtable.put(JMSAS_DESCRIPTION, object3);
        hashtable.put(JMSAS_AUTH_ALIAS, object5);
        hashtable.put(JMSAS_DESTINATION_JNDI_NAME, object4);
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"resourceProperties"}, true);
        ArrayList arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"resourceProperties");
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AttributeList attributeList2 = (AttributeList)iterator.next();
            Object object6 = ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)JMSAS_NAME);
            Object object7 = ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"value");
            if (object7 == null) {
                object7 = "";
            }
            hashtable.put(object6, object7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, "showSIBJMSActivationSpec", hashtable);
        }
        return hashtable;
    }

    private ObjectName getSIBJMSResourceAdapter(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException, SIBAdminCommandException {
        if (configService == null || session == null || objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("GET_RA_FAILED_CWSJA0403", new Object[]{objectName}, null));
        }
        ObjectName objectName2 = null;
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "J2CResourceAdapter");
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName3;
            String string;
            ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectNameArray[i], "deploymentDescriptor", false);
            if (objectName4 == null || !JMS_JCA_RESOURCE_ADAPTER_CLASS.equals(string = (String)configService.getAttribute(session, objectName3 = (ObjectName)configService.getAttribute(session, objectName4, "resourceAdapter", false), "resourceAdapterClass", false))) continue;
            objectName2 = objectNameArray[i];
            break;
        }
        if (objectName2 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("GET_RA_FAILED_CWSJA0403", new Object[]{objectName}, null));
        }
        return objectName2;
    }

    private ObjectName[] listActSpecHelper(Session session, ObjectName objectName) throws CommandNotFoundException, CommandException, ConnectorException, SIBAdminCommandException {
        if (session == null || objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("LIST_FAILED_CWSJA0404", new Object[]{objectName}, null));
        }
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = null;
        adminCommand = commandMgr.createCommand("listJ2CActivationSpecs");
        adminCommand.setConfigSession(session);
        adminCommand.setTargetObject((Object)objectName);
        adminCommand.setParameter(JMSAS_MESSAGE_LISTENER_TYPE, (Object)JMSAS_MESSAGE_LISTENER);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("LIST_FAILED_CWSJA0404", new Object[]{objectName}, null));
        }
        if (!commandResult.isSuccessful()) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("LIST_FAILED_CWSJA0404", new Object[]{objectName}, null), commandResult.getException());
        }
        return (ObjectName[])commandResult.getResult();
    }

    private void checkTargetIsActSpec(ConfigService configService, Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException, SIBAdminCommandException {
        if (configService == null || configService == null || objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NOT_SIB_JMS_ACT_SPEC_CWSJA0405", new Object[]{objectName}, null));
        }
        boolean bl = false;
        ObjectName objectName2 = (ObjectName)configService.getAttribute(session, objectName, "activationSpec", false);
        if (objectName2 != null) {
            String string = (String)configService.getAttribute(session, objectName2, "activationSpecClass", false);
            if (string != null) {
                if (string.equals(JMS_JCA_ACTIVATION_SPEC_CLASS)) {
                    bl = true;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug(tc, "activationSpecClass attribute is not correct, expecting com.ibm.ws.sib.api.jmsra.impl.JmsJcaActivationSpecImpl");
                    SibTr.debug(tc, "found :" + string);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug(tc, "activationSpecClass attribute not found in " + objectName2);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug(tc, "activationSpec attribute not found in " + objectName);
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NOT_SIB_JMS_ACT_SPEC_CWSJA0405", new Object[]{objectName}, null));
        }
    }

    private void modifyProperties(AbstractAdminCommand abstractAdminCommand, ConfigService configService, ObjectName objectName, Session session) throws AttributeNotFoundException, ConfigServiceException, ConnectorException, SIBAdminCommandException, InvalidParameterNameException, InvalidPropertyException {
        if (abstractAdminCommand == null || configService == null || objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MODIFY_FAILED_CWSJA0402", new Object[]{objectName}, null));
        }
        AttributeList attributeList = configService.getAttributes(session, objectName, new String[]{"resourceProperties"}, true);
        ArrayList arrayList = (ArrayList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"resourceProperties");
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            Object object = abstractAdminCommand.getParameter(KNOWN_PROPERTIES[i]);
            if (object == null) continue;
            boolean bl = false;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext() && !bl) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)JMSAS_NAME);
                if (!string.equalsIgnoreCase(KNOWN_PROPERTIES[i])) continue;
                if (string.equals("readAhead")) {
                    this.validateReadAhead(object);
                }
                if (string.equals("destinationType")) {
                    object = this.validateDestinationType(object);
                }
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"value", (Object)object.toString());
                bl = true;
            }
            if (bl || !tc.isDebugEnabled()) continue;
            SibTr.debug(tc, "Parameter \"" + KNOWN_PROPERTIES[i] + "\", supplied by user, is not present in activation spec parameter set, discarding.");
        }
        configService.setAttributes(session, objectName, attributeList);
    }

    private void validateReadAhead(Object object) throws SIBAdminCommandException {
        String string = null;
        try {
            string = (String)object;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.management.commands.sib.SIBJMSActSpecCmdProvider.validateReadAhead", (String)"869", (Object)((Object)this));
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_ACT_SPEC_READAHEAD_VALUE_CWSJA0409", new Object[]{object}, null));
        }
        boolean bl = false;
        if (string.equals("Default")) {
            bl = true;
        } else if (string.equals("AlwaysOff")) {
            bl = true;
        } else if (string.equals("AlwaysOn")) {
            bl = true;
        }
        if (!bl) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_ACT_SPEC_READAHEAD_VALUE_CWSJA0409", new Object[]{string}, null));
        }
    }

    private Object validateDestinationType(Object object) throws SIBAdminCommandException {
        String string = null;
        try {
            string = (String)object;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.management.commands.sib.SIBJMSActSpecCmdProvider.validateDestinationType", (String)"911", (Object)((Object)this));
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_ACT_SPEC_DEST_TYPE_VALUE_CWSJA0410", new Object[]{object}, null));
        }
        if (string.equalsIgnoreCase(QUEUE_DESTINATION_TYPE)) {
            return QUEUE_DESTINATION_TYPE;
        }
        if (string.equalsIgnoreCase(TOPIC_DESTINATION_TYPE)) {
            return TOPIC_DESTINATION_TYPE;
        }
        if (string.equalsIgnoreCase(QUEUE_INPUT_DESTINATION_TYPE)) {
            return QUEUE_DESTINATION_TYPE;
        }
        if (string.equalsIgnoreCase(TOPIC_INPUT_DESTINATION_TYPE)) {
            return TOPIC_DESTINATION_TYPE;
        }
        throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_ACT_SPEC_DEST_TYPE_VALUE_CWSJA0410", new Object[]{string}, null));
    }
}

