/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.sibresources.SIBVirtualLink;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import com.ibm.wsspi.configarchive.ImportStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class SIBAdminImportNodeExt
extends ImportStep {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBAdminImportNodeExt";
    private static final TraceComponent tc = SibTr.register(SIBAdminImportNodeExt.class, "SIAS", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();
    private static final String colonTempSeparator = "...TEMP.SEPARATOR...";

    public SIBAdminImportNodeExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public SIBAdminImportNodeExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public void validate() throws CommandValidationException {
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        super.executeStep();
        try {
            Session session = this.getConfigSession();
            Session session2 = this.getConfigArchiveSession();
            Boolean bl = (Boolean)this.getParameter("includeBuses");
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (bl.booleanValue()) {
                this.importBusScopeConfig(session2, session);
            } else {
                this.cleanupServerScopeConfig(session);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminImportNodeExt.executeStep", (String)"150", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
        }
    }

    private void importBusScopeConfig(Session session, Session session2) throws Exception {
        ObjectName objectName = null;
        try {
            objectName = this.getCell(session);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminImportNodeExt.importBusScopeConfig", (String)"172", (Object)((Object)this));
            throw new ConfigArchiveException((Throwable)exception, nls.getFormattedMessage("CONFIG_ARCHIVE_CELL_NOT_FOUND_CWSJA0800", null, null));
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = this.getCell(session2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminImportNodeExt.importBusScopeConfig", (String)"184", (Object)((Object)this));
            throw new ConfigArchiveException((Throwable)exception, nls.getFormattedMessage("DMGR_CELL_NOT_FOUND_CWSJA0801", null, null));
        }
        ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBus");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray == null || objectNameArray.length < 1) {
            return;
        }
        for (int i = 0; i < objectNameArray.length; ++i) {
            Serializable serializable;
            ObjectName objectName4;
            Object object;
            ObjectName[] objectNameArray2;
            Object object2;
            Object object3;
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            ObjectName[] objectNameArray3 = configService.queryConfigObjects(session2, objectName2, objectName3, null);
            for (int j = 0; j < objectNameArray3.length; ++j) {
                object3 = (String)configService.getAttribute(session2, objectNameArray3[j], "name");
                if (!((String)object3).equals(string)) continue;
                throw new ConfigArchiveException(nls.getFormattedMessage("BUS_ALREADY_EXISTS_ON_DMGR_CWSJA0802", new Object[]{object3}, null));
            }
            AttributeList attributeList = configService.getAttributes(session, objectNameArray[i], null, true);
            this.substituteVirtualLinkNameColons(attributeList);
            object3 = this.clearForeignBusNextHops(attributeList, session);
            HashMap hashMap = this.clearLinkRefEngines(attributeList, session);
            ObjectName objectName5 = configService.createConfigData(session2, objectName2, "SIBus", "SIBus", attributeList);
            this.restoreForeignBusNextHops(session2, objectName5, (HashMap)object3);
            this.restoreLinkRefEngines(session2, objectName5, hashMap);
            this.restoreVirtualLinkNameColons(session2, objectName5);
            ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, (String)"SIBMediation");
            ObjectName[] objectNameArray4 = configService.queryConfigObjects(session, objectNameArray[i], objectName6, null);
            if (objectNameArray4 != null && objectNameArray4.length > 0) {
                for (int j = 0; j < objectNameArray4.length; ++j) {
                    object2 = ConfigServiceHelper.getConfigDataType((ObjectName)objectNameArray4[j]);
                    objectNameArray2 = configService.getAttributes(session, objectNameArray4[j], null, true);
                    object = configService.createConfigData(session2, objectName5, (String)object2, (String)object2, (AttributeList)objectNameArray2);
                }
            }
            if ((object2 = configService.queryConfigObjects(session, objectNameArray[i], objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAbstractDestination"), null)) == null || ((ObjectName[])object2).length < 1) continue;
            for (int j = 0; j < ((ObjectName[])object2).length; ++j) {
                object = ConfigServiceHelper.getConfigDataType((ObjectName)object2[j]);
                serializable = configService.getAttributes(session, object2[j], null, true);
                ObjectName objectName7 = configService.createConfigData(session2, objectName5, (String)object, (String)object, serializable);
            }
            objectName4 = ConfigServiceHelper.createObjectName(null, (String)"SIBAuthSpace");
            objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName4, null);
            if (objectNameArray2 == null || objectNameArray2.length <= 0) continue;
            object = new AttributeList();
            serializable = configService.createConfigDataByTemplate(session2, objectName5, "SIBAuthSpace", (AttributeList)object, objectNameArray2[0]);
        }
    }

    private void cleanupServerScopeConfig(Session session) throws Exception {
        String string = (String)this.taskCmd.getParameter("nodeName");
        List list = SIBAdminImportNodeExt.getServerList(session, string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            List list2 = SIBAdminCommandHelper.getEngineList(session, objectName);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator2.next();
                configService.deleteConfigData(session, objectName2);
            }
        }
    }

    private ObjectName getCell(Session session) throws Exception {
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"Cell");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray == null || objectNameArray.length < 1) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_CELLS_FOUND_CWSJA0803", null, null));
        }
        return objectNameArray[0];
    }

    private static List getServerList(Session session, String string) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "Node=" + string);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"Server");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "name");
            ObjectName objectName3 = SIBAdminCommandHelper.resolve(session, "Node=" + string + ":Server=" + string2);
            arrayList.add(objectName3);
        }
        return arrayList;
    }

    private void substituteVirtualLinkNameColons(AttributeList attributeList) throws Exception {
        List list = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"foreignBus");
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                AttributeList attributeList2 = (AttributeList)iterator.next();
                AttributeList attributeList3 = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"virtualLink");
                if (attributeList3 == null || (string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList3, (String)"name")) == null || string.indexOf(":") < 0) continue;
                string = string.replaceFirst(":", colonTempSeparator);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"name", (Object)string);
            }
        }
    }

    private void restoreVirtualLinkNameColons(Session session, ObjectName objectName) throws Exception {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace((Session)session);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBVirtualLink");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "name");
            if (string == null || string.indexOf(colonTempSeparator) < 0) continue;
            string = string.replaceFirst(colonTempSeparator, ":");
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId((ObjectName)objectNameArray[i]);
            String string2 = configDataId.getContextUri();
            RepositoryContext repositoryContext = workSpace.findContext(string2);
            ResourceSet resourceSet = repositoryContext.getResourceSet();
            SIBVirtualLink sIBVirtualLink = (SIBVirtualLink)resourceSet.getEObject(URI.createURI((String)configDataId.getHref()), true);
            sIBVirtualLink.setName(string);
            Resource resource = resourceSet.getResource(URI.createURI((String)"sib-bus.xml"), false);
            resource.save(new HashMap());
        }
    }

    private HashMap clearForeignBusNextHops(AttributeList attributeList, Session session) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"foreignBus");
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                ObjectName objectName = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"nextHop");
                if (objectName == null) continue;
                String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"uuid");
                String string2 = (String)configService.getAttribute(session, objectName, "uuid");
                hashMap.put(string, string2);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"nextHop", null);
            }
        }
        return hashMap;
    }

    private void restoreForeignBusNextHops(Session session, ObjectName objectName, HashMap hashMap) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBForeignBus");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "uuid");
            if (!hashMap.containsKey(string)) continue;
            String string2 = (String)hashMap.get(string);
            ObjectName objectName3 = null;
            for (int j = 0; j < objectNameArray.length; ++j) {
                String string3 = (String)configService.getAttribute(session, objectNameArray[j], "uuid");
                if (!string3.equals(string2)) continue;
                objectName3 = objectNameArray[j];
                break;
            }
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"nextHop", objectName3);
            configService.setAttributes(session, objectNameArray[i], attributeList);
        }
    }

    private HashMap clearLinkRefEngines(AttributeList attributeList, Session session) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List list = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"foreignBus");
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2 = (AttributeList)iterator.next();
                AttributeList attributeList3 = (AttributeList)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList2, (String)"virtualLink");
                if (attributeList3 == null) continue;
                String string = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList3, (String)"uuid");
                List list2 = (List)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList3, (String)"linkRef");
                if (list2 == null) continue;
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    AttributeList attributeList4 = (AttributeList)iterator2.next();
                    String string2 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList4, (String)"name");
                    ObjectName objectName = (ObjectName)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList4, (String)"engine");
                    String string3 = (String)configService.getAttribute(session, objectName, "engineUuid");
                    String string4 = string + ":" + string2;
                    hashMap.put(string4, string3);
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"engine", null);
                }
            }
        }
        return hashMap;
    }

    private void restoreLinkRefEngines(Session session, ObjectName objectName, HashMap hashMap) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBVirtualLink");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string = (String)configService.getAttribute(session, objectNameArray[i], "uuid");
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBLinkRef");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName3, null);
            if (objectNameArray2 == null) continue;
            for (int j = 0; j < objectNameArray2.length; ++j) {
                String string2 = (String)configService.getAttribute(session, objectNameArray2[j], "name");
                String string3 = string + ":" + string2;
                if (!hashMap.containsKey(string3)) continue;
                String string4 = (String)hashMap.get(string3);
                ObjectName objectName4 = null;
                ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, (String)"SIBusMemberTarget");
                ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, objectName, objectName5, null);
                for (int k = 0; k < objectNameArray3.length; ++k) {
                    String string5 = (String)configService.getAttribute(session, objectNameArray3[k], "engineUuid");
                    if (!string5.equals(string4)) continue;
                    objectName4 = objectNameArray3[k];
                    break;
                }
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"engine", objectName4);
                configService.setAttributes(session, objectNameArray2[j], attributeList);
            }
        }
    }
}

