/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCleanupNodeExt;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.management.ObjectName;

public class SIBAdminDeleteServerExt
extends AbstractCommandStep {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBAdminDeleteServerExt";
    private static final TraceComponent tc = SibTr.register(SIBAdminCleanupNodeExt.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();

    public SIBAdminDeleteServerExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public SIBAdminDeleteServerExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public void validate() throws CommandValidationException {
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        super.executeStep();
        try {
            this.removeServerFromAllBuses();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminDeleteServerExt.executeStep", (String)"108", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
        }
    }

    private void removeServerFromAllBuses() throws Exception {
        Session session = this.getConfigSession();
        String string = (String)this.taskCmd.getParameter("nodeName");
        String string2 = (String)this.taskCmd.getParameter("serverName");
        if (string == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.taskCmd.getName(), "nodeName"}, null));
        }
        if (string2 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.taskCmd.getName(), "serverName"}, null));
        }
        String[] stringArray = this.getCellBusNames(session);
        for (int i = 0; i < stringArray.length; ++i) {
            ObjectName[] objectNameArray = this.getBusMembers(session, stringArray[i]);
            for (int j = 0; j < objectNameArray.length; ++j) {
                String string3 = (String)configService.getAttribute(session, objectNameArray[j], "node");
                String string4 = (String)configService.getAttribute(session, objectNameArray[j], "server");
                String string5 = (String)configService.getAttribute(session, objectNameArray[j], "cluster");
                if (!string.equals(string3) || !string2.equals(string4)) continue;
                this.removeServerFromBus(session, stringArray[i], string, string2);
            }
        }
    }

    private String[] getCellBusNames(Session session) throws Exception {
        ObjectName[] objectNameArray = this.getCellBuses(session);
        return this.getBusNames(session, objectNameArray);
    }

    private ObjectName[] getCellBuses(Session session) throws Exception {
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listSIBuses");
        adminCommand.setConfigSession(session);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_COMMAND_RESULT_CWSJA1200", new Object[]{"listSIBuses"}, null));
        }
        if (!commandResult.isSuccessful()) {
            throw (Exception)commandResult.getException();
        }
        return (ObjectName[])commandResult.getResult();
    }

    private String[] getBusNames(Session session, ObjectName[] objectNameArray) throws Exception {
        String[] stringArray = new String[objectNameArray.length];
        for (int i = 0; i < objectNameArray.length; ++i) {
            stringArray[i] = (String)configService.getAttribute(session, objectNameArray[i], "name");
        }
        return stringArray;
    }

    private ObjectName[] getBusMembers(Session session, String string) throws Exception {
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("listSIBusMembers");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_COMMAND_RESULT_CWSJA1200", new Object[]{"listSIBusMembers"}, null));
        }
        if (!commandResult.isSuccessful()) {
            throw (Exception)commandResult.getException();
        }
        return (ObjectName[])commandResult.getResult();
    }

    private void removeServerFromBus(Session session, String string, String string2, String string3) throws Exception {
        CommandMgr commandMgr = CommandMgr.getCommandMgr();
        AdminCommand adminCommand = commandMgr.createCommand("removeSIBusMember");
        adminCommand.setConfigSession(session);
        adminCommand.setParameter("bus", (Object)string);
        adminCommand.setParameter("node", (Object)string2);
        adminCommand.setParameter("server", (Object)string3);
        adminCommand.execute();
        CommandResult commandResult = adminCommand.getCommandResult();
        if (commandResult == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_COMMAND_RESULT_CWSJA1200", new Object[]{"removeSIBusMember"}, null));
        }
        if (!commandResult.isSuccessful()) {
            throw (Exception)commandResult.getException();
        }
    }
}

