/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBAdminCommandProvider
extends SimpleCommandProvider {
    private static final TraceComponent tc = SibTr.register(SIBAdminCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static final Locale rootLocale = new Locale("", "");
    private ConfigService configService = ConfigServiceFactory.getConfigService();

    public ObjectName createSIBus(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "createSIBus";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("description");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("secure");
        String string4 = (String)abstractAdminCommand.getParameter("interEngineAuthAlias");
        String string5 = (String)abstractAdminCommand.getParameter("mediationsAuthAlias");
        String string6 = (String)abstractAdminCommand.getParameter("protocol");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("discardOnDelete");
        Long l = (Long)abstractAdminCommand.getParameter("highMessageThreshold");
        Boolean bl3 = (Boolean)abstractAdminCommand.getParameter("configurationReloadEnabled");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(string2)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_CREATE_BUS_NAME_CWSJA0021", new Object[]{string2}, null));
        }
        ObjectName objectName = null;
        if (SIBAdminCommandHelper.doesBusExist(session, string2)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_ALREADY_EXISTS_CWSJA0000", new Object[]{string2}, null));
        }
        objectName = SIBAdminCommandHelper.createBus(session, string2, string3, bl, string4, string5, string6, bl2, l, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName);
        }
        return objectName;
    }

    public String deleteSIBus(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteSIBus";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForDelete(string2)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_BUS_NAME_CWSJA0022", new Object[]{string2}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getBusByName(session, string2);
        if (objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        List list = SIBAdminCommandHelper.getBusMemberList(session, objectName);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName2 = (ObjectName)iterator.next();
                SIBAdminCommandHelper.deleteBusMember(session, objectName2, string2);
            }
        }
        this.configService.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, (Object)"");
        }
        return "";
    }

    public ObjectName[] listSIBuses(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBuses";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        List list = SIBAdminCommandHelper.getBusList(session);
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        list.toArray(objectNameArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName modifySIBus(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "modifySIBus";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("description");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("secure");
        String string4 = (String)abstractAdminCommand.getParameter("interEngineAuthAlias");
        String string5 = (String)abstractAdminCommand.getParameter("mediationsAuthAlias");
        String string6 = (String)abstractAdminCommand.getParameter("protocol");
        Boolean bl2 = (Boolean)abstractAdminCommand.getParameter("discardOnDelete");
        Long l = (Long)abstractAdminCommand.getParameter("highMessageThreshold");
        Boolean bl3 = (Boolean)abstractAdminCommand.getParameter("configurationReloadEnabled");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getBusByName(session, string2);
        if (objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        SIBAdminCommandHelper.modifyBus(session, objectName, string3, bl, string4, string5, string6, bl2, l, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName);
        }
        return objectName;
    }

    public Hashtable showSIBus(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "showSIBus";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = null;
        objectName = SIBAdminCommandHelper.getBusByName(session, string2);
        if (objectName == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        String string3 = (String)this.configService.getAttribute(session, objectName, "description", false);
        Boolean bl = (Boolean)this.configService.getAttribute(session, objectName, "secure", false);
        String string4 = (String)this.configService.getAttribute(session, objectName, "interEngineAuthAlias", false);
        String string5 = (String)this.configService.getAttribute(session, objectName, "mediationsAuthAlias", false);
        String string6 = (String)this.configService.getAttribute(session, objectName, "protocol", false);
        Boolean bl2 = (Boolean)this.configService.getAttribute(session, objectName, "discardMsgsAfterQueueDeletion", false);
        Long l = (Long)this.configService.getAttribute(session, objectName, "highMessageThreshold", false);
        Boolean bl3 = (Boolean)this.configService.getAttribute(session, objectName, "configurationReloadEnabled", false);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string2 != null) {
            hashtable.put("busName", string2);
        }
        if (string3 != null) {
            hashtable.put("description", string3);
        }
        if (bl != null) {
            hashtable.put("secure", bl);
        }
        if (string4 != null) {
            hashtable.put("interEngineAuthAlias", string4);
        }
        if (string5 != null) {
            hashtable.put("mediationsAuthAlias", string5);
        }
        if (string6 != null) {
            hashtable.put("protocol", string6);
        }
        if (bl2 != null) {
            hashtable.put("discardOnDelete", bl2);
        }
        if (l != null) {
            hashtable.put("highMessageThreshold", l);
        }
        if (bl3 != null) {
            hashtable.put("configurationReloadEnabled", bl3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, hashtable);
        }
        return hashtable;
    }

    public String addSIBusMember(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addSIBusMember";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Boolean bl = null;
        string2 = (String)abstractAdminCommand.getParameter("bus");
        string3 = (String)abstractAdminCommand.getParameter("node");
        string4 = (String)abstractAdminCommand.getParameter("server");
        string5 = (String)abstractAdminCommand.getParameter("cluster");
        bl = (Boolean)abstractAdminCommand.getParameter("createDefaultDatasource");
        String string6 = (String)abstractAdminCommand.getParameter("datasourceJndiName");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.isScopeValid(string3, string4, string5)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string3, string4, string5}, null));
        }
        if (SIBAdminCommandHelper.isServer(string3, string4, string5)) {
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            if (!(bl.booleanValue() || string6 != null && string6.length() >= 1)) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "datasourceJndiName"}, null));
            }
        } else {
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (bl.booleanValue()) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0037", new Object[]{string, "createDefaultDatasource", bl.toString()}, null));
            }
            if (string6 == null || string6.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "datasourceJndiName"}, null));
            }
        }
        SIBAdminCommandHelper.addBusMember(session, string2, string3, string4, string5, bl, string6);
        return "";
    }

    public String removeSIBusMember(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeSIBusMember";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.isScopeValid(string3, string4, string5)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string3, string4, string5}, null));
        }
        SIBAdminCommandHelper.removeBusMember(session, string2, string3, string4, string5);
        return "";
    }

    public ObjectName[] listSIBusMembers(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBusMembers";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        List list = SIBAdminCommandHelper.getBusList(session, string2);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string2}, null));
        }
        ObjectName objectName = (ObjectName)list.get(0);
        List list2 = SIBAdminCommandHelper.getBusMemberList(session, objectName);
        ObjectName[] objectNameArray = new ObjectName[list2.size()];
        list2.toArray(objectNameArray);
        return objectNameArray;
    }

    public Hashtable showSIBusMember(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "showSIBusMember";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.isScopeValid(string3, string4, string5)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string3, string4, string5}, null));
        }
        List list = SIBAdminCommandHelper.getBusList(session, string2);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string2}, null));
        }
        ObjectName objectName = (ObjectName)list.get(0);
        List list2 = SIBAdminCommandHelper.getBusMemberList(session, objectName, string3, string4, string5);
        if (list2.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUSMEMBER_NOT_FOUND_CWSJA0023", null, null));
        }
        if (list2.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSMEMBERS_FOUND_CWSJA0024", null, null));
        }
        ObjectName objectName2 = (ObjectName)list2.get(0);
        String string6 = (String)this.configService.getAttribute(session, objectName2, "server", false);
        String string7 = (String)this.configService.getAttribute(session, objectName2, "node", false);
        String string8 = (String)this.configService.getAttribute(session, objectName2, "cluster", false);
        String string9 = (String)this.configService.getAttribute(session, objectName2, "description", false);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string6 != null) {
            hashtable.put("server", string6);
        }
        if (string7 != null) {
            hashtable.put("node", string7);
        }
        if (string8 != null) {
            hashtable.put("cluster", string8);
        }
        if (string9 != null) {
            hashtable.put("description", string9);
        }
        return hashtable;
    }

    public ObjectName createSIBEngine(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        ObjectName objectName;
        String string = "createSIBEngine";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        String string6 = (String)abstractAdminCommand.getParameter("description");
        String string7 = (String)abstractAdminCommand.getParameter("initialState");
        Long l = (Long)abstractAdminCommand.getParameter("highMessageThreshold");
        Boolean bl = (Boolean)abstractAdminCommand.getParameter("createDefaultDatasource");
        String string8 = (String)abstractAdminCommand.getParameter("datasourceJndiName");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (string7 != null && !(string7 = string7.toUpperCase(rootLocale)).equals("STARTED") && !string7.equals("STOPPED")) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0037", new Object[]{string, "initialState", string7}, null));
        }
        ObjectName objectName2 = SIBAdminCommandHelper.getScope(session, string3, string4, string5);
        if (SIBAdminCommandHelper.isServer(string3, string4, string5)) {
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            if (!(bl.booleanValue() || string8 != null && string8.length() >= 1)) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "datasourceJndiName"}, null));
            }
        } else {
            if (bl == null) {
                bl = Boolean.FALSE;
            }
            if (bl.booleanValue()) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0037", new Object[]{string, "createDefaultDatasource", bl.toString()}, null));
            }
            if (string8 == null || string8.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "datasourceJndiName"}, null));
            }
        }
        if ((objectName = SIBAdminCommandHelper.getBusByName(session, string2)) == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string2}, null));
        }
        List list = SIBAdminCommandHelper.getBusMemberList(session, objectName, string3, string4, string5);
        if (list.size() != 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_BUS_MEMBER_CWSJA0018", null, null));
        }
        if (SIBAdminCommandHelper.isServer(string3, string4, string5) && (object = SIBAdminCommandHelper.getEngineList(session, objectName2, string2)).size() > 0) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_ALREADY_DEFINED_CWSJA0025", null, null));
        }
        object = SIBAdminCommandHelper.generateEngineName(session, string2, string3, string4, string5);
        ObjectName objectName3 = SIBAdminCommandHelper.createEngine(session, objectName, string3, string4, string5, string6, string7, l, bl, string8);
        return objectName3;
    }

    public String deleteSIBEngine(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteSIBEngine";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        String string6 = (String)abstractAdminCommand.getParameter("engine");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getEngine(session, string2, string3, string4, string5, string6);
        SIBAdminCommandHelper.deleteEngine(session, string3, string4, string5, objectName);
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, (Object)"");
        }
        return "";
    }

    public ObjectName[] listSIBEngines(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Object object;
        String string = "listSIBEngines";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        List list = null;
        if (string2 != null) {
            if (string3 == null && string4 == null && string5 == null) {
                object = SIBAdminCommandHelper.getBusByName(session, string2);
                List list2 = SIBAdminCommandHelper.getBusMemberList(session, (ObjectName)object);
                if (list2 != null) {
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        ObjectName objectName = (ObjectName)iterator.next();
                        String string6 = (String)this.configService.getAttribute(session, objectName, "node");
                        String string7 = (String)this.configService.getAttribute(session, objectName, "server");
                        String string8 = (String)this.configService.getAttribute(session, objectName, "cluster");
                        ObjectName objectName2 = SIBAdminCommandHelper.getScope(session, string6, string7, string8);
                        List list3 = SIBAdminCommandHelper.getEngineList(session, objectName2, string2);
                        if (list == null) {
                            list = list3;
                            continue;
                        }
                        list.addAll(list3);
                    }
                }
            } else {
                object = SIBAdminCommandHelper.getScope(session, string3, string4, string5);
                list = SIBAdminCommandHelper.getEngineList(session, (ObjectName)object, string2);
            }
        } else {
            object = SIBAdminCommandHelper.getScope(session, string3, string4, string5);
            list = SIBAdminCommandHelper.getEngineList(session, (ObjectName)object);
        }
        if (list == null) {
            object = new ObjectName[]{};
        } else {
            object = new ObjectName[list.size()];
            list.toArray((T[])object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, object);
        }
        return object;
    }

    public ObjectName modifySIBEngine(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "modifySIBEngine";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        String string6 = (String)abstractAdminCommand.getParameter("engine");
        String string7 = (String)abstractAdminCommand.getParameter("description");
        String string8 = (String)abstractAdminCommand.getParameter("initialState");
        Long l = (Long)abstractAdminCommand.getParameter("highMessageThreshold");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getEngine(session, string2, string3, string4, string5, string6);
        AttributeList attributeList = new AttributeList();
        if (string7 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string7);
        }
        if (string8 != null && !(string8 = string8.toUpperCase(rootLocale)).equals("STARTED") && !string8.equals("STOPPED")) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0037", new Object[]{string, "initialState", string8}, null));
        }
        if (string8 != null) {
            if (!(string8 = string8.toUpperCase(rootLocale)).equals("STARTED") && !string8.equals("STOPPED")) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0037", new Object[]{string, "initialState", string8}, null));
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"initialState", (Object)string8);
        }
        if (l != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"highMessageThreshold", (Object)l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, objectName);
        }
        if (attributeList.size() > 0) {
            this.configService.setAttributes(session, objectName, attributeList);
        }
        return objectName;
    }

    public Hashtable showSIBEngine(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "showSIBEngine";
        if (tc.isEntryEnabled()) {
            SibTr.entry(tc, string, new Object[]{abstractAdminCommand});
        }
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("node");
        String string4 = (String)abstractAdminCommand.getParameter("server");
        String string5 = (String)abstractAdminCommand.getParameter("cluster");
        String string6 = (String)abstractAdminCommand.getParameter("engine");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getEngine(session, string2, string3, string4, string5, string6);
        String string7 = (String)this.configService.getAttribute(session, objectName, "name", false);
        String string8 = (String)this.configService.getAttribute(session, objectName, "uuid", false);
        String string9 = (String)this.configService.getAttribute(session, objectName, "description", false);
        String string10 = (String)this.configService.getAttribute(session, objectName, "initialState", false);
        Long l = (Long)this.configService.getAttribute(session, objectName, "highMessageThreshold", false);
        String string11 = (String)this.configService.getAttribute(session, objectName, "busName", false);
        String string12 = (String)this.configService.getAttribute(session, objectName, "busUuid", false);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string7 != null) {
            hashtable.put("name", string7);
        }
        if (string8 != null) {
            hashtable.put("uuid", string8);
        }
        if (string9 != null) {
            hashtable.put("description", string9);
        }
        if (string10 != null) {
            hashtable.put("initialState", string10);
        }
        if (l != null) {
            hashtable.put("highMessageThreshold", l);
        }
        if (string11 != null) {
            hashtable.put("busName", string11);
        }
        if (string12 != null) {
            hashtable.put("busUuid", string12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit(tc, string, hashtable);
        }
        return hashtable;
    }

    public String deleteSIBDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "deleteSIBDestination";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("name");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        if (!SIBAdminCommandHelper.nameOkForDelete(string3)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_DELETE_DEST_NAME_CWSJA0026", new Object[]{string3}, null));
        }
        SIBAdminCommandHelper.deleteDestination(session, string2, string3);
        return "";
    }

    public ObjectName[] listSIBDestinations(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "listSIBDestinations";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("type");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getBusByName(session, string2);
        String string4 = null;
        if (string3 != null && !SIBAdminCommandHelper.checkDestinationType(string4 = string3.toUpperCase(rootLocale))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{string3}, null));
        }
        Object var8_8 = null;
        ObjectName objectName2 = null;
        if (string4 == null) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAbstractDestination");
        } else if (string4.equals("QUEUE")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBQueue");
        } else if (string4.equals("PORT")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBPort");
        } else if (string4.equals("WEBSERVICE")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBWebService");
        } else if (string4.equals("TOPICSPACE")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBTopicSpace");
        } else if (string4.equals("ALIAS")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationAlias");
        } else if (string4.equals("FOREIGN")) {
            objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationForeign");
        }
        ObjectName[] objectNameArray = this.configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }

    public Hashtable showSIBDestination(AbstractAdminCommand abstractAdminCommand) throws Exception {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        String string = "showSIBDestination";
        Session session = abstractAdminCommand.getConfigSession();
        String string2 = (String)abstractAdminCommand.getParameter("bus");
        String string3 = (String)abstractAdminCommand.getParameter("name");
        if (string2 == null || string2.length() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{string, "bus"}, null));
        }
        ObjectName objectName = SIBAdminCommandHelper.getBusByName(session, string2);
        List list = SIBAdminCommandHelper.getDestinationList(session, objectName);
        if ((list = SIBAdminCommandHelper.filterList(session, list, "identifier", string3)).size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DEST_NOT_FOUND_CWSJA0027", null, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_DESTS_FOUND_CWSJA0028", null, null));
        }
        ObjectName objectName2 = (ObjectName)list.get(0);
        String string4 = ConfigServiceHelper.getConfigDataType((ObjectName)objectName2);
        string4 = SIBAdminCommandHelper.convertConfigType(string4);
        String string5 = string4.toUpperCase(rootLocale);
        String string6 = (String)this.configService.getAttribute(session, objectName2, "identifier", false);
        String string7 = (String)this.configService.getAttribute(session, objectName2, "uuid", false);
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (string5.equals("ALIAS") || string5.equals("FOREIGN")) {
            string8 = (String)this.configService.getAttribute(session, objectName2, "bus", false);
        }
        if (string5.equals("ALIAS")) {
            string9 = (String)this.configService.getAttribute(session, objectName2, "targetIdentifier", false);
            string10 = (String)this.configService.getAttribute(session, objectName2, "targetBus", false);
        }
        String string11 = (String)this.configService.getAttribute(session, objectName2, "description", false);
        String string12 = (String)this.configService.getAttribute(session, objectName2, "reliability", false);
        String string13 = (String)this.configService.getAttribute(session, objectName2, "maxReliability", false);
        Object object2 = this.configService.getAttribute(session, objectName2, "overrideOfQOSByProducerAllowed", false);
        Integer n = (Integer)this.configService.getAttribute(session, objectName2, "defaultPriority", false);
        Integer n2 = null;
        if (string5.equals("QUEUE") || string5.equals("WEBSERVICE") || string5.equals("PORT") || string5.equals("TOPICSPACE")) {
            n2 = (Integer)this.configService.getAttribute(session, objectName2, "maxFailedDeliveries", false);
        }
        String string14 = null;
        if (string5.equals("QUEUE") || string5.equals("WEBSERVICE") || string5.equals("PORT") || string5.equals("TOPICSPACE")) {
            string14 = (String)this.configService.getAttribute(session, objectName2, "exceptionDestination", false);
        }
        Object object3 = this.configService.getAttribute(session, objectName2, "sendAllowed", false);
        Object object4 = null;
        if (!string5.equals("FOREIGN")) {
            object4 = this.configService.getAttribute(session, objectName2, "receiveAllowed", false);
        }
        Boolean bl = null;
        if (string5.equals("QUEUE") || string5.equals("WEBSERVICE") || string5.equals("PORT")) {
            bl = (Boolean)this.configService.getAttribute(session, objectName2, "receiveExclusive", false);
        }
        String string15 = null;
        String string16 = null;
        if (!string5.equals("FOREIGN") && (serializable2 = (ObjectName)this.configService.getAttribute(session, objectName2, "replyDestination", false)) != null) {
            string15 = (String)this.configService.getAttribute(session, (ObjectName)serializable2, "bus", false);
            string16 = (String)this.configService.getAttribute(session, (ObjectName)serializable2, "destination", false);
        }
        serializable2 = null;
        if (!string5.equals("FOREIGN") && !string5.equals("TOPICSPACE")) {
            serializable2 = new ArrayList();
            object = null;
            object = (List)this.configService.getAttribute(session, objectName2, "defaultForwardRoutingPath", false);
            serializable2 = new ArrayList();
            serializable = null;
            ArrayList<String> arrayList = null;
            String string17 = null;
            String string18 = null;
            for (int i = 0; i < object.size(); ++i) {
                arrayList = new ArrayList<String>();
                serializable = (ObjectName)object.get(i);
                string17 = (String)this.configService.getAttribute(session, (ObjectName)serializable, "bus", false);
                string18 = (String)this.configService.getAttribute(session, (ObjectName)serializable, "destination", false);
                arrayList.add(string17);
                arrayList.add(string18);
                serializable2.add(i, arrayList);
            }
        }
        object = null;
        if (string5.equals("ALIAS")) {
            object = (Boolean)this.configService.getAttribute(session, objectName2, "delegateAuthorizationCheckToTarget", false);
        }
        serializable = new Hashtable<String, Object>();
        if (string6 != null) {
            ((Hashtable)serializable).put("identifier", string6);
        }
        if (string7 != null) {
            ((Hashtable)serializable).put("uuid", string7);
        }
        if (string11 != null) {
            ((Hashtable)serializable).put("description", string11);
        }
        if (string8 != null) {
            ((Hashtable)serializable).put("bus", string8);
        }
        if (string9 != null) {
            ((Hashtable)serializable).put("targetIdentifier", string9);
        }
        if (string10 != null) {
            ((Hashtable)serializable).put("targetBus", string10);
        }
        if (string12 != null) {
            ((Hashtable)serializable).put("reliability", string12);
        }
        if (string13 != null) {
            ((Hashtable)serializable).put("maxReliability", string13);
        }
        if (object2 != null) {
            ((Hashtable)serializable).put("overrideOfQOSByProducerAllowed", object2.toString());
        }
        if (n != null) {
            ((Hashtable)serializable).put("defaultPriority", n);
        }
        if (n2 != null) {
            ((Hashtable)serializable).put("maxFailedDeliveries", n2);
        }
        if (string14 != null) {
            ((Hashtable)serializable).put("exceptionDestination", string14);
        }
        if (object3 != null) {
            ((Hashtable)serializable).put("sendAllowed", object3.toString());
        }
        if (object4 != null) {
            ((Hashtable)serializable).put("receiveAllowed", object4.toString());
        }
        if (bl != null) {
            ((Hashtable)serializable).put("receiveExclusive", bl);
        }
        if (string15 != null) {
            ((Hashtable)serializable).put("replyDestinationBusName", string15);
        }
        if (string16 != null) {
            ((Hashtable)serializable).put("replyDestinationName", string16);
        }
        if (serializable2 != null) {
            ((Hashtable)serializable).put("defaultForwardRoutingPath", serializable2);
        }
        if (object != null) {
            ((Hashtable)serializable).put("delegateAuthorizationCheckToTarget", object);
        }
        return serializable;
    }
}

