/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.sibresources.SIBDestinationReliabilityInheritType;
import com.ibm.websphere.models.config.sibresources.SIBDestinationReliabilityType;
import com.ibm.websphere.models.config.sibresources.SibresourcesFactory;
import com.ibm.websphere.models.config.sibresources.SibresourcesPackage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SIBAdminCommandHelper {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBAdminCommandHelper";
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static final String SIB_DATABASE_NAME_DESCRIPTION = "Location of default Cloudscape XA database";
    private static final String SIB_DATABASE_NAME_VALUE = "${USER_INSTALL_ROOT}/databases/com.ibm.ws.sib/";
    private static final String SIB_DATASOURCE_DESCRIPTION = "Default Datasource for SIB";
    private static final String SIB_DATASOURCE_HELPER_CLASSNAME = "com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper";
    private static final String SIB_DATASOURCE_NAME = "Default SIB XA Datasource";
    private static final Integer SIB_DATASOURCE_STATEMENT_CACHE_SIZE = new Integer(40);
    private static final Integer SIB_CONNECTION_POOL_MAX_CONNECTIONS = new Integer(50);
    private static final String SIB_DATASOURCE_JNDI_NAME_STUB = "jdbc/com.ibm.ws.sib/";
    private static final String SIB_JDBC_PROVIDER_NAME = "Cloudscape JDBC Provider";
    private static final String DEFAULT_TOPIC_SPACE_NAME = "Default.Topic.Space";
    private static final String EXCEPTION_DESTINATION_PREFIX = "_SYSTEM.Exception.Destination.";
    private static ConfigService configService = ConfigServiceFactory.getConfigService();
    private static final HashMap defaultDestinationAttributes = new HashMap();
    private static final Locale rootLocale = new Locale("", "");

    public static ConfigService getConfigService() {
        return configService;
    }

    public static void addBusMember(Session session, String string, String string2, String string3, String string4, Boolean bl, String string5) throws Exception {
        ObjectName objectName;
        if (!SIBAdminCommandHelper.isScopeValid(string2, string3, string4)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string2, string3, string4}, null));
        }
        if (configService == null) {
            configService = ConfigServiceFactory.getConfigService();
        }
        ObjectName objectName2 = SIBAdminCommandHelper.getScope(session, string2, string3, string4);
        List list = SIBAdminCommandHelper.getBusList(session, string);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string}, null));
        }
        ObjectName objectName3 = (ObjectName)list.get(0);
        String string6 = (String)configService.getAttribute(session, objectName3, "uuid");
        List list2 = SIBAdminCommandHelper.getBusMemberList(session, objectName3, string2, string3, string4);
        if (list2.size() != 0) {
            String string7 = "";
            if (SIBAdminCommandHelper.isServer(string2, string3, string4)) {
                string7 = string2 + ":" + string3;
            } else if (SIBAdminCommandHelper.isCluster(string2, string3, string4)) {
                string7 = string4;
            }
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_MEMBER_ALREADY_EXISTS_CWSJA0003", new Object[]{string7}, null));
        }
        String string8 = SIBAdminCommandHelper.generateEngineName(session, string, string2, string3, string4);
        List list3 = SIBAdminCommandHelper.getEngineList(session, objectName2, string8);
        if (!(list3 = SIBAdminCommandHelper.filterList(session, list3, "name", string8)).isEmpty()) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_EXISTS_CWSJA0004", new Object[]{string8}, null));
        }
        boolean bl2 = false;
        list = SIBAdminCommandHelper.getBusList(session);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            list2 = SIBAdminCommandHelper.getBusMemberList(session, objectName, string2, string3, string4);
            if (list2.size() <= 0) continue;
            bl2 = true;
        }
        objectName = SIBAdminCommandHelper.createBusMember(session, objectName3, string2, string3, string4);
        ObjectName objectName4 = SIBAdminCommandHelper.createEngine(session, objectName3, string2, string3, string4, null, null, null, bl, string5);
        if (!bl2) {
            if (SIBAdminCommandHelper.isServer(string2, string3, string4)) {
                SIBAdminCommandHelper.enableSIBService(session, objectName2);
            } else if (SIBAdminCommandHelper.isCluster(string2, string3, string4)) {
                List list4 = SIBAdminCommandHelper.getClusterServerList(session, string4);
                Iterator iterator2 = list4.iterator();
                while (iterator2.hasNext()) {
                    ObjectName objectName5 = (ObjectName)iterator2.next();
                    SIBAdminCommandHelper.enableSIBService(session, objectName5);
                }
            }
        }
    }

    public static boolean checkDestinationType(String string) {
        return "ALIAS".equalsIgnoreCase(string) || "FOREIGN".equalsIgnoreCase(string) || "PORT".equalsIgnoreCase(string) || "QUEUE".equalsIgnoreCase(string) || "TOPICSPACE".equalsIgnoreCase(string) || "WEBSERVICE".equalsIgnoreCase(string);
    }

    public static String convertConfigType(String string) {
        if (string.equals("SIBDestinationAlias")) {
            return "Alias";
        }
        if (string.equals("SIBDestinationForeign")) {
            return "Foreign";
        }
        if (string.equals("SIBPort")) {
            return "Port";
        }
        if (string.equals("SIBQueue")) {
            return "Queue";
        }
        if (string.equals("SIBTopicSpace")) {
            return "TopicSpace";
        }
        if (string.equals("SIBWebService")) {
            return "WebService";
        }
        return null;
    }

    public static ObjectName createBus(Session session, String string, String string2, Boolean bl, String string3, String string4, String string5, Boolean bl2, Long l, Boolean bl3) throws Exception {
        ObjectName objectName;
        ObjectName objectName2 = SIBAdminCommandHelper.getCell(session);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)string);
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string2);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"secure", (Object)bl);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"interEngineAuthAlias", (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"mediationsAuthAlias", (Object)string4);
        }
        if (string5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"protocol", (Object)string5);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"discardMsgsAfterQueueDeletion", (Object)bl2);
        }
        if (l != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"highMessageThreshold", (Object)l);
        }
        if (bl3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"configurationReloadEnabled", (Object)bl3);
        }
        ObjectName objectName3 = configService.createConfigData(session, objectName2, "SIBus", "SIBus", attributeList);
        ObjectName objectName4 = SIBAdminCommandHelper.createTopicSpace(session, objectName3, DEFAULT_TOPIC_SPACE_NAME, "");
        SIBAdminCommandHelper.modifyDestinationTopicSpace(session, objectName4, null, null, null, null, null, null, null, Boolean.TRUE, Boolean.TRUE, null, null, null);
        ObjectName objectName5 = null;
        ObjectName[] objectNameArray = configService.queryTemplates(session, "SIBAuthSpace");
        if (objectNameArray != null) {
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectName = objectNameArray[i];
                if (objectName.toString().indexOf("buses/default/sib-authorisations.xml#SIBAuthSpace_DEFAULT") <= -1) continue;
                objectName5 = objectName;
                break;
            }
        }
        if (objectName5 != null) {
            AttributeList attributeList2 = new AttributeList();
            objectName = configService.createConfigDataByTemplate(session, objectName3, "SIBAuthSpace", attributeList2, objectName5);
        }
        return objectName3;
    }

    private static ObjectName createBusMember(Session session, ObjectName objectName, String string, String string2, String string3) throws Exception {
        ObjectName objectName2;
        AttributeList attributeList = new AttributeList();
        if (string != null && string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"node", (Object)string);
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"server", (Object)string2);
        } else if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"cluster", (Object)string3);
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string, string2, string3}, null));
        }
        try {
            objectName2 = configService.createConfigData(session, objectName, "busMembers", "SIBusMember", attributeList);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminCommandHelper.createBusMember", (String)"499");
            String string4 = "";
            if (SIBAdminCommandHelper.isServer(string, string2, string3)) {
                string4 = string + ":" + string2;
            } else if (SIBAdminCommandHelper.isCluster(string, string2, string3)) {
                string4 = string3;
            }
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNABLE_TO_CREATE_BUSMEMBER_CWSJA0005", new Object[]{string4}, null));
        }
        return objectName2;
    }

    public static ObjectName createDestination(Session session, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        Object object;
        Object object2;
        ObjectName objectName;
        String string11 = string6.toUpperCase(rootLocale);
        boolean bl = true;
        if (!(string11.equals("TOPICSPACE") || string11.equals("ALIAS") || string11.equals("FOREIGN") || string11.equals("WEBSERVICE") || SIBAdminCommandHelper.isScopeValid(string2, string3, string4))) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string2, string3, string4}, null));
        }
        if (string11.equals("ALIAS") || string11.equals("FOREIGN") || string11.equals("WEBSERVICE")) {
            bl = false;
        }
        if (!SIBAdminCommandHelper.checkDestinationType(string11)) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{string6}, null));
        }
        List list = SIBAdminCommandHelper.getBusList(session, string);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string}, null));
        }
        ObjectName objectName2 = (ObjectName)list.get(0);
        String string12 = (String)configService.getAttribute(session, objectName2, "uuid");
        List list2 = SIBAdminCommandHelper.getDestinationList(session, objectName2);
        if ((list2 = SIBAdminCommandHelper.filterList(session, list2, "identifier", string5)).size() > 0) {
            objectName = null;
            object2 = null;
            object2 = string11.equals("ALIAS") ? (string7 == null || string7.equals("") ? string : string7) : (string11.equals("FOREIGN") ? string10 : string);
            for (int i = 0; i < list2.size(); ++i) {
                objectName = (ObjectName)list2.get(i);
                object = objectName.getKeyProperty("_Websphere_Config_Data_Type");
                String string13 = null;
                if (!(((String)object).equals("SIBDestinationAlias") || ((String)object).equals("SIBDestinationForeign") ? ((String)object2).equals(string13 = (String)configService.getAttribute(session, objectName, "bus")) : ((String)object2).equals(string))) continue;
                throw new SIBAdminCommandException(nls.getFormattedMessage("DEST_ALREADY_EXISTS_CWSJA0009", new Object[]{string5 + ":" + (String)object2}, null));
            }
        }
        objectName = null;
        if (string11.equals("QUEUE")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            objectName = configService.createConfigData(session, objectName2, "SIBQueue", "SIBQueue", (AttributeList)object2);
        } else if (string11.equals("WEBSERVICE")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            objectName = configService.createConfigData(session, objectName2, "SIBWebService", "SIBWebService", (AttributeList)object2);
        } else if (string11.equals("PORT")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            objectName = configService.createConfigData(session, objectName2, "SIBPort", "SIBPort", (AttributeList)object2);
        } else if (string11.equals("TOPICSPACE")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            objectName = configService.createConfigData(session, objectName2, "SIBTopicSpace", "SIBTopicSpace", (AttributeList)object2);
        } else if (string11.equals("ALIAS")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            if (string7 == null || string7.equals("")) {
                ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"bus", (Object)string);
            } else {
                ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"bus", (Object)string7);
            }
            if (string9 == null || string9.equals("")) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("MISSING_ALIAS_PARAMETER_CWSJA0010", new Object[]{"targetIdentifier"}, null));
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"targetIdentifier", (Object)string9);
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"targetBus", (Object)string8);
            objectName = configService.createConfigData(session, objectName2, "SIBDestinationAlias", "SIBDestinationAlias", (AttributeList)object2);
        } else if (string11.equals("FOREIGN")) {
            object2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"identifier", (Object)string5);
            if (string10 != null) {
                if (string10.equals("") || string10.equals(string)) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("MISSING_FOREIGN_PARAMETER_CWSJA0011", new Object[]{"foreignBus"}, null));
                }
            } else {
                throw new SIBAdminCommandException(nls.getFormattedMessage("MISSING_FOREIGN_PARAMETER_CWSJA0011", new Object[]{"foreignBus"}, null));
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)object2, (String)"bus", (Object)string10);
            objectName = configService.createConfigData(session, objectName2, "SIBDestinationForeign", "SIBDestinationForeign", (AttributeList)object2);
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{string6}, null));
        }
        if (bl) {
            object2 = null;
            if (string11.equals("QUEUE") || string11.equals("PORT")) {
                object2 = SIBAdminCommandHelper.getScope(session, string2, string3, string4);
                List list3 = SIBAdminCommandHelper.getEngineList(session, (ObjectName)object2, string);
                if (list3.size() < 1) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_NOT_FOUND_CWSJA0012", null, null));
                }
                if (list3.size() > 1 && SIBAdminCommandHelper.isServer(string2, string3, string4)) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_ENGINES_FOUND_CWSJA0013", null, null));
                }
                SIBAdminCommandHelper.localizeQueue(session, objectName, objectName2, string2, string3, string4);
            } else if (string11.equals("TOPICSPACE")) {
                List list4 = SIBAdminCommandHelper.getBusMemberList(session, objectName2);
                object = null;
                for (int i = 0; i < list4.size(); ++i) {
                    String string14;
                    String string15;
                    object = (ObjectName)list4.get(i);
                    String string16 = (String)configService.getAttribute(session, (ObjectName)object, "node");
                    object2 = SIBAdminCommandHelper.getScope(session, string16, string15 = (String)configService.getAttribute(session, (ObjectName)object, "server"), string14 = (String)configService.getAttribute(session, (ObjectName)object, "cluster"));
                    List list5 = SIBAdminCommandHelper.getEngineList(session, (ObjectName)object2, string);
                    if (list5.size() < 1) {
                        throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_NOT_FOUND_CWSJA0012", null, null));
                    }
                    if (list5.size() > 1 && SIBAdminCommandHelper.isServer(string2, string3, string4)) {
                        throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_ENGINES_FOUND_CWSJA0013", null, null));
                    }
                    SIBAdminCommandHelper.localizeTopicSpace(session, objectName, objectName2, string16, string15, string14);
                }
            } else {
                throw new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{string6}, null));
            }
        }
        return objectName;
    }

    private static void createDatasource(Session session, ObjectName objectName, String string, String string2) throws Exception {
        Object object;
        ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "JDBCProvider");
        ObjectName objectName2 = null;
        if (objectNameArray.length < 1) {
            objectName2 = SIBAdminCommandHelper.createJdbcProvider(session, objectName);
        } else {
            object = null;
            for (int i = 0; i < objectNameArray.length && !((String)(object = (String)configService.getAttribute(session, objectName2 = objectNameArray[i], "name"))).equals(SIB_JDBC_PROVIDER_NAME); ++i) {
            }
            if (!((String)object).equals(SIB_JDBC_PROVIDER_NAME)) {
                objectName2 = SIBAdminCommandHelper.createJdbcProvider(session, objectName);
            }
        }
        if (objectName2 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("SIB_JDBCPROVIDER_NOT_FOUND_CWSJA0015", null, null));
        }
        object = new AttributeList();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_");
        stringBuffer.append(string);
        String string3 = new String(stringBuffer);
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"name", (Object)string3);
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"jndiName", (Object)string2);
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"description", (Object)SIB_DATASOURCE_DESCRIPTION);
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"statementCacheSize", (Object)SIB_DATASOURCE_STATEMENT_CACHE_SIZE);
        ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"datasourceHelperClassname", (Object)SIB_DATASOURCE_HELPER_CLASSNAME);
        ObjectName objectName3 = configService.createConfigData(session, objectName2, "DataSource", "DataSource", (AttributeList)object);
        if (objectName3 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNABLE_TO_CREATE_DATASOURCE_CWSJA0016", null, null));
        }
        object = new AttributeList();
        ObjectName objectName4 = configService.createConfigData(session, objectName3, "propertySet", "J2EEResourcePropertySet", (AttributeList)object);
        if (objectName4 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNABLE_TO_CREATE_RESOURCE_PROPERTYSET_CWSJA0017", null, null));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(SIB_DATABASE_NAME_VALUE);
        stringBuffer2.append(string);
        String string4 = new String(stringBuffer2);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"databaseName");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)SIB_DATABASE_NAME_DESCRIPTION);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)string4);
        ObjectName objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"shutdownDatabase");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)"");
        objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"dataSourceName");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)"");
        objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"description");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)"");
        objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"connectionAttributes");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)"upgrade=true");
        objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)"createDatabase");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"type", (Object)"java.lang.String");
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"value", (Object)"create");
        objectName5 = configService.createConfigData(session, objectName4, "resourceProperties", "J2EEResourceProperty", attributeList);
        ObjectName objectName6 = (ObjectName)configService.getAttribute(session, objectName3, "connectionPool", false);
        if (objectName6 != null) {
            AttributeList attributeList2 = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList2, (String)"maxConnections", (Object)SIB_CONNECTION_POOL_MAX_CONNECTIONS);
            if (attributeList2.size() > 0) {
                configService.setAttributes(session, objectName6, attributeList2);
            }
        }
    }

    private static void deleteDatasource(Session session, ObjectName objectName, String string, String string2) throws Exception {
        ObjectName[] objectNameArray;
        ObjectName[] objectNameArray2 = configService.getRelationship(session, objectName, "JDBCProvider");
        ObjectName[] objectNameArray3 = null;
        if (objectNameArray2.length > 0) {
            for (int i = 0; i < objectNameArray2.length; ++i) {
                objectNameArray = objectNameArray2[i];
                String string3 = (String)configService.getAttribute(session, (ObjectName)objectNameArray, "name");
                if (!string3.equals(SIB_JDBC_PROVIDER_NAME)) continue;
                objectNameArray3 = objectNameArray;
                break;
            }
        }
        if (objectNameArray3 != null) {
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"DataSource");
            objectNameArray = configService.queryConfigObjects(session, objectNameArray3, objectName2, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string4 = (String)configService.getAttribute(session, objectNameArray[i], "name", false);
                String string5 = (String)configService.getAttribute(session, objectNameArray[i], "jndiName", false);
                if (!string4.equals("_" + string) || !string5.equals(string2)) continue;
                configService.deleteConfigData(session, objectNameArray[i]);
                break;
            }
        }
    }

    public static ObjectName createEngine(Session session, ObjectName objectName, String string, String string2, String string3, String string4, String string5, Long l, Boolean bl, String string6) throws Exception {
        ObjectName objectName2;
        Object object;
        ObjectName objectName3 = SIBAdminCommandHelper.getScope(session, string, string2, string3);
        List list = SIBAdminCommandHelper.getBusMemberList(session, objectName, string, string2, string3);
        if (list.size() != 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_BUS_MEMBER_CWSJA0018", null, null));
        }
        ObjectName objectName4 = (ObjectName)list.get(0);
        String string7 = (String)configService.getAttribute(session, objectName, "name");
        String string8 = SIBAdminCommandHelper.generateEngineName(session, string7, string, string2, string3);
        String string9 = (String)configService.getAttribute(session, objectName, "uuid");
        if (l == null) {
            l = (Long)configService.getAttribute(session, objectName, "highMessageThreshold");
        }
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"name", (Object)string8);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busName", (Object)string7);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"busUuid", (Object)string9);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string4);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"initialState", (Object)string5);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"highMessageThreshold", (Object)l);
        ObjectName objectName5 = configService.createConfigData(session, objectName3, "SIBMessagingEngine", "SIBMessagingEngine", attributeList);
        if (objectName5 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNABLE_TO_CREATE_ENGINE_CWSJA0019", null, null));
        }
        String string10 = new String(SIB_DATASOURCE_JNDI_NAME_STUB + string8);
        attributeList = new AttributeList();
        if (SIBAdminCommandHelper.isServer(string, string2, string3)) {
            if (bl.booleanValue()) {
                if (string6 == null) {
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)string10);
                } else {
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)string6);
                }
            } else if (string6 == null) {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)"");
            } else {
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)string6);
            }
        } else if (string6 == null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)"");
        } else {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"dataSourceName", (Object)string6);
        }
        ObjectName objectName6 = configService.createConfigData(session, objectName5, "dataStore", "SIBDatastore", attributeList);
        if (objectName6 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNABLE_TO_CREATE_DATASTORE_CWSJA0020", null, null));
        }
        if (bl.booleanValue() && SIBAdminCommandHelper.isServer(string, string2, string3)) {
            if (string6 != null) {
                SIBAdminCommandHelper.createDatasource(session, objectName3, string8, string6);
            } else {
                SIBAdminCommandHelper.createDatasource(session, objectName3, string8, string10);
            }
        }
        String string11 = (String)configService.getAttribute(session, objectName5, "uuid");
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"engineUuid", (Object)string11);
        ObjectName objectName7 = configService.createConfigData(session, objectName4, "target", "SIBusMemberTarget", attributeList);
        ObjectName objectName8 = SIBAdminCommandHelper.createExceptionDestination(session, objectName, objectName5, string, string2, string3);
        List list2 = SIBAdminCommandHelper.getTopicSpaceList(session, objectName);
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                objectName2 = (ObjectName)object.next();
                SIBAdminCommandHelper.localizeTopicSpace(session, objectName2, objectName, string, string2, string3);
            }
        }
        if (SIBAdminCommandHelper.isCluster(string, string2, string3) && (object = SIBAdminCommandHelper.getEngineList(session, objectName3, string7)) != null && object.size() > 0) {
            objectName2 = (ObjectName)object.get(0);
            String string12 = null;
            String string13 = (String)configService.getAttribute(session, objectName5, "uuid");
            for (int i = 0; i < object.size() && (string12 = (String)configService.getAttribute(session, objectName2 = (ObjectName)object.get(i), "uuid")).equals(string13); ++i) {
                objectName2 = null;
            }
            List list3 = null;
            if (objectName2 != null) {
                list3 = SIBAdminCommandHelper.getQueueLocalizationPointList(session, objectName2);
            }
            if (list3 != null) {
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName9 = (ObjectName)iterator.next();
                    String string14 = (String)configService.getAttribute(session, objectName9, "identifier");
                    if (string14.startsWith(EXCEPTION_DESTINATION_PREFIX)) continue;
                    String string15 = (String)configService.getAttribute(session, objectName9, "targetUuid");
                    ObjectName objectName10 = SIBAdminCommandHelper.getDestinationByUuid(session, objectName, string15);
                    SIBAdminCommandHelper.localizeQueue(session, objectName10, objectName, string, string2, string3);
                }
            }
        }
        return objectName5;
    }

    private static ObjectName createExceptionDestination(Session session, ObjectName objectName, ObjectName objectName2, String string, String string2, String string3) throws Exception {
        String string4 = (String)configService.getAttribute(session, objectName, "name");
        String string5 = (String)configService.getAttribute(session, objectName2, "name");
        String string6 = (String)configService.getAttribute(session, objectName2, "uuid");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EXCEPTION_DESTINATION_PREFIX);
        stringBuffer.append(string5);
        String string7 = new String(stringBuffer);
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string7);
        ObjectName objectName3 = configService.createConfigData(session, objectName, "SIBQueue", "SIBQueue", attributeList);
        String string8 = (String)configService.getAttribute(session, objectName3, "uuid");
        stringBuffer = new StringBuffer();
        stringBuffer.append(string7);
        stringBuffer.append("@");
        stringBuffer.append(string5);
        String string9 = new String(stringBuffer);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string9);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"targetUuid", (Object)string8);
        ObjectName objectName4 = configService.createConfigData(session, objectName2, "localizationPoints", "SIBQueueLocalizationPoint", attributeList);
        attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"node", (Object)string);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"server", (Object)string2);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"cluster", (Object)string3);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"engineUuid", (Object)string6);
        ObjectName objectName5 = configService.createConfigData(session, objectName3, "localizationPointRefs", "SIBLocalizationPointRef", attributeList);
        return objectName3;
    }

    private static ObjectName createTopicSpace(Session session, ObjectName objectName, String string, String string2) throws Exception {
        AttributeList attributeList = new AttributeList();
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string);
        ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string2);
        ObjectName objectName2 = configService.createConfigData(session, objectName, "SIBTopicSpace", "SIBTopicSpace", attributeList);
        List list = SIBAdminCommandHelper.getBusMemberList(session, objectName);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                String string3 = (String)configService.getAttribute(session, objectName3, "node");
                String string4 = (String)configService.getAttribute(session, objectName3, "server");
                String string5 = (String)configService.getAttribute(session, objectName3, "cluster");
                SIBAdminCommandHelper.localizeTopicSpace(session, objectName2, objectName, string3, string4, string5);
            }
        }
        return objectName2;
    }

    public static void deleteBusMember(Session session, ObjectName objectName, String string) throws Exception {
        String string2;
        String string3;
        String string4 = (String)configService.getAttribute(session, objectName, "node");
        ObjectName objectName2 = SIBAdminCommandHelper.getScope(session, string4, string3 = (String)configService.getAttribute(session, objectName, "server"), string2 = (String)configService.getAttribute(session, objectName, "cluster"));
        List list = SIBAdminCommandHelper.getEngineList(session, objectName2, string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                SIBAdminCommandHelper.deleteEngine(session, string4, string3, string2, objectName3);
            }
        }
        configService.deleteConfigData(session, objectName);
    }

    public static void deleteDestination(Session session, String string, String string2) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session, string);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string}, null));
        }
        ObjectName objectName = (ObjectName)list.get(0);
        List list2 = SIBAdminCommandHelper.getDestinationList(session, objectName);
        if ((list2 = SIBAdminCommandHelper.filterList(session, list2, "identifier", string2)).size() == 0) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DEST_NOT_FOUND_ON_BUS_CWSJA0034", new Object[]{string, string2}, null));
        }
        ObjectName objectName2 = null;
        String string3 = null;
        for (int i = 0; i < list2.size(); ++i) {
            objectName2 = (ObjectName)list2.get(i);
            string3 = (String)configService.getAttribute(session, objectName2, "uuid");
            List list3 = SIBAdminCommandHelper.getLocalizationPointRefList(session, objectName2);
            ObjectName objectName3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            for (int j = 0; j < list3.size(); ++j) {
                Object object;
                objectName3 = (ObjectName)list3.get(j);
                string4 = (String)configService.getAttribute(session, objectName3, "node");
                string5 = (String)configService.getAttribute(session, objectName3, "server");
                string6 = (String)configService.getAttribute(session, objectName3, "cluster");
                string7 = (String)configService.getAttribute(session, objectName3, "engineUuid");
                ObjectName objectName4 = SIBAdminCommandHelper.getScope(session, string4, string5, string6);
                if (objectName4 == null) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_SCOPE_SPECIFICATION_CWSJA0008", null, null));
                }
                List list4 = SIBAdminCommandHelper.getEngineList(session, objectName4);
                if ((list4 = SIBAdminCommandHelper.filterList(session, list4, "uuid", string7)).size() < 1) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_NOT_FOUND_CWSJA0012", null, null));
                }
                if (list4.size() > 1 && SIBAdminCommandHelper.isServer(string4, string5, string6)) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_ENGINES_FOUND_CWSJA0013", null, null));
                }
                ObjectName objectName5 = null;
                if (SIBAdminCommandHelper.isServer(string4, string5, string6)) {
                    objectName5 = (ObjectName)list4.get(0);
                    List list5 = SIBAdminCommandHelper.getLocalizationPointList(session, objectName5);
                    list5 = SIBAdminCommandHelper.filterList(session, list5, "targetUuid", string3);
                    object = null;
                    for (int k = 0; k < list5.size(); ++k) {
                        object = (ObjectName)list5.get(k);
                        configService.deleteConfigData(session, (ObjectName)object);
                    }
                    continue;
                }
                if (!SIBAdminCommandHelper.isCluster(string4, string5, string6)) continue;
                for (int k = 0; k < list4.size(); ++k) {
                    objectName5 = (ObjectName)list4.get(k);
                    object = SIBAdminCommandHelper.getLocalizationPointList(session, objectName5);
                    object = SIBAdminCommandHelper.filterList(session, (List)object, "targetUuid", string3);
                    ObjectName objectName6 = null;
                    for (int i2 = 0; i2 < object.size(); ++i2) {
                        objectName6 = (ObjectName)object.get(i2);
                        configService.deleteConfigData(session, objectName6);
                    }
                }
            }
            configService.deleteConfigData(session, objectName2);
        }
    }

    public static void deleteEngine(Session session, String string, String string2, String string3, ObjectName objectName) throws Exception {
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        ObjectName objectName2;
        Object object5;
        ObjectName[] objectNameArray;
        ObjectName objectName3;
        Object object6;
        String string4 = (String)configService.getAttribute(session, objectName, "name");
        String string5 = (String)configService.getAttribute(session, objectName, "uuid");
        String string6 = (String)configService.getAttribute(session, objectName, "busUuid");
        ObjectName objectName4 = SIBAdminCommandHelper.getBusByUuid(session, string6);
        if (objectName4 == null) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_FIND_BUS_BY_UUID_CWSJA0030", new Object[]{string6}, null));
        }
        String string7 = (String)configService.getAttribute(session, objectName4, "name");
        String string8 = EXCEPTION_DESTINATION_PREFIX + string4;
        try {
            SIBAdminCommandHelper.deleteDestination(session, string7, string8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List list = SIBAdminCommandHelper.getLocalizationPointList(session, objectName);
        if (list != null) {
            object6 = list.iterator();
            while (object6.hasNext()) {
                List list2;
                ObjectName[] objectNameArray2;
                objectName3 = (ObjectName)object6.next();
                objectNameArray = (ObjectName[])configService.getAttribute(session, objectName3, "identifier");
                object5 = ConfigServiceHelper.getConfigDataType((ObjectName)objectName3);
                if ("SIBMQLinkSenderChannelLocalizationPoint".equals(object5) || (objectName2 = SIBAdminCommandHelper.getDestinationByUuid(session, objectName4, (String)(object4 = (String)configService.getAttribute(session, objectName3, "targetUuid")))) == null) continue;
                object3 = (String)configService.getAttribute(session, objectName2, "identifier");
                object2 = SIBAdminCommandHelper.getLocalizationPointRefList(session, objectName2);
                n = object2.size();
                object2 = SIBAdminCommandHelper.filterList(session, (List)object2, "engineUuid", string5);
                int n2 = object2.size();
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        objectNameArray2 = (ObjectName[])object.next();
                        configService.deleteConfigData(session, (ObjectName)objectNameArray2);
                    }
                }
                if ((objectNameArray2 = configService.queryConfigObjects(session, objectName2, (ObjectName)(object = ConfigServiceHelper.createObjectName(null, (String)"SIBDestinationMediationRef")), null)) != null && objectNameArray2.length > 0) {
                    for (int i = 0; i < objectNameArray2.length; ++i) {
                        object = ConfigServiceHelper.createObjectName(null, (String)"SIBLocalizationPointRef");
                        ObjectName[] objectNameArray3 = configService.queryConfigObjects(session, objectNameArray2[i], (ObjectName)object, null);
                        if (objectNameArray3 != null && objectNameArray3.length >= 1) continue;
                        configService.deleteConfigData(session, objectNameArray2[i]);
                    }
                }
                if (DEFAULT_TOPIC_SPACE_NAME.equals(object3) || (list2 = SIBAdminCommandHelper.getLocalizationPointRefList(session, objectName2)) != null && list2.size() >= 1) continue;
                configService.deleteConfigData(session, objectName2);
            }
        }
        object6 = SIBAdminCommandHelper.getScope(session, string, string2, string3);
        objectName3 = ConfigServiceHelper.createObjectName(null, (String)"SIBDatastore");
        objectNameArray = configService.queryConfigObjects(session, objectName, objectName3, null);
        if (objectNameArray != null) {
            object5 = (String)configService.getAttribute(session, objectNameArray[0], "dataSourceName");
            SIBAdminCommandHelper.deleteDatasource(session, (ObjectName)object6, string4, (String)object5);
        }
        configService.deleteConfigData(session, objectName);
        object5 = SIBAdminCommandHelper.getBusMemberList(session, objectName4, string, string2, string3);
        object4 = object5.iterator();
        while (object4.hasNext()) {
            objectName2 = (ObjectName)object4.next();
            object3 = ConfigServiceHelper.createObjectName(null, (String)"SIBusMemberTarget");
            object2 = configService.queryConfigObjects(session, objectName2, (ObjectName)object3, null);
            for (n = 0; n < ((ObjectName[])object2).length; ++n) {
                Object object7 = object2[n];
                object = (String)configService.getAttribute(session, (ObjectName)object7, "engineUuid");
                if (!((String)object).equals(string5)) continue;
                configService.deleteConfigData(session, (ObjectName)object7);
            }
        }
    }

    public static boolean doesBusExist(Session session, String string) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session);
        return (list = SIBAdminCommandHelper.filterListIgnoreCase(session, list, "name", string)).size() >= 1;
    }

    public static List filterList(Session session, List list, String string, String string2) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string3 = (String)configService.getAttribute(session, objectName, string);
                if (!string2.equals(string3)) continue;
                arrayList.add(objectName);
            }
        }
        return arrayList;
    }

    public static List filterListIgnoreCase(Session session, List list, String string, String string2) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                String string3 = (String)configService.getAttribute(session, objectName, string);
                if (!string2.equalsIgnoreCase(string3)) continue;
                arrayList.add(objectName);
            }
        }
        return arrayList;
    }

    public static String generateEngineName(Session session, String string, String string2, String string3, String string4) throws Exception {
        String string5 = null;
        if (SIBAdminCommandHelper.isServer(string2, string3, string4)) {
            string5 = string2 + "." + string3 + "-" + string;
        } else if (SIBAdminCommandHelper.isCluster(string2, string3, string4)) {
            ObjectName objectName = SIBAdminCommandHelper.getScope(session, string2, string3, string4);
            List list = SIBAdminCommandHelper.getEngineList(session, objectName, string);
            List list2 = null;
            String string6 = null;
            for (int i = 0; i < 1000; ++i) {
                string6 = i < 10 ? string4 + ".00" + i + "-" + string : (i < 100 ? string4 + ".0" + i + "-" + string : string4 + "." + i + "-" + string);
                list2 = SIBAdminCommandHelper.filterList(session, list, "name", string6);
                if (!list2.isEmpty()) continue;
                string5 = string6;
                break;
            }
            if (string5 == null) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_ENGINE_NAMES_AVAILABLE_CWSJA0031", null, null));
            }
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string2, string3, string4}, null));
        }
        return string5;
    }

    public static ObjectName getBusByName(Session session, String string) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session);
        if ((list = SIBAdminCommandHelper.filterList(session, list, "name", string)).size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string}, null));
        }
        ObjectName objectName = (ObjectName)list.get(0);
        return objectName;
    }

    private static ObjectName getBusByUuid(Session session, String string) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session);
        list = SIBAdminCommandHelper.filterList(session, list, "uuid", string);
        ObjectName objectName = null;
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DUPLICATE_BUS_UUIDS_CWSJA0029", null, null));
        }
        if (list.size() == 1) {
            objectName = (ObjectName)list.get(0);
        }
        return objectName;
    }

    public static List getBusList(Session session) throws Exception {
        ObjectName objectName = SIBAdminCommandHelper.getCell(session);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBus");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    public static List getBusList(Session session, String string) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session);
        list = SIBAdminCommandHelper.filterList(session, list, "name", string);
        return list;
    }

    public static List getBusMemberList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBusMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    public static List getBusMemberList(Session session, ObjectName objectName, String string, String string2, String string3) throws Exception {
        List list = SIBAdminCommandHelper.getBusMemberList(session, objectName);
        if (SIBAdminCommandHelper.isServer(string, string2, string3)) {
            list = SIBAdminCommandHelper.filterList(session, list, "node", string);
            list = SIBAdminCommandHelper.filterList(session, list, "server", string2);
        } else if (SIBAdminCommandHelper.isCluster(string, string2, string3)) {
            list = SIBAdminCommandHelper.filterList(session, list, "cluster", string3);
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{string, string2, string3}, null));
        }
        return list;
    }

    private static ObjectName getCell(Session session) throws Exception {
        String string = SIBAdminCommandHelper.getCellName();
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "Cell=" + string);
        return objectName;
    }

    private static String getCellName() {
        String string = null;
        try {
            string = AdminServiceFactory.getAdminService().getCellName();
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            string = System.getProperty("local.cell");
        }
        return string;
    }

    private static ObjectName getDestinationByUuid(Session session, ObjectName objectName, String string) throws Exception {
        List list = SIBAdminCommandHelper.getDestinationList(session, objectName);
        list = SIBAdminCommandHelper.filterList(session, list, "uuid", string);
        ObjectName objectName2 = null;
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("DUPLICATE_DEST_UUID_CWSJA0032", null, null));
        }
        if (list.size() == 1) {
            objectName2 = (ObjectName)list.get(0);
        }
        return objectName2;
    }

    public static List getDestinationList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBAbstractDestination");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    public static ObjectName getEngine(Session session, String string, String string2, String string3, String string4, String string5) throws Exception {
        ObjectName objectName = SIBAdminCommandHelper.getScope(session, string2, string3, string4);
        List list = SIBAdminCommandHelper.getEngineList(session, objectName, string);
        if (string5 != null) {
            list = SIBAdminCommandHelper.filterList(session, list, "name", string5);
        }
        if (list.size() == 0) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("ENGINE_NOT_FOUND_CWSJA0012", null, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_ENGINES_FOUND_CWSJA0013", null, null));
        }
        ObjectName objectName2 = (ObjectName)list.get(0);
        return objectName2;
    }

    public static List getEngineList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBMessagingEngine");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    public static List getEngineList(Session session, ObjectName objectName, String string) throws Exception {
        List list = SIBAdminCommandHelper.getEngineList(session, objectName);
        list = SIBAdminCommandHelper.filterList(session, list, "busName", string);
        return list;
    }

    private static List getLocalizationPointList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBLocalizationPoint");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    private static List getLocalizationPointRefList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBLocalizationPointRef");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    private static List getQueueLocalizationPointList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBQueueLocalizationPoint");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    private static List getTopicSpaceList(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBTopicSpace");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return Arrays.asList(objectNameArray);
    }

    public static ObjectName getScope(Session session, String string, String string2, String string3) throws Exception {
        ObjectName objectName = null;
        if (SIBAdminCommandHelper.isServer(string, string2, string3)) {
            objectName = SIBAdminCommandHelper.resolve(session, "Node=" + string + ":Server=" + string2);
            ObjectName[] objectNameArray = configService.getRelationship(session, objectName, "SIBService");
            if (objectNameArray.length == 0) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_MESSAGING_SERVER_CWSJA0033", null, null));
            }
        } else if (SIBAdminCommandHelper.isCluster(string, string2, string3)) {
            objectName = SIBAdminCommandHelper.resolve(session, "ServerCluster=" + string3);
        } else {
            throw new SIBAdminCommandException(nls.getFormattedMessage("INVALID_SCOPE_SPECIFICATION_CWSJA0008", null, null));
        }
        return objectName;
    }

    public static boolean isCluster(String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null && string.length() > 0) {
            bl = true;
        }
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
        }
        if (string3 != null && string3.length() > 0) {
            bl3 = true;
        }
        return !bl && !bl2 && bl3;
    }

    public static boolean isServer(String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null && string.length() > 0) {
            bl = true;
        }
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
        }
        if (string3 != null && string3.length() > 0) {
            bl3 = true;
        }
        return bl && bl2 && !bl3;
    }

    private static void localizeDestination(Session session, ObjectName objectName, ObjectName objectName2, String string, String string2, String string3, String string4) throws Exception {
        String string5 = string4.toUpperCase(rootLocale);
        if (!string5.equals("QUEUE") && !string5.equals("TOPICSPACE")) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{string4}, null));
        }
        ObjectName objectName3 = SIBAdminCommandHelper.getScope(session, string, string2, string3);
        String string6 = (String)configService.getAttribute(session, objectName, "uuid");
        String string7 = (String)configService.getAttribute(session, objectName, "identifier");
        String string8 = (String)configService.getAttribute(session, objectName2, "name");
        List list = SIBAdminCommandHelper.getEngineList(session, objectName3, string8);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName4 = (ObjectName)iterator.next();
                String string9 = (String)configService.getAttribute(session, objectName4, "name");
                String string10 = (String)configService.getAttribute(session, objectName4, "uuid");
                Long l = (Long)configService.getAttribute(session, objectName4, "highMessageThreshold");
                List list2 = SIBAdminCommandHelper.getLocalizationPointList(session, objectName4);
                if ((list2 = SIBAdminCommandHelper.filterList(session, list2, "targetUuid", string6)).size() > 0) continue;
                String string11 = string7 + "@" + string9;
                AttributeList attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"identifier", (Object)string11);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"targetUuid", (Object)string6);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"highMessageThreshold", (Object)l);
                ObjectName objectName5 = null;
                if (string5.equals("TOPICSPACE")) {
                    objectName5 = configService.createConfigData(session, objectName4, "localizationPoints", "SIBTopicSpaceLocalizationPoint", attributeList);
                } else if (string5.equals("QUEUE")) {
                    objectName5 = configService.createConfigData(session, objectName4, "localizationPoints", "SIBQueueLocalizationPoint", attributeList);
                }
                attributeList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"node", (Object)string);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"server", (Object)string2);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"cluster", (Object)string3);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"engineUuid", (Object)string10);
                ObjectName objectName6 = configService.createConfigData(session, objectName, "localizationPointRefs", "SIBLocalizationPointRef", attributeList);
            }
        }
    }

    private static void localizeQueue(Session session, ObjectName objectName, ObjectName objectName2, String string, String string2, String string3) throws Exception {
        SIBAdminCommandHelper.localizeDestination(session, objectName, objectName2, string, string2, string3, "queue");
    }

    private static void localizeTopicSpace(Session session, ObjectName objectName, ObjectName objectName2, String string, String string2, String string3) throws Exception {
        SIBAdminCommandHelper.localizeDestination(session, objectName, objectName2, string, string2, string3, "topicSpace");
    }

    public static void modifyBus(Session session, ObjectName objectName, String string, Boolean bl, String string2, String string3, String string4, Boolean bl2, Long l, Boolean bl3) throws Exception {
        AttributeList attributeList = new AttributeList();
        String string5 = (String)configService.getAttribute(session, objectName, "name");
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"secure", (Object)bl);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"interEngineAuthAlias", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"mediationsAuthAlias", (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"protocol", (Object)string4);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"discardMsgsAfterQueueDeletion", (Object)bl2);
        }
        if (l != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"highMessageThreshold", (Object)l);
        }
        if (bl3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"configurationReloadEnabled", (Object)bl3);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
    }

    public static ObjectName modifyDestinationQueue(Session session, ObjectName objectName, String string, String string2, String string3, String string4, Integer n, Integer n2, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, String string5, String string6, String[][] stringArray) throws Exception {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"reliability", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxReliability", (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"exceptionDestination", (Object)string4);
        }
        if (n != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultPriority", (Object)n);
        }
        if (n2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxFailedDeliveries", (Object)n2);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"overrideOfQOSByProducerAllowed", (Object)bl);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"sendAllowed", (Object)bl2);
        }
        if (bl3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"receiveAllowed", (Object)bl3);
        }
        if (bl4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"receiveExclusive", (Object)bl4);
        }
        if (bl5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"topicAccessCheckRequired", (Object)bl5);
        }
        AttributeList attributeList2 = (AttributeList)configService.getAttribute(session, objectName, "replyDestination");
        ObjectName objectName2 = null;
        boolean bl6 = false;
        if (attributeList2 != null) {
            objectName2 = ConfigServiceHelper.createObjectName((AttributeList)attributeList2);
            bl6 = true;
        }
        if (!bl6) {
            if (string6 != null) {
                if (!string6.equals("")) {
                    serializable = null;
                    AttributeList attributeList3 = new AttributeList();
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"bus", (Object)string5);
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"destination", (Object)string6);
                    serializable = configService.createConfigData(session, objectName, "replyDestination", "SIBQualifiedDestinationName", attributeList3);
                } else if (string5 != null && !string5.equals("")) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("REMOVING_REPLY_DESTINATION_CWSJA0047", null, null));
                }
            } else if (string5 != null && !string5.equals("")) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("REMOVING_REPLY_DESTINATION_CWSJA0047", null, null));
            }
        } else if (string6 != null) {
            if (!string6.equals("")) {
                serializable = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"destination", (Object)string6);
                if (string5 != null) {
                    ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"bus", (Object)string5);
                }
                configService.setAttributes(session, objectName2, (AttributeList)serializable);
            } else {
                configService.deleteConfigData(session, objectName2);
            }
        } else if (string5 != null) {
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"bus", (Object)string5);
            configService.setAttributes(session, objectName2, (AttributeList)serializable);
        }
        if (stringArray != null) {
            serializable = new ArrayList(stringArray[1].length);
            for (int i = 0; i < stringArray[1].length; ++i) {
                AttributeList attributeList4 = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"bus", (Object)stringArray[0][i]);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"destination", (Object)stringArray[1][i]);
                ((ArrayList)serializable).add(i, attributeList4);
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultForwardRoutingPath", (Object)serializable);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
        return objectName;
    }

    public static ObjectName modifyDestinationTopicSpace(Session session, ObjectName objectName, String string, String string2, String string3, String string4, Integer n, Integer n2, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, String string5, String string6) throws Exception {
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"reliability", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxReliability", (Object)string3);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"exceptionDestination", (Object)string4);
        }
        if (n != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultPriority", (Object)n);
        }
        if (n2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxFailedDeliveries", (Object)n2);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"overrideOfQOSByProducerAllowed", (Object)bl);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"sendAllowed", (Object)bl2);
        }
        if (bl3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"receiveAllowed", (Object)bl3);
        }
        if (bl4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"topicAccessCheckRequired", (Object)bl4);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
        return objectName;
    }

    public static ObjectName modifyDestinationForeign(Session session, ObjectName objectName, String string, String string2, String string3, Integer n, Boolean bl, Boolean bl2) throws Exception {
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"reliability", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxReliability", (Object)string3);
        }
        if (n != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultPriority", (Object)n);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"overrideOfQOSByProducerAllowed", (Object)bl);
        }
        if (bl2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"sendAllowed", (Object)bl2);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
        return objectName;
    }

    public static ObjectName modifyDestinationAlias(Session session, ObjectName objectName, String string, String string2, Integer n, String string3, String string4, String string5, String string6, String string7, String string8, String[][] stringArray, Boolean bl) throws Exception {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (string != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"description", (Object)string);
        }
        if (string2 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"reliability", (Object)string2);
        }
        if (string3 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"maxReliability", (Object)string3);
        }
        if (n != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultPriority", (Object)n);
        }
        if (string4 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"overrideOfQOSByProducerAllowed", (Object)string4);
        }
        if (string5 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"sendAllowed", (Object)string5);
        }
        if (string6 != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"receiveAllowed", (Object)string6);
        }
        AttributeList attributeList2 = (AttributeList)configService.getAttribute(session, objectName, "replyDestination");
        ObjectName objectName2 = null;
        boolean bl2 = false;
        if (attributeList2 != null) {
            objectName2 = ConfigServiceHelper.createObjectName((AttributeList)attributeList2);
            bl2 = true;
        }
        if (!bl2) {
            if (string8 != null) {
                if (!string8.equals("")) {
                    serializable = null;
                    AttributeList attributeList3 = new AttributeList();
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"bus", (Object)string7);
                    ConfigServiceHelper.setAttributeValue((AttributeList)attributeList3, (String)"destination", (Object)string8);
                    serializable = configService.createConfigData(session, objectName, "replyDestination", "SIBQualifiedDestinationName", attributeList3);
                } else if (string7 != null && !string7.equals("")) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("REMOVING_REPLY_DESTINATION_CWSJA0047", null, null));
                }
            } else if (string7 != null && !string7.equals("")) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("REMOVING_REPLY_DESTINATION_CWSJA0047", null, null));
            }
        } else if (string8 != null) {
            if (!string8.equals("")) {
                serializable = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"destination", (Object)string8);
                if (string7 != null) {
                    ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"bus", (Object)string7);
                }
                configService.setAttributes(session, objectName2, (AttributeList)serializable);
            } else {
                configService.deleteConfigData(session, objectName2);
            }
        } else if (string7 != null) {
            serializable = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)serializable, (String)"bus", (Object)string7);
            configService.setAttributes(session, objectName2, (AttributeList)serializable);
        }
        if (stringArray != null) {
            serializable = new ArrayList(stringArray[1].length);
            for (int i = 0; i < stringArray[1].length; ++i) {
                AttributeList attributeList4 = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"bus", (Object)stringArray[0][i]);
                ConfigServiceHelper.setAttributeValue((AttributeList)attributeList4, (String)"destination", (Object)stringArray[1][i]);
                ((ArrayList)serializable).add(i, attributeList4);
            }
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"defaultForwardRoutingPath", (Object)serializable);
        }
        if (bl != null) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"delegateAuthorizationCheckToTarget", (Object)bl);
        }
        if (attributeList.size() > 0) {
            configService.setAttributes(session, objectName, attributeList);
        }
        return objectName;
    }

    public static void removeBusMember(Session session, String string, String string2, String string3, String string4) throws Exception {
        List list = SIBAdminCommandHelper.getBusList(session, string);
        if (list.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUS_NOT_FOUND_CWSJA0001", new Object[]{string}, null));
        }
        if (list.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSES_FOUND_CWSJA0002", new Object[]{string}, null));
        }
        ObjectName objectName = (ObjectName)list.get(0);
        List list2 = SIBAdminCommandHelper.getBusMemberList(session, objectName, string2, string3, string4);
        if (list2.size() < 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("BUSMEMBER_NOT_FOUND_CWSJA0023", null, null));
        }
        if (list2.size() > 1) {
            throw new SIBAdminCommandException(nls.getFormattedMessage("MULTIPLE_BUSMEMBERS_FOUND_CWSJA0024", null, null));
        }
        ObjectName objectName2 = (ObjectName)list2.get(0);
        SIBAdminCommandHelper.deleteBusMember(session, objectName2, string);
    }

    public static boolean validBooleanEnumValue(String string, String string2) {
        boolean bl = false;
        String string3 = string.toUpperCase(rootLocale);
        String string4 = string2.toUpperCase(rootLocale);
        if (string3.equals("QUEUE") || string3.equals("WEBSERVICE") || string3.equals("PORT") || string3.equals("TOPICSPACE") || string3.equals("FOREIGN")) {
            if (string4.equals("TRUE") || string4.equals("FALSE")) {
                bl = true;
            }
        } else if (string3.equals("ALIAS") && (string4.equals("TRUE") || string4.equals("FALSE") || string4.equals("INHERIT"))) {
            bl = true;
        }
        return bl;
    }

    public static boolean nameOkForCreate(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        return !string.startsWith("_");
    }

    public static boolean nameOkForDelete(String string) {
        return !string.startsWith("_SYSTEM");
    }

    public static boolean isScopeValid(String string, String string2, String string3) {
        if (SIBAdminCommandHelper.isCluster(string, string2, string3)) {
            return true;
        }
        return SIBAdminCommandHelper.isServer(string, string2, string3);
    }

    private static ObjectName createJdbcProvider(Session session, ObjectName objectName) throws Exception {
        Object object;
        ObjectName[] objectNameArray = configService.queryTemplates(session, "JDBCProvider");
        ObjectName objectName2 = null;
        for (int i = 0; i < objectNameArray.length; ++i) {
            object = ConfigServiceHelper.getDisplayName((ObjectName)objectNameArray[i]);
            if (!SIB_JDBC_PROVIDER_NAME.equals(object)) continue;
            objectName2 = objectNameArray[i];
            break;
        }
        ObjectName objectName3 = null;
        if (objectName2 != null) {
            object = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"name", (Object)SIB_JDBC_PROVIDER_NAME);
            ConfigServiceHelper.setAttributeValue((AttributeList)object, (String)"description", (Object)SIB_JDBC_PROVIDER_NAME);
            objectName3 = configService.createConfigDataByTemplate(session, objectName, "JDBCProvider", (AttributeList)object, objectName2);
        }
        if (objectName3 != null) {
            object = ConfigServiceHelper.createObjectName(null, (String)"DataSource");
            ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectName3, (ObjectName)object, null);
            for (int i = 0; i < objectNameArray2.length; ++i) {
                configService.deleteConfigData(session, objectNameArray2[i]);
            }
        }
        return objectName3;
    }

    public static void enableSIBService(Session session, ObjectName objectName) throws Exception {
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBService");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        if (objectNameArray != null && objectNameArray.length > 0) {
            ObjectName objectName3 = objectNameArray[0];
            AttributeList attributeList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attributeList, (String)"enable", (Object)Boolean.TRUE);
            configService.setAttributes(session, objectName3, attributeList);
        }
    }

    public static List getClusterServerList(Session session, String string) throws Exception {
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ObjectName objectName = SIBAdminCommandHelper.resolve(session, "ServerCluster=" + string);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"ClusterMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        for (int i = 0; i < objectNameArray.length; ++i) {
            String string2 = (String)configService.getAttribute(session, objectNameArray[i], "memberName");
            String string3 = (String)configService.getAttribute(session, objectNameArray[i], "nodeName");
            ObjectName objectName3 = SIBAdminCommandHelper.resolve(session, "Node=" + string3 + ":Server=" + string2);
            arrayList.add(objectName3);
        }
        return arrayList;
    }

    protected static ObjectName resolve(Session session, String string) throws Exception {
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = configService.resolve(session, string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminCommandHelper.resolve", (String)"3119");
            throw new InvalidParameterValueException("resolve", "containmentPath", (Object)string);
        }
        if (objectNameArray == null || objectNameArray.length < 1) {
            throw new InvalidParameterValueException("resolve", "containmentPath", (Object)string);
        }
        return objectNameArray[0];
    }

    static boolean isReliabilityValid(String string, String string2, AttributeList attributeList, String string3) throws SIBAdminCommandException {
        int n;
        int n2;
        Object object;
        SibresourcesFactory sibresourcesFactory = (SibresourcesFactory)SibresourcesPackage.eINSTANCE.getEFactoryInstance();
        if (string3.equals("FOREIGN")) {
            object = sibresourcesFactory.createSIBDestinationForeign();
            n2 = object.getReliability().getValue();
            n = object.getMaxReliability().getValue();
        } else if (string3.equals("ALIAS")) {
            object = sibresourcesFactory.createSIBDestinationAlias();
            n2 = object.getReliability().getValue();
            n = object.getMaxReliability().getValue();
        } else {
            object = sibresourcesFactory.createSIBDestination();
            n2 = object.getReliability().getValue();
            n = object.getMaxReliability().getValue();
        }
        try {
            Object object2;
            object = null;
            String string4 = null;
            if (string != null) {
                object = string;
            } else if (attributeList != null) {
                object = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"reliability");
            }
            if (object != null) {
                object2 = null;
                object2 = string3.equals("ALIAS") ? SIBDestinationReliabilityInheritType.get((String)((String)object).toUpperCase(rootLocale)) : SIBDestinationReliabilityType.get((String)((String)object).toUpperCase(rootLocale));
                if (object2 == null) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_GET_RELIABILITY_VALUES_CWSJA0038", null, null));
                }
                n2 = string3.equals("ALIAS") ? object2.getValue() : ((SIBDestinationReliabilityType)object2).getValue();
            }
            if (string2 != null) {
                string4 = string2;
            } else if (attributeList != null) {
                string4 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)attributeList, (String)"maxReliability");
            }
            if (string4 != null) {
                object2 = null;
                object2 = string3.equals("ALIAS") ? SIBDestinationReliabilityInheritType.get((String)string4.toUpperCase(rootLocale)) : SIBDestinationReliabilityType.get((String)string4.toUpperCase(rootLocale));
                if (object2 == null) {
                    throw new SIBAdminCommandException(nls.getFormattedMessage("UNRECOGNIZED_PARAM_VALUE_CWSJA0041", new Object[]{"reliability"}, null));
                }
                n = string3.equals("ALIAS") ? object2.getValue() : ((SIBDestinationReliabilityType)object2).getValue();
            }
        }
        catch (SIBAdminCommandException sIBAdminCommandException) {
            FFDCFilter.processException((Throwable)sIBAdminCommandException, (String)"com.ibm.ws.management.commands.sib.SIBAdminCommandHelper.isReliabilityValid", (String)"3211");
            throw sIBAdminCommandException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminCommandHelper.isReliabilityValid", (String)"3215");
            throw new SIBAdminCommandException(nls.getFormattedMessage("FAILED_TO_GET_RELIABILITY_VALUES_CWSJA0038", null, null));
        }
        if (string3.equals("ALIAS") && (n2 == 0 || n == 0)) {
            return true;
        }
        return n2 <= n;
    }
}

