/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.configarchive.ConfigArchiveException;
import javax.management.ObjectName;

public class SIBAdminCleanupNodeExt
extends AbstractCommandStep {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.SIBAdminCleanupNodeExt";
    private static final TraceComponent tc = SibTr.register(SIBAdminCleanupNodeExt.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");
    private static ConfigService configService = ConfigServiceFactory.getConfigService();

    public SIBAdminCleanupNodeExt(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(abstractTaskCommand, commandMetadata);
    }

    public SIBAdminCleanupNodeExt(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(abstractTaskCommand, commandData);
    }

    public void validate() throws CommandValidationException {
    }

    protected void executeStep() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            return;
        }
        super.executeStep();
        try {
            this.cleanupBus();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.SIBAdminCleanupNodeExt.executeStep", (String)"100", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
        }
    }

    private void cleanupBus() throws ConfigArchiveException, ConfigServiceException, ConnectorException, InvalidParameterNameException {
        String string = (String)this.taskCmd.getParameter("nodeName");
        Session session = this.getConfigSession();
        ObjectName objectName = this.getCell(session);
        ObjectName[] objectNameArray = this.getCellBuses(session, objectName);
        for (int i = 0; i < objectNameArray.length; ++i) {
            Object object;
            ObjectName objectName2 = objectNameArray[i];
            String string2 = (String)configService.getAttribute(session, objectName2, "name", false);
            ObjectName[] objectNameArray2 = this.getBusMembers(session, objectName2);
            for (int j = 0; j < objectNameArray2.length; ++j) {
                ObjectName objectName3 = objectNameArray2[j];
                object = (String)configService.getAttribute(session, objectName3, "node", false);
                if (string == null || !string.equals(object)) continue;
                configService.deleteConfigData(session, objectName3);
            }
            ObjectName[] objectNameArray3 = this.getBusDestinations(session, objectName2);
            for (int j = 0; j < objectNameArray3.length; ++j) {
                object = objectNameArray3[j];
                String string3 = (String)configService.getAttribute(session, (ObjectName)object, "identifier", false);
                ObjectName[] objectNameArray4 = this.getDestinationLocalizationPointRefs(session, (ObjectName)object);
                int n = 0;
                for (int k = 0; k < objectNameArray4.length; ++k) {
                    ObjectName objectName4 = objectNameArray4[k];
                    String string4 = (String)configService.getAttribute(session, objectName4, "node", false);
                    if (string == null || !string.equals(string4)) continue;
                    configService.deleteConfigData(session, objectName4);
                    ++n;
                }
                if (n != objectNameArray4.length) continue;
                configService.deleteConfigData(session, (ObjectName)object);
            }
        }
    }

    private ObjectName getCell(Session session) throws ConfigArchiveException, ConfigServiceException, ConnectorException {
        if (session == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_SESSION_SUPPLIED_CWSJA1001", null, null));
        }
        ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"Cell");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, null, objectName, null);
        if (objectNameArray == null || objectNameArray.length < 1) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_CELLS_FOUND_CWSJA1000", null, null));
        }
        return objectNameArray[0];
    }

    private ObjectName[] getCellBuses(Session session, ObjectName objectName) throws ConfigArchiveException, ConfigServiceException, ConnectorException {
        if (session == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_SESSION_SUPPLIED_CWSJA1001", null, null));
        }
        if (objectName == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("DMGR_CELL_NOT_SPECIFIED_CWSJA1002", null, null));
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBus");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }

    private ObjectName[] getBusMembers(Session session, ObjectName objectName) throws ConfigArchiveException, ConfigServiceException, ConnectorException {
        if (session == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_SESSION_SUPPLIED_CWSJA1001", null, null));
        }
        if (objectName == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("DMGR_BUS_NOT_SPECIFIED_CWSJA1003", null, null));
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBusMember");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }

    private ObjectName[] getBusDestinations(Session session, ObjectName objectName) throws ConfigArchiveException, ConfigServiceException, ConnectorException {
        if (session == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_SESSION_SUPPLIED_CWSJA1001", null, null));
        }
        if (objectName == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("DMGR_BUS_NOT_SPECIFIED_CWSJA1003", null, null));
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBDestination");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }

    private ObjectName[] getDestinationLocalizationPointRefs(Session session, ObjectName objectName) throws ConfigArchiveException, ConfigServiceException, ConnectorException {
        if (session == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("NO_DMGR_SESSION_SUPPLIED_CWSJA1001", null, null));
        }
        if (objectName == null) {
            throw new ConfigArchiveException(nls.getFormattedMessage("DMGR_DESTINATION_NOT_SPECIFIED_CWSJA1004", null, null));
        }
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, (String)"SIBLocalizationPointRef");
        ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        return objectNameArray;
    }
}

