/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.commands.sib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.sib.SIBAdminCommandException;
import com.ibm.ws.management.commands.sib.SIBAdminCommandHelper;
import com.ibm.ws.management.commands.sib.SIBAdminCommandProvider;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Locale;
import javax.management.ObjectName;

public class CreateSIBDestinationCommand
extends AbstractTaskCommand {
    private static final String CLASS_NAME = "com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand";
    private static final String SIB_DEST_BUS_NAME = "bus";
    private static final String SIB_DEST_NAME = "name";
    private static final String SIB_DEST_TYPE = "type";
    private static final String SIB_DEST_NODE_NAME = "node";
    private static final String SIB_DEST_SERVER_NAME = "server";
    private static final String SIB_DEST_CLUSTER_NAME = "cluster";
    private static final String SIB_DEST_DESCRIPTION = "description";
    private static final String SIB_DEST_RELIABILITY = "reliability";
    private static final String SIB_DEST_MAX_RELIABILITY = "maxReliability";
    private static final String SIB_DEST_EXCEPTION_DESTINATION = "exceptionDestination";
    private static final String SIB_DEST_DEFAULT_PRIORITY = "defaultPriority";
    private static final String SIB_DEST_MAX_FAILED_DELIVERIES = "maxFailedDeliveries";
    private static final String SIB_DEST_ALLOW_OVERRIDE = "overrideOfQOSByProducerAllowed";
    private static final String SIB_DEST_SEND_ALLOWED = "sendAllowed";
    private static final String SIB_DEST_RECEIVE_ALLOWED = "receiveAllowed";
    private static final String SIB_DEST_REPLY_DEST_BUS = "replyDestinationBus";
    private static final String SIB_DEST_REPLY_DEST = "replyDestination";
    private static final String SIB_DEST_RECEIVE_EXCLUSIVE = "receiveExclusive";
    private static final String SIB_DEST_TOPIC_CHECK = "topicAccessCheckRequired";
    private static final String SIB_DEST_ALIAS_BUS = "aliasBus";
    private static final String SIB_DEST_TARGET_BUS = "targetBus";
    private static final String SIB_DEST_TARGET_NAME = "targetName";
    private static final String SIB_DEST_FOREIGN_BUS = "foreignBus";
    private static final String SIB_DEST_DELEGATE_AUTH = "delegateAuthorizationCheckToTarget";
    private static final String SIB_DEFAULT_ROUTING_PATH_DEST_NAME = "destination";
    private static final Locale rootLocale = new Locale("", "");
    private String taskName = null;
    private String busName = null;
    private String destName = null;
    private String type = null;
    private String nodeName = null;
    private String serverName = null;
    private String clusterName = null;
    private String description = null;
    private String reliability = null;
    private String maxReliability = null;
    private String exceptionDestination = null;
    private Integer defaultPriority = null;
    private Integer maxFailedDeliveries = null;
    private String allowOverride = null;
    private String sendAllowed = null;
    private String receiveAllowed = null;
    private Boolean receiveExclusive = null;
    private String replyDestinationBusName = null;
    private String replyDestinationName = null;
    private String[][] defaultForwardRoutingPathArray = null;
    private Boolean topicAccessCheckRequired = null;
    private String aliasBus = null;
    private String targetBusName = null;
    private String targetName = null;
    private Boolean delegateAuthorizationCheckToTarget = null;
    private String foreignBus = null;
    private String ucType = null;
    private static final TraceComponent tc = SibTr.register(SIBAdminCommandProvider.class, "SIBAdmin", "com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.management.commands.sib.CWSJAMessages");

    public CreateSIBDestinationCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        this.resetValues();
        this.taskName = taskCommandMetadata.getName();
    }

    public CreateSIBDestinationCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        this.resetValues();
        this.taskName = commandData.getName();
    }

    protected void beforeStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        taskCommandResultImpl.reset();
        try {
            this.busName = (String)this.getParameter(SIB_DEST_BUS_NAME);
            this.destName = (String)this.getParameter(SIB_DEST_NAME);
            this.type = (String)this.getParameter(SIB_DEST_TYPE);
            this.nodeName = (String)this.getParameter(SIB_DEST_NODE_NAME);
            this.serverName = (String)this.getParameter(SIB_DEST_SERVER_NAME);
            this.clusterName = (String)this.getParameter(SIB_DEST_CLUSTER_NAME);
            this.description = (String)this.getParameter(SIB_DEST_DESCRIPTION);
            this.reliability = (String)this.getParameter(SIB_DEST_RELIABILITY);
            this.maxReliability = (String)this.getParameter(SIB_DEST_MAX_RELIABILITY);
            this.exceptionDestination = (String)this.getParameter(SIB_DEST_EXCEPTION_DESTINATION);
            this.defaultPriority = (Integer)this.getParameter(SIB_DEST_DEFAULT_PRIORITY);
            this.maxFailedDeliveries = (Integer)this.getParameter(SIB_DEST_MAX_FAILED_DELIVERIES);
            this.allowOverride = (String)this.getParameter(SIB_DEST_ALLOW_OVERRIDE);
            this.sendAllowed = (String)this.getParameter(SIB_DEST_SEND_ALLOWED);
            this.receiveAllowed = (String)this.getParameter(SIB_DEST_RECEIVE_ALLOWED);
            this.replyDestinationBusName = (String)this.getParameter(SIB_DEST_REPLY_DEST_BUS);
            this.replyDestinationName = (String)this.getParameter(SIB_DEST_REPLY_DEST);
            this.receiveExclusive = (Boolean)this.getParameter(SIB_DEST_RECEIVE_EXCLUSIVE);
            this.topicAccessCheckRequired = (Boolean)this.getParameter(SIB_DEST_TOPIC_CHECK);
            this.aliasBus = (String)this.getParameter(SIB_DEST_ALIAS_BUS);
            this.targetBusName = (String)this.getParameter(SIB_DEST_TARGET_BUS);
            this.targetName = (String)this.getParameter(SIB_DEST_TARGET_NAME);
            this.delegateAuthorizationCheckToTarget = (Boolean)this.getParameter(SIB_DEST_DELEGATE_AUTH);
            this.foreignBus = (String)this.getParameter(SIB_DEST_FOREIGN_BUS);
            if (this.busName == null || this.busName.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.taskName, SIB_DEST_BUS_NAME}, null));
            }
            if (this.destName == null || this.destName.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.taskName, SIB_DEST_NAME}, null));
            }
            if (this.type == null || this.type.length() < 1) {
                throw new SIBAdminCommandException(nls.getFormattedMessage("NO_PARAM_VALUE_CWSJA0036", new Object[]{this.taskName, SIB_DEST_TYPE}, null));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand.beforeStepsExecuted", (String)"298", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
            return;
        }
        if (!SIBAdminCommandHelper.nameOkForCreate(this.destName)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_DESTINATION_NAME_CWSJA0042", new Object[]{this.destName}, null)));
            return;
        }
        this.ucType = this.type.toUpperCase(rootLocale);
        if (!SIBAdminCommandHelper.checkDestinationType(this.ucType)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("UNSUPPORTED_TYPE_CWSJA0006", new Object[]{this.type}, null)));
            return;
        }
        if (this.ucType.equals("WEBSERVICE") && (this.nodeName != null || this.serverName != null || this.clusterName != null)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_COMBINATION_CWSJA0044", null, null)));
            return;
        }
        if (!(this.ucType.equals("TOPICSPACE") || this.ucType.equals("ALIAS") || this.ucType.equals("FOREIGN") || this.ucType.equals("WEBSERVICE"))) {
            if (!SIBAdminCommandHelper.isScopeValid(this.nodeName, this.serverName, this.clusterName)) {
                taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("INVALID_PARAM_COMBINATION_CWSJA0007", new Object[]{this.nodeName, this.serverName, this.clusterName}, null)));
                return;
            }
            try {
                ObjectName objectName = SIBAdminCommandHelper.getScope(this.getConfigSession(), this.nodeName, this.serverName, this.clusterName);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand.beforeStepsExecuted", (String)"341", (Object)((Object)this));
                taskCommandResultImpl.setException((Throwable)exception);
                return;
            }
        }
        if (this.topicAccessCheckRequired != null && !this.ucType.equals("TOPICSPACE")) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, SIB_DEST_TOPIC_CHECK, this.topicAccessCheckRequired}, null)));
            return;
        }
        if (!(this.receiveExclusive == null || this.ucType.equals("QUEUE") || this.ucType.equals("PORT") || this.ucType.equals("WEBSERVICE"))) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, SIB_DEST_RECEIVE_EXCLUSIVE, this.receiveExclusive}, null)));
            return;
        }
        if (this.allowOverride == null || this.allowOverride.equals("")) {
            if (this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT") || this.ucType.equals("TOPICSPACE") || this.ucType.equals("FOREIGN")) {
                this.allowOverride = new String("True");
            } else if (this.ucType.equals("ALIAS")) {
                this.allowOverride = new String("INHERIT");
            }
        }
        if (!SIBAdminCommandHelper.validBooleanEnumValue(this.ucType, this.allowOverride)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, "allowOverride", this.allowOverride}, null)));
            return;
        }
        if (this.sendAllowed == null || this.sendAllowed.equals("")) {
            if (this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT") || this.ucType.equals("TOPICSPACE") || this.ucType.equals("FOREIGN")) {
                this.sendAllowed = new String("True");
            } else if (this.ucType.equals("ALIAS")) {
                this.sendAllowed = new String("INHERIT");
            }
        }
        if (!SIBAdminCommandHelper.validBooleanEnumValue(this.ucType, this.sendAllowed)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, SIB_DEST_SEND_ALLOWED, this.sendAllowed}, null)));
            return;
        }
        if (this.receiveAllowed == null || this.receiveAllowed.equals("")) {
            if (this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT") || this.ucType.equals("TOPICSPACE")) {
                this.receiveAllowed = new String("True");
            } else if (this.ucType.equals("ALIAS")) {
                this.receiveAllowed = new String("INHERIT");
            }
        }
        if (!this.ucType.equals("FOREIGN") && !SIBAdminCommandHelper.validBooleanEnumValue(this.ucType, this.receiveAllowed)) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_PARAM_VALUE_CWSJA0043", new Object[]{this.ucType, SIB_DEST_RECEIVE_ALLOWED, this.receiveAllowed}, null)));
            return;
        }
        if ((this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT") || this.ucType.equals("TOPICSPACE")) && this.exceptionDestination == null) {
            this.exceptionDestination = "$DEFAULT_EXCEPTION_DESTINATION";
        }
        if (this.reliability != null) {
            this.reliability = this.reliability.toUpperCase(rootLocale);
        }
        if (this.maxReliability != null) {
            this.maxReliability = this.maxReliability.toUpperCase(rootLocale);
        }
        if (this.reliability != null && this.reliability.length() > 0 || this.maxReliability != null && this.maxReliability.length() > 0) {
            try {
                if (!SIBAdminCommandHelper.isReliabilityValid(this.reliability, this.maxReliability, null, this.ucType)) {
                    taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("BAD_RELIABILITY_VALUE_CWSJA0040", null, null)));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand.beforeStepsExecuted", (String)"423", (Object)((Object)this));
                taskCommandResultImpl.setException((Throwable)exception);
            }
        }
        if (this.replyDestinationBusName != null && !this.replyDestinationBusName.equals("") && (this.replyDestinationName == null || this.replyDestinationName.equals(""))) {
            taskCommandResultImpl.setException((Throwable)new SIBAdminCommandException(nls.getFormattedMessage("REMOVING_REPLY_DESTINATION_CWSJA0047", null, null)));
        }
    }

    protected void afterStepsExecuted() {
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        try {
            Session session = this.getConfigSession();
            ObjectName objectName = SIBAdminCommandHelper.createDestination(session, this.busName, this.nodeName, this.serverName, this.clusterName, this.destName, this.type, this.aliasBus, this.targetBusName, this.targetName, this.foreignBus);
            if (this.ucType.equals("QUEUE") || this.ucType.equals("WEBSERVICE") || this.ucType.equals("PORT")) {
                objectName = SIBAdminCommandHelper.modifyDestinationQueue(session, objectName, this.description, this.reliability, this.maxReliability, this.exceptionDestination, this.defaultPriority, this.maxFailedDeliveries, new Boolean(this.allowOverride), new Boolean(this.sendAllowed), new Boolean(this.receiveAllowed), this.receiveExclusive, this.topicAccessCheckRequired, this.replyDestinationBusName, this.replyDestinationName, this.defaultForwardRoutingPathArray);
            } else if (this.ucType.equals("TOPICSPACE")) {
                objectName = SIBAdminCommandHelper.modifyDestinationTopicSpace(session, objectName, this.description, this.reliability, this.maxReliability, this.exceptionDestination, this.defaultPriority, this.maxFailedDeliveries, new Boolean(this.allowOverride), new Boolean(this.sendAllowed), new Boolean(this.receiveAllowed), this.topicAccessCheckRequired, this.replyDestinationBusName, this.replyDestinationName);
            } else if (this.ucType.equals("ALIAS")) {
                objectName = SIBAdminCommandHelper.modifyDestinationAlias(session, objectName, this.description, this.reliability, this.defaultPriority, this.maxReliability, this.allowOverride, this.sendAllowed, this.receiveAllowed, this.replyDestinationBusName, this.replyDestinationName, this.defaultForwardRoutingPathArray, this.delegateAuthorizationCheckToTarget);
            } else if (this.type.equals("FOREIGN")) {
                objectName = SIBAdminCommandHelper.modifyDestinationForeign(session, objectName, this.description, this.reliability, this.maxReliability, this.defaultPriority, new Boolean(this.allowOverride), new Boolean(this.sendAllowed));
            }
            taskCommandResultImpl.setResult((Object)objectName);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand.afterStepsExecuted", (String)"465", (Object)((Object)this));
            taskCommandResultImpl.setException((Throwable)exception);
        }
    }

    private void resetValues() {
        this.busName = null;
        this.destName = null;
        this.type = null;
        this.nodeName = null;
        this.serverName = null;
        this.clusterName = null;
        this.description = null;
        this.reliability = null;
        this.maxReliability = null;
        this.exceptionDestination = null;
        this.defaultPriority = null;
        this.maxFailedDeliveries = null;
        this.allowOverride = null;
        this.sendAllowed = null;
        this.receiveAllowed = null;
        this.receiveExclusive = null;
        this.replyDestinationBusName = null;
        this.replyDestinationName = null;
        this.defaultForwardRoutingPathArray = null;
        this.topicAccessCheckRequired = null;
        this.aliasBus = null;
        this.targetBusName = null;
        this.targetName = null;
        this.delegateAuthorizationCheckToTarget = null;
        this.foreignBus = null;
        this.ucType = null;
    }

    static /* synthetic */ String[][] access$302(CreateSIBDestinationCommand createSIBDestinationCommand, String[][] stringArray) {
        createSIBDestinationCommand.defaultForwardRoutingPathArray = stringArray;
        return stringArray;
    }

    public class DefaultForwardRoutingPathStep
    extends AbstractCommandStep {
        private String stepName;

        public DefaultForwardRoutingPathStep(AbstractTaskCommand abstractTaskCommand, CommandStepMetadata commandStepMetadata) throws CommandNotFoundException {
            super(abstractTaskCommand, (CommandMetadata)commandStepMetadata);
            this.stepName = null;
            this.stepName = commandStepMetadata.getName();
        }

        public DefaultForwardRoutingPathStep(AbstractTaskCommand abstractTaskCommand, CommandStepData commandStepData) throws CommandNotFoundException, CommandLoadException {
            super(abstractTaskCommand, (CommandData)commandStepData);
            this.stepName = null;
            this.stepName = commandStepData.getName();
        }

        public void validate() throws CommandValidationException {
            int n = this.getNumberOfRows();
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getParameter(CreateSIBDestinationCommand.SIB_DEFAULT_ROUTING_PATH_DEST_NAME, i);
                if (string != null && string.length() >= 1) continue;
                throw new CommandValidationException(nls.getFormattedMessage("NO_STEP_PARAM_VALUE_CWSJA0038", new Object[]{CreateSIBDestinationCommand.this.taskName, this.stepName, CreateSIBDestinationCommand.SIB_DEFAULT_ROUTING_PATH_DEST_NAME}, null));
            }
        }

        protected void executeStep() {
            if (CreateSIBDestinationCommand.this.ucType.equals("QUEUE") || CreateSIBDestinationCommand.this.ucType.equals("ALIAS") || CreateSIBDestinationCommand.this.ucType.equals("WEBSERVICE") || CreateSIBDestinationCommand.this.ucType.equals("PORT")) {
                Session session = this.getConfigSession();
                String string = null;
                String string2 = null;
                int n = this.getNumberOfRows();
                CreateSIBDestinationCommand.access$302(CreateSIBDestinationCommand.this, new String[2][n]);
                for (int i = 0; i < n; ++i) {
                    try {
                        string = (String)this.getParameter(CreateSIBDestinationCommand.SIB_DEST_BUS_NAME, i);
                        string2 = (String)this.getParameter(CreateSIBDestinationCommand.SIB_DEFAULT_ROUTING_PATH_DEST_NAME, i);
                        ((CreateSIBDestinationCommand)CreateSIBDestinationCommand.this).defaultForwardRoutingPathArray[0][i] = string;
                        ((CreateSIBDestinationCommand)CreateSIBDestinationCommand.this).defaultForwardRoutingPathArray[1][i] = string2;
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.commands.sib.CreateSIBDestinationCommand.DefaultForwardRoutingPathStep.executeStep", (String)"592", (Object)((Object)this));
                        CommandResultImpl commandResultImpl = new CommandResultImpl();
                        commandResultImpl.setException((Throwable)exception);
                        this.setCommandResult((CommandResult)commandResultImpl);
                        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.taskCmd.getCommandResult();
                        taskCommandResultImpl.setException((Throwable)exception);
                    }
                }
            }
        }
    }
}

