/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.odc.ODCNode;
import java.io.File;
import java.io.IOException;

public class Util {
    private static final TraceComponent tc = TrUtil.register(Util.class);
    public static final String DEPLOYMENT_MANAGER_PROCESS = "DeploymentManager";
    public static final String NODE_AGENT_PROCESS = "NodeAgent";
    public static final String MANAGED_PROCESS = "ManagedProcess";
    public static final String STANDALONE_PROCESS = "UnManagedProcess";
    public static final String PROXY_SERVER_TYPE = "PROXY_SERVER";
    public static final String ODR_TYPE = "ONDEMAND_ROUTER";
    private static String myProcessType = null;
    private static String myServerType = null;

    public static boolean isDmgr() {
        return Util.isDmgr(Util.getMyProcessType());
    }

    public static boolean isNodeAgent() {
        return Util.isNodeAgent(Util.getMyProcessType());
    }

    public static boolean isManagedProcess() {
        return Util.isManagedProcess(Util.getMyProcessType());
    }

    public static boolean isStandAlone() {
        return Util.isStandAlone(Util.getMyProcessType());
    }

    public static boolean isProxy() {
        return Util.isProxy(Util.getMyServerType());
    }

    public static boolean isODR() {
        return Util.isODR(Util.getMyServerType());
    }

    public static boolean isDmgr(String string) {
        return string.equals(DEPLOYMENT_MANAGER_PROCESS);
    }

    public static boolean isNodeAgent(String string) {
        return string.equals(NODE_AGENT_PROCESS);
    }

    public static boolean isManagedProcess(String string) {
        return string.equals(MANAGED_PROCESS);
    }

    public static boolean isStandAlone(String string) {
        return string.equals(STANDALONE_PROCESS);
    }

    public static boolean isProxy(String string) {
        return string.equals(PROXY_SERVER_TYPE) || string.equals(ODR_TYPE);
    }

    public static boolean isODR(String string) {
        return Util.isProxy(string);
    }

    public static String getMyProcessType() {
        if (myProcessType == null && (myProcessType = AdminServiceFactory.getAdminService().getProcessType()) == null) {
            throw new RuntimeException("null process type");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("my process type is " + myProcessType));
        }
        return myProcessType;
    }

    public static String getMyServerType() {
        if (myServerType == null && (myServerType = AdminServiceFactory.getAdminService().getServerType()) == null) {
            throw new RuntimeException("null server type");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("my server type is " + myServerType));
        }
        return myServerType;
    }

    public static File getPerServerFile(String string) throws IOException {
        return Util.getPerServerFile("", string);
    }

    public static File getPerServerFile(String string, String string2) throws IOException {
        PlatformHelper platformHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPerServerFile", (Object)string2);
        }
        if ((platformHelper = PlatformHelperFactory.getPlatformHelper()) != null) {
            if (platformHelper.isBaseServantJvm() || platformHelper.isCRAJvm()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPerServerFile", (Object)"in Z CRA or Servant Regtion");
                }
                return null;
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPerServerFile", (Object)"could not reach Platform Helper");
            }
            return null;
        }
        String string3 = System.getProperty("server.root");
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPerServerFile", (Object)"server.root not set");
            }
            return null;
        }
        String string4 = DoPrivUtil.getMyServerName();
        File file = new File(string3 + "/installedFilters/wlm/" + string4 + string);
        if (!DoPrivUtil.exists(file) && !DoPrivUtil.mkdirs(file)) {
            throw new IOException("unable to create directory: " + file.getAbsolutePath());
        }
        File file2 = new File(file, string2 + ".xml");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPerServerFile", (Object)file2);
        }
        return file2;
    }

    public static String makeEdgeLongName(ODCNode oDCNode, ODCNode oDCNode2) {
        return Util.makeEdgeLongName(oDCNode.getPath(), oDCNode2.getPath());
    }

    public static String makeEdgeLongName(String string, String string2) {
        return string + "::" + string2;
    }
}

