/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.websphere.management.AdminServiceFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class DoPrivUtil {
    private final File file;
    private final Runnable runnable;
    private final String name;

    public static boolean exists(File file) {
        return new DoPrivUtil(file).exists();
    }

    public static boolean mkdir(File file) {
        return new DoPrivUtil(file).mkdir();
    }

    public static boolean mkdirs(File file) {
        return new DoPrivUtil(file).mkdirs();
    }

    public static InputStream getResourceAsStream(String string) {
        return new DoPrivUtil(string).getResourceAsStream();
    }

    public static FileInputStream getInputStream(String string) throws FileNotFoundException {
        return new DoPrivUtil(string).getInputStream();
    }

    public static FileInputStream getInputStream(File file) throws FileNotFoundException {
        return new DoPrivUtil(file).getInputStream();
    }

    public static FileOutputStream getOutputStream(String string) throws FileNotFoundException {
        return new DoPrivUtil(string).getOutputStream();
    }

    public static FileOutputStream getOutputStream(File file) throws FileNotFoundException {
        return new DoPrivUtil(file).getOutputStream();
    }

    public static Thread createThread(Runnable runnable, String string) {
        return new DoPrivUtil(runnable, string).createThread();
    }

    public static String getMyCellName() {
        return new DoPrivUtil().getLocalCellName();
    }

    public static String getMyNodeName() {
        return new DoPrivUtil().getLocalNodeName();
    }

    public static String getMyServerName() {
        return new DoPrivUtil().getLocalServerName();
    }

    private DoPrivUtil() {
        this.file = null;
        this.runnable = null;
        this.name = null;
    }

    private DoPrivUtil(File file) {
        this.file = file;
        this.runnable = null;
        this.name = null;
    }

    private DoPrivUtil(String string) {
        this.file = null;
        this.runnable = null;
        this.name = string;
    }

    private DoPrivUtil(Runnable runnable, String string) {
        this.file = null;
        this.runnable = runnable;
        this.name = string;
    }

    private boolean exists() {
        Boolean bl = null;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    if (DoPrivUtil.this.file.exists()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return bl;
    }

    private boolean mkdir() {
        Boolean bl = null;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    if (DoPrivUtil.this.file.mkdir()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return bl;
    }

    private boolean mkdirs() {
        Boolean bl = null;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    if (DoPrivUtil.this.file.mkdirs()) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return bl;
    }

    private InputStream getResourceAsStream() {
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return this.getClass().getResourceAsStream(DoPrivUtil.this.name);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return inputStream;
    }

    private FileInputStream getInputStream() throws FileNotFoundException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    if (DoPrivUtil.this.file != null) {
                        return new FileInputStream(DoPrivUtil.this.file);
                    }
                    return new FileInputStream(DoPrivUtil.this.name);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        return fileInputStream;
    }

    private FileOutputStream getOutputStream() throws FileNotFoundException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    if (DoPrivUtil.this.file != null) {
                        return new FileOutputStream(DoPrivUtil.this.file);
                    }
                    return new FileOutputStream(DoPrivUtil.this.name);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (FileNotFoundException)privilegedActionException.getException();
        }
        return fileOutputStream;
    }

    private Thread createThread() {
        Thread thread = null;
        try {
            thread = (Thread)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new Thread(DoPrivUtil.this.runnable, DoPrivUtil.this.name);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException);
        }
        return thread;
    }

    private String getLocalCellName() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return AdminServiceFactory.getAdminService().getCellName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException);
        }
        return string;
    }

    private String getLocalNodeName() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return AdminServiceFactory.getAdminService().getNodeName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException);
        }
        return string;
    }

    private String getLocalServerName() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return AdminServiceFactory.getAdminService().getProcessName();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException);
        }
        return string;
    }
}

