/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.bb.Edge;
import com.ibm.ws.odc.bb.Node;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class BBTreePosting
implements Serializable {
    static final long serialVersionUID = -8994086360135257504L;
    private static final TraceComponent tc = TrUtil.register(BBTreePosting.class);
    private long version = -1L;
    private final String serverName;
    private final String serverType;
    private final Map nodes = Collections.synchronizedMap(new LinkedHashMap());
    private final Map edges = Collections.synchronizedMap(new LinkedHashMap());

    public BBTreePosting(String string, String string2) {
        this.serverName = string;
        this.serverType = string2;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long l) {
        this.version = l;
    }

    public void incrVersion() {
        ++this.version;
    }

    public void addNode(ODCNode oDCNode) throws ODCException {
        this.addNode(oDCNode, oDCNode.getProperties());
    }

    public void addNode(ODCNode oDCNode, Map map) throws ODCException {
        ODCNode oDCNode2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNode", (Object)new Object[]{oDCNode, map});
        }
        String string2 = string = (oDCNode2 = oDCNode.getParent()) != null ? oDCNode2.getLongName() : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parent = " + string));
        }
        Node node = new Node(oDCNode.getName(), oDCNode.getLongName(), oDCNode.getType().getName(), string, map);
        this.nodes.put(oDCNode.getLongName(), node);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNode", (Object)node);
        }
    }

    public void removeNode(ODCNode oDCNode) throws ODCException {
        this.removeNode(oDCNode.getLongName());
    }

    public Node removeNode(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removing node " + string));
        }
        return (Node)this.nodes.remove(string);
    }

    public void addEdge(ODCEdge oDCEdge) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addEdge", (Object)oDCEdge);
        }
        ODCEdgeImpl oDCEdgeImpl = (ODCEdgeImpl)oDCEdge;
        Edge edge = new Edge(oDCEdgeImpl.getLongName(), oDCEdge.getSrcNode().getLongName(), oDCEdge.getDstNode().getLongName());
        this.edges.put(oDCEdgeImpl.getLongName(), edge);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEdge");
        }
    }

    public void removeEdge(ODCEdge oDCEdge) throws ODCException {
        this.removeEdge(((ODCEdgeImpl)oDCEdge).getLongName());
    }

    public Edge removeEdge(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removing edge " + string));
        }
        return (Edge)this.edges.remove(string);
    }

    public boolean setProperty(ODCNode oDCNode, String string, Object object) throws ODCException {
        boolean bl;
        Node node;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperty", (Object)new Object[]{oDCNode, string, object});
        }
        if ((node = (Node)this.nodes.get(oDCNode.getLongName())) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("node not yet posted: " + oDCNode));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object);
            this.addNode(oDCNode, hashMap);
            bl = true;
        } else {
            Object v;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("node already posted: " + oDCNode));
            }
            if (!((v = node.props.get(string)) == object || v != null && object != null && v.equals(object))) {
                node.props.put(string, object);
                bl = true;
            } else {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Iterator nodes() {
        return this.nodes.values().iterator();
    }

    public Iterator edges() {
        return this.edges.values().iterator();
    }

    public void remove(ODCTreeImpl oDCTreeImpl) throws ODCException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)oDCTreeImpl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"releasing all edges");
        }
        Iterator iterator = this.edges.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Edge)iterator.next();
            oDCTreeImpl.releaseEdge(serializable.longName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"releasing all nodes");
        }
        iterator = this.nodes.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Node)iterator.next();
            oDCTreeImpl.releaseNode(((Node)serializable).longName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove", (Object)oDCTreeImpl);
        }
    }

    public String toString() {
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\n";
        String string2 = "   ";
        stringBuffer.append("VERSION:").append(this.version).append(string);
        stringBuffer.append("SERVER TYPE: ").append(this.serverType).append(string);
        stringBuffer.append("NODES:").append(string);
        Iterator iterator = this.nodes.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Node)iterator.next();
            stringBuffer.append(string2).append(serializable).append(string);
        }
        stringBuffer.append("EDGES:").append(string);
        iterator = this.edges.values().iterator();
        while (iterator.hasNext()) {
            serializable = (Edge)iterator.next();
            stringBuffer.append(string2).append(serializable).append(string);
        }
        return stringBuffer.toString();
    }
}

