/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.bb.BBMgr;
import com.ibm.ws.odc.bb.BBTreePosting;
import com.ibm.ws.odc.bb.Edge;
import com.ibm.ws.odc.bb.Node;
import com.ibm.ws.odc.bb.ServerType;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscription;
import com.ibm.wsspi.hamanager.bboard.SubjectSubscriptionEvents;
import com.ibm.wsspi.hamanager.bboard.SubjectValue;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCManagerFactory;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import com.ibm.wsspi.odc.ODCTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class BBTree
implements SubjectSubscriptionEvents {
    private static final TraceComponent tc = TrUtil.register(BBTree.class);
    protected static final BBTreePosting NO_POSTING = new BBTreePosting(null, null);
    protected static final boolean DEBUG_POSTS = new Boolean(System.getProperty("com.ibm.ws.odc.bb.debugPosts", "true"));
    protected static final Integer DOWN_WEIGHT = new Integer(0);
    protected static final Integer UP_WEIGHT = new Integer(1);
    protected static final String V2_SUFFIX = "-version2";
    public final ODCTreeImpl odcTree;
    public final MyPosting myPosting;
    protected final ODCManager odcMgr;
    protected final ODCHelper odc;
    protected final BulletinBoard bb;
    protected final BulletinBoardScope pubScope;
    protected final BulletinBoardScope[] remScopes;
    protected final Scope[] scopes;
    protected final Scope[] zippedScopes;
    protected final String myServerName;
    protected final Set newNodes = new TreeSet();
    protected final List newEdges = new LinkedList();
    protected final List propertyChanges = new LinkedList();
    protected SubjectInfo info = null;
    protected SubjectPost post = null;
    protected SubjectInfo zippedInfo = null;
    protected SubjectPost zippedPost = null;
    protected boolean needsPosting = false;
    protected File postingsFile = null;
    protected boolean updating = false;
    protected final Map serverInfoMap = new HashMap();
    protected final Map objectInfoMap = new HashMap();
    protected final Map scopeInfoMap = new HashMap();
    protected boolean initialized = false;
    protected static ThreadPool threadPool = new ThreadPool("BBTree", 1, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBTree(ODCTree oDCTree) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)oDCTree);
        }
        this.odcTree = (ODCTreeImpl)oDCTree;
        this.odc = ODCHelper.getInstance();
        BBMgr bBMgr = BBMgr.getInstance();
        this.myPosting = this.createMyPosting();
        this.bb = bBMgr.getBulletinBoard();
        this.pubScope = bBMgr.getPublicScope();
        this.remScopes = bBMgr.getRemoteScopes();
        this.scopes = new Scope[this.remScopes.length + 1];
        this.zippedScopes = new Scope[this.remScopes.length + 1];
        this.odcMgr = ODCManagerFactory.getManager();
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = null;
            this.zippedScopes[i] = null;
        }
        this.myServerName = BBMgr.getInstance().getMyServerName();
        if (DEBUG_POSTS) {
            try {
                this.postingsFile = Util.getPerServerFile(oDCTree.getName() + "-postings");
            }
            catch (IOException iOException) {
                throw new ODCException(iOException);
            }
        }
        ODCTree oDCTree2 = oDCTree;
        synchronized (oDCTree2) {
            this.initTree();
            this.odcTree.setBBTree(this);
        }
        this.start();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor", (Object)oDCTree);
        }
    }

    protected MyPosting createMyPosting() throws ODCException {
        return new MyPosting();
    }

    protected void initTree() throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initTree");
        }
        ODCNodeImpl[] oDCNodeImplArray = this.odcTree.getAllNodes();
        for (int i = 0; i < oDCNodeImplArray.length; ++i) {
            this.myPosting.addNode(oDCNodeImplArray[i]);
            this.needsPosting();
        }
        ODCEdgeImpl[] oDCEdgeImplArray = this.odcTree.getAllEdges();
        for (int i = 0; i < oDCEdgeImplArray.length; ++i) {
            this.myPosting.addEdge(oDCEdgeImplArray[i]);
            this.needsPosting();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initTree");
        }
    }

    protected synchronized void needsPosting() {
        if (!this.needsPosting) {
            this.myPosting.incrVersion();
            this.needsPosting = true;
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        this.subscribe();
        this.post();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        this.cancelSubscriptions();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updated", (Object)subjectSubscription);
            }
            try {
                ScopeInfo scopeInfo = this.getScopeInfo(subjectSubscription);
                scopeInfo.handleScopeUpdate(new UpdateInfo(scopeInfo, subjectSubscription, subjectValueArray));
                if (this.initialized) break block6;
                BBTree bBTree = this;
                synchronized (bBTree) {
                    this.initialized = true;
                    this.notify();
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "updated", tc);
            }
        }
    }

    public synchronized void waitForInitializationCompletion(int n) throws Exception {
        if (!this.initialized) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("waiting for initialization of " + this.odcTree.getName()));
            }
            this.wait(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(ODCNode oDCNode) throws ODCException {
        if (this.updating) {
            return;
        }
        Object object = this.getPostSync();
        synchronized (object) {
            this.myPosting.addNode(oDCNode);
        }
        this.needsPosting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(ODCNode oDCNode) throws ODCException {
        if (this.updating) {
            return;
        }
        Object object = this.getPostSync();
        synchronized (object) {
            this.myPosting.removeNode(oDCNode);
        }
        this.needsPosting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(ODCEdge oDCEdge) throws ODCException {
        if (this.updating) {
            return;
        }
        Object object = this.getPostSync();
        synchronized (object) {
            this.myPosting.addEdge(oDCEdge);
        }
        this.needsPosting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdge(ODCEdge oDCEdge) throws ODCException {
        if (this.updating) {
            return;
        }
        Object object = this.getPostSync();
        synchronized (object) {
            this.myPosting.removeEdge(oDCEdge);
        }
        this.needsPosting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(ODCNode oDCNode, String string, Object object) throws ODCException {
        if (this.updating) {
            return;
        }
        Object object2 = this.getPostSync();
        synchronized (object2) {
            if (this.myPosting.setProperty(oDCNode, string, object)) {
                this.needsPosting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleUpdate(ScopeInfo scopeInfo, SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
        block57: {
            ServerInfo serverInfo;
            Object object;
            Object object2;
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handleUpdate", (Object)subjectSubscription);
            }
            OutputStream outputStream = null;
            Scope scope = scopeInfo.scope;
            long l = scopeInfo.update();
            SubjectInfo subjectInfo = subjectSubscription.getSubject();
            String string = subjectInfo.getSubjectName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: reading posts for " + string));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: update number " + l + " for " + string + " from " + scope));
            }
            Set set = scope.posters;
            scope.posters = new HashSet();
            if (subjectValueArray == null) {
                subjectValueArray = new SubjectValue[]{};
            }
            if (DEBUG_POSTS && this.postingsFile != null && (outputStream = DoPrivUtil.getOutputStream(this.postingsFile)) != null) {
                this.printPosting("self", this.myPosting.getPosting(), outputStream);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: reading posts for scope " + scope));
            }
            for (int i = 0; i < subjectValueArray.length; ++i) {
                object3 = subjectValueArray[i];
                object2 = object3.getServerName();
                if (((String)object2).equals(this.myServerName)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: skipping my own posting, server=" + (String)object2));
                    continue;
                }
                object = null;
                serverInfo = this.getServerInfo((String)object2, true);
                scope.posters.add(object2);
                set.remove(object2);
                if (serverInfo.stateChanged()) {
                    arrayList.add(serverInfo);
                }
                byte[] byArray = object3.getValues();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: reading post to " + string + ", server " + (String)object2 + ", size=" + byArray.length));
                }
                if (string.endsWith(V2_SUFFIX)) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    serverInfo.setCurVersion(objectInputStream.readInt());
                    serverInfo.setMaxVersion(objectInputStream.readInt());
                    long l2 = objectInputStream.readLong();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("BBACTION: curVer=" + serverInfo.getCurVersion() + ",maxVer=" + serverInfo.getMaxVersion() + ",postVer=" + l2));
                    }
                    boolean bl = false;
                    if (serverInfo.getCurVersion() == 1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"BBACTION: ignoring version 1 posted to version 2 topic");
                        }
                        bl = true;
                    } else if (serverInfo.getCurVersion() > this.myPosting.getMaxVersion()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BBACTION: ignoring advanced version " + serverInfo.getCurVersion()));
                        }
                        bl = true;
                    } else if (serverInfo.getMaxVersion() < this.myPosting.getCurVersion()) {
                        this.myPosting.transitionToVersion(serverInfo.getMaxVersion());
                    } else if (serverInfo.posting.getVersion() == l2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("BBACTION: no change in V2 posting by " + (String)object2 + ", VERSION=" + l2));
                        }
                        bl = true;
                    }
                    if (bl) {
                        if (outputStream == null) continue;
                        this.printPosting((String)object2, serverInfo.posting, outputStream);
                        continue;
                    }
                    object = this.readBBTreePosting(objectInputStream);
                } else {
                    serverInfo.setCurVersion(1);
                    if (serverInfo.getMaxVersion() < this.myPosting.getCurVersion()) {
                        this.myPosting.transitionToVersion(serverInfo.getMaxVersion());
                    }
                    object = (BBTreePosting)this.fromBytes(byArray);
                }
                if (outputStream != null) {
                    this.printPosting((String)object2, (BBTreePosting)object, outputStream);
                }
                if (serverInfo.posting.getVersion() == ((BBTreePosting)object).getVersion()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: no change in posting by " + (String)object2 + ", VERSION=" + ((BBTreePosting)object).getVersion()));
                    continue;
                }
                this.processPosting(serverInfo, (BBTreePosting)object, linkedHashSet);
            }
            ODCTreeImpl oDCTreeImpl = this.odcTree;
            synchronized (oDCTreeImpl) {
                this.odcTree.beginTransaction("BBTree.updated");
                try {
                    this.updating = true;
                    object3 = linkedHashSet.iterator();
                    while (object3.hasNext()) {
                        ((ObjectInfo)object3.next()).update();
                    }
                    if (l > 1L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"handling new posters");
                        }
                        object3 = arrayList.iterator();
                        while (object3.hasNext()) {
                            object2 = (ServerInfo)object3.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("new poster: " + object2));
                            }
                            this.markServerUp((ServerInfo)object2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"handling old posters");
                        }
                        boolean bl = false;
                        object3 = set.iterator();
                        while (object3.hasNext()) {
                            object = (String)object3.next();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("poster missing: " + (String)object));
                            }
                            if ((serverInfo = this.getServerInfo((String)object, false)) == null) continue;
                            this.markServerDown(serverInfo);
                            bl = true;
                        }
                        if (bl) {
                            this.checkMinMaxVersion();
                        }
                    }
                    this.updating = false;
                    this.odcTree.commitTransaction();
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "updatingTree", tc);
                    this.odcTree.rollbackTransaction();
                }
                finally {
                    this.updating = false;
                }
            }
            this.post();
            Object var27_28 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                break block57;
            }
            catch (IOException iOException) {
                TrUtil.warning(iOException, this, "handleUpdate2", tc);
            }
            break block57;
            {
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "handleUpdate", tc);
                    Object var27_29 = null;
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        break block57;
                    }
                    catch (IOException iOException) {
                        TrUtil.warning(iOException, this, "handleUpdate2", tc);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    TrUtil.warning(iOException, this, "handleUpdate2", tc);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleUpdate");
        }
    }

    protected BBTreePosting readBBTreePosting(ObjectInputStream objectInputStream) throws Exception {
        ObjectInputStream objectInputStream2 = new ObjectInputStream(new GZIPInputStream(objectInputStream));
        return (BBTreePosting)objectInputStream2.readObject();
    }

    protected void checkMinMaxVersion() throws Exception {
        Iterator iterator = this.serverInfoMap.entrySet().iterator();
        int n = this.myPosting.getMaxVersion();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ServerInfo serverInfo = (ServerInfo)entry.getValue();
            if (!serverInfo.isRunning()) continue;
            n = Math.min(n, serverInfo.getMaxVersion());
        }
        if (this.myPosting.getCurVersion() < n) {
            this.myPosting.transitionToVersion(n);
        }
    }

    protected void markServerUp(ServerInfo serverInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markServerUp", (Object)serverInfo);
        }
        serverInfo.posting = NO_POSTING;
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)this.findODCServerByBBServerName(serverInfo.id);
        if (oDCNodeImpl != null) {
            int n = oDCNodeImpl.getIntProperty(this.odc.serverWeight);
            if (n == 0) {
                oDCNodeImpl.setProperty(this.odc.serverWeight, (Object)UP_WEIGHT, false);
            }
            oDCNodeImpl.setProperty(this.odc.serverState, (Object)"STARTED", false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markServerUp", (Object)serverInfo);
        }
    }

    protected void markServerDown(ServerInfo serverInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markServerDown", (Object)serverInfo);
        }
        serverInfo.posting = NO_POSTING;
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)this.findODCServerByBBServerName(serverInfo.id);
        if (oDCNodeImpl != null) {
            oDCNodeImpl.setProperty(this.odc.serverWeight, (Object)DOWN_WEIGHT, false);
            oDCNodeImpl.setProperty(this.odc.serverState, (Object)"STOPPED", false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markServerDown", (Object)serverInfo);
        }
    }

    protected void removeEdges(ODCNode oDCNode, ODCNodeType oDCNodeType) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeEdges", (Object)new Object[]{oDCNode, oDCNodeType});
        }
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            oDCNode.removeNode(oDCNodeArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEdges", (Object)new Object[]{oDCNode, oDCNodeType});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPosting(ServerInfo serverInfo, BBTreePosting bBTreePosting, Set set) throws Exception {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processPosting", (Object)new Object[]{serverInfo, bBTreePosting});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processPosting: begin " + serverInfo.name));
        }
        Iterator iterator = bBTreePosting.nodes();
        while (iterator.hasNext()) {
            serializable = (Node)iterator.next();
            object = serverInfo.posting.removeNode(serializable.longName);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processPosting: create node " + serializable.longName));
                }
                this.addNode((Node)serializable, serverInfo, set);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("compare property values for change: " + serializable));
            }
            Iterator iterator2 = serializable.props.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string = (String)entry.getKey();
                Object object2 = object != null ? (Object)((Node)object).props.get(string) : null;
                Object v = entry.getValue();
                if (object2 != null && object2.toString().length() == 0) {
                    object2 = null;
                }
                if (v != null && v.toString().length() == 0) {
                    v = null;
                }
                if (object2 == v || object2 != null && v != null && object2.equals(v)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processPosting: setProperty: node=" + serializable.longName + ", name=" + string + ", value=" + v));
                }
                this.setProperty((Node)serializable, serverInfo, string, v, set);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releasing old nodes for " + serverInfo.name));
        }
        iterator = serverInfo.posting.nodes();
        while (iterator.hasNext()) {
            serializable = (Node)iterator.next();
            this.removeNode((Node)serializable, serverInfo, set);
            object = this.getPostSync();
            synchronized (object) {
                if (this.myPosting.removeNode(serializable.longName) != null) {
                    this.needsPosting();
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("comparing edges for " + serverInfo.name));
        }
        iterator = bBTreePosting.edges();
        while (iterator.hasNext()) {
            serializable = (Edge)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("comparing edge: " + serializable));
            }
            if (serverInfo.posting.removeEdge(((Edge)serializable).longName) != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processPosting: create edge " + ((Edge)serializable).longName));
            }
            this.addEdge((Edge)serializable, serverInfo, set);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("releasing old edges for " + serverInfo.name));
        }
        iterator = serverInfo.posting.edges();
        while (iterator.hasNext()) {
            serializable = (Edge)iterator.next();
            this.removeEdge((Edge)serializable, serverInfo, set);
            object = this.getPostSync();
            synchronized (object) {
                if (this.myPosting.removeEdge(((Edge)serializable).longName) != null) {
                    this.needsPosting();
                }
            }
        }
        serverInfo.posting = bBTreePosting;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processPosting: end " + serverInfo.name));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processPosting", (Object)serverInfo.name);
        }
    }

    protected void addNode(Node node, ServerInfo serverInfo, Set set) throws Exception {
        NodeInfo nodeInfo;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addNode " + node + " by " + serverInfo.id));
        }
        if ((nodeInfo = this.getNodeInfo(node)) != null) {
            nodeInfo.setCreate(true);
            set.add(nodeInfo);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ignore node " + node));
        }
    }

    protected void addEdge(Edge edge, ServerInfo serverInfo, Set set) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addEdge " + edge + " by " + serverInfo.id));
        }
        EdgeInfo edgeInfo = this.getEdgeInfo(edge);
        edgeInfo.setCreate(true);
        set.add(edgeInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEdge", (Object)edgeInfo);
        }
    }

    protected void removeNode(Node node, ServerInfo serverInfo, Set set) throws Exception {
        NodeInfo nodeInfo;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeNode " + node + " by " + serverInfo.id));
        }
        if ((nodeInfo = (NodeInfo)this.objectInfoMap.remove(node.longName)) != null) {
            nodeInfo.setCreate(false);
            set.add(nodeInfo);
        }
    }

    protected void removeEdge(Edge edge, ServerInfo serverInfo, Set set) throws Exception {
        EdgeInfo edgeInfo;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeEdge " + edge + " by " + serverInfo.id));
        }
        if ((edgeInfo = (EdgeInfo)this.objectInfoMap.remove(edge.longName)) != null) {
            edgeInfo.setCreate(false);
            set.add(edgeInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post() {
        if (!this.needsPosting) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: no posting needed for " + this));
            }
            return;
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: posting tree " + this));
            }
            Object object = this.getPostSync();
            synchronized (object) {
                this.myPosting.post();
            }
            this.needsPosting = false;
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "post-failure", tc);
        }
    }

    protected Object getPostSync() {
        return this;
    }

    protected void addNewNode(Node node) {
        this.newNodes.add(node);
    }

    public String toString() {
        return this.odcTree.toString();
    }

    protected synchronized SubjectInfo getSubjectInfo() throws Exception {
        if (this.info == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: creating subject for " + this));
            }
            this.info = this.bb.createSubject(this.pubScope, this.odcTree.getName());
        }
        return this.info;
    }

    protected synchronized SubjectInfo getZippedSubjectInfo() throws Exception {
        if (this.zippedInfo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: creating zipped subject for " + this));
            }
            this.zippedInfo = this.bb.createSubject(this.pubScope, this.odcTree.getName() + V2_SUFFIX);
        }
        return this.zippedInfo;
    }

    protected synchronized SubjectPost getSubjectPost() throws Exception {
        if (this.post == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: creating posting for " + this));
            }
            this.post = this.bb.createPost(this.getSubjectInfo());
        }
        return this.post;
    }

    protected synchronized SubjectPost getZippedSubjectPost() throws Exception {
        if (this.zippedPost == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: creating posting for " + this));
            }
            this.zippedPost = this.bb.createPost(this.getZippedSubjectInfo());
        }
        return this.zippedPost;
    }

    protected synchronized void subscribe() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"subscribe");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BBACTION: local subscription: tree=" + this));
        }
        if (this.scopes[0] == null) {
            try {
                this.scopes[0] = new Scope(this.bb.subscribe(this.getSubjectInfo(), (SubjectSubscriptionEvents)this));
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "local-subscription-failure", tc);
            }
        }
        if (this.zippedScopes[0] == null) {
            try {
                this.zippedScopes[0] = new Scope(this.bb.subscribe(this.getZippedSubjectInfo(), (SubjectSubscriptionEvents)this));
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "local-subscription-failure", tc);
            }
        }
        for (int i = 0; i < this.remScopes.length; ++i) {
            SubjectInfo subjectInfo;
            BulletinBoardScope bulletinBoardScope = this.remScopes[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: remote subscription: tree=" + this + ", scope=" + bulletinBoardScope));
            }
            if (this.scopes[i + 1] == null) {
                try {
                    subjectInfo = this.bb.createSubject(bulletinBoardScope, this.odcTree.getName());
                    this.scopes[i + 1] = new Scope(this.bb.subscribe(subjectInfo, (SubjectSubscriptionEvents)this));
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "remote-subscription-failure-" + bulletinBoardScope, tc);
                }
            }
            if (this.zippedScopes[i + 1] != null) continue;
            try {
                subjectInfo = this.bb.createSubject(bulletinBoardScope, this.odcTree.getName() + V2_SUFFIX);
                this.zippedScopes[i + 1] = new Scope(this.bb.subscribe(subjectInfo, (SubjectSubscriptionEvents)this));
                continue;
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "remote-subscription-failure-" + bulletinBoardScope, tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"subscribe");
        }
    }

    protected synchronized void cancelSubscriptions() {
        Scope scope;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cancelSubscriptions");
        }
        for (n = 0; n < this.scopes.length; ++n) {
            scope = this.scopes[n];
            if (scope == null || scope.subscription == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: canceling subscription: tree=" + this + ", subscription=" + scope.subscription));
            }
            try {
                scope.subscription.close();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "cancelSubscriptions", tc);
            }
            scope.subscription = null;
        }
        for (n = 0; n < this.zippedScopes.length; ++n) {
            scope = this.zippedScopes[n];
            if (scope == null || scope.subscription == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("BBACTION: canceling subscription: tree=" + this + ", subscription=" + scope.subscription));
            }
            try {
                scope.subscription.close();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "cancelSubscriptions", tc);
            }
            scope.subscription = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancelSubscriptions");
        }
    }

    protected Scope findScope(SubjectSubscription subjectSubscription) throws ODCException {
        Scope scope;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findScope", (Object)subjectSubscription);
        }
        for (n = 0; n < this.scopes.length; ++n) {
            scope = this.scopes[n];
            if (scope.subscription != subjectSubscription) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findScope", (Object)scope);
            }
            return scope;
        }
        for (n = 0; n < this.zippedScopes.length; ++n) {
            scope = this.zippedScopes[n];
            if (scope.subscription != subjectSubscription) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findScope", (Object)scope);
            }
            return scope;
        }
        throw new ODCException("scope not found for " + subjectSubscription);
    }

    protected ODCNode findODCServerByBBServerName(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findODCServerByBBServerName", (Object)string);
        }
        String[] stringArray = string.split("\\\\");
        ODCNode oDCNode = this.odcTree.getRoot().getNode(this.odc.cell, stringArray[0]);
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findODCServerByBBServerName", (Object)"cell not found");
            }
            return null;
        }
        ODCNode oDCNode2 = oDCNode.getNode(this.odc.node, stringArray[1]);
        if (oDCNode2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findODCServerByBBServerName", (Object)"node not not found");
            }
            return null;
        }
        ODCNode oDCNode3 = oDCNode2.getNode(this.odc.server, stringArray[2]);
        if (oDCNode3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"findODCServerByBBServerName", (Object)"server not not found");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findODCServerByBBServerName", (Object)oDCNode3);
        }
        return oDCNode3;
    }

    protected Object fromBytes(byte[] byArray) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        return objectInputStream.readObject();
    }

    protected void printPosting(String string, BBTreePosting bBTreePosting, OutputStream outputStream) {
        if (!tc.isDebugEnabled()) {
            return;
        }
        try {
            String string2 = "POSTER: " + string + "\n";
            outputStream.write(string2.getBytes());
            outputStream.write(bBTreePosting.toString().getBytes());
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "printPosting", tc);
        }
    }

    protected void setProperty(Node node, ServerInfo serverInfo, String string, Object object, Set set) throws Exception {
        NodeInfo nodeInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperty", (Object)new Object[]{node, serverInfo.id, string, object});
        }
        if ((nodeInfo = this.getNodeInfo(node)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)("node type " + node.name + " not defined locally"));
            }
            return;
        }
        PropertyInfo propertyInfo = nodeInfo.getPropertyInfo(string);
        if (propertyInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)("property " + string + " not defined locally for node " + node.name));
            }
            return;
        }
        propertyInfo.setValue(serverInfo, object);
        set.add(propertyInfo);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)propertyInfo);
        }
    }

    protected ScopeInfo getScopeInfo(SubjectSubscription subjectSubscription) throws Exception {
        ScopeInfo scopeInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getScopeInfo", (Object)subjectSubscription);
        }
        if ((scopeInfo = (ScopeInfo)this.scopeInfoMap.get(subjectSubscription)) == null) {
            scopeInfo = new ScopeInfo(this.findScope(subjectSubscription));
            this.scopeInfoMap.put(subjectSubscription, scopeInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getScopeInfo", (Object)scopeInfo);
        }
        return scopeInfo;
    }

    protected ServerInfo getServerInfo(String string, boolean bl) throws Exception {
        ServerInfo serverInfo;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerInfo", (Object)string);
        }
        if ((serverInfo = (ServerInfo)this.serverInfoMap.get(string)) == null) {
            serverInfo = new ServerInfo(string);
            this.serverInfoMap.put(string, serverInfo);
        } else {
            serverInfo.setRunning(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerInfo", (Object)serverInfo);
        }
        return serverInfo;
    }

    protected NodeInfo getNodeInfo(Node node) throws Exception {
        NodeInfo nodeInfo = this.getNodeInfo(node.longName);
        if (nodeInfo == null) {
            ODCNodeType oDCNodeType = this.odcMgr.getNodeType(node.type);
            if (oDCNodeType == null) {
                return null;
            }
            nodeInfo = new NodeInfo(node, oDCNodeType);
            this.objectInfoMap.put(node.longName, nodeInfo);
        }
        return nodeInfo;
    }

    protected NodeInfo getNodeInfo(String string) throws Exception {
        return (NodeInfo)this.objectInfoMap.get(string);
    }

    protected EdgeInfo getEdgeInfo(Edge edge) {
        EdgeInfo edgeInfo = (EdgeInfo)this.objectInfoMap.get(edge.longName);
        if (edgeInfo == null) {
            edgeInfo = new EdgeInfo(edge);
            this.objectInfoMap.put(edge.longName, edgeInfo);
        }
        return edgeInfo;
    }

    protected void removeObjectInfo(ObjectInfo objectInfo) {
        this.objectInfoMap.remove(objectInfo.path);
    }

    static {
        threadPool.setRequestBufferSize(20);
    }

    protected class MyPosting {
        protected int curVersion = this.getMaxVersion();
        protected int maxVersion = this.getMaxVersion();
        protected BBTreePosting v1 = null;
        protected BBTreePosting v2;

        public MyPosting() throws ODCException {
            BBMgr bBMgr = BBMgr.getInstance();
            this.v2 = new BBTreePosting(bBMgr.getMyServerName(), bBMgr.getMyServerType());
        }

        public int getCurVersion() {
            return this.curVersion;
        }

        public void setCurVersion(int n) {
            this.curVersion = n;
        }

        public void post() throws Exception {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            BBTreePosting bBTreePosting = this.getPosting();
            if (this.curVersion == 1) {
                objectOutputStream.writeObject(bBTreePosting);
                objectOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                BBTree.this.getSubjectPost().updatePost(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: post written for V1; size=" + byArray.length));
                }
            } else {
                objectOutputStream.writeInt(this.curVersion);
                objectOutputStream.writeInt(this.getMaxVersion());
                objectOutputStream.writeLong(this.v2.getVersion());
                ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new GZIPOutputStream(objectOutputStream));
                objectOutputStream2.writeObject(bBTreePosting);
                objectOutputStream2.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                BBTree.this.getZippedSubjectPost().updatePost(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: post written for V2; size=" + byArray.length));
                }
            }
        }

        public BBTreePosting getPosting() {
            if (this.curVersion == 1) {
                if (this.v1 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"building V1 posting");
                    }
                    this.v1 = new BBTreePosting(this.v2.getServerName(), this.v2.getServerType());
                    this.v1.setVersion(this.v2.getVersion());
                    this.v2 = null;
                    this.rebuildPosting();
                }
                return this.v1;
            }
            if (this.v2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"building V2 posting");
                }
                this.v2 = new BBTreePosting(this.v1.getServerName(), this.v1.getServerType());
                this.v2.setVersion(this.v1.getVersion());
                this.v1 = null;
                this.rebuildPosting();
            }
            return this.v2;
        }

        public String getServerName() {
            return this.getPosting().getServerName();
        }

        public String getServerType() {
            return this.getPosting().getServerType();
        }

        public long getVersion() {
            return this.getPosting().getVersion();
        }

        public void incrVersion() {
            this.getPosting().incrVersion();
        }

        public void addNode(ODCNode oDCNode) throws ODCException {
            boolean bl = this.curVersion == 1;
            this.getPosting().addNode(oDCNode, ((ODCNodeImpl)oDCNode).getProperties(bl));
        }

        public void removeNode(ODCNode oDCNode) throws ODCException {
            this.getPosting().removeNode(oDCNode);
        }

        public Node removeNode(String string) {
            return this.getPosting().removeNode(string);
        }

        public void addEdge(ODCEdge oDCEdge) throws ODCException {
            this.getPosting().addEdge(oDCEdge);
        }

        public void removeEdge(ODCEdge oDCEdge) throws ODCException {
            this.getPosting().removeEdge(oDCEdge);
        }

        public Edge removeEdge(String string) {
            return this.getPosting().removeEdge(string);
        }

        public boolean setProperty(ODCNode oDCNode, String string, Object object) throws ODCException {
            return this.getPosting().setProperty(oDCNode, string, object);
        }

        public Iterator nodes() {
            return this.getPosting().nodes();
        }

        public Iterator edges() {
            return this.getPosting().edges();
        }

        public void remove(ODCTreeImpl oDCTreeImpl) throws ODCException {
            this.getPosting().remove(oDCTreeImpl);
        }

        public String toString() {
            return this.getPosting().toString();
        }

        protected int getMaxVersion() {
            return 2;
        }

        protected void transitionToVersion(int n) throws Exception {
            int n2 = this.getCurVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("transition from version " + n2 + " to version " + n));
            }
            if (n2 == n) {
                return;
            }
            this.setCurVersion(n);
            BBTree.this.needsPosting();
            this.post();
            if (n2 == 1) {
                BBTree.this.getSubjectPost().close();
                BBTree.this.post = null;
            }
            if (n == 1) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeInt(1);
                objectOutputStream.writeInt(this.getMaxVersion());
                objectOutputStream.writeLong(-1L);
                objectOutputStream.close();
                BBTree.this.getZippedSubjectPost().updatePost(byteArrayOutputStream.toByteArray());
            }
        }

        protected void rebuildPosting() {
            try {
                BBTree.this.initTree();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    protected class Scope {
        public SubjectSubscription subscription;
        public Set posters = new HashSet();

        public Scope(SubjectSubscription subjectSubscription) {
            this.subscription = subjectSubscription;
        }
    }

    protected class PropertyChange {
        public final Node node;
        public final String name;
        public final Object value;

        public PropertyChange(Node node, String string, Object object) {
            this.node = node;
            this.name = string;
            this.value = object;
        }

        public String toString() {
            return this.node.longName + ", property=" + this.name + ", value=" + this.value;
        }
    }

    protected class PostingPair {
        public final String poster;
        public final BBTreePosting old;
        public final BBTreePosting cur;

        public PostingPair(String string, BBTreePosting bBTreePosting, BBTreePosting bBTreePosting2) {
            this.poster = string;
            this.old = bBTreePosting;
            this.cur = bBTreePosting2;
        }

        public void compareAndRelease() throws Exception {
            Serializable serializable;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"compareAndRelease", (Object)this.poster);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("comparing edges for " + this.poster));
            }
            Iterator iterator = this.cur.edges();
            while (iterator.hasNext()) {
                serializable = (Edge)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("comparing edge: " + serializable));
                }
                if (this.old.removeEdge(serializable.longName) != null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("new edge reference: " + serializable));
                }
                BBTree.this.newEdges.add(serializable);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releasing old edges for " + this.poster));
            }
            iterator = this.old.edges();
            while (iterator.hasNext()) {
                serializable = (Edge)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: releasing edge " + serializable));
                }
                BBTree.this.odcTree.releaseEdge(serializable.longName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("comparing nodes for " + this.poster));
            }
            iterator = this.cur.nodes();
            while (iterator.hasNext()) {
                Node node;
                serializable = (Node)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("comparing node: " + serializable));
                }
                if ((node = this.old.removeNode(((Node)serializable).longName)) == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("new node reference: " + serializable));
                    }
                    BBTree.this.addNewNode((Node)serializable);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("compare property values for change: " + serializable));
                }
                Iterator iterator2 = ((Node)serializable).props.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Object v;
                    Map.Entry entry = iterator2.next();
                    Object v2 = node.props.get(entry.getKey());
                    if (v2 == (v = entry.getValue()) || v2 != null && v != null && v2.equals(v)) continue;
                    BBTree.this.propertyChanges.add(new PropertyChange((Node)serializable, (String)entry.getKey(), v));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releasing old nodes for " + this.poster));
            }
            iterator = this.old.nodes();
            while (iterator.hasNext()) {
                serializable = (Node)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("BBACTION: releasing node " + ((Node)serializable).longName));
                }
                BBTree.this.odcTree.releaseNode(((Node)serializable).longName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"compareAndRelease", (Object)this.poster);
            }
        }

        public String toString() {
            return this.poster;
        }
    }

    protected class ServerInfo {
        public final String id;
        public final String cell;
        public final String node;
        public final String name;
        public final ServerType type;
        private int curVersion;
        private int maxVersion = 1;
        public BBTreePosting posting = NO_POSTING;
        private boolean running = true;
        private boolean stateChanged = true;

        public ServerInfo(String string) {
            this.id = string;
            String[] stringArray = string.split("\\\\");
            this.cell = stringArray[0];
            this.node = stringArray[1];
            this.name = stringArray[2];
            this.type = ServerType.getServerType(this.name);
        }

        public int getCurVersion() {
            return this.curVersion;
        }

        public void setCurVersion(int n) {
            this.curVersion = n;
        }

        public int getMaxVersion() {
            return this.maxVersion;
        }

        public void setMaxVersion(int n) {
            this.maxVersion = n;
        }

        public boolean isNodeAgent() {
            return this.type == ServerType.NODE_AGENT;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean bl) {
            this.stateChanged = this.running != bl;
            this.running = bl;
        }

        public boolean stateChanged() {
            return this.stateChanged;
        }

        public String toString() {
            return this.id + ": running=" + this.running;
        }
    }

    protected abstract class ObjectInfo {
        public final String path;

        public ObjectInfo(String string) {
            this.path = string;
        }

        public abstract void update() throws Exception;

        public String toString() {
            return this.path;
        }
    }

    protected class PropertyInfo
    extends ObjectInfo {
        public final NodeInfo nodeInfo;
        public final ODCPropertyDescriptor propDesc;
        protected Object propVal;
        protected int propPriority;
        protected boolean nodeAgentWeight;
        protected boolean needsUpdate;

        public PropertyInfo(NodeInfo nodeInfo, ODCPropertyDescriptor oDCPropertyDescriptor) throws Exception {
            super(nodeInfo.path + "/property/" + oDCPropertyDescriptor.getName());
            this.propVal = null;
            this.propPriority = -1;
            this.nodeAgentWeight = false;
            this.needsUpdate = false;
            this.nodeInfo = nodeInfo;
            this.propDesc = oDCPropertyDescriptor;
        }

        public void setValue(ServerInfo serverInfo, Object object) {
            int n = 0;
            if (object instanceof ODCPropertyValueWrapper) {
                ODCPropertyValueWrapper oDCPropertyValueWrapper = (ODCPropertyValueWrapper)object;
                object = oDCPropertyValueWrapper.getPropVal();
                n = oDCPropertyValueWrapper.getPropPriority();
            }
            if (this.propDesc == BBTree.this.odc.serverWeight) {
                if (serverInfo.isNodeAgent()) {
                    this.setProperty(object, n);
                    this.nodeAgentWeight = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("nodeagent set server weight to " + object + " for " + this.path));
                    }
                } else if (!this.nodeAgentWeight) {
                    this.setProperty(object, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("server weight set to " + object + " for " + this.path));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignore server weight change; already set by node agent");
                }
            } else {
                this.setProperty(object, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("property set to " + object + " for " + this.path));
                }
            }
            this.needsUpdate = true;
        }

        public void update() throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"PropertyInfo.update", (Object)this);
            }
            if (!this.needsUpdate) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"PropertyInfo.update", (Object)"no update needed");
                }
                return;
            }
            this.needsUpdate = false;
            this.nodeInfo.update();
            ODCNodeImpl oDCNodeImpl = BBTree.this.odcTree.getNode(this.nodeInfo.path);
            if (oDCNodeImpl == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"PropertyInfo.update", (Object)("node not found: " + this.nodeInfo.path));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PropertyInfo.update: path=" + this.path + ", value=" + this.propVal));
            }
            oDCNodeImpl.setProperty(this.propDesc, this.propVal);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"PropertyInfo.update", (Object)"not set");
            }
        }

        protected int getIndex(ServerType serverType) {
            if (this.propDesc == BBTree.this.odc.serverWeight) {
                return serverType.serverWeightIndex;
            }
            return serverType.defaultPropertyIndex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("property=").append(this.propDesc);
            stringBuffer.append(",").append(this.nodeInfo);
            stringBuffer.append(",needsUpdate=").append(this.needsUpdate);
            return stringBuffer.toString();
        }

        private void setProperty(Object object, int n) {
            if (this.propPriority <= n) {
                this.propVal = object;
                this.propPriority = n;
            }
        }
    }

    protected class EdgeInfo
    extends ObjectInfo {
        private final String parentPath;
        private final String childPath;
        private boolean create;

        public EdgeInfo(Edge edge) {
            super(edge.longName);
            this.create = false;
            this.parentPath = edge.parentLongName;
            this.childPath = edge.childLongName;
        }

        public void setCreate(boolean bl) {
            this.create = bl;
        }

        public void update() throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"edge.update", (Object)this);
            }
            if (this.create) {
                ODCNode oDCNode;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("edge change: create " + this.path));
                }
                if ((oDCNode = this.getNode(this.parentPath)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"edge.update", (Object)("parent not found: " + this.parentPath));
                    }
                    return;
                }
                ODCNode oDCNode2 = this.getNode(this.childPath);
                if (oDCNode2 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"edge.update", (Object)("child not found: " + this.childPath));
                    }
                    return;
                }
                oDCNode.addNode(oDCNode2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("edge created: " + this.path));
                }
            } else {
                ODCNode oDCNode;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("edge change: delete " + this.path));
                }
                if ((oDCNode = this.getNode(this.parentPath)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"edge.update", (Object)("parent not found: " + this.parentPath));
                    }
                    return;
                }
                ODCNode oDCNode3 = this.getNode(this.childPath);
                if (oDCNode3 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"edge.update", (Object)("child not found: " + this.childPath));
                    }
                    return;
                }
                oDCNode.removeNode(oDCNode3);
                BBTree.this.removeObjectInfo(this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("edge deleted: " + this.path));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"edge.update", (Object)this);
            }
        }

        protected ODCNode getNode(String string) throws Exception {
            NodeInfo nodeInfo;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"edge.getNode", (Object)string);
            }
            if ((nodeInfo = BBTree.this.getNodeInfo(string)) == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"edge.getNode", (Object)"info not found");
                }
                return null;
            }
            nodeInfo.update();
            ODCNodeImpl oDCNodeImpl = BBTree.this.odcTree.getNode(string);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"edge.getNode", (Object)oDCNodeImpl);
            }
            return oDCNodeImpl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("parent=").append(this.parentPath);
            stringBuffer.append(",child=").append(this.childPath);
            stringBuffer.append(",create=").append(this.create);
            return stringBuffer.toString();
        }
    }

    protected class NodeInfo
    extends ObjectInfo {
        private final String name;
        private final ODCNodeType type;
        private final String parentPath;
        private boolean create;
        private Map propInfoMap;

        public NodeInfo(Node node, ODCNodeType oDCNodeType) throws Exception {
            super(node.longName);
            this.create = false;
            this.propInfoMap = new HashMap();
            this.name = node.name;
            this.type = oDCNodeType;
            this.parentPath = node.parentLongName;
        }

        public PropertyInfo getPropertyInfo(String string) throws Exception {
            PropertyInfo propertyInfo = (PropertyInfo)this.propInfoMap.get(string);
            if (propertyInfo == null) {
                ODCPropertyDescriptor oDCPropertyDescriptor = this.type.getPropertyDescriptor(string);
                if (oDCPropertyDescriptor == null) {
                    return null;
                }
                propertyInfo = new PropertyInfo(this, oDCPropertyDescriptor);
                this.propInfoMap.put(string, propertyInfo);
            }
            return propertyInfo;
        }

        public void setCreate(boolean bl) {
            this.create = bl;
        }

        public void update() throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"node.update", (Object)this);
            }
            if (this.create) {
                NodeInfo nodeInfo;
                if (this.parentPath == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"node.update", (Object)"root node");
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("node change: create " + this.path));
                }
                if ((nodeInfo = BBTree.this.getNodeInfo(this.parentPath)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"node.update", (Object)("parent not found: " + this.parentPath));
                    }
                    return;
                }
                nodeInfo.update();
                ODCNodeImpl oDCNodeImpl = BBTree.this.odcTree.getNode(this.parentPath);
                if (oDCNodeImpl == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"node.update", (Object)("parent deleted: " + this.parentPath));
                    }
                    return;
                }
                BBTree.this.odcTree.createNode(this.name, this.type, oDCNodeImpl);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("node created: " + this.path));
                }
            } else {
                ODCNodeImpl oDCNodeImpl;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("node change: delete " + this.path));
                }
                if ((oDCNodeImpl = BBTree.this.odcTree.getNode(this.path)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"node.update", (Object)("node not found: " + this.path));
                    }
                    return;
                }
                oDCNodeImpl.remove();
                BBTree.this.removeObjectInfo(this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("node deleted: " + this.path));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"node.update", (Object)this);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("name=").append(this.name);
            stringBuffer.append(",type=").append(this.type);
            stringBuffer.append(",parent=").append(this.parentPath);
            stringBuffer.append(",create=").append(this.create);
            return stringBuffer.toString();
        }
    }

    protected class ScopeInfo
    implements Runnable {
        public final Scope scope;
        private long updateCount = 0L;
        private UpdateInfo updateInfo = null;
        private final Object runLock = new Object();

        public ScopeInfo(Scope scope) {
            this.scope = scope;
        }

        public long update() {
            return ++this.updateCount;
        }

        public void handleScopeUpdate(UpdateInfo updateInfo) throws Exception {
            if (this.putUpdateInfo(updateInfo)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"scheduling update processing");
                }
                threadPool.execute((Runnable)this, 3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dropped previous update");
            }
        }

        protected synchronized boolean putUpdateInfo(UpdateInfo updateInfo) {
            boolean bl = this.updateInfo == null;
            this.updateInfo = updateInfo;
            return bl;
        }

        protected synchronized UpdateInfo getUpdateInfo() {
            UpdateInfo updateInfo = this.updateInfo;
            this.updateInfo = null;
            return updateInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.runLock;
            synchronized (object) {
                UpdateInfo updateInfo = this.getUpdateInfo();
                if (updateInfo != null) {
                    BBTree.this.handleUpdate(updateInfo.scopeInfo, updateInfo.subjectSubscription, updateInfo.values);
                }
            }
        }
    }

    protected class UpdateInfo {
        public final ScopeInfo scopeInfo;
        public final SubjectSubscription subjectSubscription;
        public final SubjectValue[] values;

        public UpdateInfo(ScopeInfo scopeInfo, SubjectSubscription subjectSubscription, SubjectValue[] subjectValueArray) {
            this.scopeInfo = scopeInfo;
            this.subjectSubscription = subjectSubscription;
            this.values = subjectValueArray;
        }
    }
}

