/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.bb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.odc.ODCService;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScopes;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BBMgr
extends ComponentImpl {
    private static final String ODCBB = "ODC.BBEnabled";
    public static final boolean ENABLED = System.getProperty("ODC.BBEnabled", "true").equalsIgnoreCase("true");
    private static final TraceComponent tc = TrUtil.register(BBMgr.class);
    private static final String SEP = "\\";
    private static BBMgr instance = null;
    private BulletinBoard bb = null;
    private String myServerName = null;
    private String myServerType = null;
    private BulletinBoardScope pubScope = null;
    private final ArrayList remScopes = new ArrayList();
    private boolean scopesInitialized = false;
    private static List treesToRun = new LinkedList();
    private List runningTrees = new ArrayList();
    private static PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();

    public static synchronized BBMgr getInstance() throws ODCException {
        if (instance == null) {
            throw new ODCException(BBMgr.class.getName() + " service is not started");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manageTree(ODCTree oDCTree) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"manageTree", (Object)oDCTree);
        }
        if (!ENABLED) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"manageTree", (Object)"disabled");
            }
            return;
        }
        List list = treesToRun;
        synchronized (list) {
            if (instance == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"BBMgr not started yet");
                }
                treesToRun.add(oDCTree);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"BBMgr has been started already");
                }
                BBMgr.instance.runningTrees.add(ODCService.getODCFactory().createBBTree(oDCTree));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"manageTree", (Object)oDCTree);
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (!ENABLED) {
            throw new ComponentDisabledException("ODC over bulletin board disabled; value of ODC.BBEnabled equals " + System.getProperty(ODCBB));
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService.getProcessType().equals("UnManagedProcess")) {
            throw new ComponentDisabledException("ODC over bulletin board disabled on standalone");
        }
        if (platformHelper.isZOS() && (platformHelper.isServantJvm() || platformHelper.isCRAJvm())) {
            throw new ComponentDisabledException("BBMgr disabled in z/OS Servant and CRA.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        this.init();
        instance = this;
        List list = treesToRun;
        synchronized (list) {
            while (treesToRun.size() > 0) {
                ODCTree oDCTree = (ODCTree)treesToRun.remove(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("starting tree " + oDCTree));
                }
                try {
                    this.runningTrees.add(ODCService.getODCFactory().createBBTree(oDCTree));
                }
                catch (ODCException oDCException) {
                    throw new RuntimeWarning((Throwable)((Object)oDCException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    private void init() throws RuntimeWarning, RuntimeError {
        AdminService adminService;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        if (this.bb == null) {
            adminService = (CoreStack)this.getService(CoreStack.class);
            if (adminService == null) {
                throw new RuntimeWarning("Failed to get service " + CoreStack.class.getName());
            }
            try {
                BulletinBoardFactory bulletinBoardFactory = adminService.getBulletinboardFactory();
                if (bulletinBoardFactory == null) {
                    throw new RuntimeWarning("Failed to find bulletin board factory");
                }
                this.bb = bulletinBoardFactory.findBulletinBoard("ODC");
                if (this.bb == null) {
                    throw new RuntimeWarning("Failed to find ODC bulletin board");
                }
            }
            catch (HAParameterRejectedException hAParameterRejectedException) {
                throw new RuntimeWarning((Throwable)hAParameterRejectedException);
            }
            finally {
                this.releaseService(adminService);
            }
        }
        adminService = AdminServiceFactory.getAdminService();
        this.myServerName = adminService.getCellName() + SEP + adminService.getNodeName() + SEP + adminService.getProcessName();
        this.myServerType = adminService.getProcessType();
        this.initScopes();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init", (Object)this.myServerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScopes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initScopes");
        }
        this.pubScope = null;
        this.remScopes.clear();
        BulletinBoardScopes bulletinBoardScopes = (BulletinBoardScopes)this.getService(BulletinBoardScopes.class);
        if (bulletinBoardScopes == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initScopes", (Object)"BulletinBoardScopes service unavailable");
            }
            return;
        }
        try {
            this.pubScope = bulletinBoardScopes.getPublicScope();
            Map map = bulletinBoardScopes.getPeerAccessPointsMap();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("scope key = " + k));
                }
                BulletinBoardScope bulletinBoardScope = null;
                HashMap hashMap = new HashMap();
                hashMap.put("peerName", k);
                bulletinBoardScope = bulletinBoardScopes.getRemoteScope(hashMap);
                this.remScopes.add(bulletinBoardScope);
            }
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            TrUtil.warning(hAParameterRejectedException, (Object)this, "initScopes", tc);
        }
        finally {
            this.releaseService(bulletinBoardScopes);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initScopes");
        }
    }

    public BulletinBoard getBulletinBoard() {
        return this.bb;
    }

    public String getMyServerName() {
        return this.myServerName;
    }

    public String getMyServerType() {
        return this.myServerType;
    }

    public BulletinBoardScope getPublicScope() {
        return this.pubScope;
    }

    public BulletinBoardScope[] getRemoteScopes() {
        return this.remScopes.toArray(new BulletinBoardScope[0]);
    }
}

