/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ws.odc.ODCManagerImpl;
import com.ibm.ws.odc.ODCSchemaImpl;
import com.ibm.wsspi.odc.ODCEdgeCardinality;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCManagerFactory;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ODCSchemaParser
extends DefaultHandler
implements ErrorHandler {
    private final ArrayList nodeTypeStack = new ArrayList();
    private final ODCManagerImpl mgr;
    private ODCSchemaImpl schema;
    private String sFilename;
    private String sErrorMessage;
    private SAXParser parser;
    private boolean bParsedSuccessfully;

    public ODCSchemaParser(ODCManagerImpl oDCManagerImpl) throws ODCException {
        try {
            this.mgr = oDCManagerImpl;
            this.parser = SAXParserFactory.newInstance().newSAXParser();
            this.sFilename = null;
            this.bParsedSuccessfully = false;
            this.sErrorMessage = null;
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
    }

    public synchronized void parse(InputStream inputStream, ODCSchemaImpl oDCSchemaImpl) throws ODCException {
        try {
            this.schema = oDCSchemaImpl;
            this.bParsedSuccessfully = false;
            this.sErrorMessage = null;
            this.parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
        this.schema = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block7: {
            String string4 = string3;
            try {
                if (string4.equalsIgnoreCase("ODCSchema")) break block7;
                if (string4.equalsIgnoreCase("type")) {
                    ODCNodeType oDCNodeType = this.schema.createNodeType(this.findAttr("name", attributes));
                    this.push(oDCNodeType);
                    break block7;
                }
                if (string4.equalsIgnoreCase("typeref")) {
                    ODCNodeType oDCNodeType = this.schema.findNodeType(this.findAttr("name", attributes));
                    this.push(oDCNodeType);
                    break block7;
                }
                if (string4.equalsIgnoreCase("relationship")) {
                    ODCNodeType oDCNodeType = this.schema.findNodeType(this.findAttr("parent", attributes));
                    ODCNodeType oDCNodeType2 = this.schema.findNodeType(this.findAttr("child", attributes));
                    ODCEdgeCardinality oDCEdgeCardinality = ODCEdgeCardinality.findByName(this.findAttr("type", attributes));
                    boolean bl = this.toBoolean("linked", this.getAttr("linked", attributes), false);
                    this.schema.createEdgeType(oDCNodeType, oDCNodeType2, oDCEdgeCardinality, bl);
                    break block7;
                }
                if (string4.equalsIgnoreCase("property")) {
                    ODCNodeType oDCNodeType = this.top();
                    if (oDCNodeType == null) {
                        throw new SAXException("attribute must be inside a 'type' element");
                    }
                    String string5 = this.findAttr("name", attributes);
                    String string6 = this.getAttr("type", attributes);
                    string6 = string6 != null ? string6 : "String";
                    ODCPropertyType oDCPropertyType = this.mgr.getPropertyTypeRegistry().find(string6);
                    String string7 = this.getAttr("defaultValue", attributes);
                    boolean bl = this.toBoolean("global", this.getAttr("global", attributes), true);
                    Object object = string7 == null ? null : oDCPropertyType.fromString(string7);
                    oDCNodeType.createPropertyDescriptor(string5, oDCPropertyType, object, bl);
                    break block7;
                }
                throw new SAXException("invalid tag: " + string4);
            }
            catch (ODCException oDCException) {
                throw new SAXException((Exception)((Object)oDCException));
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3;
        if (string4.equalsIgnoreCase("type") || string4.equalsIgnoreCase("typeref")) {
            this.pop();
        }
    }

    private boolean toBoolean(String string, String string2, boolean bl) throws SAXException {
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new SAXException("invalid value for '" + string + "' ; must be 'true' or 'false'");
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("ERROR: " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        System.out.println("FATAL: " + sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        System.out.println("WARN: " + sAXParseException);
    }

    private void push(ODCNodeType oDCNodeType) throws SAXException {
        this.nodeTypeStack.add(oDCNodeType);
    }

    private ODCNodeType pop() throws SAXException {
        int n = this.nodeTypeStack.size();
        if (n <= 0) {
            this.parseError("no matching tag");
        }
        return (ODCNodeType)this.nodeTypeStack.remove(n - 1);
    }

    private ODCNodeType top() {
        int n = this.nodeTypeStack.size();
        if (n == 0) {
            return null;
        }
        return (ODCNodeType)this.nodeTypeStack.get(n - 1);
    }

    private String getAttr(String string, Attributes attributes) {
        return attributes.getValue(string);
    }

    private String findAttr(String string, Attributes attributes) throws SAXException {
        String string2 = this.getAttr(string, attributes);
        if (string2 == null) {
            throw new SAXException("attribute '" + string + "' not found");
        }
        return string2;
    }

    private void parseError(String string) throws SAXException {
        throw new SAXException(string);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: ODCSchemaParser <ODCSchema.xml>");
            System.exit(1);
        }
        ODCSchemaImpl oDCSchemaImpl = new ODCSchemaImpl((ODCManagerImpl)ODCManagerFactory.getManager());
        ODCSchemaParser oDCSchemaParser = new ODCSchemaParser(new ODCManagerImpl(false));
        oDCSchemaParser.parse(new FileInputStream(new File(stringArray[0])), oDCSchemaImpl);
        oDCSchemaImpl.print(System.out);
    }
}

