/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCPropertiesFactory;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCPropertyType;
import com.ibm.wsspi.odc.ODCPropertyValueWrapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ODCProperties {
    private ODCNodeTypeImpl nodeType;
    private ODCPropertyDescriptorImpl[] descs;
    private Object[] values;

    public ODCProperties(ODCPropertiesFactory oDCPropertiesFactory, ODCNodeTypeImpl oDCNodeTypeImpl) {
        this.nodeType = oDCNodeTypeImpl;
        this.descs = oDCPropertiesFactory.getPropertyDescriptors();
        this.values = new Object[this.descs.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.descs[i].defaultValue;
        }
    }

    public ODCProperties(Map map) {
        this.addProperties(map);
    }

    public synchronized void registerPropertyDescriptor(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl2 = this.getPropertyDescriptor(oDCPropertyDescriptorImpl.name);
        if (oDCPropertyDescriptorImpl2 != null) {
            throw new IllegalArgumentException("property already registered: " + oDCPropertyDescriptorImpl.name);
        }
        this.addPropertyDescriptor(oDCPropertyDescriptorImpl);
    }

    public synchronized ODCPropertyDescriptorImpl getPropertyDescriptor(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl2 = this.getPropertyDescriptor(oDCPropertyDescriptorImpl.name);
        if (oDCPropertyDescriptorImpl2 != null) {
            return oDCPropertyDescriptorImpl2;
        }
        this.addPropertyDescriptor(oDCPropertyDescriptorImpl);
        return oDCPropertyDescriptorImpl;
    }

    public synchronized ODCPropertyDescriptorImpl getPropertyDescriptor(String string) {
        for (int i = 0; i < this.descs.length; ++i) {
            if (!string.equals(this.descs[i].name)) continue;
            return this.descs[i];
        }
        return null;
    }

    public Object getProperty(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        if (this.values[oDCPropertyDescriptorImpl.index] instanceof ODCPropertyValueWrapper) {
            return ((ODCPropertyValueWrapper)this.values[oDCPropertyDescriptorImpl.index]).getPropVal();
        }
        return this.values[oDCPropertyDescriptorImpl.index];
    }

    public void setProperty(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl, Object object) {
        int n = 0;
        int n2 = -1;
        if (object instanceof ODCPropertyValueWrapper) {
            n = ((ODCPropertyValueWrapper)object).getPropPriority();
        }
        if (this.values[oDCPropertyDescriptorImpl.index] instanceof ODCPropertyValueWrapper) {
            n2 = ((ODCPropertyValueWrapper)this.values[oDCPropertyDescriptorImpl.index]).getPropPriority();
        }
        if (n >= n2) {
            this.values[oDCPropertyDescriptorImpl.index] = object;
        }
    }

    public Map getProperties() {
        return this.getProperties(true);
    }

    public Map getProperties(boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < this.descs.length; ++i) {
            Object object = this.values[i];
            if (object == null) continue;
            if (bl && object instanceof ODCPropertyValueWrapper) {
                object = ((ODCPropertyValueWrapper)object).getPropVal();
            }
            hashMap.put(this.descs[i].name, object);
        }
        return hashMap;
    }

    public void addProperties(Map map) {
        Set set = map.keySet();
        this.values = new Object[set.size()];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = new ODCPropertyDescriptorImpl(string, ODCPropertyType.STRING, null, this.nodeType, true, false);
            oDCPropertyDescriptorImpl = this.getPropertyDescriptor(oDCPropertyDescriptorImpl);
            this.setProperty(oDCPropertyDescriptorImpl, v);
        }
    }

    public int size() {
        return this.values.length;
    }

    public ODCPropertyDescriptorImpl getDescriptor(int n) {
        return this.descs[n];
    }

    public Object getValue(int n) {
        return this.values[n];
    }

    public boolean hasValues() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return true;
        }
        return false;
    }

    public ODCPropertyDescriptor[] getDescriptors() {
        return this.descs;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    private void addPropertyDescriptor(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        ODCPropertyDescriptorImpl[] oDCPropertyDescriptorImplArray = new ODCPropertyDescriptorImpl[this.descs.length + 1];
        System.arraycopy(this.descs, 0, oDCPropertyDescriptorImplArray, 0, this.descs.length);
        oDCPropertyDescriptorImplArray[this.descs.length] = oDCPropertyDescriptorImpl;
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        objectArray[this.values.length] = null;
        this.descs = oDCPropertyDescriptorImplArray;
        this.values = objectArray;
    }
}

