/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;

public class ODCPluginCfgGenerator
implements ODCTransactionListener {
    private static final TraceComponent tc = TrUtil.register(ODCPluginCfgGenerator.class);
    private static final String ODR_CLUSTER = "ODRCluster";
    private static final String ODR_URI_GROUP = "ODRUriGroup";
    private ODCHelper odc;
    private ODCManager mgr;
    private ODCTree targetTree;
    private String cellName = null;
    private String nodeName = null;
    private String serverName = null;
    private File pluginCfgFile;
    private String logLevel = "Error";
    private String logFile;
    private String keyFile;
    private String stashFile;
    private String notificationCmd = null;
    private final String NL = System.getProperty("line.separator", "\n");
    private final String IN1 = "   ";
    private final String IN2 = "      ";
    private final String IN3 = "         ";
    private final String IN4 = "            ";
    private static final String serverRoot = System.getProperty("server.root", "");
    private static final String PREFIX = "com.ibm.ws.odr.plugincfg.";
    private static final String[][] CONFIG_ATTRS = new String[][]{{"ASDisableNagle", "false"}, {"AcceptAllContent", "false"}, {"AppServerPortPreference", "HostHeader"}, {"ChunkedResponse", "false"}, {"IISDisableNagle", "false"}, {"IISPluginPriority", "High"}, {"IgnoreDNSFailures", "false"}, {"RefreshInterval", "60"}, {"ResponseChunkSize", "64"}, {"VHostMatchingCompat", "false"}};
    private static final String[][] LOG_ATTRS = new String[][]{{"LogLevel", "Error"}, {"Name", serverRoot + "/logs/http_plugin.log"}};
    private static final String[][] CLUSTER_ATTRS = new String[][]{{"CloneSeparatorChange", "false"}, {"LoadBalance", "Round Robin"}, {"PostSizeLimit", "-1"}, {"RemoveSpecialHeaders", "true"}, {"RetryInterval", "60"}};
    private static String[][] SERVER_ATTRS = new String[][]{{"ConnectTimeout", "0"}, {"ExtendedHandshake", "false"}, {"MaxConnections", "-1"}, {"WaitForContinue", "false"}};
    private static String[][] GLOBAL_PROPS = new String[][]{{"ESIEnable", "true"}, {"ESIMaxCacheSize", "1024"}, {"ESIInvalidationMonitor", "false"}};
    private static String[][] HTTPS_PROPS = new String[][]{{"keyring", serverRoot + "/etc/plugin-key.kdb"}, {"stashfile", serverRoot + "/etc/plugin-key.sth"}};
    private final Props configAttrs;
    private final Props logAttrs;
    private final Props clusterAttrs;
    private final Props serverAttrs;
    private final Props globalProps;
    private final Props httpsProps;

    public ODCPluginCfgGenerator(ODCTree oDCTree) throws Exception {
        this(oDCTree, null, null, null);
    }

    public ODCPluginCfgGenerator(ODCTree oDCTree, String string, String string2, String string3) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)new Object[]{string, string2, string3});
        }
        this.cellName = string;
        this.nodeName = string2;
        this.serverName = string3;
        this.configAttrs = new Props("com.ibm.ws.odr.plugincfg.config.", CONFIG_ATTRS);
        this.logAttrs = new Props("com.ibm.ws.odr.plugincfg.log.", LOG_ATTRS);
        this.clusterAttrs = new Props("com.ibm.ws.odr.plugincfg.cluster.", CLUSTER_ATTRS);
        this.serverAttrs = new Props("com.ibm.ws.odr.plugincfg.server.", SERVER_ATTRS);
        this.globalProps = new Props("com.ibm.ws.odr.plugincfg.property.", GLOBAL_PROPS);
        this.httpsProps = new Props("com.ibm.ws.odr.plugincfg.property.https.", HTTPS_PROPS);
        this.init(oDCTree);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contructor");
        }
    }

    public String getNotificationCommand() {
        return this.notificationCmd;
    }

    public void setNotificationCommand(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("notificationCmd=" + string));
        }
        this.notificationCmd = string;
    }

    private void init(ODCTree oDCTree) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)oDCTree);
        }
        this.targetTree = oDCTree;
        this.odc = ODCHelper.getInstance();
        this.mgr = this.odc.mgr;
        this.pluginCfgFile = this.serverName == null ? new File(serverRoot + "/etc/plugin-cfg.xml") : new File(serverRoot + "/" + this.serverName + "/etc/plugin-cfg.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.targetTree.addListener(this);
            this.generatePluginCfg();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        this.targetTree.removeListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public ODCEventType[] interestEventTypes() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleEvent", (Object)oDCEvent);
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.generatePluginCfg();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(ODCEvent[] oDCEventArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleEvents", (Object)oDCEventArray);
        }
        ODCTree oDCTree = this.targetTree;
        synchronized (oDCTree) {
            this.generatePluginCfg();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleEvents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void generatePluginCfg() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generatePluginCfg", (Object)this.pluginCfgFile);
        }
        try {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>").append(this.NL);
                stringBuffer.append("<!-- This file was automatically generated -->").append(this.NL);
                stringBuffer.append("<Config");
                this.configAttrs.addAttrs(stringBuffer);
                stringBuffer.append(">").append(this.NL);
                stringBuffer.append("   ").append("<Log");
                this.logAttrs.addAttrs(stringBuffer);
                stringBuffer.append("/>").append(this.NL);
                stringBuffer.append("   ").append("<!-- Properties -->").append(this.NL);
                this.globalProps.addProps("   ", stringBuffer);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"start server clusters");
                }
                stringBuffer.append("   ").append("<!-- Server Clusters -->").append(this.NL);
                this.addProxyServerCluster(stringBuffer);
                ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
                int i = 0;
                while (true) {
                    Object object2;
                    ODCNode oDCNode;
                    int n2;
                    Object object3;
                    ODCNode[] oDCNodeArray2;
                    Object object;
                    if (i < oDCNodeArray.length) {
                        object = oDCNodeArray[i];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("cell=" + object));
                        }
                        stringBuffer.append("   ").append("<!-- Virtual Host Groups -->").append(this.NL);
                        oDCNodeArray2 = object.getNodes(this.odc.vhostGroup);
                    } else {
                        this.addRequestMetrics(stringBuffer);
                        stringBuffer.append("</Config>");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"writing plugincfg");
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(this.pluginCfgFile);
                        fileOutputStream.write(stringBuffer.toString().getBytes());
                        fileOutputStream.close();
                        if (this.notificationCmd != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("notificationCmd: " + this.notificationCmd));
                            }
                            object = Runtime.getRuntime().exec(this.notificationCmd);
                            ((Process)object).getOutputStream().close();
                            int n = ((Process)object).waitFor();
                            if (n != 0) {
                                Tr.warning((TraceComponent)tc, (String)("notification command exited with status code of " + n));
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"successful notification");
                            }
                        }
                        Object var17_23 = null;
                        if (!tc.isEntryEnabled()) return;
                        Tr.exit((TraceComponent)tc, (String)"generatePluginCfg");
                        return;
                    }
                    for (int j = 0; j < oDCNodeArray2.length; ++j) {
                        ODCNode oDCNode2 = oDCNodeArray2[j];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("virtualHostGroup=" + oDCNode2));
                        }
                        stringBuffer.append("   ").append("<VirtualHostGroup Name=\"").append(oDCNode2.getLongName()).append("\">").append(this.NL);
                        object3 = oDCNode2.getNodes(this.odc.vhost);
                        for (n2 = 0; n2 < ((ODCNode[])object3).length; ++n2) {
                            oDCNode = object3[n2];
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("virtualHost=" + oDCNode));
                            }
                            stringBuffer.append("      ").append("<VirtualHost Name=\"").append(oDCNode.getName()).append("\"/>").append(this.NL);
                        }
                        stringBuffer.append("   ").append("</VirtualHostGroup>").append(this.NL);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"start URI groups");
                    }
                    stringBuffer.append("   ").append("<!-- URI Groups -->").append(this.NL);
                    ODCNode[] oDCNodeArray3 = object.getNodes(this.odc.application);
                    int n = 0;
                    block7: while (true) {
                        if (n < oDCNodeArray3.length) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("app=" + oDCNodeArray3[n]));
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"start routes");
                            }
                            stringBuffer.append("   ").append("<!-- Routes -->").append(this.NL);
                            break;
                        }
                        object3 = oDCNodeArray3[n].getNodes(this.odc.webModule);
                        n2 = 0;
                        while (true) {
                            ODCNode[] oDCNodeArray4;
                            if (n2 < ((ODCNode[])object3).length) {
                                oDCNode = object3[n2];
                                stringBuffer.append("   ").append("<UriGroup Name=\"").append(oDCNode.getPath()).append("\">").append(this.NL);
                                object2 = ODCPluginCfgGenerator.normalizeContextRoot((String)oDCNode.getProperty(this.odc.webModuleContextRoot));
                                oDCNodeArray4 = oDCNode.getNodes(this.odc.uri);
                            } else {
                                ++n;
                                continue block7;
                            }
                            for (int j = 0; j < oDCNodeArray4.length; ++j) {
                                ODCNode oDCNode3 = oDCNodeArray4[j];
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("uri=" + oDCNode3));
                                }
                                String string = oDCNode3.getName();
                                stringBuffer.append("      ").append("<Uri Name=\"").append((String)object2);
                                if (!string.startsWith("/")) {
                                    stringBuffer.append("/");
                                }
                                stringBuffer.append(string).append("\"/>").append(this.NL);
                                if (!string.equals("*") && !string.equals("/*")) continue;
                                if (!tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tc, (String)"skipping remaining uris");
                                break;
                            }
                            stringBuffer.append("   ").append("</UriGroup>").append(this.NL);
                            ++n2;
                        }
                        break;
                    }
                    for (n = 0; n < oDCNodeArray2.length; ++n) {
                        object3 = oDCNodeArray2[n];
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("virtualHostGroup=" + object3));
                        }
                        ODCNode[] oDCNodeArray5 = object3.getNodes(this.odc.webModule);
                        for (int j = 0; j < oDCNodeArray5.length; ++j) {
                            object2 = oDCNodeArray5[j];
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("webModule=" + object2));
                            }
                            stringBuffer.append("   ").append("<Route").append(this.NL);
                            stringBuffer.append("      ").append("VirtualHostGroup=\"").append(object3.getLongName()).append("\"").append(this.NL);
                            stringBuffer.append("      ").append("UriGroup=\"").append(object2.getPath()).append("\"").append(this.NL);
                            stringBuffer.append("      ").append("ServerCluster=\"").append(ODR_CLUSTER).append("\"/>").append(this.NL);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                Object var17_24 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit((TraceComponent)tc, (String)"generatePluginCfg");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_25 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"generatePluginCfg");
            throw throwable;
        }
    }

    private void addProxyServerCluster(StringBuffer stringBuffer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addProxyServerCluster");
        }
        stringBuffer.append("   ").append("<ServerCluster Name=\"").append(ODR_CLUSTER).append("\"");
        this.clusterAttrs.addAttrs(stringBuffer);
        stringBuffer.append(">").append(this.NL);
        ODCNode[] oDCNodeArray = this.targetTree.getRoot().getNodes(this.odc.cell);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNode oDCNode = oDCNodeArray[i];
            if (this.cellName != null && !this.cellName.equals(oDCNode.getName())) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("skipping cell; " + oDCNode.getName() + "!=" + this.cellName));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNode));
            }
            ODCNode[] oDCNodeArray2 = oDCNode.getNodes(this.odc.node);
            for (int j = 0; j < oDCNodeArray2.length; ++j) {
                ODCNode oDCNode2 = oDCNodeArray2[j];
                if (this.nodeName != null && !this.nodeName.equals(oDCNode2.getName())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("skipping node; " + oDCNode2.getName() + "!=" + this.nodeName));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("node=" + oDCNode2));
                }
                ODCNode[] oDCNodeArray3 = oDCNode2.getNodes(this.odc.server);
                for (int k = 0; k < oDCNodeArray3.length; ++k) {
                    ODCNode oDCNode3 = oDCNodeArray3[k];
                    if (oDCNode3.getBooleanProperty(this.odc.serverIsODR)) {
                        if (this.serverName == null || this.serverName.equals(oDCNode3.getName())) {
                            this.addODR(oDCNode3, stringBuffer);
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("skipping server; " + oDCNode3.getName() + "!=" + this.serverName));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("skipping server; " + oDCNode3 + " is not an ODR"));
                }
            }
        }
        stringBuffer.append("   ").append("</ServerCluster>").append(this.NL);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addProxyServerCluster");
        }
    }

    private void addODR(ODCNode oDCNode, StringBuffer stringBuffer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addODR");
        }
        stringBuffer.append("      ").append("<Server Name=\"").append(oDCNode.getName()).append("\"");
        this.serverAttrs.addAttrs(stringBuffer);
        stringBuffer.append(">").append(this.NL);
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.transport);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNode oDCNode2 = oDCNodeArray[i];
            if (!oDCNode2.getBooleanProperty(this.odc.transportODR)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("skipping transport; " + oDCNode2 + " is not ODR"));
                continue;
            }
            stringBuffer.append("         ").append("<Transport");
            stringBuffer.append(" Hostname=\"").append(oDCNode2.getProperty(this.odc.transportHost)).append("\"");
            stringBuffer.append(" Port =\"").append(oDCNode2.getProperty(this.odc.transportPort)).append("\"");
            String string = (String)oDCNode2.getProperty(this.odc.transportProtocol);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("transport=" + oDCNode2 + "; protocol=" + string));
            }
            if (string.equalsIgnoreCase("https")) {
                stringBuffer.append(" Protocol =\"").append(string).append("\">").append(this.NL);
                this.httpsProps.addProps("            ", stringBuffer);
                stringBuffer.append("         ").append("</Transport>").append(this.NL);
                continue;
            }
            stringBuffer.append(" Protocol =\"").append(oDCNode2.getProperty(this.odc.transportProtocol)).append("\"/>").append(this.NL);
        }
        stringBuffer.append("      ").append("</Server>").append(this.NL);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addODR");
        }
    }

    private void addRequestMetrics(StringBuffer stringBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRequestMetrics");
        }
        this.addGenericConfig("   ", "com.ibm.ws.odr.plugincfg.RequestMetrics", stringBuffer);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRequestMetrics");
        }
    }

    private void addGenericConfig(String string, String string2, StringBuffer stringBuffer) {
        int n = 1;
        while (true) {
            String string3;
            String string4;
            if ((string4 = System.getProperty(string3 = string2 + "." + n)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("generic config not found: " + string3));
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("add generic config; " + string3 + "=" + string4));
            }
            stringBuffer.append(string).append(string4).append(this.NL);
            this.addGenericConfig(string + "   ", string3, stringBuffer);
            ++n;
        }
    }

    private static String normalizeContextRoot(String string) {
        if (string == null) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private class NameValuePair {
        public final String name;
        public final String value;

        public NameValuePair(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }

    private class Props {
        private final NameValuePair[] nvPairs;

        public Props(String string, String[][] stringArray) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"Props", (Object)string);
            }
            ArrayList<NameValuePair> arrayList = new ArrayList<NameValuePair>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = System.getProperty(string + string2, stringArray[i][1]);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string2 + "=" + string3));
                }
                arrayList.add(new NameValuePair(string2, string3));
            }
            this.nvPairs = arrayList.toArray(new NameValuePair[0]);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Props");
            }
        }

        public void addAttrs(StringBuffer stringBuffer) {
            for (int i = 0; i < this.nvPairs.length; ++i) {
                String string = this.nvPairs[i].name;
                String string2 = this.nvPairs[i].value;
                stringBuffer.append(" ").append(string).append("=\"").append(string2).append("\"");
            }
        }

        public void addProps(String string, StringBuffer stringBuffer) {
            for (int i = 0; i < this.nvPairs.length; ++i) {
                String string2 = this.nvPairs[i].name;
                String string3 = this.nvPairs[i].value;
                stringBuffer.append(string).append("<Property Name=\"").append(string2).append("\" Value=\"").append(string3).append("\"/>").append(ODCPluginCfgGenerator.this.NL);
            }
        }
    }
}

