/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCPropertyTypeRegistryImpl;
import com.ibm.ws.odc.ODCSchemaImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.bb.BBMgr;
import com.ibm.ws.odc.mbean.TargetTreeMbean;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.odc.ws390.proxy.ODCProxyManager;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyTypeRegistry;
import com.ibm.wsspi.odc.ODCSchema;
import com.ibm.wsspi.odc.ODCTree;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ODCManagerImpl
implements ODCManager {
    private static final TraceComponent tc = TrUtil.register(ODCManagerImpl.class);
    private static final String SCHEMA_XML = "/META-INF/ODCSchema.xml";
    private static ODCManagerImpl instance = null;
    private ODCSchemaImpl schema = null;
    private final Hashtable registry = new Hashtable();
    private final ODCPropertyTypeRegistryImpl propertyTypeRegistry = new ODCPropertyTypeRegistryImpl();
    private final boolean bbTransportEnabled = BBMgr.ENABLED;
    protected TargetTreeMbean targetMbean = null;

    public ODCManagerImpl() {
        this(true);
    }

    public ODCManagerImpl(boolean bl) {
        if (!bl) {
            return;
        }
        try {
            this.init();
        }
        catch (ODCException oDCException) {
            oDCException.printStackTrace(System.out);
        }
    }

    private void init() throws ODCException {
        block6: {
            InputStream inputStream;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"init", (Object)SCHEMA_XML);
            }
            if ((inputStream = DoPrivUtil.getResourceAsStream(SCHEMA_XML)) == null) {
                throw new RuntimeException("'/META-INF/ODCSchema.xml' was not found by Class.getResourceAsStream");
            }
            this.schema = new ODCSchemaImpl(this);
            this.schema.augment(inputStream);
            if (this.targetMbean == null) {
                this.targetMbean = new TargetTreeMbean();
                try {
                    this.targetMbean.initialize();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"TargetTreeMbean could not be registered due to failures.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODCTree findTree(String string) throws ODCException {
        Hashtable hashtable = this.registry;
        synchronized (hashtable) {
            ODCTreeImpl oDCTreeImpl = (ODCTreeImpl)this.registry.get(string);
            if (oDCTreeImpl == null) {
                throw new ODCException("ODC tree not found: " + string);
            }
            return oDCTreeImpl;
        }
    }

    public ODCTree getTree(String string) throws ODCException {
        return this.findTree(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODCTree getTree(String string, ODCNodeType oDCNodeType) throws ODCException {
        Hashtable hashtable = this.registry;
        synchronized (hashtable) {
            ODCTreeImpl oDCTreeImpl = (ODCTreeImpl)this.registry.get(string);
            if (oDCTreeImpl == null) {
                oDCTreeImpl = new ODCTreeImpl(this, string, (ODCNodeTypeImpl)oDCNodeType);
                try {
                    oDCTreeImpl.setFile(Util.getPerServerFile(string));
                }
                catch (IOException iOException) {
                    throw new ODCException(iOException);
                }
                this.registry.put(string, oDCTreeImpl);
                BBMgr.manageTree(oDCTreeImpl);
                ODCProxyManager.manageTree(oDCTreeImpl);
            }
            return oDCTreeImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODCTree[] getTrees() {
        Hashtable hashtable = this.registry;
        synchronized (hashtable) {
            return this.registry.values().toArray(new ODCTree[0]);
        }
    }

    public ODCPropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propertyTypeRegistry;
    }

    public ODCNodeType getNodeType(String string) {
        return this.schema.getNodeType(string);
    }

    public ODCNodeType findNodeType(String string) throws ODCException {
        return this.schema.getNodeType(string);
    }

    public ODCEdgeType getEdgeType(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) {
        return this.schema.getEdgeType(oDCNodeType, oDCNodeType2);
    }

    public ODCEdgeType findEdgeType(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        return this.schema.findEdgeType(oDCNodeType, oDCNodeType2);
    }

    public ODCSchema getSchema() {
        return this.schema;
    }
}

