/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class ZOSdump
extends Dump {
    static boolean bCompounded = true;
    static int ascbasxb = 0;
    static final int DR1 = -992349888;
    static final int DR2 = -992349632;
    static boolean verbose = false;
    static final int HEADERSIZE = 64;
    static final int CHUNKSIZE = 4096;
    static final int BLOCKSIZE = 4160;
    static boolean oldFormat = false;
    static int levelCount = 0;
    static int savedAsid;
    private static long[] numberOfMemoryRanges;
    private static long numberOfAddressSpaces;
    private Vector foundAsids = new Vector();
    private int[] asidArray;
    private static int currentAsidPosition;
    private static int asid01Position;
    private static long currentAddress;
    private static CompoundedMemoryRanges compoundedMemory;
    private static MemoryRange[][] memoryRanges;

    public ZOSdump(String string) throws FileNotFoundException {
        super(string);
        this.initCaching();
        bIsLittleEndian = false;
        this.setSystemType(3);
        try {
            long l = 0L;
            this.seek(l);
            boolean bl = false;
            boolean bl2 = true;
            AsidMemoryRanges asidMemoryRanges = null;
            int n = 0;
            if (bCompounded) {
                compoundedMemory = new CompoundedMemoryRanges();
            }
            while (!bl) {
                this.seek(l);
                byte[] byArray = new byte[28];
                this.readFully(byArray);
                int n2 = this.getInt(byArray, 0);
                if (n2 == -992349888 || n2 == -992349632) {
                    int n3 = this.getInt(byArray, 3);
                    int n4 = 0;
                    if (!oldFormat) {
                        n4 = this.getInt(byArray, 5);
                    }
                    int n5 = this.getInt(byArray, oldFormat ? 5 : 6);
                    long l2 = n4;
                    l2 <<= 32;
                    l2 += (long)n5;
                    if (verbose) {
                        System.err.println("Asid: 0x" + Integer.toHexString(n3) + "   Address: 0x" + Long.toHexString(l2) + "   Offset: 0x" + Long.toHexString(l));
                    }
                    if (!bCompounded) {
                        if (bl2) {
                            ++numberOfAddressSpaces;
                            n = n3;
                            bl2 = false;
                            asidMemoryRanges = new AsidMemoryRanges(n3);
                            this.foundAsids.add(asidMemoryRanges);
                        }
                        if (n3 != n) {
                            boolean bl3 = false;
                            for (int i = 0; !bl3 && i < this.foundAsids.size(); ++i) {
                                int n6 = ((AsidMemoryRanges)this.foundAsids.get((int)i)).asid;
                                if (n6 != n3) continue;
                                bl3 = true;
                                asidMemoryRanges = (AsidMemoryRanges)this.foundAsids.get(i);
                            }
                            if (!bl3) {
                                ++numberOfAddressSpaces;
                                asidMemoryRanges = new AsidMemoryRanges(n3);
                                this.foundAsids.add(asidMemoryRanges);
                            }
                            n = n3;
                        }
                    }
                    if (l2 > 0xFFFFFFFFL) {
                        bIs32Bit = false;
                    }
                    MemoryRange memoryRange = new MemoryRange(l2, l, 4096L, n3);
                    if (bCompounded) {
                        if (memoryRange.getAsid() != 0) {
                            compoundedMemory.addRange(memoryRange);
                        }
                    } else {
                        asidMemoryRanges.addRange(memoryRange);
                    }
                } else {
                    System.err.println("Unrecognised block type (0x" + Integer.toHexString(n2) + ") at position 0x" + Long.toHexString(this.getFilePointer()));
                }
                l += 4160L;
                try {
                    this.seek(l);
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.err.println("An unexpected IOException:" + iOException.toString());
        }
        if (bCompounded) {
            this.consolidateMemoryCompounded();
        } else {
            this.consolidateMemory();
        }
        if (verbose) {
            for (int i = 0; i < memoryRanges.length; ++i) {
                if (!bCompounded) {
                    System.err.println("\n Asid: 0x" + Integer.toHexString(this.asidArray[i]));
                }
                for (int j = 0; j < memoryRanges[i].length; ++j) {
                    long l = memoryRanges[i][j].getVaddr();
                    long l3 = memoryRanges[i][j].getSize();
                    long l4 = memoryRanges[i][j].getFileoffset();
                    System.err.println("  #" + j + "\tAddr: 0x" + Long.toHexString(l) + "   \tSize: 0x" + Long.toHexString(l3) + "   \tOffset: 0x" + Long.toHexString(l4));
                }
            }
        }
    }

    public MemoryRange[] getMemoryRanges() {
        if (bCompounded) {
            return memoryRanges[0];
        }
        if (-1 == currentAsidPosition) {
            return null;
        }
        return memoryRanges[currentAsidPosition];
    }

    public byte[] getMemoryBytes(long l, int n) {
        return this.getMemoryBytes(l, n, false);
    }

    public byte[] getMemoryBytes(long l, int n, boolean bl) {
        byte[] byArray;
        int n2;
        long l2;
        int n3;
        if (l == 0L) {
            return null;
        }
        if (!bl && this.cachedData && levelCount == 0) {
            byte[] byArray2 = this.checkCaches(l, n);
            if (byArray2 != null) {
                ++this.cacheHits;
                return byArray2;
            }
            ++this.cacheMisses;
        }
        int n4 = 0;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        if (++levelCount == 1) {
            n3 = this.findWhichMemoryRange(l);
            if (n3 != -1) {
                savedAsid = memoryRangeArray[n3].getAsid();
            }
        } else {
            n3 = this.findWhichMemoryRange(l, savedAsid);
        }
        if (-1 == n3) {
            --levelCount;
            return null;
        }
        int n5 = currentAsidPosition;
        if (bCompounded) {
            n5 = 0;
        }
        long l3 = memoryRanges[n5][n3].getVaddr();
        long l4 = l2 = l - l3;
        n4 = (int)(l2 / 4096L + 1L);
        if (n4 > 0) {
            l2 += (long)(64 * n4);
        }
        long l5 = n;
        byte[] byArray3 = null;
        int n6 = (int)(l2 + l5 - (long)((n4 - 1) * 4096)) / 4096;
        l5 += (long)(n6 * 64);
        try {
            long l6 = memoryRanges[n5][n3].getFileoffset() + l2;
            n2 = (int)l5;
            long l7 = memoryRanges[n5][n3].getSize() - l2;
            if (l5 > (l7 += 64L * (memoryRanges[n5][n3].getSize() / 4096L))) {
                n2 = (int)l7;
            }
            byArray3 = new byte[n2];
            this.seek(l6);
            this.read(byArray3, 0, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n6 > 0) {
            byte[] byArray4 = new byte[byArray3.length];
            int n7 = 0;
            n2 = 0;
            boolean bl2 = false;
            for (int i = 0; i < n6 + 1; ++i) {
                int n8;
                if (0 == i) {
                    n8 = (int)(4096L - l4 % 4096L);
                    if (n8 > byArray3.length) {
                        n8 = byArray3.length;
                    }
                    System.arraycopy(byArray3, 0, byArray4, 0, n8);
                    n2 = n8;
                    n7 = n8;
                    continue;
                }
                n8 = byArray3.length - (n7 += 64);
                if (n8 > 4096) {
                    n8 = 4096;
                }
                if (n8 > 0) {
                    System.arraycopy(byArray3, n7, byArray4, n2, n8);
                }
                n2 += n8;
                n7 += n8;
            }
            if (byArray4.length > n) {
                byte[] byArray5 = new byte[n];
                System.arraycopy(byArray4, 0, byArray5, 0, n);
                if (!bl && --levelCount == 0 && this.cachedData && byArray3 != null) {
                    this.cacheFill(byArray5, l, memoryRanges[n5][n3]);
                }
                return byArray5;
            }
            byArray3 = byArray4;
        }
        if (byArray3.length < n && null != (byArray = this.getMemoryBytes(l + (long)byArray3.length, n - byArray3.length))) {
            byte[] byArray6 = new byte[byArray3.length + byArray.length];
            System.arraycopy(byArray3, 0, byArray6, 0, byArray3.length);
            System.arraycopy(byArray, 0, byArray6, byArray3.length, byArray.length);
            byArray3 = byArray6;
        }
        if (!bl && --levelCount == 0 && this.cachedData && byArray3 != null) {
            this.cacheFill(byArray3, l, memoryRanges[n5][n3]);
        }
        return byArray3;
    }

    public long seekToMemoryAddress(long l) {
        long l2 = 0L;
        boolean bl = false;
        currentAddress = l;
        int n = this.findWhichMemoryRange(l);
        if (-1 != n) {
            int n2 = 0;
            if (n >= 1000000) {
                n2 = asid01Position;
                n -= 1000000;
            }
            long l3 = l - memoryRanges[n2][n].getVaddr();
            l2 = memoryRanges[0][n].getSize() - l3;
        }
        return l2;
    }

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        boolean bl;
        block6: {
            int n = 0;
            bl = false;
            try {
                randomAccessFile.seek(0L);
                n = randomAccessFile.readInt();
                if (n == -992349888) {
                    if (verbose) {
                        System.err.println("Its a DR1!!!");
                    }
                    oldFormat = true;
                    bl = true;
                }
                if (n == -992349632) {
                    if (verbose) {
                        System.err.println("Its a DR2!!!");
                    }
                    bl = true;
                }
            }
            catch (IOException iOException) {
                if (!verbose) break block6;
                System.err.println("Its not a ZOSDump!!!");
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: java ZOSDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            if (ZOSdump.isSupportedDump(randomAccessFile)) {
                System.err.println("\n File \"" + stringArray[0] + "\" looks to be a ZOSDump");
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n File \"" + stringArray[0] + "\" not found.");
            System.exit(1);
        }
        try {
            new ZOSdump(stringArray[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n File \"" + stringArray[0] + "\" not found.");
            System.exit(1);
        }
    }

    private int getInt(byte[] byArray, int n) {
        int n2 = byArray[n <<= 2] << 24;
        int n3 = byArray[n + 1] << 16 & 0xFFFFFF;
        int n4 = byArray[n + 2] << 8 & 0xFFFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    private long getLong(byte[] byArray) {
        long l = (long)byArray[0] << 56 & 0xFFFFFFFFFFFFFFFFL;
        long l2 = (long)byArray[1] << 48 & 0xFFFFFFFFFFFFFFL;
        long l3 = (long)byArray[2] << 40 & 0xFFFFFFFFFFFFL;
        long l4 = (long)byArray[3] << 32 & 0xFFFFFFFFFFL;
        long l5 = (long)byArray[4] << 24 & 0xFFFFFFFFL;
        long l6 = (long)byArray[5] << 16 & 0xFFFFFFL;
        long l7 = (long)byArray[6] << 8 & 0xFFFFL;
        long l8 = (long)byArray[7] & 0xFFL;
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    private void establishCurrentAsid() {
        Object var1_2;
        asid01Position = -1;
        for (int i = 0; i < this.asidArray.length; ++i) {
            if (this.asidArray[i] != 1) continue;
            asid01Position = i;
            i = this.asidArray.length;
        }
        if (asid01Position != -1 && (var1_2 = null)[0].getVaddr() == 0L) {
            try {
                this.seek(var1_2[0].getFileoffset() + 548L + 64L);
                int n = this.readInt();
                int n2 = this.findWhichMemoryRange((long)n + 108L);
                if (-1 == n2 || n2 < 1000000) {
                    System.err.println("Error looking for ascbasxb");
                } else {
                    long l = var1_2[n2 -= 1000000].getFileoffset();
                    long l2 = var1_2[n2].getVaddr();
                    long l3 = l + ((long)n - l2) + 108L + 64L;
                    this.seek(l3);
                    ascbasxb = this.readInt();
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException looking for psaaold or ascbasxb");
            }
        }
    }

    private void consolidateMemoryCompounded() {
        int n;
        memoryRanges = new MemoryRange[1][];
        int n2 = 0;
        long l = 0L;
        int n3 = ZOSdump.compoundedMemory.unconsolidatedRanges.size();
        for (n = 0; n < ZOSdump.compoundedMemory.unconsolidatedRanges.size(); ++n) {
            long l2 = ((MemoryRange)ZOSdump.compoundedMemory.unconsolidatedRanges.get(n)).getVaddr();
            if (n3 == 1 || l + 4096L != l2) {
                ++n2;
            }
            l = l2;
        }
        ZOSdump.memoryRanges[0] = new MemoryRange[n2];
        n2 = 0;
        l = 0L;
        for (n = 0; n < ZOSdump.compoundedMemory.unconsolidatedRanges.size(); ++n) {
            MemoryRange memoryRange = (MemoryRange)ZOSdump.compoundedMemory.unconsolidatedRanges.get(n);
            if (0 == n2) {
                ZOSdump.memoryRanges[0][n2] = memoryRange;
                ++n2;
                l = memoryRange.getVaddr();
                continue;
            }
            long l3 = memoryRange.getVaddr();
            if (l + 4096L == l3) {
                memoryRanges[0][n2 - 1].setSize(memoryRanges[0][n2 - 1].getSize() + 4160L - 64L);
            } else {
                ZOSdump.memoryRanges[0][n2] = memoryRange;
                ++n2;
            }
            l = l3;
        }
        this.arraySort(memoryRanges[0]);
    }

    private void consolidateMemory() {
        int n;
        this.asidArray = new int[this.foundAsids.size()];
        memoryRanges = new MemoryRange[this.foundAsids.size()][];
        for (n = 0; n < this.foundAsids.size(); ++n) {
            int n2;
            AsidMemoryRanges asidMemoryRanges = (AsidMemoryRanges)this.foundAsids.get(n);
            this.asidArray[n] = asidMemoryRanges.asid;
            int n3 = 0;
            long l = 0L;
            int n4 = asidMemoryRanges.unconsolidatedRanges.size();
            for (n2 = 0; n2 < asidMemoryRanges.unconsolidatedRanges.size(); ++n2) {
                long l2 = ((MemoryRange)asidMemoryRanges.unconsolidatedRanges.get(n2)).getVaddr();
                if (n4 == 1 || l + 4096L != l2) {
                    ++n3;
                }
                l = l2;
            }
            ZOSdump.memoryRanges[n] = new MemoryRange[n3];
            n3 = 0;
            l = 0L;
            for (n2 = 0; n2 < asidMemoryRanges.unconsolidatedRanges.size(); ++n2) {
                MemoryRange memoryRange = (MemoryRange)asidMemoryRanges.unconsolidatedRanges.get(n2);
                if (0 == n3) {
                    ZOSdump.memoryRanges[n][n3] = memoryRange;
                    ++n3;
                    l = memoryRange.getVaddr();
                    continue;
                }
                long l3 = memoryRange.getVaddr();
                if (l + 4096L == l3) {
                    memoryRanges[n][n3 - 1].setSize(memoryRanges[n][n3 - 1].getSize() + 4160L - 64L);
                } else {
                    ZOSdump.memoryRanges[n][n3] = memoryRange;
                    ++n3;
                }
                l = l3;
            }
        }
        for (n = 0; n < memoryRanges.length; ++n) {
            if (memoryRanges[n].length <= 1) continue;
            this.arraySort(memoryRanges[n]);
        }
    }

    private void arraySort(MemoryRange[] memoryRangeArray) {
        for (int i = 1; i < memoryRangeArray.length; ++i) {
            long l = memoryRangeArray[i].getVaddr();
            if (l >= memoryRangeArray[i - 1].getVaddr()) continue;
            int n = 0;
            for (int j = i - 2; j >= 0; --j) {
                if (l < memoryRangeArray[j].getVaddr()) continue;
                n = j + 1;
                j = 0;
            }
            MemoryRange memoryRange = memoryRangeArray[i];
            for (int j = i; j > n; --j) {
                memoryRangeArray[j] = memoryRangeArray[j - 1];
            }
            memoryRangeArray[n] = memoryRange;
        }
    }

    public Dump.Loaded[] getLoadedInfo() {
        return null;
    }

    public long readLongEx() throws IOException {
        long l = 0L;
        byte[] byArray = this.getMemoryBytes(currentAddress, 8);
        if (byArray.length != 8) {
            throw new IOException("ZOSDump unable to read long (8 bytes)from 0x" + Long.toHexString(currentAddress));
        }
        l = this.getLong(byArray);
        return l;
    }

    public int readIntEx() throws IOException {
        int n = 0;
        byte[] byArray = this.getMemoryBytes(currentAddress, 4);
        if (byArray.length != 4) {
            throw new IOException("ZOSDump unable to read int (4 bytes) from 0x" + Long.toHexString(currentAddress));
        }
        n = this.getInt(byArray, 0);
        return n;
    }

    public void readFullyEx(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = this.getMemoryBytes(currentAddress, byArray.length);
        if (byArray2 != null) {
            if (byArray2.length != n) {
                throw new IOException("ZOSDump unable to read " + n + "bytes for 0x" + Long.toHexString(currentAddress));
            }
        } else {
            throw new IOException("ZOSDump unable to read bytes for 0x" + Long.toHexString(currentAddress));
        }
        System.arraycopy(byArray2, 0, byArray, 0, n);
    }

    public int readEx(byte[] byArray) throws IOException {
        int n = 0;
        byte[] byArray2 = this.getMemoryBytes(currentAddress, byArray.length);
        if (byArray2 != null) {
            n = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n);
        }
        return n;
    }

    public int readEx(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        byte[] byArray2 = this.getMemoryBytes(currentAddress, n2);
        if (byArray2 != null) {
            n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n3);
        }
        return n3;
    }

    static {
        numberOfAddressSpaces = 0L;
        currentAsidPosition = -1;
        asid01Position = -1;
        Dump.registerDumpSupport(ZOSdump.class);
    }

    class AddressSpace {
        AddressSpace() {
        }
    }

    class CompoundedMemoryRanges {
        Vector unconsolidatedRanges;

        CompoundedMemoryRanges() {
        }

        void addRange(MemoryRange memoryRange) {
            if (null == this.unconsolidatedRanges) {
                this.unconsolidatedRanges = new Vector();
            }
            this.unconsolidatedRanges.add(memoryRange);
        }
    }

    class AsidMemoryRanges {
        int asid;
        int taskCount;
        int[] tasks;
        Vector unconsolidatedRanges = new Vector();

        AsidMemoryRanges(int n) {
            this.asid = n;
        }

        void addRange(MemoryRange memoryRange) {
            this.unconsolidatedRanges.add(memoryRange);
        }

        int[] getTasks() {
            return this.tasks;
        }

        void addTasks(int n, int[] nArray) {
        }
    }
}

