/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;

public class J9Monitor {
    private String name;
    private long id;
    private long owner;
    private String idAsString;
    private String ownerAsString;
    private long objectAddr;
    private String objectAddrAsString;

    public J9Monitor(String string, String string2, String string3, String string4) {
        this.idAsString = string;
        this.name = string2;
        this.id = DumpUtils.parseLongHex(string);
        this.ownerAsString = string3;
        this.objectAddrAsString = string4;
        if (null != string3) {
            this.owner = DumpUtils.parseLongHex(string3);
        }
        if (null == this.name) {
            this.name = "Un-named Monitor@" + this.idAsString;
        }
        if (null != string4) {
            this.objectAddr = DumpUtils.parseLongHex(string4);
        }
        J9JVMConsole.addMonitor(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + this.name);
        stringBuffer.append("\n\tid= " + this.idAsString);
        if (this.owner != 0L) {
            stringBuffer.append("\n\towner= " + this.ownerAsString);
        }
        if (this.objectAddr != 0L) {
            stringBuffer.append("\n\tobject= " + this.objectAddrAsString);
        }
        return stringBuffer.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public String getName() {
        return this.name;
    }

    public long getOwner() {
        return this.owner;
    }

    public long getObjectAddr() {
        return this.objectAddr;
    }

    public String getObjectAddrAsString() {
        return this.objectAddrAsString;
    }
}

