/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;

public class ClassField {
    static final int ACC_PUBLIC = 1;
    static final int ACC_PRIVATE = 2;
    static final int ACC_PROTECTED = 4;
    static final int ACC_STATIC = 8;
    static final int ACC_FINAL = 16;
    static final int ACC_SYNCHRONIZED = 32;
    static final int ACC_VOLATILE = 64;
    static final int ACC_TRANSIENT = 128;
    static final int ACC_NATIVE = 256;
    static final int ACC_INTERFACE = 512;
    static final int ACC_ABSTRACT = 1024;
    static final int ACC_SUPER = 32;
    static final int ACC_STRICT = 2048;
    static final int T_CLASS = 2;
    static final int T_BOOLEAN = 4;
    static final int T_CHAR = 5;
    static final int T_FLOAT = 6;
    static final int T_DOUBLE = 7;
    static final int T_BYTE = 8;
    static final int T_SHORT = 9;
    static final int T_INT = 10;
    static final int T_LONG = 11;
    private String definingClassId;
    private String fieldName;
    private String signature;
    private int offset;
    private static Dump theDump;
    private static String primativeClassShortForms;
    private int modifiers;

    public ClassField(String string, String string2, String string3, String string4, String string5) {
        this.definingClassId = string;
        this.fieldName = string2;
        this.signature = string3;
        this.offset = Integer.parseInt(string4);
        string5 = DumpUtils.stripOff0x(string5);
        if (string5.length() == 8) {
            string5 = string5.substring(1);
        }
        this.modifiers = Integer.parseInt(string5, 16);
    }

    public String toString() {
        String string = ClassField.convertModifier(this.modifiers);
        StringBuffer stringBuffer = new StringBuffer(this.fieldName + "  modifiers:" + string + "  sig: " + this.signature + "  offset: " + this.offset);
        if (null != this.definingClassId) {
            stringBuffer.append("  (defined in class " + this.definingClassId + ")");
        }
        return stringBuffer.toString();
    }

    public String formatField(byte[] byArray, boolean bl, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(" + this.offset + ") " + "fieldName: " + this.fieldName + "  sig: " + this.signature);
        char c = this.signature.charAt(0);
        byte[] byArray2 = null;
        boolean bl2 = false;
        switch (c) {
            case 'I': 
            case 'Z': {
                byArray2 = this.normalizeTarget(4, this.offset, byArray, bl);
                int n2 = this.getIntFromBytes(byArray2);
                if (c == 'Z') {
                    if (0 == n2) {
                        stringBuffer.append("  value= FALSE (0x0)");
                        break;
                    }
                    stringBuffer.append("  value= TRUE (0x" + Integer.toHexString(n2) + ")");
                    break;
                }
                stringBuffer.append("  value=" + n2 + " (0x" + Integer.toHexString(n2) + ")");
                break;
            }
            case 'J': {
                byArray2 = this.normalizeTarget(8, this.offset, byArray, bl);
                long l = this.getLongFromBytes(byArray2);
                stringBuffer.append("  value=" + l + " (0x" + Long.toHexString(l) + ")");
                break;
            }
            case 'B': {
                byte by;
                byte by2 = by = byArray[this.offset];
                stringBuffer.append("  value= " + Byte.toString(by));
                break;
            }
            case 'F': {
                byArray2 = this.normalizeTarget(4, this.offset, byArray, bl);
                int n3 = this.getIntFromBytes(byArray2);
                stringBuffer.append("  value= 0x" + Integer.toHexString(n3));
                break;
            }
            case 'D': {
                byArray2 = this.normalizeTarget(8, this.offset, byArray, bl);
                long l = this.getLongFromBytes(byArray2);
                stringBuffer.append("  value= 0x" + Long.toHexString(l));
                break;
            }
            case 'C': {
                byArray2 = this.normalizeTarget(2, this.offset, byArray, bl);
                String string = new String(byArray2);
                int n4 = byArray2[0];
                n4 = n4 << 24 >>> 24;
                int n5 = byArray2[1];
                n5 = n5 << 24 >>> 24;
                stringBuffer.append("  value= \"" + DumpUtils.byteToAscii.substring(n5, n5 + 1) + "\" (ascii)   \"" + DumpUtils.byteToEbcdic.substring(n5, n5 + 1) + "\" (ebcdic) ");
                stringBuffer.append("   (0x" + DumpUtils.byteToHex.substring(2 * n4, 2 * n4 + 2) + DumpUtils.byteToHex.substring(2 * n5, 2 * n5 + 2) + ")");
                break;
            }
            case '[': {
                boolean bl3 = false;
                if (2 == this.signature.length()) {
                    char c2 = this.signature.charAt(1);
                    int n6 = primativeClassShortForms.indexOf(c2);
                    if (-1 != n6) {
                        bl3 = true;
                    }
                    stringBuffer.append(" Its a primitive array @0x");
                } else {
                    stringBuffer.append(" Its a non-primitive array @0x");
                }
                byArray2 = this.normalizeTarget(n, this.offset, byArray, bl);
                long l = 0L;
                l = 4 == n ? (long)this.getIntFromBytes(byArray2) : this.getLongFromBytes(byArray2);
                stringBuffer.append(Long.toHexString(l));
                break;
            }
            case 'L': {
                byArray2 = this.normalizeTarget(n, this.offset, byArray, bl);
                long l = 0L;
                l = 4 == n ? (long)this.getIntFromBytes(byArray2) : this.getLongFromBytes(byArray2);
                if (this.signature.equals("Ljava/lang/String;")) {
                    String string = null;
                    if (l == 0L) break;
                    J9Object j9Object = J9Heap.checkForObject(l);
                    J9Object j9Object2 = null;
                    if (j9Object != null) {
                        j9Object2 = J9JVMUtils.getCharArrayFromString(j9Object);
                    } else {
                        string = " !!! 0x" + Long.toHexString(l) + " does not validate as a known string object !!!";
                    }
                    if (null != j9Object2 && j9Object2.isPrimitiveArray() && j9Object2.getPrimitiveArrayType() == 1) {
                        string = J9JVMUtils.convertCharArrayObject(j9Object2);
                    }
                    stringBuffer.append("  value= 0x" + Long.toHexString(l) + " ==> \"" + string + "\"");
                    break;
                }
                String string = "";
                J9Object j9Object = null;
                if (0L != l) {
                    j9Object = J9Heap.checkForObject(l);
                    if (null == j9Object) {
                        string = string + " !!! Reference 0x" + Long.toHexString(l) + " is not a known object !!!";
                    } else if (!this.signature.equals("L" + j9Object.getClassForObject().getName() + ";")) {
                        string = string + " Reference is an instance of " + j9Object.getClassForObject().getName();
                    }
                }
                stringBuffer.append("  value= 0x" + Long.toHexString(l) + string);
                break;
            }
            default: {
                stringBuffer.append("\n formatField method unable to cope with " + c);
            }
        }
        return stringBuffer.toString();
    }

    public String getSignature() {
        return this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    private byte[] normalizeTarget(int n, int n2, byte[] byArray, boolean bl) {
        byte[] byArray2 = new byte[n];
        int n3 = n2;
        int n4 = 1;
        int n5 = 0;
        if (bl) {
            n3 = n2;
            n4 = -1;
            n5 = n - 1;
        }
        int n6 = n5;
        for (int i = 0; i < n; ++i) {
            byArray2[n6] = byArray[n3 + i];
            n6 += n4;
        }
        return byArray2;
    }

    private long getLongFromBytes(byte[] byArray) {
        long l = 0L;
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            l += (long)n;
        }
        return l;
    }

    private int getIntFromBytes(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            n += n2;
        }
        return n;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected static String convertModifier(int n) {
        String string = "";
        if (1 == (n & 1)) {
            string = string + " public";
        }
        if (2 == (n & 2)) {
            string = string + " private";
        }
        if (4 == (n & 4)) {
            string = string + " protected";
        }
        if (8 == (n & 8)) {
            string = string + " static";
        }
        if (16 == (n & 0x10)) {
            string = string + " final";
        }
        if (128 == (n & 0x80)) {
            string = string + " transient";
        }
        if (64 == (n & 0x40)) {
            string = string + " volatile";
        }
        if (256 == (n & 0x100)) {
            string = string + " native";
        }
        if (512 == (n & 0x200)) {
            string = string + " interface";
        }
        if (1024 == (n & 0x400)) {
            string = string + " abstract";
        }
        if (32 == (n & 0x20)) {
            string = string + " super";
        }
        if (2048 == (n & 0x800)) {
            string = string + " strict";
        }
        return string;
    }

    static {
        primativeClassShortForms = "IJZBSCDF";
    }
}

