/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.saxhandler;

import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericSaxHandler
extends DefaultHandler {
    private static String errorString;
    private static boolean bInErrorElement;
    private static StringBuffer gpfSb;
    private static boolean bInGpfElement;
    private static Object userHandler;
    private static Locator documentLocator;
    private static Class userHandlerClass;
    private static HashMap methodTable;
    private static int level;
    private static boolean bFatalParseError;

    public GenericSaxHandler(File file, Object object, Object object2) throws SAXException, FileNotFoundException {
        if (file == null) {
            throw new SAXException("null input file");
        }
        GenericSaxHandler genericSaxHandler = this;
        userHandler = object;
        userHandlerClass = userHandler.getClass();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            CommandPlugin commandPlugin;
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (null != object2 && object2 instanceof CommandPlugin) {
                commandPlugin = (CommandPlugin)object2;
                commandPlugin.notifyObservers("Parsing of xml started for file " + file.getName() + "... be patient");
            }
            sAXParser.parse(file, (DefaultHandler)genericSaxHandler);
            if (null != object2 && object2 instanceof CommandPlugin) {
                commandPlugin = (CommandPlugin)object2;
                commandPlugin.notifyObservers("Parsing ended");
            }
        }
        catch (SAXParseException sAXParseException) {
            Console.reportError("SaxParseException caught", null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            StringBuffer stringBuffer = new StringBuffer("UTFDataFormatException caught\n");
            stringBuffer.append("\tmessage:" + uTFDataFormatException.getMessage() + "\n");
            stringBuffer.append("\tDamaged xml.");
            Console.reportError(stringBuffer.toString(), null);
            bFatalParseError = true;
        }
        catch (Exception exception) {
            Console.reportError("Unexpected error caught while attempting to parse xml", exception);
        }
        if (bFatalParseError) {
            throw new SAXException("Fatal Error");
        }
    }

    public void setDocumentLocator(Locator locator) {
        documentLocator = locator;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = this.getName(string2, string3);
        this.passToUserMethod(string4, attributes, true);
        ++level;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this.getName(string2, string3);
        this.passToUserMethod(string4, null, false);
        --level;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (bInErrorElement) {
            errorString = new String(cArray, n, n2);
        }
        if (bInGpfElement) {
            if (gpfSb == null) {
                gpfSb = new StringBuffer();
                gpfSb.append(new String(cArray, n, n2));
            } else {
                gpfSb.append(new String(cArray, n, n2));
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        Console.reportError("SAXParseException error: ", sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        Console.reportError("SAXParseException warning: ", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        Console.reportError("Fatal error encountered processing incoming xml.", null);
        bFatalParseError = true;
    }

    private String getName(String string, String string2) {
        if (string == null || "".equals(string)) {
            return string2;
        }
        return string;
    }

    private void passToUserMethod(String string, Attributes attributes, boolean bl) {
        Method method = null;
        String string2 = string + "El";
        method = (Method)methodTable.get(string2);
        if (null == method && methodTable.containsKey(string2)) {
            return;
        }
        if (null == method) {
            try {
                Class[] classArray = new Class[]{Attributes.class, Boolean.class};
                method = userHandlerClass.getDeclaredMethod(string2, classArray);
            }
            catch (Exception exception) {
                Console.reportError("Unable to find parsing dupport for " + string2, exception);
            }
            methodTable.put(string2, method);
        }
        if (null != method) {
            try {
                method.invoke(userHandler, attributes, new Boolean(bl));
            }
            catch (Exception exception) {
                Console.reportError("Exception trying to invoke sax parsing for " + string2, exception);
            }
        }
    }

    public static int getLevel() {
        return level;
    }

    public static void setLevel(int n) {
        level = n;
    }

    public static void setBInErrorElement(boolean bl) {
        bInErrorElement = bl;
    }

    public static String getErrorString() {
        return errorString;
    }

    public static void setBInGpfElement(boolean bl) {
        bInGpfElement = bl;
    }

    public static StringBuffer getGpfSb() {
        return gpfSb;
    }

    static {
        methodTable = new HashMap();
        level = 0;
        bFatalParseError = false;
    }
}

