/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class Main {
    private Dump dump;
    private static final String j9libName = "j9jextract";
    private String dumpName;
    private static String outputName;

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 || stringArray.length == 2) {
            if (stringArray.length == 2) {
                outputName = stringArray[1];
            }
            if (!new Main(stringArray[0]).init()) {
                System.out.println("jextract failed.");
            } else {
                System.out.println("jextract complete.");
            }
        } else {
            if (stringArray.length > 2) {
                System.out.println("Only 1 or 2  parameters expected.");
            }
            Main.printHelp();
        }
    }

    public Main() {
    }

    public Main(String string) {
        this.dumpName = string;
    }

    private boolean init() {
        File file;
        String string = null;
        try {
            System.loadLibrary(j9libName);
        }
        catch (SecurityException securityException) {
            string = "Security permissions don't allow required native library to be loaded.";
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string = "Native library j9jextract cannot be found. Please check your path.";
        }
        catch (Exception exception) {
            string = "Unexpected exception occurred loading: j9jextract";
            exception.printStackTrace();
        }
        if (string != null) {
            System.out.println("Error. " + string);
            return false;
        }
        System.out.println("Loading dump file...");
        try {
            this.dump = Dump.getDumptype(this.dumpName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = new File(this.dumpName);
            if (!file2.exists()) {
                string = "Could not find dump file: " + this.dumpName;
            } else if (!file2.canRead()) {
                string = "Unable to read dump file (check permission): " + this.dumpName;
            } else {
                string = "Unexpected FileNotFoundException occurred opening: " + this.dumpName;
                fileNotFoundException.printStackTrace();
            }
        }
        catch (Exception exception) {
            string = "Unexpected Exception occurred opening: " + this.dumpName;
            exception.printStackTrace();
        }
        if (string != null) {
            System.out.println("Error. " + string);
            return false;
        }
        if (this.dump == null) {
            System.out.println("Error. Dump type not recognised for dump: " + this.dumpName);
            return false;
        }
        if (null == outputName) {
            outputName = this.dumpName.concat(".xml");
        }
        if (!(file = new File(outputName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.canWrite()) {
                string = "Unable to write to \"" + outputName + "\" (check permission)";
                System.out.println("Error. " + string);
                return false;
            }
        }
        System.out.println("Dump file successfully found. Running jextract...");
        try {
            this.doJextract(this.dump, outputName);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Failure detected during jextract, see previous message(s).");
            return false;
        }
        catch (Error error) {
            System.out.println(error.getMessage());
            System.out.println("Failure detected during jextract, see previous message(s).");
            return false;
        }
        return true;
    }

    public native void doJextract(Dump var1, String var2) throws Exception;

    private static void printHelp() {
        System.out.println("Usage: jextract [dump_name] [output filename]");
        System.out.println("\t output filename defaults to dump_name.xml");
    }
}

