/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class DvNamesIndexFile {
    private String name;
    private TreeMap objectIndex;
    private RandomAccessFile dataFile;
    public boolean isComplete = false;
    private long NamesOffset;
    private long ClassNameData;
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_COUNT = 1;
    public static final int SORT_BY_TOTAL_SIZE = 2;
    private static final int VERSION = 1;
    private static String dataFileIdentifier = "JFOD";
    private static String classNameDataIdentifier = "JFNI";

    public DvNamesIndexFile(String string, long l) throws IOException {
        Object object;
        String string2 = Console.getProperty("WORKDIR");
        if (null != string2 && !string.startsWith(string2)) {
            object = new File(string);
            string = string2 + File.separator + ((File)object).getName();
        }
        try {
            this.dataFile = new RandomAccessFile(string + ".jfod", "r");
            this.name = string + ".jfod";
            if (this.checkHeader(this.dataFile, l) && this.ClassNameData != 0L) {
                this.dataFile.seek(this.ClassNameData);
                object = new byte[4];
                this.dataFile.readFully((byte[])object);
                if (new String((byte[])object).equals(classNameDataIdentifier)) {
                    this.objectIndex = new TreeMap();
                    int n = this.dataFile.readInt();
                    for (int i = 0; i < n; ++i) {
                        JClass jClass = new JClass(this.dataFile);
                        this.objectIndex.put(jClass.name, jClass);
                    }
                    this.isComplete = true;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dataFile = new RandomAccessFile(string + ".jfod", "rw");
        this.name = string + ".jfod";
        this.writeHeader(this.dataFile, l);
        this.NamesOffset = this.dataFile.getFilePointer();
        this.dataFile.writeLong(0L);
        this.dataFile.writeLong(0L);
        this.objectIndex = new TreeMap();
    }

    private boolean checkHeader(DataInput dataInput, long l) throws IOException {
        byte[] byArray = new byte[4];
        dataInput.readFully(byArray);
        int n = dataInput.readInt();
        long l2 = dataInput.readLong();
        this.NamesOffset = this.dataFile.getFilePointer();
        this.ClassNameData = dataInput.readLong();
        return new String(byArray).equals(dataFileIdentifier) && n == 1 && l == l2 && this.ClassNameData != 0L;
    }

    public String getName() {
        return this.name;
    }

    private void writeHeader(DataOutput dataOutput, long l) throws IOException {
        dataOutput.write(dataFileIdentifier.getBytes());
        dataOutput.writeInt(1);
        dataOutput.writeLong(l);
    }

    public void commit() {
        if (this.isComplete) {
            return;
        }
        try {
            this.dataFile.seek(this.NamesOffset);
            this.dataFile.writeLong(this.dataFile.length());
            this.dataFile.seek(this.dataFile.length());
            this.dataFile.write(classNameDataIdentifier.getBytes());
            this.dataFile.writeInt(this.objectIndex.size());
            Iterator iterator = this.objectIndex.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                JClass jClass = (JClass)this.objectIndex.get(k);
                jClass.write(this.dataFile);
            }
        }
        catch (Exception exception) {
            Console.reportError("JVMDF0001: Unable to write the NamesIndex file ", exception);
        }
        this.isComplete = true;
    }

    public int getInstanceCountForClass(String string) {
        int n = 0;
        JClass jClass = this.getClass(string);
        if (jClass != null) {
            n = jClass.count;
        }
        return n;
    }

    public long getInstanceSizeForClass(String string) {
        long l = 0L;
        JClass jClass = this.getClass(string);
        if (jClass != null) {
            l = jClass.totalSize / (long)jClass.count;
        }
        return l;
    }

    private JClass getClass(String string) {
        JClass jClass = (JClass)this.objectIndex.get(string.intern());
        return jClass;
    }

    public long[] getInstancesForClass(String string) {
        JClass jClass = this.getClass(string);
        if (jClass == null) {
            return null;
        }
        int n = jClass.count;
        int n2 = 0;
        long[] lArray = new long[n];
        Iterator iterator = jClass.getIterator();
        while (iterator.hasNext()) {
            JInstance jInstance = (JInstance)iterator.next();
            lArray[n2] = jInstance.address;
            ++n2;
        }
        return lArray;
    }

    public long getInstancesForClass(String string, int n, long l, long[] lArray) {
        int n2;
        Arrays.fill(lArray, 0L);
        JClass jClass = this.getClass(string);
        if (jClass == null) {
            return 0L;
        }
        int n3 = lArray.length;
        Iterator iterator = jClass.getIterator();
        for (n2 = jClass.count - n - n3; n2 > 0; --n2) {
            iterator.next();
        }
        int n4 = lArray.length - 1 + n2;
        while (iterator.hasNext()) {
            lArray[n4--] = (Long)iterator.next();
        }
        return lArray[lArray.length - 1 + n2];
    }

    public Vector getAllClassNames() {
        return new Vector(this.objectIndex.keySet());
    }

    public Vector summary(int n, boolean bl) {
        int n2;
        int n3;
        Vector<String> vector = new Vector<String>(this.objectIndex.size());
        if (bl) {
            n3 = 0;
            n2 = 1;
        } else {
            n3 = this.objectIndex.size() - 1;
            n2 = -1;
        }
        long l = 0L;
        long l2 = 0L;
        if (n == 0) {
            Iterator iterator = this.objectIndex.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                JClass jClass = (JClass)this.objectIndex.get(k);
                vector.add(n3, new String(jClass.name + " : " + jClass.count + "   " + jClass.totalSize + " bytes"));
                n3 += n2;
                l2 += (long)jClass.count;
                l += jClass.totalSize;
            }
        } else {
            Object object;
            TreeSet<Object> treeSet = null;
            switch (n) {
                case 1: {
                    treeSet = new TreeSet<Object>(new CompareByCount());
                    break;
                }
                case 2: {
                    treeSet = new TreeSet(new CompareByTotalSize());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("JVMDF005: Invalid sort criterion " + n);
                }
            }
            Iterator iterator = this.objectIndex.values().iterator();
            while (iterator.hasNext()) {
                object = (JClass)iterator.next();
                treeSet.add(object);
                l2 += (long)((JClass)object).count;
                l += ((JClass)object).totalSize;
            }
            object = treeSet.iterator();
            while (object.hasNext()) {
                JClass jClass = (JClass)object.next();
                vector.add(n3, new String(jClass.name + " : " + jClass.count + "   " + jClass.totalSize + " bytes"));
                n3 += n2;
            }
        }
        vector.add("");
        vector.add(new String("Total number of objects = " + l2 + " Total byte count = " + l));
        return vector;
    }

    public boolean write(J9Object j9Object) {
        int n = j9Object.getInstanceSize();
        int n2 = j9Object.getHeapId();
        String string = j9Object.getClassForObject().getName();
        this.write(string, j9Object.getObjectAddress(), (short)n2, n);
        return false;
    }

    public boolean write(String string, long l, short s, long l2) {
        JClass jClass = this.getClass(string);
        if (jClass == null) {
            jClass = new JClass(string);
            this.objectIndex.put(jClass.name, jClass);
        }
        ++jClass.count;
        jClass.totalSize += l2;
        JInstance jInstance = new JInstance(l, jClass.jinstance);
        try {
            jClass.jinstance = this.dataFile.getFilePointer();
            jInstance.write();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private class InstanceIterator
    implements Iterator {
        JInstance instance;

        InstanceIterator(long l) {
            try {
                this.instance = new JInstance(l);
            }
            catch (IOException iOException) {
                Console.reportError("JVMDF0001: Unable to write the NamesIndex file ", iOException);
                this.instance = null;
            }
        }

        public boolean hasNext() {
            return this.instance != null;
        }

        public Object next() {
            JInstance jInstance = this.instance;
            if (this.instance.nextRecord == 0L) {
                this.instance = null;
            } else {
                try {
                    this.instance = new JInstance(this.instance.nextRecord);
                }
                catch (IOException iOException) {
                    Console.reportError("JVMDF003: Unable to read index data file. ", iOException);
                    this.instance = null;
                }
            }
            return jInstance;
        }

        public void remove() {
            throw new RuntimeException("JVMDF004: No DvNamesIndex$InstanceIterator.remove method.");
        }
    }

    private class JClass {
        String name;
        long jinstance;
        long totalSize;
        int count = 0;

        JClass(String string) {
            this.name = string.intern();
        }

        Iterator getIterator() {
            return new InstanceIterator(this.jinstance);
        }

        void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.name.length());
            dataOutput.write(this.name.getBytes());
            dataOutput.writeLong(this.jinstance);
            dataOutput.writeLong(this.totalSize);
            dataOutput.writeInt(this.count);
        }

        JClass(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray);
            this.name = new String(byArray).intern();
            this.jinstance = dataInput.readLong();
            this.totalSize = dataInput.readLong();
            this.count = dataInput.readInt();
        }
    }

    private class CompareByTotalSize
    implements Comparator {
        private CompareByTotalSize() {
        }

        public int compare(Object object, Object object2) {
            JClass jClass = (JClass)object;
            JClass jClass2 = (JClass)object2;
            return (int)(jClass.totalSize - jClass2.totalSize);
        }

        public boolean equals(Object object) {
            JClass jClass = (JClass)object;
            return this.compare(this, object) == 0;
        }
    }

    private class CompareByCount
    implements Comparator {
        private CompareByCount() {
        }

        public int compare(Object object, Object object2) {
            JClass jClass = (JClass)object;
            JClass jClass2 = (JClass)object2;
            int n = jClass.count - jClass2.count;
            if (n != 0) {
                return n;
            }
            return jClass.name.compareTo(jClass2.name);
        }

        public boolean equals(Object object) {
            JClass jClass = (JClass)object;
            return this.compare(this, object) == 0;
        }
    }

    private class JInstance {
        long address;
        long nextRecord;

        JInstance(long l, long l2) {
            this.address = l;
            this.nextRecord = l2;
        }

        JInstance(long l) throws IOException {
            DvNamesIndexFile.this.dataFile.seek(l);
            this.address = DvNamesIndexFile.this.dataFile.readLong();
            this.nextRecord = DvNamesIndexFile.this.dataFile.readLong();
        }

        private void write() throws IOException {
            DvNamesIndexFile.this.dataFile.writeLong(this.address);
            DvNamesIndexFile.this.dataFile.writeLong(this.nextRecord);
        }
    }
}

