/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public abstract class HeapDumpUtil {
    private static final int HEAPROOTS_HEXSTRING_LENGTH = 8;

    public static String getDefaultFileName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(J9JVMConsole.getTheDump().getDumpName());
        stringBuffer.append(HeapDumpUtil.isPortableDump() ? ".phd" : ".hd");
        stringBuffer.append(".gz");
        return stringBuffer.toString();
    }

    public static boolean isPortableDump() {
        String string = Console.getProperty("HEAPDUMPFORMAT");
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("Classic");
    }

    public static int doClassicHeapDump(PrintWriter printWriter) throws IOException, IllegalArgumentException {
        printWriter.println("// jdmpview heapdump generated at " + new Date() + " from '" + J9JVMConsole.getTheDump().getDumpName() + "'");
        printWriter.println("// IBM Java VM 1.4.2 (J9 version " + J9JVMConsole.getTheDump().getVersion() + " build " + J9JVMConsole.getTheDump().getStamp() + ")");
        return HeapDumpUtil.dumpObjects(printWriter);
    }

    public static int doPortableHeapDump(OutputStream outputStream) throws IOException, IllegalArgumentException {
        Dump dump = J9JVMConsole.getTheDump();
        if (dump == null) {
            throw new IllegalArgumentException("The dump is not set");
        }
        boolean bl = dump.is32bit();
        boolean bl2 = dump.isLittleEndian();
        PortableHeapDump portableHeapDump = new PortableHeapDump(dump, bl, bl2);
        return portableHeapDump.writeHeapDump(new DataOutputStream(outputStream));
    }

    private static String toHexString(long l) {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l).toUpperCase());
        if (stringBuffer.length() < 8) {
            for (int i = 8 - stringBuffer.length(); i > 0; --i) {
                stringBuffer.insert(0, "0");
            }
        }
        stringBuffer.insert(0, "0x");
        return stringBuffer.toString();
    }

    private static int dumpObjects(PrintWriter printWriter) throws IOException, IllegalArgumentException {
        J9ObjectIterator j9ObjectIterator = J9ObjectIterator.getObjectIterator(null);
        char[] cArray = new char[]{'/', '/', '-', '-', '\\', '\\', '-', '-'};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (j9ObjectIterator.hasNext()) {
            int n9;
            Object object;
            J9Object j9Object;
            if (++n % 50 == 0) {
                ++n8;
            }
            if ((j9Object = (J9Object)j9ObjectIterator.next()).isInstanceOfClass()) {
                ++n3;
            } else if (j9Object.isArray()) {
                if (j9Object.isPrimitiveArray()) {
                    ++n5;
                } else {
                    ++n4;
                }
            } else {
                ++n2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.append(HeapDumpUtil.toHexString(j9Object.getObjectAddress()));
            stringBuffer.append(" [");
            stringBuffer.append(j9Object.getInstanceSize());
            stringBuffer.append("] ");
            if (j9Object.isArray()) {
                object = new StringBuffer();
                n9 = j9Object.getClassForObject().getArity();
                if (j9Object.isPrimitiveArray()) {
                    ((StringBuffer)object).append("primitive array");
                } else {
                    if (n9 >= 1) {
                        ((StringBuffer)object).append("array of ");
                        --n9;
                    }
                    ((StringBuffer)object).append(j9Object.getArrayTypeAsString());
                    for (int i = 1; i <= n9; ++i) {
                        ((StringBuffer)object).append("[");
                    }
                }
                stringBuffer.append((StringBuffer)object);
            } else if (j9Object.isInstanceOfClass()) {
                stringBuffer.append("class ");
                object = J9JVMConsole.getClass(j9Object.getObjectAddress());
                stringBuffer.append(((J9Class)object).getName());
            } else {
                stringBuffer.append(j9Object.getClassForObject().getName());
            }
            printWriter.println(stringBuffer.toString());
            if (j9Object.isPrimitiveArray()) continue;
            object = j9Object.getObjectRefs();
            stringBuffer2.append("\t");
            if (object != null) {
                for (n9 = 0; n9 < ((Object)object).length; ++n9) {
                    stringBuffer2.append("0x");
                    if (object[n9] == 0L) {
                        stringBuffer2.append("0");
                    } else {
                        stringBuffer2.append(Long.toHexString((long)object[n9]).toUpperCase());
                    }
                    stringBuffer2.append(" ");
                    if (object[n9] == 0L) {
                        ++n7;
                        continue;
                    }
                    ++n6;
                }
            }
            printWriter.println(stringBuffer2.toString());
        }
        System.out.println();
        printWriter.print("//Breakdown - Classes: " + n3);
        printWriter.print(", Objects: " + n2);
        printWriter.print(", ObjectArrays: " + n4);
        printWriter.println(", PrimitiveArrays: " + n5);
        printWriter.print("//EOF: Total 'Objects',Refs(null) : ");
        printWriter.println("" + n + "," + n6 + "(" + n7 + ")");
        return n;
    }
}

