/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleUtils;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

public class DumpBaseCmds
extends CommandPlugin {
    private Observer observer;
    private DumpBaseCmds mySelf = this;
    private Command[] myCommands;
    private Command[] commandsPostSetDump;
    private static Dump theDump;

    public DumpBaseCmds() {
        int n = 1;
        this.myCommands = new Command[n];
        this.myCommands[0] = new Command("set", "dump", this.mySelf, false, false, false, "Identifies the dump to work with");
        n = 12;
        this.commandsPostSetDump = new Command[n];
        this.commandsPostSetDump[0] = new Command("dis", "mmap", this.mySelf, true, false, false, "Displays the virtual address ranges within the dump");
        this.commandsPostSetDump[1] = new Command("dis", "mem", this.mySelf, true, false, false, "Formats and displays portions of memory");
        this.commandsPostSetDump[2] = new Command("dis", "sys", this.mySelf, true, false, false, "Displays build and version info for the JVM");
        this.commandsPostSetDump[3] = new Command("dis", "ptr", this.mySelf, true, false, false, "Displays the value at an address as a pointer");
        this.commandsPostSetDump[4] = new Command("dis", "long", this.mySelf, true, false, false, "Displays the value at an address as a long (8 byes)");
        this.commandsPostSetDump[5] = new Command("dis", "int", this.mySelf, true, false, false, "Displays the value at an address as an int (4 byes)");
        this.commandsPostSetDump[6] = new Command("find", "*", this.mySelf, true, false, false, "Find a string in memory");
        this.commandsPostSetDump[7] = new Command("findptr", "*", this.mySelf, true, false, false, "Find a pointer in memory");
        this.commandsPostSetDump[8] = new Command("findnext", "*", this.mySelf, true, false, false, "Repeat previous find command");
        this.commandsPostSetDump[9] = new Command("whatis", "*", this.mySelf, true, false, false, "Attempt to identify where an address ");
        this.commandsPostSetDump[10] = new Command("+", "*", this.mySelf, true, false, false, "Scroll forwards through memory");
        this.commandsPostSetDump[11] = new Command("-", "*", this.mySelf, true, false, false, "Scroll backwards through memory");
    }

    public String go(String string, String string2) {
        String string3 = null;
        CommandDetails commandDetails = new CommandDetails(string);
        String string4 = commandDetails.getVerb();
        String string5 = commandDetails.getNoun();
        if (string4.equals("SET") && string5.equals("DUMP")) {
            string3 = this.doSetDump(commandDetails.getRest());
        }
        if (null == theDump) {
            theDump = DumpConsole.getTheDump();
        }
        if (null != theDump) {
            if (string4.equals("DIS") && string5.equals("MMAP")) {
                string3 = this.doMemMap();
            } else if (string4.equals("DIS") && string5.equals("MEM")) {
                string3 = this.doDisplayMem(commandDetails.getRest());
            } else if (string4.equals("DIS") && string5.equals("SYS")) {
                string3 = this.doDisplaySys();
            } else if (string4.equals("FIND")) {
                string3 = this.goFind("FIND", string5, commandDetails, string2);
            } else if (string4.equals("FINDNEXT")) {
                string3 = this.doFindNext();
            } else if (string4.equals("FINDPTR")) {
                string3 = this.doFindPtr(string5, commandDetails);
            } else if (string4.equals("DIS") && (string5.equals("PTR") || string5.equals("INT") || string5.equals("LONG"))) {
                string3 = this.doDisplayPIL(commandDetails.getRest(), string5);
            } else if (string4.equals("WHATIS")) {
                string3 = this.doWhatis(string5);
            } else if (string4.equals("+") || string4.equals("-")) {
                string3 = this.doPlusMinus(string4);
            }
        }
        return string3;
    }

    private String goFind(String string, String string2, CommandDetails commandDetails, String string3) {
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, " ,");
        String string5 = null;
        if (stringTokenizer.countTokens() > 1) {
            stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
        }
        if (string5 == null) {
            string4 = this.doFindHelp();
        }
        boolean bl = false;
        if (string5.startsWith("\"")) {
            int n;
            int n2 = string3.indexOf("\"");
            int n3 = string3.lastIndexOf("\"");
            if (n3 != n2) {
                bl = true;
                n = string3.length();
                if (n > n3 + 1) {
                    if (string3.substring(n3 + 1, n3 + 2).equals(",")) {
                        string5 = string3.substring(n2 + 1, n3);
                        commandDetails.setRest(string3.substring(n3 + 2));
                    }
                } else if (n == n3 + 1) {
                    string5 = string3.substring(n2 + 1, n3);
                    commandDetails.setRest(null);
                }
            }
            if ((-1 == n3 || n3 == n2) && -1 != (n = string3.indexOf(","))) {
                commandDetails.setRest(string3.substring(n));
            }
        } else {
            int n = string3.indexOf(",");
            if (-1 != n) {
                commandDetails.setRest(string3.substring(n));
            }
        }
        string4 = this.findInMemory(string, string5, commandDetails.getRest(), bl);
        return string4;
    }

    public Command[] getCommandSet() {
        return this.myCommands;
    }

    private String doSetDump(String string) {
        String string2 = null;
        Dump dump = DumpConsole.getTheDump();
        if (dump != null) {
            return "Set dump has already been done";
        }
        try {
            dump = Dump.getDumptype(string);
            if (null == dump) {
                string2 = "Unrecognized as a dump file";
            } else {
                string2 = "Recognised as a ";
                string2 = dump.is32bit() ? string2 + "32-bit " : string2 + "64-bit ";
                string2 = dump.isLittleEndian() ? string2 + "little-endian " : string2 + "big-endian ";
                string2 = string2 + dump.getSystemTypeAsString(dump.getSystemType()) + " dump.";
                this.notifyObservers(string2);
                string2 = null;
                DumpConsole.setTheDump(dump);
                DumpConsole.addInAdditionalCommands(this.commandsPostSetDump, this);
                String string3 = dump.getDumpName() + ".xml";
                this.notifyObservers(" Trying to use \"" + string3 + "\" as metadata.....");
                File file = new File(string3);
                if (file.exists()) {
                    String string4 = "SET METADATA " + string3;
                    this.notifyObservers(" Issuing \"" + string4 + "\" .....");
                    int n = Console.findVerbNounCombo(string4);
                    if (-1 != n) {
                        String string5 = Console.doCommand(n, string4, null);
                        if (null != string5) {
                            this.notifyObservers("\n " + string5);
                        }
                    } else {
                        Console.reportError("Unable to find \"SET METADATA\" as a command", null);
                    }
                } else {
                    this.notifyObservers(" Unable to find \"" + string3 + "\" ..... set metadata will need to be entered manually");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string6 = Console.getProperty("WORKDIR");
            string2 = null != string6 && !string.startsWith(string6) ? this.doSetDump(string6 + File.separator + string) : "File \"" + string + "\" not found";
        }
        return string2;
    }

    private String doFindNext() {
        String string = null;
        String string2 = Console.getProperty("FINDNEXT");
        if (null == string2) {
            string = "No previous find has been done";
        } else {
            this.notifyObservers("issuing FIND " + string2);
            Console.handleInput("FIND " + string2, false);
        }
        return string;
    }

    private String doFindPtr(String string, CommandDetails commandDetails) {
        int n;
        int n2;
        String string2 = null;
        if (string == null) {
            this.notifyObservers("No parameter specified - ");
            String string3 = Console.getHelp("FINDPTR");
            this.notifyObservers(string3);
            return string2;
        }
        String string4 = DumpUtils.stripOff0x(string);
        boolean bl = false;
        for (n2 = 0; n2 < string4.length(); ++n2) {
            n = ConsoleUtils.hexValue(string4.charAt(n2));
            if (n != -1) continue;
            bl = true;
        }
        if (bl) {
            this.notifyObservers("\nInvalid hex value in input: 0x" + string4 + "\n");
        } else {
            n2 = string4.length();
            if (theDump.is32bit()) {
                if (n2 > 8) {
                    this.notifyObservers("\nPointer is too long (max 8 hex characters!\n");
                    return string2;
                }
                if (n2 < 8) {
                    for (n = 0; n < 8 - n2; ++n) {
                        string4 = "0" + string4;
                    }
                }
            } else {
                if (n2 > 8) {
                    this.notifyObservers("\nPointer is too long (max 16 hex characters!\n");
                    return string2;
                }
                if (n2 < 16) {
                    for (n = 0; n < 16 - n2; ++n) {
                        string4 = "0" + string4;
                    }
                }
            }
            if (theDump.isLittleEndian()) {
                if (theDump.is32bit()) {
                    String string5 = string4.substring(6, 8) + string4.substring(4, 6) + string4.substring(2, 4) + string4.substring(0, 2);
                    string4 = "0x" + string5;
                } else {
                    String string6 = string4.substring(14, 16) + string4.substring(12, 14) + string4.substring(10, 12) + string4.substring(8, 10) + string4.substring(6, 8) + string4.substring(4, 6) + string4.substring(2, 4) + string4.substring(0, 2);
                    string4 = "0x" + string6;
                }
                string2 = this.findInMemory("FINDPTR", string4, commandDetails.getRest(), false);
            }
        }
        return string2;
    }

    private String doMemMap() {
        String string = null;
        MemoryRange[] memoryRangeArray = theDump.getMemoryRanges();
        if (null != memoryRangeArray) {
            this.notifyObservers("\nMemory Map\n==========");
            for (int i = 0; i < memoryRangeArray.length; ++i) {
                if (null == memoryRangeArray[i] || memoryRangeArray[i].getSize() == 0L) continue;
                this.notifyObservers(memoryRangeArray[i].toString());
            }
        }
        return string;
    }

    private String doDisplayPIL(String string, String string2) {
        String string3;
        block11: {
            string3 = null;
            String string4 = new String(string);
            if (string4.startsWith("@") && null == (string4 = DumpUtils.chainViaPtr(string4, theDump.isLittleEndian()))) {
                string3 = "Error - Invalid pointer using @ in " + string;
            }
            if (string3 == null) {
                if (ConsoleUtils.verifyAsHex(string4 = DumpUtils.stripOff0x(string4))) {
                    try {
                        long l = DumpUtils.parseLongHex(string4);
                        Dump dump = DumpConsole.getTheDump();
                        long l2 = 0L;
                        if (dump.seekToMemoryAddress(l) > 0L) {
                            try {
                                if (string2.equals("INT")) {
                                    l2 = DumpUtils.convertEndian(dump.readIntEx());
                                    string3 = l2 + " (0x" + Long.toHexString(l2) + ")";
                                    break block11;
                                }
                                if (string2.equals("LONG")) {
                                    l2 = DumpUtils.convertEndian(dump.readLongEx());
                                    string3 = l2 + " (0x" + Long.toHexString(l2) + ")";
                                    break block11;
                                }
                                l2 = dump.readPtr(l);
                                string3 = " 0x" + Long.toHexString(l2);
                            }
                            catch (IOException iOException) {}
                            break block11;
                        }
                        string3 = "Error address not found in dump - 0x" + Long.toHexString(l);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string3 = "Error - was expecting valid hex and not " + string;
                    }
                } else {
                    string3 = "Error - was expecting valid hex and not " + string;
                }
            }
        }
        return string3;
    }

    private String doDisplayMem(String string) {
        String string2;
        block14: {
            string2 = null;
            Vector vector = new Vector();
            vector = ConsoleUtils.breakUpInput(string, ",. ");
            if (vector.size() == 1) {
                vector.add("256");
            }
            if (vector.size() != 0) {
                String string3 = (String)vector.get(0);
                String string4 = new String(string3);
                if (string3.startsWith("@") && null == (string3 = DumpUtils.chainViaPtr(string3, theDump.isLittleEndian()))) {
                    string2 = "Error - Invalid pointer using @ in " + string4;
                }
                string3 = DumpUtils.stripOff0x(string3);
                String string5 = (String)vector.get(1);
                if (ConsoleUtils.verifyAsHex(string3)) {
                    if (!ConsoleUtils.verifyAsPositiveNumber(string5)) {
                        string2 = "Error - Invalid Length!";
                    } else {
                        try {
                            long l = DumpUtils.parseLongHex(string3);
                            int n = Integer.parseInt(string5);
                            Dump dump = DumpConsole.getTheDump();
                            byte[] byArray = dump.getMemoryBytes(l, n);
                            if (null != byArray) {
                                boolean bl = true;
                                if (dump.getSystemType() == 3) {
                                    bl = false;
                                }
                                long l2 = l;
                                long l3 = l;
                                String string6 = "0x" + Long.toHexString(l2 += (long)n) + "," + n;
                                String string7 = "0x" + Long.toHexString(l3 -= (long)n) + "," + n;
                                Console.setProperty("DISNEXTMEM", string6);
                                Console.setProperty("DISPREVMEM", string7);
                                Vector vector2 = DumpUtils.formatMemory(byArray, l, 16, bl);
                                if (vector2.size() != 0) {
                                    for (int i = 0; i < vector2.size(); ++i) {
                                        this.notifyObservers(vector2.get(i));
                                    }
                                }
                                break block14;
                            }
                            string2 = "Error - Address not in memory: " + string4;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    string2 = "Error - Invalid Address!";
                }
            } else {
                string2 = "Error - No address specified!";
            }
        }
        return string2;
    }

    private String doDisplaySys() {
        this.notifyObservers("\tSystem Summary\n\t=============\n");
        this.notifyObservers(theDump.toString());
        return null;
    }

    public static Dump getTheDump() {
        return theDump;
    }

    public String checkCommandValidity(Command command) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (command.isSetDumpRun() && null == DumpConsole.getTheDump()) {
            stringBuffer.append("\n \"Set dump\" needs to be run before this command! (no dump file established)");
        }
        if (command.isSetMetadataRun() && null == J9JVMConsole.getKnownHeaps()) {
            stringBuffer.append("\n \"Set metadata\" needs to be run before this command! (no known heaps)");
        }
        if (command.isDisOsRun() && null == J9JVMConsole.getNamesFile()) {
            stringBuffer.append("\n \"Dis os\" needs to be run before this command! (no names index file)");
        }
        if ((string = stringBuffer.toString()).equals("")) {
            string = null;
        }
        return string;
    }

    private String findInMemory(String string, String string2, String string3, boolean bl) {
        String string4;
        long l = 0L;
        long l2 = -1L;
        boolean bl2 = false;
        int n = 256;
        int n2 = 1;
        boolean bl3 = false;
        int n3 = 1;
        String string5 = "1";
        boolean bl4 = false;
        Vector<Object> vector = new Vector<Object>();
        String string6 = null;
        String string7 = string2;
        boolean bl5 = false;
        Vector vector2 = null;
        if (string.equals("FINDPTR")) {
            bl5 = true;
        }
        if (null == string2) {
            bl4 = true;
            String string8 = this.doFindHelp();
            this.notifyObservers(string8);
        } else {
            int n4;
            int n5;
            Object object;
            int n6;
            int n7;
            boolean bl6 = false;
            if (theDump.getSystemType() == 3) {
                bl6 = true;
            }
            string4 = null;
            if (null != string3) {
                string4 = string3;
                n7 = string3.indexOf("\"");
                if (-1 != n7) {
                    string4 = string3.substring(n7 + 2);
                }
            }
            if (!bl4 && !bl && string7.toUpperCase().startsWith("0X")) {
                if (2 < string7.length()) {
                    bl3 = true;
                    string7 = DumpUtils.stripOff0x(string7);
                    string7.trim();
                    if (1 == string7.length() % 2) {
                        string7 = "0" + string7;
                    }
                    for (n7 = 0; n7 < string7.length(); ++n7) {
                        n6 = ConsoleUtils.hexValue(string7.charAt(n7));
                        if (n6 != -1) continue;
                        bl4 = true;
                    }
                    if (bl4) {
                        vector.add("\nInvalid hex value: 0x" + string7 + "\n");
                    }
                } else {
                    vector.add("\nInvalid command structure:" + string7 + "\n");
                    bl4 = true;
                }
            }
            if (!bl4 && bl5) {
                bl3 = true;
                for (n7 = 0; n7 < string7.length(); ++n7) {
                    n6 = ConsoleUtils.hexValue(string7.charAt(n7));
                    if (n6 != -1) continue;
                    bl4 = true;
                }
                if (bl4) {
                    vector.add("\nInvalid hex value: 0x" + string7 + "\n");
                }
            }
            Vector<String> vector3 = new Vector<String>();
            if (!bl4 && null != string4) {
                n6 = 0;
                while (0 == n6) {
                    int n8 = string4.indexOf(",,");
                    if (-1 == n8) {
                        n6 = 1;
                        continue;
                    }
                    string4 = string4.substring(0, n8 + 1) + " " + string4.substring(n8 + 1);
                }
                object = new StringTokenizer(string4, ",");
                n5 = ((StringTokenizer)object).countTokens();
                if (0 != n5) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        vector3.add(((StringTokenizer)object).nextToken().trim());
                    }
                }
                if (n5 > 5) {
                    vector.add("\nInvalid command structure: too many parameters\n");
                    bl4 = true;
                }
            }
            if (!bl4 && 0 != vector3.size()) {
                String string9 = (String)vector3.get(0);
                if (0 != string9.length()) {
                    try {
                        l = ConsoleUtils.hexToLong(string9);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + string9);
                    }
                }
                if (1 < vector3.size() && 0 != ((String)(object = (String)vector3.get(1))).length()) {
                    try {
                        l2 = ConsoleUtils.hexToLong((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid parameter:" + (String)object);
                    }
                }
                if (2 < vector3.size() && ((String)(object = (String)vector3.get(2))).length() != 0) {
                    try {
                        n2 = Integer.parseInt((String)object);
                        if (1 > n2 || 256 < n2) {
                            bl4 = true;
                            vector.add("Invalid boundary parameter (between 1 and 256 are valid) :" + (String)object);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid boundary parameter:" + (String)object);
                    }
                }
                if (3 < vector3.size() && ((String)(object = (String)vector3.get(3))).length() != 0) {
                    try {
                        n = Integer.parseInt((String)object);
                        if (16 > n) {
                            bl4 = true;
                            vector.add("Invalid print length parameter (less than 16) :" + (String)object);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid print length parameter:" + (String)object);
                    }
                }
                if (4 < vector3.size() && (string5 = (String)vector3.get(4)).length() != 0) {
                    try {
                        n3 = Integer.parseInt(string5);
                        if (n3 > 100 || n3 < 1) {
                            bl4 = true;
                            vector.add("Invalid find limit (>100 or <1) :" + string5);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl4 = true;
                        vector.add("Invalid find limit:" + string5);
                    }
                }
            }
            if (!bl4) {
                int n9;
                byte[] byArray;
                if (bl3) {
                    byArray = new byte[string7.length() / 2];
                    for (n9 = 0; n9 < byArray.length; ++n9) {
                        String string10 = string7.substring(n9 * 2, n9 * 2 + 2);
                        n4 = Integer.parseInt(string10, 16);
                        if (n4 > 127) {
                            n4 -= 256;
                        }
                        string10 = String.valueOf(n4);
                        byArray[n9] = Byte.parseByte(string10);
                    }
                } else {
                    byArray = new byte[string7.length()];
                    n9 = 0;
                    n5 = 0;
                    String string11 = Console.getProperty("FORMATAS");
                    if (null != string11) {
                        if ((string11 = string11.toUpperCase()).startsWith("E")) {
                            n9 = 1;
                        }
                        if (string11.startsWith("A")) {
                            n5 = 1;
                        }
                    }
                    if (bl6 && 0 == n5 || 1 == n9) {
                        try {
                            byArray = string7.getBytes("Cp1047");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Console.reportError("Cp1047 not found", unsupportedEncodingException);
                        }
                    } else {
                        byArray = string7.getBytes();
                    }
                }
                if ((vector2 = DumpUtils.findInMemory(theDump, byArray, l, l2, n2, n3, bl2)).size() == n3) {
                    vector.add("  Note: your search result limit was " + n3 + " ... there may be more results\n");
                }
                if (1 < vector2.size()) {
                    for (n9 = 0; n9 < vector2.size(); ++n9) {
                        long l3 = (Long)vector2.elementAt(n9);
                        vector.add("#" + n9 + ": " + Long.toHexString(l3));
                    }
                }
                if (0 != vector2.size()) {
                    Long l4 = (Long)vector2.elementAt(vector2.size() - 1);
                    String string12 = string7;
                    if (bl) {
                        string12 = "\"" + string12 + "\"";
                    }
                    if (bl3) {
                        string12 = "0x" + string12;
                    }
                    long l5 = l4;
                    string12 = string12 + "," + Long.toHexString(l5 += (long)n2) + ",";
                    string12 = string12 + Long.toHexString(l2) + "," + n2 + ",";
                    string12 = string12 + n + "," + string5;
                    Console.setProperty("FINDNEXT", string12);
                    byte[] byArray2 = null;
                    byArray2 = theDump.getMemoryBytes(l5 - (long)n2, n);
                    Vector vector4 = DumpUtils.formatMemory(byArray2, l5 - (long)n2, 16, !bl6);
                    if (null != vector4) {
                        vector.add(vector4);
                    }
                    vector.add("  Tip 1: Use FINDNEXT (FN) command to progress through them");
                    vector.add("  Tip 2: Use \"SET FINDMODE=V\" to do automatic WHATIS\n");
                } else if (bl5) {
                    vector.add("\n No occurrence of pointer found.");
                } else {
                    vector.add("\n No occurrence of search parameter found.\n Note: If parameter was a string then check case.\nIf required \"SET FORMATAS=A\" can be used to\n force ASCII search on EBCDIC dump (and vice versa).\n Note: You can use \" SET FINDMODE=V\" to cause find to\n issue a WHATIS against each found memory position.");
                }
                vector.add(" Find finished...\n");
            }
        }
        if (null != vector) {
            this.notifyObservers(vector);
        }
        boolean bl7 = false;
        string4 = Console.getProperty("FINDMODE");
        if (null != string4 && string4.toUpperCase().startsWith("V")) {
            bl7 = true;
        }
        if (bl7) {
            for (int i = 0; i < vector2.size(); ++i) {
                long l6 = (Long)vector2.elementAt(i);
                this.notifyObservers("Issuing \"whatis " + Long.toHexString(l6) + "\" \n");
                String string13 = "whatis 0x" + Long.toHexString(l6);
                Console.handleInput(string13, false);
            }
        }
        return string6;
    }

    private String doPlusMinus(String string) {
        String string2 = null;
        String string3 = null;
        string3 = string.equals("+") ? Console.getProperty("DISNEXTMEM") : Console.getProperty("DISPREVMEM");
        string2 = null == string3 ? " No previous \"dis mem\" command has been issued." : this.doDisplayMem(string3);
        return string2;
    }

    private String doWhatis(String string) {
        String string2 = null;
        if (null == string) {
            this.notifyObservers(" Sorry, but I need to know what you want to know about.\n\t e.g. whatis 0x888abc");
            return string2;
        }
        try {
            long l = DumpUtils.parseLongHex(string);
            int n = theDump.findWhichMemoryRange(l);
            if (-1 == n) {
                this.notifyObservers(" \"" + string + "\" is not a known address in memory  ");
            } else {
                this.notifyObservers(" \"" + string + "\" is a known address in memory (range = " + n + ")");
                if (J9JVMBaseCmds.isSetMetaDataDone()) {
                    string2 = J9JVMBaseCmds.whatis(string, l, this);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.notifyObservers(" \"" + string + "\" is not recognised as a valid address");
        }
        return string2;
    }

    private String doFindHelp() {
        return Console.getHelp("FIND");
    }
}

