/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this(IdentityDatabase.d("h\u0000\u0016a[h\f\u000br\u001a4K"));
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(IdentityDatabase.d("N\r\ff\u0014i\r\n`X~E\u000bz@:\u0007\u00005\\{\u0015\u0015pZs\u000b\u0002;"), classNotFoundException);
            IdentityDatabase.b(IdentityDatabase.d("N\r\u00005B\u007f\u0017\u0016|[tE\ns\u0014n\r\u00005P{\u0011\u0004wUi\u0000E|G:\n\u0007f[v\u0000\u0011p\u001a:&\u0004{Zu\u0011E|Zs\u0011\ftXs\u001f\u0000;"));
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("N\r\ff\u0014i\r\n`X~E\u000bz@:\u0007\u00005\\{\u0015\u0015pZs\u000b\u0002;"), invalidClassException);
            IdentityDatabase.b(IdentityDatabase.d("O\u000b\u0004wX\u007fE\u0011z\u0014s\u000b\fa]{\t\foQ:\u0016\u001cf@\u007f\bE|P\u007f\u000b\u0011|@cE\u0016v[j\u0000_5\u0014S\u000b\u0013tXs\u0001&yUi\u0016 mW\u007f\u0015\u0011|[tKE\u001f`r\f\u00165]iE\bzGnE\t|_\u007f\t\u001c5Po\u0000Ea[:\u0004EfQh\f\u0004y]`\u0004\u0011|[tE\u0013pFi\f\n{]t\u0002EeFu\u0007\tpY E\u00045Wv\u0004\u0016f\u0014o\u0016\u0000q\u0014s\u000bE~QcE\btZ{\u0002\u0000xQt\u0011EbUiE\nwGu\t\u0000aQ~"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(IdentityDatabase.d("N\r\u00005G\u007f\u0017\ftXs\u001f\u0004a]u\u000bEf@h\u0000\u0004x\u0014s\u0016Ev[h\u0017\u0010e@\u007f\u0001K5at\u0004\u0007yQ:\u0011\n5Xu\u0004\u0001;"), streamCorruptedException);
            IdentityDatabase.b(IdentityDatabase.d("O\u000b\u0004wX\u007fE\u0011z\u0014s\u000b\fa]{\t\foQ:\u0016\u001cf@\u007f\bE|P\u007f\u000b\u0011|@cE\u0016v[j\u0000K5gn\u0017\u0000tYY\n\u0017gDo\u0011\u0000qqb\u0006\u0000e@s\n\u000b;"));
        }
        if (identityDatabase != null) return identityDatabase;
        return new IdentityDatabase(IdentityDatabase.d("o\u000b\f{]n\f\u0004y]`\u0000\u0001"));
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(IdentityDatabase.d("}\u0000\u0011;Gs\u0002\u000bpF"));
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(IdentityDatabase.d("}\u0000\u0011;Gs\u0002\u000bpF"));
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d("{\u0001\u0001;]~\u0000\u000ba]n\u001c"));
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = IdentityDatabase.d("t\u0004\bp\u0014y\n\u000bsXs\u0006\u0011");
        }
        if (identity3 != null) {
            string = IdentityDatabase.d("q\u0000\u001c5Wu\u000b\u0003y]y\u0011");
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d("h\u0000\bzB\u007fK\fqQt\u0011\faM"));
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(IdentityDatabase.d("n\r\u0000gQ:\f\u00165ZuE\fqQt\u0011\faM:\u000b\u0004xQ~E") + string + IdentityDatabase.d(":\f\u000b5") + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("N\r\ff\u0014i\r\n`X~E\u000bz@:\u0007\u00005\\{\u0015\u0015pZs\u000b\u0002;"), invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException(IdentityDatabase.d("n\r\ff\u0014~\u0004\u0011tV{\u0016\u00005\\{\u0016E{[:\u0016\n`Fy\u0000Es]v\u0000"));
        }
        this.b(this.sourceFile);
    }

    private static File b() {
        String string = Security.getProperty(IdentityDatabase.d("s\u0001\u0000{@s\u0011\u001c;P{\u0011\u0004wUi\u0000"));
        if (string == null) {
            string = System.getProperty(IdentityDatabase.d("o\u0016\u0000g\u001ar\n\bp")) + File.separatorChar + IdentityDatabase.d("s\u0001\u0000{@s\u0011\u001cqV4\n\u0007\u007f");
        }
        return new File(string);
    }

    private static void c() {
        File file = IdentityDatabase.b();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(IdentityDatabase.d("v\n\u0004q]t\u0002EfMi\u0011\u0000x\u0014~\u0004\u0011tV{\u0016\u00005Rh\n\b5Rs\t\u0000/\u0014") + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(IdentityDatabase.d("I\u001c\u0016aQwE\u0001t@{\u0007\u0004fQ:\f\u000b|@s\u0004\t|N\u007f\u0001_5") + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(IdentityDatabase.d("_\u0017\u0017zF:\f\u000b|@s\u0004\t|Ns\u000b\u00025]~\u0000\u000ba]n\u001cEqUn\u0004\u0007tG\u007f_E") + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(IdentityDatabase.d("_\u0017\u0017zF:\u0011\u0017l]t\u0002Ea[:\f\u000bf@{\u000b\u0011|Un\u0000Et\u0014i\u001c\u0016aQwE\fqQt\u0011\fa]\u007f\u0016EqV:\f\u000b5") + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return IdentityDatabase.d("y\n\b;]x\bKvFc\u0015\u0011z\u001aj\u0017\nc]~\u0000\u0017;}~\u0000\u000ba]n\u001c!t@{\u0007\u0004fQ6E\u0016zAh\u0006\u00005Rs\t\u0000/\u0014") + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.d();
            securityManager.checkSecurityAccess(string);
        }
    }

    String d() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(IdentityDatabase.d("i\u0000\u0017|Uv\f\u001fp\u001as\u0001\u0000{@s\u0011\u001c;P{\u0011\u0004wUi\u0000"));
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void e() {
        IdentityDatabase.c();
    }

    static {
        AccessController.doPrivileged(new j());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 26;
                        break;
                    }
                    case 1: {
                        n5 = 101;
                        break;
                    }
                    case 2: {
                        n5 = 101;
                        break;
                    }
                    case 3: {
                        n5 = 21;
                        break;
                    }
                    default: {
                        n5 = 52;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

