/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 2607870640963059136L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(DHPublicKey.a("\\\u0010Vc\u0014kQH\u007f\u0014{\u0004[h[^\"v#J?\u0014Vn\u0014{\u0018Vj"));
        }
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("V\u001fNl\u0017v\u0015\u0018f\u001efQ^b\tr\u0010L"));
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("^\u001d_D\u001f?\u0018K-\u0015p\u0005\u0018l[L4iX>Q2}"));
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new InvalidKeyException(DHPublicKey.a("O\u0010Jl\u0016z\u0005]\u007f\b?\u001cQ~\bv\u001f_"));
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new InvalidKeyException(DHPublicKey.a("Q\u0004Ta[o\u0010Jl\u0016z\u0005]\u007f\b"));
            }
            if (derValue3.getTag() != 48) {
                throw new InvalidKeyException(DHPublicKey.a("O\u0010Jl\u0016z\u0005]\u007f\b?\u001fWy[~QkH*J4vN>"));
            }
            derValue3.getData().reset();
            this.p = derValue3.getData().getInteger();
            this.g = derValue3.getData().getInteger();
            if (derValue3.getData().available() != 0) {
                this.l = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new InvalidKeyException(DHPublicKey.a("Z\tL\u007f\u001a?\u0001Y\u007f\u001ar\u0014Lh\t?\u0015Yy\u001a"));
            }
            this.key = derValue.getData().getBitString();
            this.a();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(DHPublicKey.a("Z\t[h\blQSh\u0002?\u0015Yy\u001a"));
            }
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException(DHPublicKey.a("O\u0003Q{\u001ak\u0014\u0015{\u001as\u0004]-\u0017z\u001f_y\u0013?\u0005Wb[}\u0018_"));
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String getFormat() {
        return DHPublicKey.a("G_\r=B");
    }

    public String getAlgorithm() {
        return DHPublicKey.a("[9");
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putInteger(this.p);
                derOutputStream2.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream2.putInteger(BigInteger.valueOf(this.l));
                }
                DerValue derValue = new DerValue(48, derOutputStream2.toByteArray());
                derOutputStream.putDerValue(derValue);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream);
                derOutputStream3.putBitString(this.key);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public BigInteger getY() {
        return this.y;
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(DHPublicKey.a("V3uG8ZQ|d\u001dy\u0018] 3z\u001dT`\u001aqQhx\u0019s\u0018[-0z\b\u0002\u0007\u0002%{") + this.y.toString() + "\n" + DHPublicKey.a("oK2") + this.p.toString() + "\n" + DHPublicKey.a("xK2") + this.g.toString());
        if (this.l != 0) {
            stringBuffer.append(DHPublicKey.a("\u0015\u001d\u0002\u0007[?Q\u0018") + this.l);
        }
        return stringBuffer.toString();
    }

    private void a() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PublicKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 31;
                        break;
                    }
                    case 1: {
                        n5 = 113;
                        break;
                    }
                    case 2: {
                        n5 = 56;
                        break;
                    }
                    case 3: {
                        n5 = 13;
                        break;
                    }
                    default: {
                        n5 = 123;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

