/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.j2ee.commonarchivecore.exception.ArchiveWrappedException;
import com.ibm.etools.j2ee.commonarchivecore.helpers.RuntimeClasspathEntry;
import com.ibm.etools.jca.Connector;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.ClassLoaderUtils;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassGraph {
    private static TraceComponent tc = Tr.register((String)ClassGraph.class.getName(), (String)"Websphere ClassLoader", null);
    protected ArrayList moduleNodes = new ArrayList();
    protected HashMap modulePathMap = new HashMap();
    protected ArrayList dependentPaths = new ArrayList();
    protected ClassLoader parent = null;
    protected JarClassLoader dependencyLoader = null;
    protected boolean singleWarClassLoader;
    protected boolean libDelegationMode = true;
    protected String[] libraryPaths = null;
    protected String[] nativeLibPaths = new String[0];
    protected ArrayList serverPaths = new ArrayList();

    public ClassGraph(ClassLoader classLoader, String[] stringArray, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{"parent=" + classLoader, "libraryPaths=" + PathUtils.arrayToString((String[])stringArray), "delegationMode=" + bl});
        }
        this.parent = classLoader;
        this.libDelegationMode = bl;
        this.libraryPaths = PathUtils.expandPaths((String[])stringArray);
        this.libraryPaths = ClassLoaderUtils.addDependentJars(this.libraryPaths);
        this.singleWarClassLoader = bl2;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public ClassGraph(ClassGraphState classGraphState) {
        this(classGraphState.parent, classGraphState.libraryPaths, classGraphState.libDelegationMode, classGraphState.singleWarClassLoader);
        this.dependencyLoader = classGraphState.previousDependencyLoader;
        this.serverPaths = classGraphState.previousServerPaths;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public ClassGraph(ClassLoader classLoader, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        this(classLoader, stringArray, bl, bl2);
        this.nativeLibPaths = stringArray2;
    }

    public ClassGraph(ClassLoader classLoader) {
        this(classLoader, new String[0], ClassLoaderManager.getDefaultDelegationMode(), true);
    }

    public void addModule(ModuleRef moduleRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addModule", (Object)moduleRef);
        }
        boolean bl = tc.isDebugEnabled();
        ModuleNode moduleNode = new ModuleNode();
        moduleNode.moduleRef = moduleRef;
        this.moduleNodes.add(moduleNode);
        ModuleFile moduleFile = moduleRef.getModuleFile();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("adding module: " + moduleFile.getURI() + " isEJBJarFile=" + moduleFile.isEJBJarFile() + " isWARFile=" + moduleFile.isWARFile()));
        }
        if (moduleFile.isApplicationClientFile()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)("module: " + moduleFile.getURI() + " is an application client module. skipping..."));
            }
            return;
        }
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = moduleFile.getLocalRuntimeClassPath();
        for (int i = 0; i < runtimeClasspathEntryArray.length; ++i) {
            String string = this.normalizePath(runtimeClasspathEntryArray[i].getAbsolutePath());
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)("module: " + moduleFile.getURI() + " local path: " + string));
            }
            this.dependentPaths.remove(string);
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)("module: " + moduleFile.getURI() + " adding " + string + " as a module path."));
            }
            this.modulePathMap.put(string, moduleNode);
            PathUtils.listAddNoDup((List)moduleNode.paths, (Object)string);
            PathUtils.listAddNoDup((List)moduleNode.localPaths, (Object)string);
        }
        RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = moduleFile.getDependencyClassPath();
        for (int i = 0; i < runtimeClasspathEntryArray2.length; ++i) {
            String string = this.normalizePath(runtimeClasspathEntryArray2[i].getAbsolutePath());
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)("module: " + moduleFile.getURI() + " dependency path: " + string));
            }
            PathUtils.listAddNoDup((List)moduleNode.paths, (Object)string);
            if (this.modulePathMap.get(string) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addModule", (Object)moduleRef);
        }
    }

    public JarClassLoader getDependencyClassLoader() {
        return this.dependencyLoader;
    }

    public void addUtilityJars(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addUtilityJars", (Object)PathUtils.arrayToString((String[])stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.normalizePath(stringArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("utility path: " + string));
            }
            if (this.modulePathMap.get(string) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)string);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addUtilityJars");
        }
    }

    public ClassLoader calculate(EARFile eARFile, String string) {
        return this.createClassLoaders(eARFile, string, true, null);
    }

    public void updateClassLoaders(EARFile eARFile, String string, ClassLoader classLoader) {
        this.createClassLoaders(eARFile, string, false, classLoader);
    }

    public void dispose() {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dispose", (Object)this);
        }
        this.moduleNodes.clear();
        this.modulePathMap.clear();
        this.dependentPaths.clear();
        this.parent = null;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dispose", (Object)this);
        }
    }

    protected String normalizePath(String string) {
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.classloader.ClassGraph.normalizePath", (String)"200", (Object)this);
        }
        return file.getPath();
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef moduleRef) {
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            ModuleNode moduleNode = (ModuleNode)this.moduleNodes.get(i);
            if (moduleNode == null || moduleNode.moduleRef != moduleRef) continue;
            return moduleNode.classLoader;
        }
        return this.dependencyLoader;
    }

    private void processWARModule(EARFile eARFile, ClassLoader classLoader, JarClassLoader jarClassLoader, ModuleRef moduleRef, String[] stringArray, ModuleNode moduleNode, DynamicPolicy dynamicPolicy, String string, ArrayList arrayList) {
        StringBuffer stringBuffer;
        boolean bl = tc.isDebugEnabled();
        JarClassLoader jarClassLoader2 = null;
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("creating WarClassLoader paths=" + PathUtils.arrayToString((String[])stringArray)));
        }
        String[] stringArray2 = new String[2];
        try {
            stringBuffer = new StringBuffer(moduleRef.getModuleFile().getBinariesPath());
            stringBuffer.append("/WEB-INF/");
            int n = stringBuffer.length();
            stringArray2[0] = stringBuffer.append("classes").toString();
            stringBuffer.setLength(n);
            stringArray2[1] = stringBuffer.append("lib").toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)this.getClass().getName(), (String)"232");
        }
        stringBuffer = new DynamicPolicy.Module("web", stringArray2, moduleRef.getUri(), null);
        if (jarClassLoader == null) {
            moduleNode.classLoader = jarClassLoader2 = new JarClassLoader(stringArray, classLoader, ClassLoaderManager.getDefaultDelegationMode());
            if (dynamicPolicy != null) {
                Map map = this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, jarClassLoader2.getCodeSourcePermissions(), (DynamicPolicy.Module)stringBuffer);
                jarClassLoader2.setCodeSourcePermissions(map);
            }
        } else {
            jarClassLoader.addPaths(stringArray);
            this.addToServerPaths(stringArray);
            moduleNode.classLoader = jarClassLoader;
            arrayList.add(stringBuffer);
        }
    }

    private void processEJBModule(ModuleRef moduleRef, String[] stringArray, ModuleNode moduleNode, ArrayList arrayList) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug((TraceComponent)tc, (String)("adding EJB paths to dependencyLoader paths=" + PathUtils.arrayToString((String[])stringArray)));
        }
        this.dependencyLoader.addPaths(stringArray);
        this.addToServerPaths(stringArray);
        moduleNode.classLoader = this.dependencyLoader;
        arrayList.add(new DynamicPolicy.Module("ejb", stringArray, moduleRef.getUri(), null));
    }

    protected ClassLoader createClassLoaders(EARFile eARFile, String string, boolean bl, ClassLoader classLoader) {
        Object object;
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createClassLoaders", (Object)new Object[]{eARFile, string});
        }
        boolean bl2 = tc.isDebugEnabled();
        ClassLoader classLoader2 = null;
        JarClassLoader jarClassLoader = null;
        ArrayList<DynamicPolicy.Module> arrayList = new ArrayList<DynamicPolicy.Module>(this.moduleNodes.size());
        if (bl) {
            classLoader2 = this.parent;
            if (ClassLoaderManager.getSingleServerClassLoader()) {
                if (this.singleWarClassLoader) {
                    this.dependencyLoader = jarClassLoader = ClassLoaderManager.serverClassLoader;
                } else {
                    this.dependencyLoader = ClassLoaderManager.serverClassLoader;
                    classLoader2 = this.dependencyLoader;
                }
            } else {
                this.dependencyLoader = new JarClassLoader(new String[0], this.parent, this.libDelegationMode);
                if (this.singleWarClassLoader) {
                    jarClassLoader = this.dependencyLoader;
                } else {
                    classLoader2 = this.dependencyLoader;
                }
            }
        } else {
            classLoader2 = classLoader;
        }
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)("dependencyLoader=" + this.dependencyLoader));
            Tr.debug((TraceComponent)tc, (String)("warParent=" + classLoader2));
            Tr.debug((TraceComponent)tc, (String)("warGroup=" + jarClassLoader));
        }
        DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            object = (ModuleNode)this.moduleNodes.get(i);
            String[] stringArray = new String[((ModuleNode)object).localPaths.size()];
            ((ModuleNode)object).localPaths.toArray(stringArray);
            ModuleRef moduleRef = ((ModuleNode)object).moduleRef;
            if (moduleRef.isEJB()) {
                this.processEJBModule(moduleRef, stringArray, (ModuleNode)object, arrayList);
                continue;
            }
            if (moduleRef.isWeb()) {
                this.processWARModule(eARFile, classLoader2, jarClassLoader, moduleRef, stringArray, (ModuleNode)object, dynamicPolicy, string, arrayList);
                continue;
            }
            if (moduleRef.isConnector()) {
                stringArray = PathUtils.expandPaths((String[])stringArray);
                this.dependencyLoader.addPaths(stringArray);
                this.addToServerPaths(stringArray);
                ((ModuleNode)object).classLoader = this.dependencyLoader;
                try {
                    Connector connector = (Connector)moduleRef.getDeploymentDescriptor();
                    arrayList.add(new DynamicPolicy.Module("RARFile", stringArray, moduleRef.getUri(), (List)connector.getResourceAdapter().getSecurityPermissions()));
                }
                catch (ArchiveWrappedException archiveWrappedException) {}
                continue;
            }
            if (moduleRef.isClient()) {
                this.dependencyLoader.addPaths(stringArray);
                this.addToServerPaths(stringArray);
                ((ModuleNode)object).classLoader = this.dependencyLoader;
                arrayList.add(new DynamicPolicy.Module("utility", stringArray, moduleRef.getUri(), null));
                continue;
            }
            System.out.println("unsupported module type=" + moduleRef);
            Thread.dumpStack();
        }
        String[] stringArray = this.dependentPaths.toArray(new String[this.dependentPaths.size()]);
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)("adding dependency loader paths: " + PathUtils.arrayToString((String[])stringArray)));
        }
        this.dependencyLoader.addPaths(stringArray);
        this.addToServerPaths(stringArray);
        arrayList.add(new DynamicPolicy.Module("utility", stringArray, null, null));
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)("adding library paths: " + PathUtils.arrayToString((String[])this.libraryPaths)));
        }
        this.dependencyLoader.addPaths(this.libraryPaths);
        this.addToServerPaths(this.libraryPaths);
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)("adding native library paths: " + PathUtils.arrayToString((String[])this.nativeLibPaths)));
        }
        this.dependencyLoader.addNativeLibPaths(this.nativeLibPaths);
        if (dynamicPolicy != null) {
            object = this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, this.dependencyLoader.getCodeSourcePermissions(), arrayList);
            this.dependencyLoader.setCodeSourcePermissions((Map)object);
            this.generateLibraryCodeSource(dynamicPolicy, this.dependencyLoader.getCodeSourcePermissions(), this.libraryPaths);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createClassLoaders", (Object)this);
        }
        return classLoader2;
    }

    public String[] getServerPaths() {
        if (ClassLoaderManager.getSingleServerClassLoader()) {
            return this.serverPaths.toArray(new String[0]);
        }
        return null;
    }

    private void addToServerPaths(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.serverPaths.add(stringArray[i]);
        }
    }

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(super.toString());
        printWriter.println("singleServerClassLoader: " + ClassLoaderManager.getSingleServerClassLoader());
        printWriter.println("singleWarClassLoader: " + this.singleWarClassLoader);
        printWriter.println("modules          : " + this.moduleNodes.size());
        printWriter.println("dependent paths  : " + this.dependentPaths.size());
        Iterator iterator = this.dependentPaths.iterator();
        while (iterator.hasNext()) {
            printWriter.println("deppath: " + iterator.next());
        }
        printWriter.println("library paths  : " + this.libraryPaths.length);
        for (n = 0; n < this.libraryPaths.length; ++n) {
            printWriter.println("library path: " + this.libraryPaths[n]);
        }
        printWriter.println("native library paths : " + this.nativeLibPaths.length);
        for (n = 0; n < this.nativeLibPaths.length; ++n) {
            printWriter.println("native library path: " + this.nativeLibPaths[n]);
        }
        for (n = 0; n < this.moduleNodes.size(); ++n) {
            ModuleNode moduleNode = (ModuleNode)this.moduleNodes.get(n);
            printWriter.println("module: " + moduleNode.moduleRef.getModuleFile().getURI());
            for (int i = 0; i < moduleNode.localPaths.size(); ++i) {
                printWriter.println("   " + moduleNode.localPaths.get(i));
            }
        }
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map map, DynamicPolicy.Module module) {
        DynamicPolicy.Module[] moduleArray = new DynamicPolicy.Module[]{module};
        return this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, map, moduleArray);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map map, List list) {
        DynamicPolicy.Module[] moduleArray = new DynamicPolicy.Module[list.size()];
        list.toArray(moduleArray);
        return this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, map, moduleArray);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map hashMap, DynamicPolicy.Module[] moduleArray) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        try {
            DynamicPolicy.Application application = new DynamicPolicy.Application(eARFile.getBinariesPath(), string, moduleArray);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("type", "application");
            hashMap2.put("application", (String)application);
            dynamicPolicy.getSecurityPolicy(hashMap2, hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)this.getClass().getName(), (String)"356");
        }
        return hashMap;
    }

    private Map generateLibraryCodeSource(DynamicPolicy dynamicPolicy, Map hashMap, String[] stringArray) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("type", "library");
        hashMap2.put("classpath", stringArray);
        dynamicPolicy.getSecurityPolicy(hashMap2, hashMap);
        return hashMap;
    }

    public ClassGraphState getState() {
        return new ClassGraphState(this.parent, this.dependencyLoader, this.serverPaths, this.libraryPaths, this.libDelegationMode, this.singleWarClassLoader);
    }

    static class ModuleNode {
        ArrayList paths = new ArrayList();
        ArrayList localPaths = new ArrayList();
        JarClassLoader classLoader = null;
        ModuleRef moduleRef;

        ModuleNode() {
        }

        public String toString() {
            return "module: " + this.moduleRef.getModuleFile().getName();
        }
    }
}

