/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import com.ibm.xml.b2b.util.entity.ByteArrayParsedEntityFactory;
import com.ibm.xml.b2b.util.entity.EntityInputSource;
import com.ibm.xml.b2b.util.entity.ParsedEntityFactory;
import count.CounterBase;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXPCounter
extends CounterBase
implements ErrorHandler,
EntityResolver,
ContentHandler {
    private static final boolean COUNT_ALL_CHARS = true;
    private XMLReader fXMLReader;
    private boolean fValidation;
    private boolean fExternalGeneralEntities = true;
    private boolean fExternalParameterEntities = true;
    private boolean fUseCharacterStream;
    private boolean fWarmingUp;
    private PrintWriter fTraceLog;

    protected int processSwitch(String[] stringArray, int n) throws Exception {
        int n2 = super.processSwitch(stringArray, n);
        if (n2 != n) {
            return n2;
        }
        String string = stringArray[n];
        if (!string.startsWith("-")) {
            return n;
        }
        if (string.equals("-v")) {
            this.fValidation = true;
            return ++n;
        }
        if (string.equals("-noge")) {
            this.fExternalGeneralEntities = false;
            return ++n;
        }
        if (string.equals("-nope")) {
            this.fExternalParameterEntities = false;
            return ++n;
        }
        if (string.equals("-utf16")) {
            this.fUseCharacterStream = true;
            return ++n;
        }
        if (string.equals("-L")) {
            if (n == stringArray.length - 1) {
                System.err.println("error: missing logfile name");
                System.exit(1);
            }
            this.fTraceLog = new PrintWriter((Writer)new FileWriter(stringArray[++n], false), true);
            return ++n;
        }
        JAXPCounter.printUsage();
        System.exit(1);
        return n;
    }

    protected void parseSetup(String string) throws Exception {
        super.parseSetup(string);
        if (this.fXMLReader == null) {
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                this.fXMLReader = sAXParser.getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
            if (this.fXMLReader == null) {
                this.fXMLReader = XMLReaderFactory.createXMLReader();
            }
            this.fXMLReader.setErrorHandler(this);
            this.fXMLReader.setEntityResolver(this);
            this.fXMLReader.setContentHandler(this);
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/validation", this.fValidation);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.fExternalGeneralEntities);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.fExternalParameterEntities);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.fXMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.fWarmingUp = true;
    }

    protected boolean runDocumentTest(EntityInputSource entityInputSource) {
        this.fElemCount = 0;
        this.fAttrCount = 0;
        this.fCharCount = 0;
        this.fSpaceCount = 0;
        try {
            InputSource inputSource = new InputSource();
            inputSource.setPublicId(entityInputSource.getPublicId());
            inputSource.setSystemId(entityInputSource.getSystemId());
            inputSource.setEncoding(entityInputSource.getEncoding());
            inputSource.setByteStream(entityInputSource.getByteStream());
            inputSource.setCharacterStream(entityInputSource.getCharacterStream());
            this.fXMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            if (!this.fWarmingUp) {
                sAXParseException.printStackTrace(System.err);
            } else {
                this.fWarmingUp = false;
            }
            return false;
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.fWarmingUp) {
            return;
        }
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        if (this.fWarmingUp) {
            return;
        }
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.fWarmingUp) {
            throw sAXParseException;
        }
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public InputSource resolveEntity(String string, String string2) {
        if (this.fWarmingUp) {
            return null;
        }
        return null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.fWarmingUp) {
            return;
        }
        this.fElemCount += string3.length();
        if (attributes != null) {
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string4 = attributes.getQName(n2);
                this.fAttrCount += string4.length();
                String string5 = attributes.getValue(n2);
                this.fCharCount += string5.length();
                ++n2;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.fWarmingUp) {
            return;
        }
        this.fCharCount += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.fWarmingUp) {
            return;
        }
        this.fSpaceCount += n2;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.fWarmingUp = false;
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void endElement(String string, String string2, String string3) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void skippedEntity(String string) {
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.JAXPCounter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -c       Just count.");
        System.err.println("  -s       Use sockets.");
        System.err.println("  -m       Use memory.");
        System.err.println("  -v       Turn on validation.");
        System.err.println("  -noge    Turn off external general entities.");
        System.err.println("  -nope    Turn off external parameter entities.");
        System.err.println("  -utf16   Use CharacterStream, not ByteStream.");
        System.err.println("  -h       This help screen.");
    }

    public JAXPCounter() {
        super((ParsedEntityFactory)new ByteArrayParsedEntityFactory(false));
    }

    public static void main(String[] stringArray) {
        try {
            JAXPCounter jAXPCounter = new JAXPCounter();
            jAXPCounter.count(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

