/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanBaseWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaBeanWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.JavaHelpers;

public class JavaBeanDeserializerWriter
extends JavaBeanBaseWriter {
    protected boolean emitExtraMethods = true;
    protected String beanClass;
    protected ArrayList elementSetFromStringList = new ArrayList();
    protected static final int MAX = 25;
    protected JavaHelpers collectionType;
    private static Hashtable parseText = new Hashtable(50);

    protected JavaBeanDeserializerWriter(Emitter emitter, Type type) {
        super(emitter, type, type.getName() + "_Deser", "deserializer");
        ClassFactory classFactory = emitter.getToolEnv().getClassFactory();
        this.collectionType = classFactory.forName("java.util.Collection");
    }

    protected String getExtendsText() {
        String string = !this.isBaseClass() ? "extends " + this.extendType.getName() + "_Deser " : (this.type.isSimpleContent() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleBeanDeserializer " : (this.type.isSimpleType() ? "extends com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer " : "extends com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializer "));
        return string;
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.beanClass = this.getClassName().substring(0, this.className.lastIndexOf("_Deser"));
        printWriter.println("    /**");
        printWriter.println("     * Constructor");
        printWriter.println("     */");
        printWriter.println("    public " + this.getClassName() + "(");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType, ");
        printWriter.println("           com.ibm.ws.webservices.engine.description.TypeDesc _typeDesc) {");
        printWriter.println("        super(_javaType, _xmlType, _typeDesc);");
        printWriter.println("    }");
        if (!this.type.isSimpleType()) {
            Boolean bl = (Boolean)this.type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            if (!(this.type.isAbstract() || bl != null && bl.booleanValue() || !this.emitExtraMethods)) {
                this.buildQNames();
                this.writeCreateValue(printWriter);
                this.writeTryElementSetFromString(printWriter);
                this.writeTryAttributeSetFromString(printWriter);
                this.writeTryElementSetFromObject(printWriter);
                this.writeTryElementSetFromList(printWriter);
                this.writeQNames(printWriter, "    ", "private");
            }
        }
    }

    private void writeCreateValue(PrintWriter printWriter) throws IOException {
        printWriter.println("    /**");
        printWriter.println("     * Create instance of java bean");
        printWriter.println("     */");
        printWriter.println("    public void createValue() {");
        this.startTolerateCheckedException(printWriter, "     ");
        printWriter.println("        value = new " + this.type.getName() + "();");
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    private void writeTryElementSetFromString(PrintWriter printWriter) throws IOException {
        printWriter.println("    protected boolean tryElementSetFromString(javax.xml.namespace.QName qName, java.lang.String strValue) {");
        this.startTolerateCheckedException(printWriter, "     ");
        String string = "if";
        if (this.elements != null) {
            String string2;
            String string3;
            String string4;
            ChildEntry childEntry;
            int n;
            for (n = 0; n < this.elements.size(); ++n) {
                childEntry = (ChildEntry)this.elements.get(n);
                if (!this.isAcceptable(childEntry)) continue;
                string4 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                string3 = this.getParseText(string4, childEntry.getType());
                string2 = (String)this._qNameMap.get(childEntry.getQName());
                if (string3 == null || string2 == null || string4.lastIndexOf("]") - string4.indexOf("[") >= 2) continue;
                this.elementSetFromStringList.add(childEntry);
            }
            if (this.elementSetFromStringList.size() <= 25) {
                for (n = 0; n < this.elementSetFromStringList.size(); ++n) {
                    childEntry = (ChildEntry)this.elementSetFromStringList.get(n);
                    string4 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    string3 = this.getParseText(string4, childEntry.getType());
                    string2 = (String)this._qNameMap.get(childEntry.getQName());
                    printWriter.println("        " + string + " (qName==" + string2 + ") {");
                    printWriter.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(childEntry)) {
                        printWriter.println(childEntry.getName() + "=" + string3 + ";");
                    } else {
                        printWriter.println(JavaBeanWriter.setterMethodName(childEntry) + "(" + string3 + ");");
                    }
                    printWriter.println("          return true;}");
                    string = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            printWriter.println("        return false;");
        } else {
            printWriter.println("        return super.tryElementSetFromString(qName, strValue);");
        }
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    private void writeTryAttributeSetFromString(PrintWriter printWriter) throws IOException {
        printWriter.println("    protected boolean tryAttributeSetFromString(javax.xml.namespace.QName qName, java.lang.String strValue) {");
        this.startTolerateCheckedException(printWriter, "     ");
        String string = "if";
        if (this.attributes != null) {
            String string2;
            String string3;
            String string4;
            ChildEntry childEntry;
            int n;
            ArrayList<ChildEntry> arrayList = new ArrayList<ChildEntry>();
            for (n = 0; n < this.attributes.size(); ++n) {
                childEntry = (ChildEntry)this.attributes.get(n);
                if (!this.isAcceptable(childEntry)) continue;
                string4 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                string3 = this.getParseText(string4, childEntry.getType());
                string2 = (String)this._qNameMap.get(childEntry.getQName());
                if (string3 == null || string2 == null || string4.lastIndexOf("]") - string4.indexOf("[") >= 2) continue;
                arrayList.add(childEntry);
            }
            if (arrayList.size() <= 25) {
                for (n = 0; n < arrayList.size(); ++n) {
                    childEntry = (ChildEntry)arrayList.get(n);
                    string4 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    string3 = this.getParseText(string4, childEntry.getType());
                    string2 = (String)this._qNameMap.get(childEntry.getQName());
                    printWriter.println("        " + string + " (qName==" + string2 + ") {");
                    printWriter.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(childEntry)) {
                        printWriter.println(childEntry.getName() + "=" + string3 + ";");
                    } else {
                        printWriter.println(JavaBeanWriter.setterMethodName(childEntry) + "(" + string3 + ");");
                    }
                    printWriter.println("          return true;}");
                    string = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            printWriter.println("        return false;");
        } else {
            printWriter.println("        return super.tryAttributeSetFromString(qName, strValue);");
        }
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    private void writeTryElementSetFromObject(PrintWriter printWriter) throws IOException {
        printWriter.println("    protected boolean tryElementSetFromObject(javax.xml.namespace.QName qName, java.lang.Object objValue) {");
        this.startTolerateCheckedException(printWriter, "     ");
        printWriter.println("        if (objValue == null) {");
        printWriter.println("          return true;");
        printWriter.println("        }");
        String string = "if";
        if (this.elements != null) {
            String string2;
            String string3;
            String string4;
            ChildEntry childEntry;
            int n;
            ArrayList<ChildEntry> arrayList = new ArrayList<ChildEntry>();
            ClassFactory classFactory = this.emitter.getToolEnv().getClassFactory();
            for (n = 0; n < this.elements.size(); ++n) {
                childEntry = (ChildEntry)this.elements.get(n);
                if (!this.isAcceptable(childEntry) || (string4 = (String)this._qNameMap.get(childEntry.getQName())) == null || childEntry.getType().isCollectionTypeEntry() || ((ChildElement)childEntry).getAnyElement() || this.elementSetFromStringList.contains(childEntry) || this.collectionType.isAssignableFrom((EClassifier)(string3 = classFactory.forName(string2 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE)))) || string2.lastIndexOf("]") - string2.indexOf("[") >= 2) continue;
                arrayList.add(childEntry);
            }
            if (arrayList.size() <= 25) {
                for (n = 0; n < arrayList.size(); ++n) {
                    childEntry = (ChildEntry)arrayList.get(n);
                    string4 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    string2 = (String)this._qNameMap.get(childEntry.getQName());
                    string3 = "";
                    String string5 = "";
                    printWriter.println("        " + string + " (qName==" + string2 + ") {");
                    if (string4.lastIndexOf("]") - string4.indexOf("[") == 1 && string4.indexOf(".") > 0) {
                        printWriter.println("          if (objValue instanceof java.util.List) {");
                        printWriter.println("            " + string4 + " array = new " + string4.substring(0, string4.length() - 1) + "((java.util.List)objValue).size()];");
                        printWriter.println("            ((java.util.List)objValue).toArray(array);");
                        printWriter.print("            ((" + this.beanClass + ")value).");
                        if (JavaBeanWriter.isDataMember(childEntry)) {
                            printWriter.println(childEntry.getName() + "=array;");
                        } else {
                            printWriter.println(JavaBeanWriter.setterMethodName(childEntry) + "(array);");
                        }
                        printWriter.println("          } else { ");
                        string3 = "  ";
                        string5 = "}";
                    }
                    printWriter.print(string3 + "          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(childEntry)) {
                        printWriter.println(childEntry.getName() + "=(" + string4 + ")objValue;" + string5);
                    } else {
                        printWriter.println(JavaBeanWriter.setterMethodName(childEntry) + "((" + string4 + ")objValue);" + string5);
                    }
                    printWriter.println("          return true;}");
                    string = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            printWriter.println("        return false;");
        } else {
            printWriter.println("        return super.tryElementSetFromObject(qName, objValue);");
        }
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    private void writeTryElementSetFromList(PrintWriter printWriter) throws IOException {
        printWriter.println("    protected boolean tryElementSetFromList(javax.xml.namespace.QName qName, java.util.List listValue) {");
        this.startTolerateCheckedException(printWriter, "     ");
        String string = "if";
        if (this.elements != null) {
            String string2;
            String string3;
            ChildEntry childEntry;
            int n;
            ArrayList<ChildEntry> arrayList = new ArrayList<ChildEntry>();
            for (n = 0; n < this.elements.size(); ++n) {
                childEntry = (ChildEntry)this.elements.get(n);
                if (!this.isAcceptable(childEntry)) continue;
                string3 = (String)this._qNameMap.get(childEntry.getQName());
                string2 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                if (string3 == null || !childEntry.getType().isCollectionTypeEntry() || string2.lastIndexOf("]") - string2.indexOf("[") != 1 || string2.indexOf(".") <= 0 || ((ChildElement)childEntry).getAnyElement()) continue;
                arrayList.add(childEntry);
            }
            if (arrayList.size() <= 25) {
                for (n = 0; n < arrayList.size(); ++n) {
                    childEntry = (ChildEntry)arrayList.get(n);
                    string3 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
                    string2 = (String)this._qNameMap.get(childEntry.getQName());
                    printWriter.println("        " + string + " (qName==" + string2 + ") {");
                    printWriter.println("          " + string3 + " array = new " + string3.substring(0, string3.length() - 1) + "listValue.size()];");
                    printWriter.println("          listValue.toArray(array);");
                    printWriter.print("          ((" + this.beanClass + ")value).");
                    if (JavaBeanWriter.isDataMember(childEntry)) {
                        printWriter.println(childEntry.getName() + "=array;");
                    } else {
                        printWriter.println(JavaBeanWriter.setterMethodName(childEntry) + "(array);");
                    }
                    printWriter.println("          return true;}");
                    string = "else if";
                }
            }
        }
        if (this.isBaseClass()) {
            printWriter.println("        return false;");
        } else {
            printWriter.println("        return super.tryElementSetFromList(qName, listValue);");
        }
        this.endTolerateCheckedException(printWriter, "     ");
        printWriter.println("    }");
    }

    private boolean isAcceptable(ChildEntry childEntry) {
        boolean bl;
        boolean bl2 = bl = childEntry.getDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME) == null ? false : (Boolean)childEntry.getDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME);
        return !bl;
    }

    private String getParseText(String string, TypeEntry typeEntry) {
        String string2 = (String)parseText.get(string);
        if (string2 == null) {
            if (string.equals("java.util.Calendar")) {
                if (Constants.equals(typeEntry.getQName(), Constants.XSD_DATE)) {
                    string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateToCalendar(strValue)";
                } else if (Constants.equals(typeEntry.getQName(), Constants.XSD_DATETIME)) {
                    string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateTimeToCalendar(strValue)";
                } else if (Constants.equals(typeEntry.getQName(), Constants.XSD_TIME)) {
                    string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseTimeToCalendar(strValue)";
                }
            } else if (string.equals("java.util.Date") && Constants.equals(typeEntry.getQName(), Constants.XSD_DATETIME)) {
                string2 = "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDateTimeToDate(strValue)";
            }
        }
        return string2;
    }

    static {
        parseText.put("java.lang.String", "strValue");
        parseText.put("int", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseint(strValue)");
        parseText.put("boolean", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseboolean(strValue)");
        parseText.put("char", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsechar(strValue)");
        parseText.put("long", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parselong(strValue)");
        parseText.put("double", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsedouble(strValue)");
        parseText.put("short", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseshort(strValue)");
        parseText.put("float", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsefloat(strValue)");
        parseText.put("byte", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parsebyte(strValue)");
        parseText.put("java.lang.Integer", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseInteger(strValue)");
        parseText.put("java.lang.Boolean", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBoolean(strValue)");
        parseText.put("java.lang.Character", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseCharacter(strValue)");
        parseText.put("java.lang.Long", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseLong(strValue)");
        parseText.put("java.lang.Double", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseDouble(strValue)");
        parseText.put("java.lang.Short", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseShort(strValue)");
        parseText.put("java.lang.Float", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseFloat(strValue)");
        parseText.put("java.lang.Byte", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseByte(strValue)");
        parseText.put("java.math.BigInteger", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBigInteger(strValue)");
        parseText.put("java.math.BigDecimal", "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer.parseBigDecimal(strValue)");
    }
}

