/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.URLHashSet;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AIRWriter
extends JavaClassWriter {
    private Emitter emitter;
    private Definition definition;
    private SymbolTable symbolTable;
    private URLHashSet writtenFiles = new URLHashSet();

    protected AIRWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, AIRWriter.getName(emitter, definition), "importResolver");
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    private static String getName(Emitter emitter, Definition definition) {
        QName qName = QNameTable.createQName(definition.getTargetNamespace(), "_AbsoluteImportResolver");
        return emitter.getJavaName(qName);
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.wsdl.ImportResolver ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeResolutions(printWriter);
        this.writeResolveMethod(printWriter);
    }

    private void writeResolutions(PrintWriter printWriter) throws IOException {
        try {
            printWriter.println("    private static java.util.Hashtable resolutions = new java.util.Hashtable();");
            String string = this.symbolTable.getWSDLURI();
            URL uRL = Utils.getURL(null, string);
            printWriter.println("    static {");
            printWriter.println("        String content;");
            Document document = XMLUtils.newDocument(string);
            this.writeWSDLResolutions(printWriter, uRL, this.definition, document);
            printWriter.println("    }");
            printWriter.println();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.wsdl.toJava.AIRWriter.writeResolutions", (String)"115", (Object)this);
            throwable.printStackTrace();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable.getMessage());
        }
    }

    private void writeXSDResolutions(PrintWriter printWriter, URL uRL, Node node) throws IOException, ParserConfigurationException, SAXException {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if ("import".equals(node2.getLocalName()) || "include".equals(node2.getLocalName()) || "redefine".equals(node2.getLocalName())) {
                    String string;
                    URL uRL2;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Node node3 = namedNodeMap.getNamedItem("namespace");
                    if (node3 != null && Constants.isSOAP_ENC(node3.getNodeValue())) continue;
                    Node node4 = namedNodeMap.getNamedItem("schemaLocation");
                    if (node4 != null && !this.writtenFiles.contains(uRL2 = Utils.getURL(uRL, string = node4.getNodeValue()))) {
                        this.writtenFiles.add(uRL2);
                        if (this.isAbsolute(uRL2)) {
                            this.writeFile(printWriter, uRL2, string);
                        }
                        this.writeXSDResolutions(printWriter, uRL2, XMLUtils.newDocument(uRL2.toString()));
                    }
                }
                this.writeXSDResolutions(printWriter, uRL, node2);
            }
        }
    }

    private void writeWSDLResolutions(PrintWriter printWriter, URL uRL, Definition definition, Document document) throws IOException, ParserConfigurationException, SAXException {
        if (document != null) {
            this.writeXSDResolutions(printWriter, uRL, document);
        }
        if (definition != null) {
            Map map = definition.getImports();
            Object[] objectArray = map.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Vector vector = (Vector)map.get(objectArray[i]);
                for (int j = 0; j < vector.size(); ++j) {
                    Import import_ = (Import)vector.get(j);
                    String string = import_.getLocationURI();
                    if (this.writtenFiles.contains(string)) continue;
                    this.writtenFiles.add(string);
                    URL uRL2 = Utils.getURL(uRL, string);
                    if (this.isAbsolute(uRL2)) {
                        this.writeFile(printWriter, uRL2, string);
                    }
                    this.writeWSDLResolutions(printWriter, uRL2, import_.getDefinition(), XMLUtils.newDocument(uRL2.toString()));
                }
            }
        }
    }

    private boolean isAbsolute(URL uRL) {
        String string = uRL.getPath();
        return string == null || string.startsWith("/");
    }

    private void writeFile(PrintWriter printWriter, URL uRL, String string) throws IOException {
        printWriter.print("        content = \"");
        InputStream inputStream = uRL.openStream();
        int n = inputStream.read();
        while (n != -1) {
            char c = (char)n;
            if (c == '\"') {
                printWriter.print('\\');
                printWriter.print(c);
            } else if (c == '\n') {
                printWriter.println("\" +");
                printWriter.print("            \"");
            } else if (c != '\r') {
                printWriter.print(c);
            }
            n = inputStream.read();
        }
        printWriter.println("\";");
        printWriter.println("        resolutions.put(\"" + string + "\", content);");
        printWriter.println();
    }

    private void writeResolveMethod(PrintWriter printWriter) throws IOException {
        printWriter.println("    public java.io.InputStream resolve(java.lang.String location) {");
        printWriter.println("        java.lang.String contents = (String) resolutions.get(location);");
        printWriter.println("        java.io.InputStream is = null;");
        printWriter.println("        if (contents != null) {");
        printWriter.println("            is = new java.io.ByteArrayInputStream(contents.getBytes());");
        printWriter.println("        }");
        printWriter.println("        return is;");
        printWriter.println("    }");
        printWriter.println();
    }
}

