/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public abstract class TypeEntry
extends SymTabEntry
implements Serializable {
    protected Node node;
    protected List nodeStack;
    protected int refTypeSIDX;
    protected String dims = "";
    protected boolean onlyWrappedLiteralReferenced = false;
    private boolean isAbstract = false;

    protected TypeEntry(QName qName, Node node, List list, SymbolTable symbolTable) {
        super(qName, symbolTable);
        this.node = node;
        this.nodeStack = list;
        this.dims = "";
    }

    public void setRefType(TypeEntry typeEntry, String string) {
        this.refTypeSIDX = typeEntry.getSIDX();
        if (string == null) {
            string = "";
        }
        this.dims = string;
    }

    public Node getNode() {
        return this.node;
    }

    public List getNodeStack() {
        return this.nodeStack;
    }

    public boolean isOnlyWrappedLiteralReferenced() {
        return this.onlyWrappedLiteralReferenced;
    }

    void setOnlyWrappedLiteralReference(boolean bl) {
        this.onlyWrappedLiteralReferenced = bl;
    }

    protected TypeEntry getUndefinedTypeRef() {
        if (this instanceof Undefined) {
            return this;
        }
        TypeEntry typeEntry = this.getRefType();
        if (this.isUndefined() && typeEntry != null && typeEntry.isUndefined()) {
            TypeEntry typeEntry2 = typeEntry;
            while (!(typeEntry2 instanceof Undefined)) {
                typeEntry2 = typeEntry2.getRefType();
            }
            return typeEntry2;
        }
        return null;
    }

    protected boolean isUndefined() {
        if (this instanceof Undefined) {
            return true;
        }
        if (this.refTypeSIDX != 0) {
            return this.getRefType().isUndefined();
        }
        return false;
    }

    public TypeEntry getRefType() {
        return (TypeEntry)this.symbolTable.lookup(this.refTypeSIDX);
    }

    public String getDimensions() {
        return this.dims;
    }

    public boolean isBaseType() {
        if (this.dims.length() > 0) {
            return false;
        }
        TypeEntry typeEntry = this.getRefType();
        if (typeEntry != null) {
            return typeEntry.isBaseType();
        }
        return this.node == null;
    }

    public boolean isCollectionTypeEntry() {
        return this.qname.getLocalPart().indexOf(93) > 0;
    }

    void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        return super.toString(string) + string + "refTypeSIDX:   " + this.refTypeSIDX + "\n" + string + "Undefined?:    " + this.isUndefined() + "\n" + string + "isBaseType     " + this.isBaseType() + "\n" + (this.getNode() != null ? string + "Node:\n    " + this.getNode() + "\n" : string + "Node:          " + this.getNode() + "\n") + string + "NodeStack:     " + this.getNodeStack() + "\n" + string + "Dims:          " + this.dims + "\n" + string + "isAbstract     " + this.isAbstract + "\n" + string + "OnlyWrappedLitRef " + this.onlyWrappedLiteralReferenced + "\n";
    }
}

