/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.introspect;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.tools.resource.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.BeanPropertyDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.BeanUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;

public class TypeEntryIntrospector {
    protected static Log log = LogFactory.getLog(TypeEntryIntrospector.class.getName());
    private Emitter emitter;
    private ClassFactory classFactory;
    private SymbolTable symbolTable;

    TypeEntryIntrospector(Emitter emitter) {
        this.emitter = emitter;
        this.classFactory = emitter.getToolEnv().getClassFactory();
        this.symbolTable = emitter.getSymbolTable();
    }

    void introspect1(TypeEntry typeEntry) {
        if (typeEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaHelpers = this.findType(typeEntry);
    }

    void introspect2(TypeEntry typeEntry) {
        boolean bl;
        if (typeEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        JavaHelpers javaHelpers = this.findType(typeEntry);
        if (javaHelpers == null) {
            return;
        }
        if (!TypeEntryIntrospector.compatibleBeanTest(javaHelpers)) {
            return;
        }
        if (!(typeEntry instanceof Type)) {
            return;
        }
        JavaClass javaClass = (JavaClass)javaHelpers;
        if (this.emitter.isDebug()) {
            this.symbolTable.getToolEnv().report(Messages.getMessage("introspectClass00", typeEntry.getQName().toString(), javaClass.infoString()));
        }
        Type type = (Type)typeEntry;
        List list = BeanUtils.getPd(javaClass, this.emitter.getToolEnv());
        Boolean bl2 = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        boolean bl3 = bl = bl2 != null ? bl2 : false;
        if (type.isEnumeration()) {
            this.processEnumChildren(type, javaClass);
            this.validateEnumeration(javaClass);
        } else {
            this.processChildren(type, list, bl);
            if (bl) {
                this.validateException(type, javaHelpers, typeEntry);
            } else {
                this.validateBean(type, javaHelpers);
            }
        }
    }

    JavaHelpers findType(TypeEntry typeEntry) {
        return TypeEntryIntrospector.locateClass(typeEntry, this.emitter, this.classFactory);
    }

    private void processChildren(Type type, List list, boolean bl) {
        if (type.getChildren() != null) {
            for (int i = 0; i < type.getChildren().size(); ++i) {
                ChildEntry childEntry = (ChildEntry)type.getChildren().get(i);
                TypeEntryIntrospector.processChild(type, childEntry, list, bl, this.emitter, this.symbolTable, this.classFactory);
            }
        }
    }

    static void processChild(Entry entry, ChildEntry childEntry, List list, boolean bl, Emitter emitter, SymbolTable symbolTable, ClassFactory classFactory) {
        Object object;
        int n;
        Object object2 = null;
        String string = childEntry.getName();
        for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
            object = (BeanPropertyDescriptor)list.get(n);
            if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
            object2 = object;
        }
        if (object2 == null) {
            string = childEntry.getQName().getLocalPart();
            for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
                object = (BeanPropertyDescriptor)list.get(n);
                if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
                object2 = object;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, childEntry, string, false);
            }
        }
        if (object2 == null && "_value".equals(childEntry.getName()) && entry instanceof Type && ((Type)entry).isSimpleContent() && ((Type)entry).getExtensionBase() != null) {
            string = "value";
            for (n = 0; list != null && n < list.size() && object2 == null; ++n) {
                object = (BeanPropertyDescriptor)list.get(n);
                if (!((BeanPropertyDescriptor)object).getName().equals(string)) continue;
                object2 = object;
                com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, childEntry, string, false);
            }
        }
        if (object2 == null) {
            emitter.getToolEnv().reportFatalErr(Messages.getMessage(bl ? "noFaultProperty00" : "noBeanProperty00", entry.getName(), childEntry.getName()));
            return;
        }
        if (((BeanPropertyDescriptor)object2).isField()) {
            childEntry.setDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER, Boolean.TRUE);
        } else {
            childEntry.setDynamicVar(JavaGeneratorFactory.GET_METHOD_NAME, ((BeanPropertyDescriptor)object2).getReadMethodName());
            childEntry.setDynamicVar(JavaGeneratorFactory.SET_METHOD_NAME, ((BeanPropertyDescriptor)object2).getWriteMethodName());
            if (!bl && ((BeanPropertyDescriptor)object2).getWriteMethodName() == null) {
                String string2 = Messages.getMessage("noSetterMethod00", entry.getName(), childEntry.getName(), ((BeanPropertyDescriptor)object2).getReadMethodName());
                childEntry.setDynamicVar(JavaGeneratorFactory.MISSING_SETTER_NAME, Boolean.TRUE);
                Object object3 = object = symbolTable.getMetaInfo() == null ? null : (String)symbolTable.getMetaInfo().getProperty("MMDVersion");
                if ("1.0".equals(object)) {
                    emitter.getToolEnv().reportWarning(string2);
                } else {
                    emitter.getToolEnv().reportFatalErr(string2);
                }
            }
        }
        if (((BeanPropertyDescriptor)object2).hasCheckedException()) {
            entry.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        JavaGeneratorFactory.defaultChildJavaType(childEntry);
        String string3 = (String)childEntry.getDynamicVar(JavaGeneratorFactory.JAVA_TYPE);
        object = childEntry.getType();
        while (!(object instanceof Type) && !((TypeEntry)object).isCollectionTypeEntry()) {
            object = ((TypeEntry)object).getRefType();
        }
        BooleanHolder booleanHolder = new BooleanHolder();
        String string4 = TypeEntryIntrospector.compatibleTypeTest(((BeanPropertyDescriptor)object2).getRawType(), string3, (TypeEntry)object, emitter.getFactory().getBaseTypeMapping().getTypeMapping(), classFactory, symbolTable, false, true, booleanHolder);
        if (string4 == null) {
            emitter.getToolEnv().reportFatalErr(Messages.getMessage(bl ? "invalidFault02" : "incompatibleTypes02", entry.getName(), ((BeanPropertyDescriptor)object2).getRawType().getJavaName(), string3));
        } else if (!string4.equals(string3)) {
            childEntry.setDynamicVar(JavaGeneratorFactory.JAVA_TYPE, string4);
            if (booleanHolder.value) {
                emitter.getToolEnv().reportWarning(Messages.getMessage(bl ? "invalidFault02" : "incompatibleTypes02", entry.getName(), ((BeanPropertyDescriptor)object2).getRawType().getJavaName(), string3));
            }
        }
    }

    private void validateBean(Type type, JavaHelpers javaHelpers) {
        EList eList;
        this.extensionCheck(type, javaHelpers);
        JavaClass javaClass = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (javaClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        String string = javaHelpers.getJavaName().substring(javaHelpers.getJavaName().lastIndexOf(46) + 1);
        boolean bl = false;
        Method method = ((JavaClass)javaHelpers).getPublicMethod(string, new ArrayList());
        boolean bl2 = bl = method != null;
        if (!bl && !((JavaClass)javaHelpers).isInterface()) {
            eList = ((JavaClass)javaHelpers).getMethods();
            if (eList == null) {
                bl = true;
            } else {
                boolean bl3 = false;
                for (int i = 0; !bl3 && i < eList.size(); ++i) {
                    bl3 = ((Method)eList.get(i)).getName().equals(string);
                }
                boolean bl4 = bl = !bl3;
            }
        }
        if (bl && method != null && method.getJavaExceptions() != null && method.getJavaExceptions().size() > 0) {
            type.setDynamicVar("throwsCheckedException", Boolean.TRUE);
        }
        if (!bl) {
            eList = this.classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
            boolean bl5 = bl = type.isSimpleTypeOrSimpleContent() && eList.isAssignableFrom((EClassifier)javaHelpers);
        }
        if (!bl && !type.isAbstract()) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean00", javaHelpers.getJavaName(), string));
        }
    }

    private void validateException(Type type, JavaHelpers javaHelpers, TypeEntry typeEntry) {
        this.extensionCheck(type, javaHelpers);
        JavaClass javaClass = (JavaClass)this.classFactory.forName("java.lang.Throwable");
        if (javaClass == null) {
            throw new InternalException(new ClassNotFoundException("java.lang.Throwable"));
        }
        if (!javaClass.isAssignableFrom((EClassifier)javaHelpers)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault00", javaHelpers.getJavaName(), "java.lang.Throwable"));
        }
        boolean bl = false;
        String string = javaHelpers.getJavaName().substring(javaHelpers.getJavaName().lastIndexOf(46) + 1);
        List list = ((JavaClass)javaHelpers).getPublicMethodsNamed(string);
        ArrayList arrayList = (ArrayList)typeEntry.getDynamicVar("constructorOrder");
        if (list.size() == 0 && arrayList.size() == 0) {
            bl = true;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Method method = (Method)list.get(i);
                EList eList = method.getParameters();
                if (eList.size() != arrayList.size()) continue;
                bl = true;
                if (method.getJavaExceptions() == null || method.getJavaExceptions().size() <= 0) continue;
                type.setDynamicVar("throwsCheckedException", Boolean.TRUE);
            }
        }
        if (!bl) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidFault01", javaHelpers.getJavaName(), string, String.valueOf(arrayList.size())));
        }
    }

    private void extensionCheck(Type type, JavaHelpers javaHelpers) {
        Type type2 = type.getExtensionBase();
        if (type2 == null || type.isSimpleTypeOrSimpleContent()) {
            return;
        }
        JavaHelpers javaHelpers2 = this.findType(type2);
        JavaClass javaClass = ((JavaClass)javaHelpers).getSupertype();
        if (!javaClass.equals(javaHelpers2)) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidBean02", javaHelpers.getJavaName(), javaClass.getJavaName(), type2.getName()));
        }
    }

    private void validateEnumeration(JavaClass javaClass) {
        List list = javaClass.getPublicMethodsNamed("getValue");
        if (list.size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "getValue"));
        }
        if ((list = javaClass.getPublicMethodsNamed("fromValue")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "fromValue"));
        }
        if ((list = javaClass.getPublicMethodsNamed("fromString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "fromString"));
        }
        if ((list = javaClass.getPublicMethodsNamed("toString")).size() < 1) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum00", javaClass.getJavaName(), "toString"));
        }
        if ((list = javaClass.getPublicMethodsNamed("setValue")).size() > 0) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("invalidEnum01", javaClass.getJavaName(), "setValue"));
        }
    }

    private void processEnumChildren(Type type, JavaClass javaClass) {
        EList eList = javaClass.getFields();
        for (int i = 0; i < eList.size(); ++i) {
            Field field = (Field)eList.get(i);
            String string = com.ibm.ws.webservices.wsdl.fromJava.Utils.getInitialValue(field);
            if (string == null && field.getName().charAt(0) == '_') continue;
            ChildEnumValueEntry childEnumValueEntry = null;
            for (int j = 0; j < type.getChildren().size() && childEnumValueEntry == null; ++j) {
                ChildEnumValueEntry childEnumValueEntry2 = (ChildEnumValueEntry)type.getChildren().get(j);
                if (!childEnumValueEntry2.getEnumValue().equals(string)) continue;
                childEnumValueEntry = childEnumValueEntry2;
            }
            if (childEnumValueEntry == null) continue;
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(this.symbolTable, childEnumValueEntry, field.getName().substring(1), false);
        }
    }

    static String compatibleTypeTest(JavaHelpers javaHelpers, String string, TypeEntry typeEntry, TypeMapping typeMapping, ClassFactory classFactory, SymbolTable symbolTable, boolean bl, boolean bl2, BooleanHolder booleanHolder) {
        Object object;
        String string2 = javaHelpers.getJavaName();
        if (string2.equals(string)) {
            return string2;
        }
        if (string2.equals("javax.xml.soap.SOAPElement") || string2.equals("org.w3c.dom.Element")) {
            if (!bl) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        QName qName = com.ibm.ws.webservices.wsdl.fromJava.Utils.getTypeQName(javaHelpers, typeMapping, classFactory);
        if (qName != null && qName.equals(typeEntry.getQName())) {
            if (string2 != string && (string2.equals(Utils.getWrapperType(string)) || string.equals(Utils.getWrapperType(string2)))) {
                if (bl2) {
                    booleanHolder.value = true;
                } else {
                    return null;
                }
            }
            return string2;
        }
        if (Constants.equals(typeEntry.getQName(), Constants.XSD_ANY) && string2.equals("javax.xml.soap.SOAPElement[]")) {
            return string2;
        }
        JavaHelpers javaHelpers2 = classFactory.forName("com.ibm.ws.webservices.engine.encoding.SimpleType");
        if (javaHelpers2 != null && ((Type)typeEntry).isSimpleType() && javaHelpers2.isAssignableFrom((EClassifier)javaHelpers)) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, string2, true);
            if (!bl) {
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        if (((Type)typeEntry).isEnumeration() && string2.equals(((Entry)(object = ((Type)typeEntry).getRestrictionBase())).getName())) {
            if (!bl) {
                ((Type)typeEntry).setEnumeration(false);
                return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
            }
            return string2;
        }
        if (string.equals("java.lang.Object[]") && (object = classFactory.forName("java.util.Collection")).isAssignableFrom((EClassifier)javaHelpers)) {
            return string2;
        }
        if (string2.indexOf("[]") > 0) {
            object = typeEntry.getDimensions();
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) {
                typeEntry2 = (TypeEntry)typeEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
                object = "[]";
            }
            if (typeEntry2 != null) {
                if (((String)object).length() == 0) {
                    string2 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers, string, typeEntry2, typeMapping, classFactory, symbolTable, bl, bl2, booleanHolder);
                    if (!bl && string2 != null) {
                        return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
                    }
                    return string2;
                }
                int n = string2.lastIndexOf((String)object);
                int n2 = string.lastIndexOf((String)object);
                if (n >= 0 && n2 >= 0) {
                    JavaHelpers javaHelpers3 = classFactory.forName(string2.substring(0, n));
                    String string3 = TypeEntryIntrospector.compatibleTypeTest(javaHelpers3, string.substring(0, n2), typeEntry2, typeMapping, classFactory, symbolTable, bl, bl2, booleanHolder);
                    if (string3 != null) {
                        string2 = string3 + (String)object;
                        if (!bl && string2 != null) {
                            return TypeEntryIntrospector.setJavaName(symbolTable, typeEntry, string2);
                        }
                        return string2;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private static String setJavaName(SymbolTable symbolTable, TypeEntry typeEntry, String string) {
        boolean bl;
        boolean bl2 = bl = typeEntry.getDynamicVar("oldName2") != null;
        if (bl && !string.equals(typeEntry.getName())) {
            return null;
        }
        com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(symbolTable, typeEntry, string, false);
        return string;
    }

    static boolean compatibleBeanTest(JavaHelpers javaHelpers) {
        if (!(javaHelpers instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)javaHelpers;
        String string = javaHelpers.getJavaName();
        if (javaClass.isArray() || javaHelpers.isPrimitive()) {
            return false;
        }
        return !string.startsWith("java.") && !string.startsWith("javax.") && !string.startsWith("com.ibm.ws.webservices.engine.types") && !string.startsWith("org.w3c.dom");
    }

    public static JavaHelpers locateClass(SymTabEntry symTabEntry, Emitter emitter, ClassFactory classFactory) {
        String string;
        String string2 = "";
        JavaHelpers javaHelpers = null;
        TypeEntry typeEntry = (TypeEntry)symTabEntry.getDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN);
        if (typeEntry != null && (javaHelpers = classFactory.forName(string2 = emitter.getJavaName(symTabEntry.getQName()))) != null) {
            symTabEntry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
        }
        if (javaHelpers == null) {
            string2 = symTabEntry.getName();
            javaHelpers = classFactory.forName(string2);
        }
        if (javaHelpers == null && typeEntry != null && (string = TypeEntryIntrospector.locateClass(typeEntry, emitter, classFactory)) != null) {
            string2 = string.getJavaName() + "[]";
            javaHelpers = classFactory.forName(string2);
        }
        if (javaHelpers == null) {
            string = symTabEntry.getQName().getLocalPart();
            String string3 = emitter.getNamespaces().getCreate(symTabEntry.getQName().getNamespaceURI());
            string2 = string3 + "." + string;
            javaHelpers = classFactory.forName(string2);
            if (javaHelpers == null) {
                string2 = string3 + "." + JavaUtils.xmlNameToJavaClass(string);
                javaHelpers = classFactory.forName(string2);
            }
            if (javaHelpers != null) {
                symTabEntry.setDynamicVar(SymbolTable.WRAPPED_ARRAY_PATTERN, null);
            }
        }
        if (javaHelpers != null && !string2.equals(symTabEntry.getName())) {
            com.ibm.ws.webservices.wsdl.mapping.Utils.setJavaName(emitter.getSymbolTable(), symTabEntry, string2, false);
        }
        return javaHelpers;
    }
}

