/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.sysengine;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.soap.container.SoapContainerRouter;
import com.ibm.ws.soap.container.SoapContainerService;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.WebServicesSystemService;
import com.ibm.ws.webservices.component.WSSysServerImpl;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.metadata.SysServerModuleMetaData;
import com.ibm.ws.webservices.sysengine.SystemEndpointContextImpl;
import com.ibm.ws.webservices.trace.MessageTrace;
import com.ibm.wsspi.soapcontainer.SOAPRequest;
import com.ibm.wsspi.soapcontainer.SOAPResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;

public class SystemEngineRouter
implements SoapContainerRouter,
MessageContext.OneWayListener {
    public static final String DOUBLE_QUOTES = "\"";
    protected static Log log = LogFactory.getLog(SystemEngineRouter.class.getName());

    public void doPost(SOAPRequest sOAPRequest, SOAPResponse sOAPResponse, Object object) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter SystemEngineRouter.doPost()");
        }
        SysServerModuleMetaData sysServerModuleMetaData = (SysServerModuleMetaData)object;
        String string = null;
        MessageContext messageContext = null;
        Message message = null;
        WebServicesEngine webServicesEngine = null;
        try {
            webServicesEngine = this.getEngine();
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"76", (Object)this);
            log.error((Object)Messages.getMessage("noEngine00"), (Throwable)webServicesFault);
            throw new RuntimeException(webServicesFault);
        }
        try {
            messageContext = this.createMessageContext(webServicesEngine, sOAPRequest, sOAPResponse);
            InputStream inputStream = sOAPRequest.getInputStream();
            byte[] byArray = null;
            boolean bl = MessageTrace.isTraceEnabled();
            if (bl) {
                byArray = this.extractRequestBytesForTrace(sOAPRequest, inputStream);
                inputStream = new ByteArrayInputStream(byArray);
            }
            String string2 = sOAPRequest.getHeader("Content-Type");
            Message message2 = new Message(inputStream, string2, sOAPRequest.getHeader("Content-Location"));
            messageContext.setRequestMessage(message2);
            if (bl && byArray != null) {
                MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, string2, byArray);
            }
            try {
                string = this.getSoapAction(sOAPRequest);
                if (string != null) {
                    messageContext.setUseSOAPAction(true);
                    messageContext.setSOAPActionURI(string);
                } else {
                    messageContext.setUseSOAPAction(false);
                    messageContext.setSOAPActionURI(string);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invoking WebServices Engine.");
                }
                webServicesEngine.invoke(messageContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Return from WebServices Engine.");
                }
                if ((message = messageContext.getResponseMessage()) != null) {
                    message.ifFaultThrowSelf();
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"129", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
                int n = this.getHttpServletResponseStatus(webServicesFault);
                if (n == 401) {
                    sOAPResponse.setHeader("WWW-Authenticate", "Basic realm=\"WebServices\"");
                }
                sOAPResponse.setStatusCode(n);
                message = messageContext.getResponseMessage();
                if (message == null) {
                    message = new Message(webServicesFault);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"145", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                sOAPResponse.setStatusCode(500);
                message = messageContext.getResponseMessage();
                if (message == null) {
                    message = new Message(WebServicesFault.makeFault(exception));
                }
            }
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"162", (Object)this);
            log.error((Object)Messages.getMessage("webServicesFault00"), (Throwable)webServicesFault);
            message = messageContext.getResponseMessage();
            if (message == null) {
                message = new Message(webServicesFault);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"173", (Object)this);
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        if (message != null) {
            if (messageContext.isOneWay()) {
                log.error((Object)Messages.getMessage("servlet.unexpected.oneway.response00"));
            } else {
                try {
                    this.sendResponse(this.getProtocolVersion(sOAPRequest), message.getContentType(messageContext.getSOAPConstants()), sOAPResponse, message);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.doPost", (String)"181", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Response sent.");
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No Response Sent");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit SystemEngineRouter.doPost()");
        }
    }

    private byte[] extractRequestBytesForTrace(SOAPRequest sOAPRequest, InputStream inputStream) throws IOException {
        String string;
        byte[] byArray = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start copying SOAP request to trace buffer");
        }
        if ((string = sOAPRequest.getHeader("Content-Length")) != null) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"650", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)numberFormatException);
                n = inputStream.available();
            }
            byArray = new byte[n];
            int n2 = n;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = inputStream.read(byArray, n3, n2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Trace buffer needs " + n2 + " bytes at offset " + n3 + " got " + n4 + " bytes"));
                }
                if (n4 < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("End of stream with " + n2 + " bytes still expected"));
                    }
                    n2 = 0;
                    continue;
                }
                n2 -= n4;
                n3 += n4;
            }
        } else {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n = 0;
            int n5 = 0;
            while (n5 >= 0) {
                byte[] byArray2 = new byte[1024];
                n5 = inputStream.read(byArray2, 0, 1024);
                if (n5 < 0) continue;
                arrayList.add(byArray2);
                arrayList2.add(new Integer(n5));
                n += n5;
            }
            byArray = new byte[n];
            int n6 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray3 = (byte[])arrayList.get(i);
                int n7 = (Integer)arrayList2.get(i);
                System.arraycopy(byArray3, 0, byArray, n6, n7);
                n6 += n7;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Done copying SOAP request to trace buffer");
        }
        return byArray;
    }

    private WebServicesEngine getEngine() throws WebServicesFault {
        SoapContainerService soapContainerService = WSSysServerImpl.getWSSysServerImpl().getSOAPContainerService();
        WebServicesEngine webServicesEngine = (WebServicesEngine)soapContainerService.getEngine();
        if (webServicesEngine == null) {
            WebServicesSystemService webServicesSystemService = WebServicesServiceHome.getWebServicesSystemService();
            webServicesEngine = ServerEngine.getServer(webServicesSystemService, null);
            soapContainerService.cacheEngine(webServicesEngine);
        }
        return webServicesEngine;
    }

    private MessageContext createMessageContext(WebServicesEngine webServicesEngine, SOAPRequest sOAPRequest, SOAPResponse sOAPResponse) {
        Object object;
        MessageContext messageContext = new MessageContext(webServicesEngine);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MessageContext:" + messageContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + sOAPRequest.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + sOAPRequest.getHeader("Content-Location")));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + sOAPRequest.getRequestPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + sOAPRequest.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + sOAPRequest.getRemoteAddr()));
        }
        messageContext.setTransportName("http");
        String string = sOAPRequest.getRequestPathInfo();
        if (string != null) {
            object = string.substring(string.indexOf("/", 1));
            if (log.isDebugEnabled()) {
                log.debug((Object)("SystemEngineRouter.createMessageContext(engine, req, res): Setting msgcontext MC_RELATIVE_PATH to " + (String)object));
            }
            messageContext.setProperty("path", object);
        }
        if ((string = sOAPRequest.getHeader("Authorization")) != null) {
            messageContext.setProperty("Authorization", string);
        }
        if ((string = sOAPRequest.getRemoteAddr()) != null) {
            messageContext.setProperty("remoteaddr", string);
        }
        object = new SystemEndpointContextImpl(messageContext, sOAPRequest);
        messageContext.setProperty("servletEndpointContext", object);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, sOAPResponse);
        messageContext.addOneWayListener(this);
        return messageContext;
    }

    private String getSoapAction(SOAPRequest sOAPRequest) throws WebServicesFault {
        String string = sOAPRequest.getHeader("SOAPAction");
        if (log.isDebugEnabled()) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + string));
        }
        if (string == null) {
            WebServicesFault webServicesFault = new WebServicesFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)Messages.getMessage("genFault00"), (Throwable)webServicesFault);
            throw webServicesFault;
        }
        if (string.length() == 0) {
            string = null;
        }
        if (string.length() > 1 && string.startsWith(DOUBLE_QUOTES) && string.endsWith(DOUBLE_QUOTES)) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected int getHttpServletResponseStatus(WebServicesFault webServicesFault) {
        return webServicesFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    protected String getProtocolVersion(SOAPRequest sOAPRequest) {
        String string;
        int n;
        String string2 = HTTPConstants.HEADER_PROTOCOL_V10;
        String string3 = sOAPRequest.getProtocol();
        if (string3 != null && -1 != (n = string3.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((string = string3.substring(n + 1)).trim())) {
            string2 = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return string2;
    }

    private void sendResponse(String string, String string2, SOAPResponse sOAPResponse, Message message) throws WebServicesFault, Exception {
        if (message == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"NO WEBSERVICES MESSAGE TO RETURN!");
            }
            sOAPResponse.setStatusCode(204);
            String string3 = Messages.getMessage("noData00");
            sOAPResponse.setContentLength(string3.getBytes().length);
            OutputStream outputStream = sOAPResponse.getOutputStream();
            outputStream.write(string3.getBytes());
            outputStream.flush();
            sOAPResponse.finishResponse();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returned Content-Type:" + string2));
            }
            try {
                sOAPResponse.setContentType(string2);
                if (!MessageTrace.isTraceEnabled()) {
                    message.writeTo(sOAPResponse.getOutputStream());
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    message.writeTo(byteArrayOutputStream);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    sOAPResponse.getOutputStream().write(byArray);
                    MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, string2, byArray);
                }
                message.removeAllAttachments();
                sOAPResponse.finishResponse();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.sysengine.SystemEngineRouter.sendResponse", (String)"484", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            }
        }
    }

    public void oneWay(MessageContext messageContext) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter SystemEngineRouter.oneWay(owe)");
        }
        if ((object = messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE)) != null) {
            SOAPResponse sOAPResponse = (SOAPResponse)object;
            sOAPResponse.setContentLength(0);
            sOAPResponse.finishResponse();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit SystemEngineRouter.oneWay(owe)");
        }
    }
}

