/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderLocator;
import com.ibm.ws.webservices.multiprotocol.extensions.CompositeExtensionRegistry;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionDescription;
import com.ibm.ws.webservices.multiprotocol.extensions.ExtensionRegistrySupplier;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.multiprotocol.utils.WSDLFactoryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;

public class ServiceProviderManager {
    private static final TraceComponent _tc = Tr.register((Class)ServiceProviderManager.class, (String)"WebServices", (String)"com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    protected List additionalServiceProviders;
    protected Map namespace2ServiceProviderCache;
    protected WSDLFactoryImpl wsdlFactory;
    protected boolean useDiscovery;
    public static final String SERVICE_PROVIDER_PFX1 = "jaxrpc.service.provider.default.";
    public static final String SERVICE_PROVIDER_PFX2 = "jaxrpc.service.provider.uri.";
    static /* synthetic */ Class class$javax$wsdl$Input;
    static /* synthetic */ Class class$javax$wsdl$Output;

    public ServiceProviderManager() {
        this(null, true);
    }

    public ServiceProviderManager(List list) {
        this(list, true);
    }

    public ServiceProviderManager(List list, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"ServiceProviderManager ctor(Map,boolean)", (Object)new Object[]{list, new Boolean(bl)});
        }
        this.additionalServiceProviders = list;
        this.useDiscovery = bl;
        this.namespace2ServiceProviderCache = new HashMap();
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"ServiceProviderManger ctor(Map,boolean)");
        }
    }

    public Iterator getAllServiceProviders() {
        ArrayList<ServiceProvider> arrayList = new ArrayList<ServiceProvider>(this.getAdditionalProviders());
        arrayList.addAll(this.getDiscoveredServiceProviders());
        Collection collection = this.namespace2ServiceProviderCache.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)iterator.next();
            if (serviceProvider == null || arrayList.contains(serviceProvider)) continue;
            arrayList.add(serviceProvider);
        }
        return arrayList.iterator();
    }

    public ServiceProvider getServiceProvider(String string) {
        ServiceProvider serviceProvider = (ServiceProvider)this.namespace2ServiceProviderCache.get(string);
        if (serviceProvider == null) {
            ArrayList arrayList = this.getSupportingServiceProvider(string);
            serviceProvider = arrayList.size() == 0 ? null : (arrayList.size() == 1 ? (ServiceProvider)arrayList.get(0) : this.chooseServiceProvider(arrayList, string));
            this.namespace2ServiceProviderCache.put(string, serviceProvider);
        }
        return serviceProvider;
    }

    public boolean isServiceProviderAvailable(String string) {
        ServiceProvider serviceProvider = this.getServiceProvider(string);
        boolean bl = serviceProvider != null;
        return bl;
    }

    public void overrideDefaultServiceProvider(String string, ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            this.namespace2ServiceProviderCache.remove(string);
        } else {
            this.namespace2ServiceProviderCache.put(string, serviceProvider);
        }
    }

    public WSDLFactory getWSDLFactory() {
        if (this.wsdlFactory == null) {
            this.wsdlFactory = new WSDLFactoryImpl();
            ExtensionRegistry extensionRegistry = this.getExtensionRegistry();
            this.wsdlFactory.setPopulatedExtensionRegistry(extensionRegistry);
        }
        return this.wsdlFactory;
    }

    protected ExtensionRegistry getExtensionRegistry() {
        CompositeExtensionRegistry compositeExtensionRegistry = new CompositeExtensionRegistry();
        this.registerCommonExtensions(compositeExtensionRegistry);
        Iterator iterator = this.getAllServiceProviders();
        while (iterator.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)iterator.next();
            ExtensionDescription[] extensionDescriptionArray = serviceProvider.getExtensionDescriptions();
            if (extensionDescriptionArray != null) {
                for (int i = 0; i < extensionDescriptionArray.length; ++i) {
                    compositeExtensionRegistry.registerExtension(extensionDescriptionArray[i]);
                }
            }
            if (!(serviceProvider instanceof ExtensionRegistrySupplier)) continue;
            ExtensionRegistry extensionRegistry = ((ExtensionRegistrySupplier)((Object)serviceProvider)).getExtensionRegistry();
            compositeExtensionRegistry.addExtensionRegistry(extensionRegistry);
        }
        return compositeExtensionRegistry;
    }

    private void registerCommonExtensions(CompositeExtensionRegistry compositeExtensionRegistry) {
        compositeExtensionRegistry.registerExtension(new AgnosticAddress().getExtensionDescription());
        CompositeExtensionRegistry compositeExtensionRegistry2 = compositeExtensionRegistry;
        for (int i = 0; i < Constants.ACTIONS_WSA.length; ++i) {
            compositeExtensionRegistry2.registerExtensionAttributeType(class$javax$wsdl$Input == null ? ServiceProviderManager.class$("javax.wsdl.Input") : class$javax$wsdl$Input, Constants.ACTIONS_WSA[i], 0);
            compositeExtensionRegistry2.registerExtensionAttributeType(class$javax$wsdl$Output == null ? ServiceProviderManager.class$("javax.wsdl.Output") : class$javax$wsdl$Output, Constants.ACTIONS_WSA[i], 0);
        }
    }

    protected List getDiscoveredServiceProviders() {
        ArrayList arrayList = this.useDiscovery ? ServiceProviderLocator.getInstance().getServiceProviders() : new ArrayList();
        return arrayList;
    }

    protected ArrayList getSupportingServiceProvider(String string) {
        ArrayList<ServiceProvider> arrayList = new ArrayList<ServiceProvider>();
        Iterator iterator = this.getAllServiceProviders();
        while (iterator.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)iterator.next();
            if (!serviceProvider.isBindingNamespaceSupported(string)) continue;
            arrayList.add(serviceProvider);
        }
        return arrayList;
    }

    protected ServiceProvider chooseServiceProvider(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() < 1) {
            return null;
        }
        return (ServiceProvider)arrayList.get(0);
    }

    protected List getAdditionalProviders() {
        if (this.additionalServiceProviders == null) {
            this.additionalServiceProviders = new ArrayList();
        }
        return this.additionalServiceProviders;
    }
}

