/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientEntityMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.ws.webservices.multiprotocol.ServiceInformation;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOConvertorException;
import com.ibm.ws.webservices.multiprotocol.sdo.SDOWSDLAdder;
import com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation;
import com.ibm.ws.webservices.multiprotocol.utils.ServiceManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;

public class ServiceContext {
    private URL wsdlDocumentLocation;
    private Definition wsdlDefinition;
    private QName serviceName;
    private Map seiToPortTypeMapping;
    private Map portTypeToPortMapping;
    private Map namespace2PackageMapping;
    private ServiceInformation serviceInfo;
    private String defaultNamespace;
    private String serviceNamespace;
    private String locatorClassName;
    private String serviceRefName = null;
    private boolean managedEnv = false;
    private ClientEntityMetaData clientMetaData = null;
    private Map overriddingEndpointURIs = null;
    private Map overriddingBindingNamespaces = null;
    private Service protocolSpecificService;
    private ServiceManager serviceManager;
    private String sdoRepositoryKey;
    private QName sdoServiceName;
    private Service locator = null;
    private boolean dynamicRuntimeEnv = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ServiceContext: \n\tserviceName=");
        stringBuffer.append(this.serviceName != null ? this.serviceName.toString() : "<null>");
        stringBuffer.append("\n\tserviceRefName=");
        stringBuffer.append(this.serviceRefName != null ? this.serviceRefName : "<null>");
        stringBuffer.append("\n\tdefaultNamespace=");
        stringBuffer.append(this.defaultNamespace != null ? this.defaultNamespace : "<null>");
        stringBuffer.append("\n\tserviceNamespace=");
        stringBuffer.append(this.serviceNamespace != null ? this.serviceNamespace : "<null>");
        stringBuffer.append("\n\tlocatorClassName=");
        stringBuffer.append(this.locatorClassName != null ? this.locatorClassName : "<null>");
        stringBuffer.append("\n\tmanagedEnv=");
        stringBuffer.append(this.managedEnv ? "true" : "false");
        stringBuffer.append("\n\tclientReference=[");
        stringBuffer.append(this.clientMetaData != null ? this.clientMetaData.toString() : "<null>");
        stringBuffer.append("]\n\twsdlDocumentLocation=");
        stringBuffer.append(this.wsdlDocumentLocation != null ? this.wsdlDocumentLocation.toString() : "<null>");
        stringBuffer.append("\n\tWSDL Definition=\n****** WSDL Definition ******\n");
        stringBuffer.append(this.wsdlDefinition != null ? this.wsdlDefinition.toString() : "<none>");
        stringBuffer.append("\n\n****** End of WSDL Definition ******\n\n");
        return stringBuffer.toString();
    }

    public ServiceContext(URL uRL, Definition definition, QName qName) {
        this.wsdlDocumentLocation = uRL;
        this.wsdlDefinition = definition;
        this.serviceName = qName;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Definition getDefinition() {
        return this.wsdlDefinition;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    void setServiceName(QName qName) {
        if (qName != null) {
            this.serviceName = qName;
        }
    }

    public Map getSEIToPortTypeMapping() {
        return this.seiToPortTypeMapping;
    }

    public void setSEIToPortTypeMapping(Map map) {
        this.seiToPortTypeMapping = map;
    }

    public Map getPortTypeToPortMapping() {
        return this.portTypeToPortMapping;
    }

    public void setPortTypeToPortMapping(Map map) {
        this.portTypeToPortMapping = map;
    }

    public Map getNamespace2PackageMapping() {
        return this.namespace2PackageMapping;
    }

    public void setNamespace2PackageMapping(Map map) {
        this.namespace2PackageMapping = map;
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        return this.defaultNamespace;
    }

    public QName getPortQName(Port port2) {
        QName qName = QNameTable.createQName(this.getServiceNamespace(), port2.getName());
        return qName;
    }

    public QName getPortQName(String string) {
        QName qName = string == null ? null : QNameTable.createQName(this.getServiceNamespace(), string);
        return qName;
    }

    public Port getNamedPort(String string) {
        QName qName = QNameTable.createQName(this.getServiceName().getNamespaceURI(), string == null ? "" : string);
        Port port2 = this.getPortForQName(qName);
        return port2;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public void setServiceRefName(String string) {
        this.serviceRefName = string;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public ClientServiceMetaData getClientServiceMetaData() {
        ClientServiceMetaData clientServiceMetaData = null;
        if (this.clientMetaData != null) {
            clientServiceMetaData = this.clientMetaData.getService(this.serviceRefName);
        }
        return clientServiceMetaData;
    }

    public void setClientMetaData(ClientEntityMetaData clientEntityMetaData) {
        this.clientMetaData = clientEntityMetaData;
    }

    public ClientEngine getClientEngine() {
        if (this.clientMetaData != null) {
            return this.clientMetaData.getEngine();
        }
        return null;
    }

    public Port getPortForQName(QName qName) {
        javax.wsdl.Service service = this.getWSDLService();
        Port port2 = null;
        if (service != null && qName != null) {
            port2 = service.getPort(qName.getLocalPart());
        }
        return port2;
    }

    public Collection getServicePorts() {
        javax.wsdl.Service service = this.getWSDLService();
        Collection collection = service != null ? service.getPorts().values() : new ArrayList(0);
        return collection;
    }

    public javax.wsdl.Service getWSDLService() {
        javax.wsdl.Service service = null;
        Definition definition = this.getDefinition();
        if (definition != null) {
            QName qName = this.getServiceName();
            service = definition.getService(qName);
        }
        return service;
    }

    public String getServiceNamespace() {
        if (this.serviceNamespace == null) {
            QName qName = this.getServiceName();
            this.serviceNamespace = qName == null ? "" : qName.getNamespaceURI();
        }
        return this.serviceNamespace;
    }

    public List getPortsForPortType(QName qName) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.getServicePorts();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Port port2 = (Port)iterator.next();
            if (!port2.getBinding().getPortType().getQName().equals(qName)) continue;
            arrayList.add(port2.getName());
        }
        return arrayList;
    }

    public String getPortBindingNamespace(Port port2) {
        List list;
        String string = null;
        Map map = this.getOverriddingBindingNamespaces();
        if (map != null) {
            string = (String)map.get(port2.getName());
        }
        if (string == null && (list = port2.getBinding().getExtensibilityElements()) != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && string == null) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!extensibilityElement.getElementType().getLocalPart().equals("binding")) continue;
                string = extensibilityElement.getElementType().getNamespaceURI();
            }
        }
        return string;
    }

    public boolean hasWSDL() {
        boolean bl = this.wsdlDefinition != null;
        return bl;
    }

    public void setLocatorName(String string) {
        this.locatorClassName = string;
    }

    public String getLocatorName() {
        return this.locatorClassName;
    }

    public void setServiceInformation(ServiceInformation serviceInformation) {
        this.serviceInfo = serviceInformation;
    }

    public ServiceInformation getServiceInformation() {
        if (this.serviceInfo != null) {
            return this.serviceInfo;
        }
        ServiceInformation serviceInformation = null;
        if (!this.dynamicRuntimeEnv) {
            String string;
            String string2;
            if (this.locatorClassName != null) {
                string2 = this.locatorClassName.substring(0, this.locatorClassName.lastIndexOf("Locator"));
                string = string2 + "Information";
                try {
                    serviceInformation = (ServiceInformation)ClassUtils.forName(string).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (serviceInformation != null) {
                this.serviceInfo = serviceInformation;
                return serviceInformation;
            }
            String string3 = string2 = this.namespace2PackageMapping == null ? null : (String)this.namespace2PackageMapping.get(this.serviceNamespace);
            if (string2 == null) {
                String string4 = this.serviceNamespace != null ? this.serviceNamespace : (string = this.serviceName != null ? this.serviceName.getNamespaceURI() : null);
                if (string != null) {
                    string2 = JavaUtils.makePackageName(string);
                }
            }
            if (string2 != null && string2 != "" && this.serviceName != null) {
                string = JavaUtils.xmlNameToJavaClass(this.serviceName.getLocalPart());
                String string5 = string2 + "." + string + "Information";
                try {
                    serviceInformation = (ServiceInformation)ClassUtils.forName(string5).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (serviceInformation == null && this.serviceName != null && (this.wsdlDocumentLocation != null || this.wsdlDefinition != null)) {
            serviceInformation = new DynamicServiceInformation(this.wsdlDefinition, this.wsdlDocumentLocation == null ? null : this.wsdlDocumentLocation.toString(), this.serviceName);
        }
        this.serviceInfo = serviceInformation;
        return serviceInformation;
    }

    public Map getOperationDescriptions(String string) {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getOperationDescriptions(string);
    }

    public List getOperationDescriptions(String string, String string2) {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getOperationDescriptions(string, string2);
    }

    public Map getTypeMappings() {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getTypeMappings();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnv;
    }

    public void setManagedEnvironment(boolean bl) {
        this.managedEnv = bl;
    }

    public void setOverriddingEndpointURIs(Map map) {
        this.overriddingEndpointURIs = map;
    }

    public Map getOverriddingEndpointURIs() {
        return this.overriddingEndpointURIs;
    }

    public void setOverriddingBindingNamespaces(Map map) {
        this.overriddingBindingNamespaces = map;
    }

    public Map getOverriddingBindingNamespaces() {
        return this.overriddingBindingNamespaces;
    }

    public Service getProtocolSpecificService() {
        return this.protocolSpecificService;
    }

    public void setProtocolSpecificService(Service service) {
        this.protocolSpecificService = service;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public String getSdoRepositoryKey() {
        if (this.sdoRepositoryKey == null) {
            this.sdoRepositoryKey = this.initSDORepositoryKey();
        }
        return this.sdoRepositoryKey;
    }

    public void setSdoRepositoryKey(String string) {
        this.sdoRepositoryKey = string;
    }

    protected String initSDORepositoryKey() {
        URL uRL = this.getWSDLDocumentLocation();
        if (uRL == null) {
            throw new JAXRPCException("attempting to store WSDL in SDO repository but WSDL URL is null");
        }
        String string = uRL.toString();
        ClientServiceMetaData clientServiceMetaData = this.getClientServiceMetaData();
        String string2 = clientServiceMetaData != null ? clientServiceMetaData.getName() + ":" + string : Thread.currentThread().getName() + ":" + string;
        try {
            SDOWSDLAdder.getInstance().addWSDLToSDORepository(string2, string);
        }
        catch (SDOConvertorException sDOConvertorException) {
            throw new JAXRPCException("exception storing WSDL in SDO repository: " + sDOConvertorException, (Throwable)sDOConvertorException);
        }
        return string2;
    }

    public QName getSdoServiceName() {
        if (this.sdoServiceName == null) {
            this.sdoServiceName = this.getServiceName();
        }
        return this.sdoServiceName;
    }

    public void setSdoServiceName(QName qName) {
        this.sdoServiceName = qName;
    }

    public String getOverriddenProtocol(String string) {
        String string2 = null;
        Map map = this.getOverriddingBindingNamespaces();
        if (map != null && string != null && (string2 = (String)map.get(string)) != null && string2.length() < 1) {
            string2 = null;
        }
        return string2;
    }

    public boolean isProtocolOverridden(QName qName) {
        boolean bl = false;
        if (qName != null) {
            bl = this.getOverriddenProtocol(qName.getLocalPart()) != null;
        }
        return bl;
    }

    public boolean isNonBoundWSDL() {
        Port port2;
        Binding binding;
        Map map;
        boolean bl = false;
        javax.wsdl.Service service = this.getWSDLService();
        if (service != null && (map = service.getPorts()) != null && map.size() == 1 && (binding = (port2 = (Port)map.get(map.keySet().iterator().next())).getBinding()) != null) {
            List list = binding.getExtensibilityElements();
            bl = list == null || list.size() == 0;
        }
        return bl;
    }

    void setGeneratedService(Service service) {
        this.locator = service;
    }

    public Service getGeneratedService() {
        return this.locator;
    }

    public boolean isDynamicRuntimeEnv() {
        return this.dynamicRuntimeEnv;
    }

    public void setDynamicRuntimeEnv(boolean bl) {
        this.dynamicRuntimeEnv = bl;
    }
}

