/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.modutils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.DefaultMapping;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.ws.webservices.modutils.PreferredPortDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;

public class ClientBndUtil {
    protected static final TraceComponent tc = Tr.register((Class)ClientBndUtil.class, (String)"WebServices", (String)"com.ibm.ws.webservices.resources.webservicesMessages");
    private ClientBinding clientBinding = null;
    private HashMap preferredPortMappings = new HashMap();

    public ClientBndUtil(ClientBinding clientBinding) {
        this.clientBinding = clientBinding;
    }

    public void setupPreferredPortMappings(HashMap hashMap, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupPreferredPortMappings", (Object)new Object[]{string, string2});
        }
        this.preferredPortMappings = hashMap;
        if (this.clientBinding != null) {
            EList eList = this.clientBinding.getComponentScopedRefs();
            EList eList2 = null;
            if (eList != null && eList.size() > 0) {
                Iterator iterator = eList.iterator();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)iterator.next();
                        String string3 = componentScopedRefs.getComponentNameLink();
                        if (!string2.equals(string3)) continue;
                        eList2 = componentScopedRefs.getServiceRefs();
                        if (eList2 != null) {
                            this.addChoices(eList2, string, string2);
                        }
                        break;
                    }
                }
            } else {
                eList2 = this.clientBinding.getServiceRefs();
                this.addChoices(eList2, string, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupPreferredPortMappings");
        }
    }

    private void addChoices(EList eList, String string, String string2) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string3;
            ServiceRef serviceRef = (ServiceRef)iterator.next();
            String string4 = serviceRef.getServiceRefLink();
            if (!(string4 = ClientBndUtil.normalizeServiceName(string4)).equals(string3 = ClientBndUtil.normalizeServiceName(string))) continue;
            this.insertDefaultMapping(serviceRef, string2);
        }
    }

    private void insertDefaultMapping(ServiceRef serviceRef, String string) {
        EList eList;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insertDefaultMapping", (Object)new Object[]{string});
        }
        if ((iterator = (eList = serviceRef.getDefaultMappings()).iterator()) != null) {
            while (iterator.hasNext()) {
                Object[] objectArray;
                DefaultMapping defaultMapping = (DefaultMapping)iterator.next();
                String string2 = defaultMapping.getPortTypeLocalName();
                String string3 = defaultMapping.getPortTypeNamespace();
                QName qName = new QName(string3, string2);
                PreferredPortDescriptor preferredPortDescriptor = (PreferredPortDescriptor)this.preferredPortMappings.get(qName.toString());
                if (preferredPortDescriptor == null) {
                    objectArray = new Object[]{qName.toString()};
                    Tr.warning((TraceComponent)tc, (String)"WSWS0050E", (Object)objectArray);
                    break;
                }
                objectArray = defaultMapping.getPortLocalName();
                String string4 = defaultMapping.getPortNamespace();
                QName qName2 = new QName(string4, (String)objectArray);
                preferredPortDescriptor.setPortPreferred(qName2.toString());
                preferredPortDescriptor.setEjbName(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insertDefaultMapping");
        }
    }

    public static String normalizeServiceName(String string) {
        String string2 = string;
        if (string.startsWith("service/")) {
            string2 = string.substring(8);
        }
        return string2;
    }

    public EList getServiceRefs(String string) {
        EList eList = null;
        if (this.clientBinding != null) {
            EList eList2 = this.clientBinding.getComponentScopedRefs();
            if (eList2 != null && eList2.size() > 0) {
                Iterator iterator = eList2.iterator();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        ComponentScopedRefs componentScopedRefs = (ComponentScopedRefs)iterator.next();
                        String string2 = componentScopedRefs.getComponentNameLink();
                        if (!string.equals(string2)) continue;
                        eList = componentScopedRefs.getServiceRefs();
                        break;
                    }
                }
            } else {
                eList = this.clientBinding.getServiceRefs();
            }
        }
        return eList;
    }

    public String getDeployedWSDL(String string, String string2) {
        EList eList;
        String string3 = null;
        string = ClientBndUtil.normalizeServiceName(string);
        if (this.clientBinding != null && (eList = this.getServiceRefs(string2)) != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServiceRef serviceRef = (ServiceRef)iterator.next();
                String string4 = serviceRef.getServiceRefLink();
                if (!string.equals(string4 = ClientBndUtil.normalizeServiceName(string4))) continue;
                string3 = serviceRef.getDeployedWSDLFile();
                if (string3 == null || !string3.equals("")) break;
                string3 = null;
                break;
            }
        }
        return string3;
    }
}

