/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class ElementAlternateContent
extends AlternateContentBase {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";

    public static ElementAlternateContent create(Element element) {
        return new ElementAlternateContent(element, AlternateContentBase.CONTENT_PLUS_TAG);
    }

    ElementAlternateContent(Element element, short s) {
        super(element, s);
    }

    protected Element getDOMElement() {
        return (Element)this.content;
    }

    protected void serialize(SerializationContext serializationContext, boolean bl) throws Exception {
        MappingScope mappingScope = null;
        if (this.owner.getParentElement() != null) {
            mappingScope = this._getMappingScope((SOAPElement)this.owner.getParentElement()).flatten();
        }
        boolean bl2 = serializationContext.getSerializationWriter().getPretty();
        serializationContext.getSerializationWriter().setPretty(false);
        serializationContext.getSerializationWriter().writeDOMElement((Element)this.content, mappingScope, !bl);
        serializationContext.getSerializationWriter().setPretty(bl2);
    }

    public boolean hasToEvents() {
        return true;
    }

    public void toEvents(PEventProcessor pEventProcessor, MappingScope mappingScope, Attributes attributes) throws SAXException {
        this.toEvents(pEventProcessor, (Element)this.content, mappingScope, attributes, this.owner);
    }

    private void toEvents(PEventProcessor pEventProcessor, Element element, MappingScope mappingScope, Attributes attributes, SOAPElement sOAPElement) throws SAXException {
        String string = element.getLocalName();
        if (string == null || string.length() == 0) {
            string = element.getNodeName();
        }
        String string2 = element.getPrefix();
        String string3 = string;
        if (string2 != null && string2.length() != 0) {
            string3 = string2 + ":" + string;
        }
        String string4 = element.getNamespaceURI() == null ? "" : element.getNamespaceURI();
        pEventProcessor.startElement(string4, string, string3, attributes, mappingScope, sOAPElement);
        this.toContainedEvents(pEventProcessor, element);
        pEventProcessor.endElement(string4, string, string3);
    }

    private void toContainedEvents(PEventProcessor pEventProcessor, Element element) throws SAXException {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            if (node instanceof Element) {
                object = (Element)node;
                String string = object.getLocalName();
                if (string == null || string.length() == 0) {
                    string = object.getNodeName();
                }
                String string2 = object.getPrefix();
                String string3 = string;
                if (string2 != null && string2.length() != 0) {
                    string3 = string2 + ":" + string;
                }
                String string4 = object.getNamespaceURI() == null ? "" : object.getNamespaceURI();
                Attributes attributes = this.toPrefixEvents(pEventProcessor, (Element)object);
                pEventProcessor.startElement(string4, string, string3, attributes);
                this.toContainedEvents(pEventProcessor, (Element)object);
                pEventProcessor.endElement(string4, string, string3);
                continue;
            }
            if (node instanceof Comment) {
                object = ((CharacterData)node).getData();
                if (object == null) continue;
                pEventProcessor.comment(((String)object).toCharArray(), 0, ((String)object).length());
                continue;
            }
            if (node instanceof Text) {
                object = ((Text)node).getData();
                if (object == null) continue;
                pEventProcessor.characters((String)object);
                continue;
            }
            if (!(node instanceof CDATASection) || (object = "<![CDATA[" + ((Text)node).getData() + "]]>") == null) continue;
            pEventProcessor.characters((String)object);
        }
    }

    private Attributes toPrefixEvents(PEventProcessor pEventProcessor, Element element) throws SAXException {
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node;
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            String string = (node = namedNodeMap.item(i)).getNamespaceURI() == null ? "" : node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = node.getNodeValue();
            String string4 = ((Attr)node).getName();
            if (XMLNS.equals(string4) || string4.startsWith(XMLNS_COLON)) {
                String string5 = "";
                if (string4.startsWith(XMLNS_COLON)) {
                    string5 = string4.substring(string4.indexOf(":") + 1);
                }
                pEventProcessor.startPrefixMapping(string5, string3);
                continue;
            }
            attributesImpl.addAttribute(string, string2, string4, "CDATA", string3);
        }
        if (attributesImpl != null) {
            return attributesImpl;
        }
        return NullAttributes.singleton;
    }
}

