/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBodyBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPHeaderBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Document;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPEnvelopeBuilder
extends SOAPBuilder {
    private boolean gotHeader = false;
    private boolean gotBody = false;
    private boolean errorChecking = false;

    public SOAPEnvelopeBuilder(SOAPEnvelope sOAPEnvelope) {
        this.myElement = sOAPEnvelope;
        SAAJ12Document sAAJ12Document = (SAAJ12Document)((Object)this.myElement.getOwnerDocument());
        this.errorChecking = sAAJ12Document.getErrorChecking();
        sAAJ12Document.setErrorChecking(false);
    }

    public SOAPEnvelope getEnvelope() {
        return (SOAPEnvelope)this.myElement;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        SOAPConstants sOAPConstants;
        if (!string2.equals("Envelope")) {
            throw new SAXException(Messages.getMessage("badTag00", string2));
        }
        SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)this.myElement;
        if (string.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            sOAPConstants = SOAPConstants.SOAP11_CONSTANTS;
        } else if (string.equals("http://www.w3.org/2002/06/soap-envelope")) {
            sOAPConstants = SOAPConstants.SOAP12_CONSTANTS;
        } else {
            String string4 = Messages.getMessage("badNamespace00", string);
            WebServicesFault webServicesFault = new WebServicesFault(QNameTable.createQName(sOAPEnvelope.getSOAPFactory().getSOAPConstants().getEnvelopeURI(), "VersionMismatch"), string4, null, null);
            throw new SAXException(string4, webServicesFault);
        }
        if (deserializationContext.getMessageContext() != null) {
            deserializationContext.getMessageContext().setSOAPConstants(sOAPConstants);
        }
        sOAPEnvelope.setMappingScope(mappingScope);
        String string5 = "";
        int n = string3.indexOf(58);
        if (n > 0) {
            string5 = string3.substring(0, n);
        }
        sOAPEnvelope.setPrefix(string5);
        sOAPEnvelope.getSOAPFactory().setSOAPConstants(sOAPConstants);
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        try {
            SOAPBuilder sOAPBuilder = null;
            QName qName = QNameTable.createQName(string, string2);
            if (qName.equals(this.myElement.getSOAPFactory().getSOAPConstants().getHeaderQName())) {
                if (this.gotHeader) {
                    throw new SAXException(Messages.getMessage("only1Header00"));
                }
                this.gotHeader = true;
                sOAPBuilder = new SOAPHeaderBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPHeader(string3, attributes, mappingScope, deserializationContext, (SOAPEnvelope)this.myElement);
                sOAPBuilder.setMyElement(this.myChildElement);
                return sOAPBuilder;
            }
            if (qName.equals(this.myElement.getSOAPFactory().getSOAPConstants().getBodyQName())) {
                if (this.gotBody) {
                    throw new SAXException(Messages.getMessage("only1Body00"));
                }
                this.gotBody = true;
                sOAPBuilder = new SOAPBodyBuilder();
                this.myChildElement = this.myElement.getSOAPFactory().createSOAPBody(string3, attributes, mappingScope, deserializationContext, (SOAPEnvelope)this.myElement);
                sOAPBuilder.setMyElement(this.myChildElement);
                return sOAPBuilder;
            }
            throw new SAXException(Messages.getMessage("noCustomElems00"));
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder.onStartChild", (String)"230", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        try {
            if (!this.gotHeader && ((SOAPEnvelope)this.myElement).getHeader() != null) {
                ((SOAPEnvelope)this.myElement).getHeader().detachNode();
            }
            if (!this.gotBody && ((SOAPEnvelope)this.myElement).getBody() != null) {
                ((SOAPEnvelope)this.myElement).getBody().detachNode();
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder.endElement", (String)"260", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
        finally {
            SAAJ12Document sAAJ12Document = (SAAJ12Document)((Object)this.myElement.getOwnerDocument());
            sAAJ12Document.setErrorChecking(this.errorChecking);
        }
    }

    public void characters(String string) throws SAXException {
        if (!XMLUtils.isXMLWhitespace(string)) {
            throw new SAXException(Messages.getMessage("nonWSDetected00", string, this.myElement.getQName().toString()));
        }
        super.characters(string);
    }
}

