/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.CustomDeserializer;
import com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer;
import com.ibm.ws.webservices.engine.encoding.utils.MethodTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RequestResponseProcessor
extends DEventProcessor {
    protected static Log log = LogFactory.getLog(RequestResponseProcessor.class.getName());
    private RequestResponse reqResp;
    private ParamValue currentParam = null;
    private boolean isResponse;
    private OperationDesc operation;
    private boolean isHeaderElement;
    private boolean legacyTestMode = false;
    private QName evilQName = null;
    private ParameterDesc evilParamDesc = null;
    private boolean needSecondaryLookup = true;

    public RequestResponseProcessor(RequestResponse requestResponse, boolean bl) throws SAXException {
        this.reqResp = requestResponse;
        this.isResponse = bl;
    }

    public void setOperation(OperationDesc operationDesc) {
        this.operation = operationDesc;
        this.evilQName = null;
        this.evilParamDesc = null;
    }

    public void setLegacyTestMode(boolean bl) {
        this.legacyTestMode = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        this.currentParam = null;
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: RequestResponseProcessor.onStartChild()");
        }
        deserializationContext.setSimpleEventOptimization(true);
        QName qName = AttributeUtils.getTypeFromAttributes(string, string2, attributes, mappingScope);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("typeFromAttr00", "" + qName));
        }
        Class<?> clazz = null;
        QName qName2 = QNameTable.createQName(string, string2);
        ParameterDesc parameterDesc = this.getParameterDesc(qName2);
        if (parameterDesc != null) {
            clazz = parameterDesc.getJavaSigType();
            if (parameterDesc.getMode() != 1 && !parameterDesc.getIsReturn()) {
                clazz = JavaUtils.getHolderValueType(clazz);
            }
            if (this.currentParam == null || this.currentParam.getParamDesc() != parameterDesc) {
                this.currentParam = new ParamValue(string, string2, null);
                this.reqResp.addParam(this.currentParam);
            }
            this.currentParam.setParamDesc(parameterDesc);
            if (qName == null) {
                qName = parameterDesc.getTypeQName();
            }
        } else if (this.legacyTestMode) {
            if (this.currentParam == null || !this.currentParam.getQName().getNamespaceURI().equals(string) || !this.currentParam.getQName().getLocalPart().equals(string2)) {
                this.currentParam = new ParamValue(string, string2, null);
                this.reqResp.addParam(this.currentParam);
            }
        } else {
            throw new SAXException(Messages.getMessage("noParmDesc", this.operation == null ? "???" : this.operation.getElementQName().toString(), qName2.toString(), this.operation == null ? "???" : this.getParameterList(this.operation, "    ")));
        }
        if (attributes.getValue("href") != null) {
            DefaultDeserializer defaultDeserializer = new DefaultDeserializer();
            defaultDeserializer.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
            defaultDeserializer.setDefaultType(qName);
            return defaultDeserializer;
        }
        if (AttributeUtils.isNil(attributes)) {
            DefaultDeserializer defaultDeserializer = new DefaultDeserializer();
            defaultDeserializer.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
            return defaultDeserializer;
        }
        Deserializer deserializer = null;
        deserializer = qName == null && string != null && !string.equals("") ? deserializationContext.getDeserializer(null, qName2) : deserializationContext.getDeserializer(clazz, qName);
        if (deserializer == null) {
            if (qName != null) {
                deserializer = deserializationContext.getDeserializer(null, qName);
                if (parameterDesc != null && parameterDesc.getJavaSigType() != null) {
                    Class clazz2 = deserializationContext.getTypeMapping().getClassForQName(qName);
                    Class<?> clazz3 = clazz;
                    if (!parameterDesc.isMaxOccursIs1() && clazz3.getComponentType() != null) {
                        clazz3 = clazz3.getComponentType();
                    }
                    if (null != clazz2 && !JavaUtils.isConvertable(clazz2, clazz3)) {
                        throw new SAXException("Bad types (" + clazz2 + " -> " + clazz3 + ")");
                    }
                }
            } else {
                deserializer = new DefaultDeserializer();
            }
        }
        if (deserializer == null) {
            throw new SAXException(Messages.getMessage("noDeser01", string2, "" + qName));
        }
        if (this.shouldDisableSimpleEvent(parameterDesc, deserializer)) {
            deserializationContext.setSimpleEventOptimization(false);
        }
        deserializer.setDefaultType(qName);
        deserializer.registerValueTarget(new MethodTarget(this.currentParam, ParamValue.getValueSetMethod()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: RequestResponseProcessor.onStartChild()");
        }
        return deserializer;
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        deserializationContext.setSimpleEventOptimization(false);
        super.onEndChild(string, string2, deserializationContext);
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("setProp00", "MessageContext", "RequestResponseProcessor.endElement()."));
        }
        if (this.needHeaderProcessing()) {
            this.processHeaders(deserializationContext);
        }
        this.processAttachments(deserializationContext);
        this.adjustParamsForMinOccurs0();
    }

    private void adjustParamsForMinOccurs0() throws SAXException {
        if (this.operation != null) {
            Vector vector = this.reqResp.getParams();
            for (int i = -1; i < this.operation.getNumParams(); ++i) {
                ParameterDesc parameterDesc = null;
                parameterDesc = i >= 0 ? this.operation.getParameter(i) : this.operation.getReturnParamDesc();
                if (parameterDesc == null || !parameterDesc.isMinOccursIs0() || (!this.isResponse || parameterDesc.getMode() == 1) && (this.isResponse || parameterDesc.getMode() == 2)) continue;
                boolean bl = false;
                for (int j = 0; j < vector.size() && !bl; ++j) {
                    ParamValue paramValue = (ParamValue)vector.elementAt(j);
                    bl = paramValue.getQName().equals(parameterDesc.getQName());
                }
                if (bl) continue;
                ParamValue paramValue = new ParamValue(parameterDesc.getQName(), null);
                paramValue.setParamDesc(parameterDesc);
                vector.add(paramValue);
            }
        }
    }

    public void processNoDataBinding(SOAPElement sOAPElement, DeserializationContext deserializationContext) throws SAXException {
        this.currentParam = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: processingForNoDataBinding");
        }
        for (Node node = sOAPElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof SOAPElement)) continue;
            this.processNoDataBindingParameter((SOAPElement)((Object)node));
        }
        if (this.needHeaderProcessing()) {
            this.processHeaders(deserializationContext);
        }
        this.processAttachments(deserializationContext);
        this.adjustParamsForMinOccurs0();
    }

    private String getParameterList(OperationDesc operationDesc, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < operationDesc.getNumParams(); ++i) {
            stringBuffer.append(string);
            stringBuffer.append(operationDesc.getParameter(i).getQName().toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private void processNoDataBindingParameter(SOAPElement sOAPElement) throws SAXException {
        QName qName = sOAPElement.getQName();
        ParameterDesc parameterDesc = this.getParameterDesc(qName);
        if (parameterDesc == null) {
            throw new SAXException(Messages.getMessage("noParmDesc", this.operation == null ? "???" : this.operation.getElementQName().toString(), qName.toString(), this.operation == null ? "???" : this.getParameterList(this.operation, "    ")));
        }
        if (this.currentParam == null || this.currentParam.getParamDesc() != parameterDesc) {
            this.currentParam = new ParamValue(qName.getNamespaceURI(), qName.getLocalPart(), null);
            this.reqResp.addParam(this.currentParam);
        }
        this.currentParam.setParamDesc(parameterDesc);
        this.currentParam.setValue(sOAPElement);
    }

    public void setEnableSecondaryLookup(boolean bl) {
        this.needSecondaryLookup = bl;
    }

    public boolean isEnableSecondaryLookup() {
        return this.needSecondaryLookup;
    }

    private ParameterDesc getParameterDesc(QName qName) throws SAXException {
        ParameterDesc parameterDesc = null;
        Vector vector = this.reqResp.getParams();
        if (this.operation != null) {
            parameterDesc = this.isResponse ? this.operation.getOutputParamByQName(qName) : this.operation.getInputParamByQName(qName);
            QName qName2 = this.operation.getElementQName();
            if (parameterDesc == null && qName2 != null && (qName2.getNamespaceURI() == qName.getNamespaceURI() || qName2.getNamespaceURI().equals(qName.getNamespaceURI()))) {
                QName qName3 = QNameTable.createQName("", qName.getLocalPart());
                parameterDesc = this.isResponse ? this.operation.getOutputParamByQName(qName3) : this.operation.getInputParamByQName(qName3);
            }
            if (parameterDesc == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getParameterDesc(): Did not find a parameter with the name " + qName.toString() + " in operation desc " + this.operation.toString()));
                }
                if (this.isResponse) {
                    parameterDesc = this.operation.getReturnParamDesc();
                    if (parameterDesc == null) {
                        parameterDesc = new ParameterDesc();
                        parameterDesc.setMode((byte)2);
                        parameterDesc.setIsReturn(true);
                    }
                } else if (this.isEnableSecondaryLookup()) {
                    if (qName.equals(this.evilQName)) {
                        parameterDesc = this.evilParamDesc;
                    } else {
                        this.evilQName = qName;
                        int n = vector.size();
                        if (n >= this.operation.getNumParams() && this.operation.getNumParams() > 0) {
                            n = this.operation.getNumParams() - 1;
                        }
                        parameterDesc = this.evilParamDesc = this.operation.getParameter(n);
                    }
                }
            }
            if (parameterDesc == null) {
                throw new SAXException(Messages.getMessage("noParmDesc", this.operation.getElementQName().toString(), qName.toString(), this.getParameterList(this.operation, "    ")));
            }
            if (!this.isHeaderElement && (this.isResponse && parameterDesc.isOutHeader() || !this.isResponse && parameterDesc.isInHeader())) {
                throw new SAXException(Messages.getMessage("expectedHeaderParam", parameterDesc.getQName().toString()));
            }
        }
        return parameterDesc;
    }

    private boolean needHeaderProcessing() {
        if (this.operation == null) {
            return false;
        }
        ArrayList arrayList = this.operation.getParameters();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                if ((this.isResponse || !parameterDesc.isInHeader()) && (!this.isResponse || !parameterDesc.isOutHeader())) continue;
                return true;
            }
        }
        return this.isResponse && this.operation.getReturnParamDesc() != null && this.operation.getReturnParamDesc().isOutHeader();
    }

    private void processHeaders(DeserializationContext deserializationContext) throws SAXException {
        try {
            Object object;
            Object object2;
            Serializable serializable;
            javax.xml.soap.SOAPElement sOAPElement;
            this.isHeaderElement = true;
            boolean bl = RequestResponse.isNoDataBindingOperation(this.operation);
            for (sOAPElement = this.reqResp.getBody().getParentElement(); sOAPElement != null && !(sOAPElement instanceof SOAPEnvelope); sOAPElement = sOAPElement.getParentElement()) {
            }
            if (sOAPElement == null) {
                return;
            }
            deserializationContext.createEventConverter(new WrapperProcessor(new NOOPProcessor()));
            P2DConverter p2DConverter = deserializationContext.getEventConverter();
            ArrayList arrayList = this.operation.getParameters();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    serializable = (ParameterDesc)arrayList.get(i);
                    if ((this.isResponse || !((ParameterDesc)serializable).isInHeader()) && (!this.isResponse || !((ParameterDesc)serializable).isOutHeader())) continue;
                    object2 = (SOAPHeader)((SOAPEnvelope)sOAPElement).getHeader();
                    object = ((SOAPElement)object2).getChildElements(((ParameterDesc)serializable).getQName().getNamespaceURI(), ((ParameterDesc)serializable).getQName().getLocalPart());
                    while (object != null && object.hasNext()) {
                        SOAPElement sOAPElement2 = (SOAPElement)object.next();
                        if (bl) {
                            this.processNoDataBindingParameter(sOAPElement2);
                            continue;
                        }
                        p2DConverter.pushDEventProcessor(this);
                        sOAPElement2.toEvents(p2DConverter);
                        p2DConverter.popDEventProcessor();
                        sOAPElement2.removeContents();
                        sOAPElement2.setAlternateContent(this.currentParam);
                    }
                }
            }
            if (this.isResponse && this.operation.getReturnParamDesc() != null && this.operation.getReturnParamDesc().isOutHeader()) {
                ParameterDesc parameterDesc = this.operation.getReturnParamDesc();
                serializable = (SOAPHeader)((SOAPEnvelope)sOAPElement).getHeader();
                object2 = ((SOAPElement)serializable).getChildElements(parameterDesc.getQName().getNamespaceURI(), parameterDesc.getQName().getLocalPart());
                while (object2 != null && object2.hasNext()) {
                    object = (SOAPElement)object2.next();
                    if (bl) {
                        this.processNoDataBindingParameter((SOAPElement)object);
                        continue;
                    }
                    p2DConverter.pushDEventProcessor(this);
                    ((SOAPElement)object).toEvents(p2DConverter);
                    p2DConverter.popDEventProcessor();
                    ((SOAPElement)object).removeContents();
                    ((SOAPElement)object).setAlternateContent(this.currentParam);
                }
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor.processHeaders", (String)"507", (Object)this);
            throw new SAXException((Exception)((Object)sOAPException));
        }
        finally {
            this.isHeaderElement = false;
            deserializationContext.freeEventConverter();
        }
    }

    private void processAttachments(DeserializationContext deserializationContext) {
        if (deserializationContext == null) {
            return;
        }
        MessageContext messageContext = deserializationContext.getMessageContext();
        if (messageContext == null) {
            return;
        }
        Message message = messageContext.getCurrentMessage();
        if (message == null) {
            return;
        }
        Iterator iterator = message.getAttachments();
        while (iterator.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
            String string = attachmentPart.getContentIdPartName();
            if (string == null) continue;
            ParameterDesc parameterDesc = null;
            QName qName = QNameTable.createQName("", string);
            if (this.isResponse) {
                parameterDesc = this.operation.getOutputParamByQName(qName);
                if (parameterDesc == null) {
                    parameterDesc = this.getAttachmentParamByName(string);
                }
                if (parameterDesc == null && !string.equals((parameterDesc = this.operation.getReturnParamDesc()).getName())) {
                    parameterDesc = null;
                }
            } else {
                parameterDesc = this.operation.getInputParamByQName(qName);
                if (parameterDesc == null) {
                    parameterDesc = this.getAttachmentParamByName(string);
                }
            }
            if (parameterDesc == null) continue;
            this.processAttachment(attachmentPart, parameterDesc, deserializationContext);
        }
    }

    private ParameterDesc getAttachmentParamByName(String string) {
        ArrayList arrayList = this.operation.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
            String string2 = null;
            string2 = (String)parameterDesc.getOption(ParameterDesc.PART_NAME);
            if (string2 == null || !parameterDesc.isWSDL11MIME() || (!this.isResponse || parameterDesc.getMode() == 1) && (this.isResponse || parameterDesc.getMode() == 2) || !string2.equals(string)) continue;
            return parameterDesc;
        }
        return null;
    }

    private void processAttachment(AttachmentPart attachmentPart, ParameterDesc parameterDesc, DeserializationContext deserializationContext) {
        QName qName = parameterDesc.getTypeQName();
        if (!Constants.WSI_SWAREF.equals(qName) && !Constants.WEBSERVICES_VOID.equals(qName)) {
            try {
                JAFDataHandlerDeserializer jAFDataHandlerDeserializer = (JAFDataHandlerDeserializer)deserializationContext.getTypeMapping().getDeserializer(qName).getDeserializerAs("WebServices SAX Mechanism");
                DataHandler dataHandler = AttachmentUtils.getActivationDataHandler(attachmentPart);
                ParamValue paramValue = new ParamValue(parameterDesc.getQName(), jAFDataHandlerDeserializer.makeValue(dataHandler));
                paramValue.setParamDesc(parameterDesc);
                this.reqResp.addParam(paramValue);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.xmlsoap.builder.RequestResponseProcessor", (String)"225", (Object)this);
            }
        }
    }

    private boolean shouldDisableSimpleEvent(ParameterDesc parameterDesc, Deserializer deserializer) {
        if (parameterDesc == null || parameterDesc.getJavaSigType() == null) {
            return false;
        }
        return deserializer instanceof CustomDeserializer || javax.xml.soap.SOAPElement.class.isAssignableFrom(parameterDesc.getJavaType());
    }
}

