/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.websphere.webservices.soap.IBMSOAPElement;
import com.ibm.websphere.webservices.soap.IBMSOAPFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.SOAPPart;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.Comment;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.ProtectionChecker;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.builders.AsSOAPElementProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Document;
import com.ibm.ws.webservices.engine.xmlsoap.saaj12.SAAJ12Text;
import com.ibm.ws.webservices.utils.WebServicesInputSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPElement
extends ElementNSImpl
implements Serializable,
IBMSOAPElement {
    private static Log log = LogFactory.getLog(SOAPElement.class.getName());
    boolean isProtect = false;
    protected boolean inAsSOAPElement = false;
    protected boolean rebuildTagQName = false;
    protected boolean rebuildAttributesAndMapping = false;
    protected SOAPFactory soapFactory;
    transient AlternateContentBase altContent;
    protected static int CONTEXT_CONTENT = 1;
    protected static int CONTEXT_ATTRS = 2;
    protected static int CONTEXT_TAG = 3;
    private MappingScope mappingScope = null;
    private boolean validMappingScope = true;
    private boolean callerIsSelf = false;
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    private static final String EMPTY_STRING = "";
    private String deferredMimeType = null;
    private Object deferredAttachment = null;

    SOAPElement(String string, String string2, SOAPFactory sOAPFactory) {
        super((CoreDocumentImpl)sOAPFactory.getOwnerDocument(), string, string2);
        this.soapFactory = sOAPFactory;
    }

    public SOAPElement(Element element, SOAPFactory sOAPFactory) {
        super((CoreDocumentImpl)sOAPFactory.getOwnerDocument(), element.getNamespaceURI(), element.getLocalName() == null || element.getLocalName().length() == 0 ? element.getNodeName() : element.getLocalName());
        this.setPrefix(element.getPrefix());
        this.soapFactory = sOAPFactory;
        try {
            this.setAlternateContent(element);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.init", (String)"210", (Object)this);
            throw new RuntimeException(sOAPException);
        }
    }

    public final javax.xml.soap.SOAPElement addAttribute(javax.xml.soap.Name name2, String string) throws SOAPException {
        this.addAttribute(name2.getURI(), name2.getPrefix(), name2.getLocalName(), string);
        return this;
    }

    public final javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.Name name2) throws SOAPException {
        return this.addChildElement(name2.getLocalName(), name2.getPrefix(), name2.getURI());
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        sOAPElement = (javax.xml.soap.SOAPElement)this.insertBefore((org.w3c.dom.Node)sOAPElement, null);
        try {
            sOAPElement.setParentElement((javax.xml.soap.SOAPElement)this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addChildElement", (String)"313", (Object)this);
            this.removeChild((org.w3c.dom.Node)sOAPElement);
            sOAPElement = null;
        }
        return sOAPElement;
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement(EMPTY_STRING, string, this.soapFactory);
        return this.addChildElement(sOAPElement);
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string, String string2) throws SOAPException {
        return this.addChildElement(string, string2, this.getNamespaceURI(string2));
    }

    public final javax.xml.soap.SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement(string3, string, this.soapFactory);
        sOAPElement.setPrefix(string2);
        return this.addChildElement(sOAPElement);
    }

    public final javax.xml.soap.SOAPElement addNamespaceDeclaration(String string, String string2) {
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        String string3 = XMLNS;
        if (string != null && string.length() != 0) {
            string3 = string3 + ":" + string;
        }
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", string3, string2);
        return this;
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (SAAJ12Text.isCommentValue(string)) {
            this.addComment(string);
        } else {
            this.insertBefore((org.w3c.dom.Node)((Object)new Text((SAAJ12Document)this.ownerDocument, string)), null);
        }
        return this;
    }

    public javax.xml.soap.SOAPElement addComment(String string) throws SOAPException {
        this.asSOAPElement(CONTEXT_CONTENT);
        this.insertBefore((org.w3c.dom.Node)((Object)new Comment((SAAJ12Document)this.ownerDocument, string)), null);
        return this;
    }

    public final Iterator getAllAttributes() {
        String string;
        Object object;
        Object object2;
        int n;
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<javax.xml.soap.Name> arrayList = new ArrayList<javax.xml.soap.Name>();
        this.callerIsSelf = true;
        NamedNodeMap namedNodeMap = super.getAttributes();
        this.callerIsSelf = false;
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            object2 = namedNodeMap.item(n);
            String string2 = object2.getNamespaceURI();
            object = object2.getLocalName();
            string = object2.getPrefix();
            try {
                arrayList.add(this.soapFactory.createName((String)object, string, string2));
                continue;
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getAllAttributes", (String)"443", (Object)this);
                throw new InternalException((Exception)((Object)sOAPException));
            }
        }
        if (this.validMappingScope && this.mappingScope != null) {
            n = this.mappingScope.size();
            object2 = "http://www.w3.org/2000/xmlns/";
            for (int i = 0; i < n; ++i) {
                object = this.mappingScope.get(i);
                string = XMLNS;
                String string3 = ((Mapping)object).getPrefix();
                try {
                    arrayList.add(this.soapFactory.createName(string3, string, (String)object2));
                    continue;
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getAllAttributes", (String)"470", (Object)this);
                    throw new InternalException((Exception)((Object)sOAPException));
                }
            }
        }
        return arrayList.iterator();
    }

    public final String getAttributeValue(javax.xml.soap.Name name2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        String string = null;
        String string2 = name2.getURI();
        String string3 = name2.getLocalName();
        string = string2 == null || string2.length() == 0 ? this.getAttribute(name2.getQualifiedName()) : this.getAttributeNS(string2, string3);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public final Iterator getChildElements() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return new CEIterator((org.w3c.dom.Node)((Object)this));
    }

    public final Iterator getChildElements(javax.xml.soap.Name name2) {
        return this.getChildElements(name2.getURI(), name2.getLocalName());
    }

    public final javax.xml.soap.Name getElementName() {
        try {
            return this.soapFactory.createName(this.getLocalName(), this.getPrefix(), this.getNamespaceURI());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getElementName", (String)"534", (Object)this);
            throw new InternalException((Exception)((Object)sOAPException));
        }
    }

    public final void setEncodingStyle(String string) throws SOAPException {
        this.asSOAPElement(CONTEXT_ATTRS);
        if (string == null) {
            string = EMPTY_STRING;
        }
        if (this.hasAttributeNS(this.soapFactory.getSOAPConstants().getEnvelopeURI(), "encodingStyle")) {
            throw new IllegalArgumentException("illegalArgumentException01");
        }
        String string2 = EMPTY_STRING;
        MappingScope mappingScope = this._getMappingScope();
        string2 = mappingScope.getOrCreatePrefix(this.soapFactory.getSOAPConstants().getEnvelopeURI(), null, false);
        String string3 = "encodingStyle";
        if (string2 != null && string2.length() > 0) {
            string3 = string2 + ":" + string3;
        }
        this.callerIsSelf = true;
        super.setAttributeNS(this.soapFactory.getSOAPConstants().getEnvelopeURI(), string3, string);
        this.callerIsSelf = false;
    }

    public final Iterator getNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> arrayList = new ArrayList<String>();
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            for (int i = 0; i < mappingScope.size(); ++i) {
                Mapping mapping = mappingScope.get(i);
                arrayList.add(mapping.getPrefix());
            }
        }
        return arrayList.iterator();
    }

    public final String getNamespaceURI(String string) {
        this.asSOAPElement(CONTEXT_TAG);
        MappingScope mappingScope = this._getMappingScope();
        Mapping mapping = mappingScope.getMappingForPrefix(string, false);
        if (mapping != null) {
            return mapping.getNamespaceURI();
        }
        return null;
    }

    public final Iterator getVisibleNamespacePrefixes() {
        this.asSOAPElement(CONTEXT_ATTRS);
        ArrayList<String> arrayList = new ArrayList<String>();
        MappingScope mappingScope = this._getMappingScope();
        if (mappingScope != null) {
            MappingScope mappingScope2 = mappingScope.flatten();
            for (int i = 0; i < mappingScope2.size(); ++i) {
                Mapping mapping = mappingScope2.get(i);
                arrayList.add(mapping.getPrefix());
            }
        }
        return arrayList.iterator();
    }

    public final boolean removeAttribute(javax.xml.soap.Name name2) {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        String string = name2.getURI();
        String string2 = name2.getLocalName();
        boolean bl = false;
        Element element = this._getDOMElement();
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (element != null) {
            if (this.hasAttributeNS(string, string2)) {
                this.removeAttributeNS(string, string2);
                bl = true;
            }
        } else {
            this.asSOAPElement(CONTEXT_ATTRS);
            if (this.hasAttributeNS(string, string2)) {
                this.removeAttributeNS(string, string2);
                bl = true;
            }
        }
        return bl;
    }

    public final void removeContents() {
        if (this.getAlternateContent() != null) {
            this.altContent.removeChildNodes();
        } else {
            Iterator iterator = this.getChildElements();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public final boolean removeNamespaceDeclaration(String string) {
        boolean bl;
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        String string2 = XMLNS;
        if (string != null && string.length() > 0) {
            string2 = string2 + ":" + string;
        }
        if (bl = this.hasAttribute(string2)) {
            this.removeAttribute(string2);
        }
        return bl;
    }

    public final String getEncodingStyle() {
        this.asSOAPElement(CONTEXT_ATTRS);
        String string = super.getAttributeNS(this.soapFactory.getSOAPConstants().getEnvelopeURI(), "encodingStyle");
        if (string == null) {
            javax.xml.soap.SOAPElement sOAPElement = this.getParentElement();
            string = sOAPElement == null ? EMPTY_STRING : sOAPElement.getEncodingStyle();
        }
        return string;
    }

    public final javax.xml.soap.SOAPElement getParentElement() {
        org.w3c.dom.Node node = this.getParentNode();
        return node instanceof Document ? null : (javax.xml.soap.SOAPElement)node;
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new SOAPException(Messages.getMessage("nullParent00"));
        }
        SOAPElement sOAPElement2 = (SOAPElement)sOAPElement;
        ProtectionChecker.protectionCheck_removeChildElement(sOAPElement2);
        ProtectionChecker.protectionCheck_addChildElement((SOAPElement)sOAPElement);
        ProtectionChecker.protectionCheck_removeElement(this);
        if (this.getAlternateContent() != null) {
            this.soapFactory = sOAPElement2.getSOAPFactory();
        }
        SOAPElement sOAPElement3 = (SOAPElement)this.getParentElement();
        if (sOAPElement2 != sOAPElement3) {
            sOAPElement2.addChildElement(this);
        }
    }

    public final void detachNode() {
        SOAPElement sOAPElement = (SOAPElement)this.getParentElement();
        if (sOAPElement != null) {
            sOAPElement.removeChildElement(this);
        }
    }

    public final void recycleNode() {
        this.detachNode();
        this.soapFactory = null;
        this.mappingScope = null;
        this.validMappingScope = false;
        if (this.altContent != null) {
            this.altContent.detach();
        }
    }

    public final String getValue() {
        org.w3c.dom.Node node;
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node2 = this.getFirstChild();
        if (node2 != null && node2.getNextSibling() == null) {
            if (node2 instanceof CharacterData && !(node2 instanceof org.w3c.dom.Comment)) {
                return ((CharacterData)node2).getData();
            }
            return null;
        }
        org.w3c.dom.Node node3 = null;
        for (node = node2; node != null && node3 == null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            node3 = (CharacterData)node;
        }
        if (node3 == null) {
            return null;
        }
        node = node3.getNextSibling();
        if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) {
            return node3.getData();
        }
        super.normalize();
        for (node = node2 = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof CharacterData) || node instanceof org.w3c.dom.Comment) continue;
            return ((CharacterData)node).getData();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setValue(String string) {
        this.asSOAPElement(CONTEXT_CONTENT);
        javax.xml.soap.Text text = null;
        boolean bl = false;
        int n = 0;
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            bl = true;
            Object e = iterator.next();
            if (!(e instanceof javax.xml.soap.Text)) continue;
            text = (javax.xml.soap.Text)e;
            n = (short)(n + 1);
        }
        if (bl) {
            if (n == 1) {
                text.setValue(string);
                return;
            }
            if (!log.isDebugEnabled()) throw new IllegalStateException(Messages.getMessage("badTextNode00"));
            log.debug((Object)"can not set value");
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
        try {
            this.addTextNode(string);
            return;
        }
        catch (SOAPException sOAPException) {
            throw new IllegalStateException(Messages.getMessage("badTextNode00"));
        }
    }

    public final String getAttribute(String string) {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getAttribute(string);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.getAttribute(string);
    }

    public final Attr getAttributeNode(String string) {
        ProtectionChecker.protectionCheck_accessAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getAttributeNode(string);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (!this.callerIsSelf) {
            this._invalidateMappingScope();
        }
        return super.getAttributeNode(string);
    }

    public final Attr getAttributeNodeNS(String string, String string2) {
        ProtectionChecker.protectionCheck_accessAttributes(this);
        string = string == null || string.length() == 0 ? null : string;
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getAttributeNodeNS(string, string2);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (!this.callerIsSelf) {
            this._invalidateMappingScope();
        }
        return super.getAttributeNodeNS(string, string2);
    }

    public final String getAttributeNS(String string, String string2) {
        string = string == null || string.length() == 0 ? null : string;
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getAttributeNS(string, string2);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (this.validMappingScope && this.mappingScope != null && "http://www.w3.org/2000/xmlns/".equals(string)) {
            Mapping mapping;
            if (XMLNS.equals(string2)) {
                string2 = EMPTY_STRING;
            }
            return (mapping = this.mappingScope.getMappingForPrefix(string2, true)) == null ? null : mapping.getNamespaceURI();
        }
        return super.getAttributeNS(string, string2);
    }

    public final NodeList getElementsByTagName(String string) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getElementsByTagName(string);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        string = string == null || string.length() == 0 ? null : string;
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getElementsByTagNameNS(string, string2);
    }

    public final String getTagName() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getTagName();
        }
        return this.getNodeName();
    }

    public final boolean hasAttribute(String string) {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.hasAttribute(string);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (string.startsWith(XMLNS)) {
            this._invalidateMappingScope();
        }
        this.callerIsSelf = true;
        boolean bl = super.hasAttribute(string);
        this.callerIsSelf = false;
        return bl;
    }

    public final boolean hasAttributeNS(String string, String string2) {
        string = string == null || string.length() == 0 ? null : string;
        Element element = this._getDOMElement();
        if (element != null) {
            return element.hasAttributeNS(string, string2);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (this.validMappingScope && this.mappingScope != null && "http://www.w3.org/2000/xmlns/".equals(string)) {
            Mapping mapping;
            if (XMLNS.equals(string2)) {
                string2 = EMPTY_STRING;
            }
            return (mapping = this.mappingScope.getMappingForPrefix(string2, true)) != null;
        }
        this.callerIsSelf = true;
        boolean bl = super.hasAttributeNS(string, string2);
        this.callerIsSelf = false;
        return bl;
    }

    public final void removeAttribute(String string) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            element.removeAttribute(string);
        } else {
            this.asSOAPElement(CONTEXT_ATTRS);
            if (string.startsWith(XMLNS)) {
                this._invalidateMappingScope();
            }
            super.removeAttribute(string);
        }
    }

    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            return element.removeAttributeNode(attr);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        this._invalidateMappingScope();
        return super.removeAttributeNode(attr);
    }

    public final void removeAttributeNS(String string, String string2) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        string = string == null || string.length() == 0 ? null : string;
        Element element = this._getDOMElement();
        if (element != null) {
            element.removeAttributeNS(string, string2);
        } else {
            this.asSOAPElement(CONTEXT_ATTRS);
            if (this.validMappingScope && this.mappingScope != null && "http://www.w3.org/2000/xmlns/".equals(string)) {
                if (XMLNS.equals(string2)) {
                    string2 = EMPTY_STRING;
                }
                boolean bl = this.mappingScope.removeMappingForPrefix(string2);
                return;
            }
            super.removeAttributeNS(string, string2);
        }
    }

    public final void setAttribute(String string, String string2) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            element.setAttribute(string, string2);
        } else {
            this.asSOAPElement(CONTEXT_ATTRS);
            if (string.startsWith(XMLNS)) {
                this._invalidateMappingScope();
            }
            this.callerIsSelf = true;
            super.setAttribute(string, string2);
            this.callerIsSelf = false;
        }
    }

    public final Attr setAttributeNode(Attr attr) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            return element.setAttributeNode(attr);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (!this.callerIsSelf) {
            this._invalidateMappingScope();
        }
        attr = this.importAttr(attr);
        Attr attr2 = super.setAttributeNode(attr);
        return attr2;
    }

    public final void setAttributeNS(String string, String string2, String string3) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        string = string == null || string.length() == 0 ? null : string;
        Element element = this._getDOMElement();
        if (element != null) {
            element.setAttributeNS(string, string2, string3);
        } else {
            this.asSOAPElement(CONTEXT_ATTRS);
            if (this.validMappingScope && string2.startsWith(XMLNS)) {
                if (this.mappingScope == null) {
                    this.mappingScope = new MappingScope();
                }
                String string4 = EMPTY_STRING;
                if (string2.startsWith(XMLNS_COLON)) {
                    string4 = string2.substring(6);
                }
                this.mappingScope.addMapping(string3, string4);
                return;
            }
            this.callerIsSelf = true;
            super.setAttributeNS(string, string2, string3);
            this.callerIsSelf = false;
        }
    }

    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            return element.setAttributeNodeNS(attr);
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (!this.callerIsSelf) {
            this._invalidateMappingScope();
        }
        attr = this.importAttr(attr);
        return super.setAttributeNodeNS(attr);
    }

    public final org.w3c.dom.Node appendChild(org.w3c.dom.Node node) throws DOMException {
        return super.appendChild(node);
    }

    public final org.w3c.dom.Node cloneNode(boolean bl) {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.cloneNode(bl);
    }

    public final NamedNodeMap getAttributes() {
        ProtectionChecker.protectionCheck_accessAttributes(this);
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getAttributes();
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        if (!this.callerIsSelf) {
            this._invalidateMappingScope();
        }
        return super.getAttributes();
    }

    public final NodeList getChildNodes() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getChildNodes();
    }

    public final org.w3c.dom.Node getFirstChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getFirstChild();
    }

    public final org.w3c.dom.Node getLastChild() {
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.getLastChild();
    }

    public final String getLocalName() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getLocalName();
        }
        this.asSOAPElement(CONTEXT_TAG);
        return super.getLocalName();
    }

    public final String getNamespaceURI() {
        String string = null;
        Element element = this._getDOMElement();
        if (element != null) {
            string = element.getNamespaceURI();
        } else {
            this.asSOAPElement(CONTEXT_TAG);
            string = super.getNamespaceURI();
        }
        string = string == null || string.length() == 0 ? null : string;
        return string;
    }

    public final org.w3c.dom.Node getNextSibling() {
        return super.getNextSibling();
    }

    public final String getNodeName() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getNodeName();
        }
        this.asSOAPElement(CONTEXT_TAG);
        return super.getNodeName();
    }

    public final short getNodeType() {
        return super.getNodeType();
    }

    public final String getNodeValue() {
        return super.getNodeValue();
    }

    public final Document getOwnerDocument() {
        return super.getOwnerDocument();
    }

    public final org.w3c.dom.Node getParentNode() {
        return super.getParentNode();
    }

    public final String getPrefix() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.getPrefix();
        }
        this.asSOAPElement(CONTEXT_TAG);
        if (this.getNamespaceURI() == null) {
            return null;
        }
        return super.getPrefix();
    }

    public final org.w3c.dom.Node getPreviousSibling() {
        return super.getPreviousSibling();
    }

    public final boolean hasAttributes() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.hasAttributes();
        }
        this.asSOAPElement(CONTEXT_ATTRS);
        return super.hasAttributes() || this.validMappingScope && this.mappingScope != null && this.mappingScope.size() > 0;
    }

    public final boolean hasChildNodes() {
        Element element = this._getDOMElement();
        if (element != null) {
            return element.hasChildNodes();
        }
        this.asSOAPElement(CONTEXT_CONTENT);
        return super.hasChildNodes();
    }

    public final org.w3c.dom.Node insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node node2) throws DOMException {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node3 = null;
        node3 = this.isValidSAAJChild(node) ? node : this.wrapChildDOMNode(node);
        node3 = super.insertBefore(node3, node2);
        if (node instanceof SOAPElement && ((SOAPElement)((Object)node)).getAlternateContent() == null) {
            ((SOAPElement)((Object)node3))._getMappingScope();
        }
        return node3;
    }

    public final boolean isSupported(String string, String string2) {
        return super.isSupported(string, string2);
    }

    public final void normalize() {
        Element element = this._getDOMElement();
        if (element != null) {
            element.normalize();
        } else {
            this.asSOAPElement(CONTEXT_CONTENT);
            super.normalize();
        }
    }

    public final void setNodeValue(String string) {
        super.setNodeValue(string);
    }

    public final void setPrefix(String string) throws DOMException {
        this.asSOAPElement(CONTEXT_TAG);
        super.setPrefix(string);
    }

    public final Attributes getSAXAttributes() {
        AttributesImpl attributesImpl = null;
        NamedNodeMap namedNodeMap = null;
        Element element = this._getDOMElement();
        namedNodeMap = element != null ? element.getAttributes() : super.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            org.w3c.dom.Node node;
            if (attributesImpl == null) {
                attributesImpl = new AttributesImpl();
            }
            String string = (node = namedNodeMap.item(i)).getNamespaceURI() == null ? EMPTY_STRING : node.getNamespaceURI();
            String string2 = node.getLocalName();
            String string3 = node.getNodeValue();
            String string4 = ((Attr)node).getName();
            if (XMLNS.equals(string4) || string4.startsWith(XMLNS_COLON)) continue;
            attributesImpl.addAttribute(string, string2, string4, "CDATA", string3);
        }
        if (attributesImpl != null) {
            return attributesImpl;
        }
        return NullAttributes.singleton;
    }

    public final void setAttributes(Attributes attributes) {
        ProtectionChecker.protectionCheck_changeAttributes(this);
        this.callerIsSelf = true;
        NamedNodeMap namedNodeMap = this.getAttributes();
        Document document = this.getOwnerDocument();
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = document.createAttributeNS(attributes.getURI(i), attributes.getQName(i));
                attr.setValue(attributes.getValue(i));
                namedNodeMap.setNamedItem(attr);
            }
        }
        this.callerIsSelf = false;
    }

    public final void setAttribute(String string, String string2, String string3) {
        this.addAttribute(string, string2, string3);
    }

    public final String getAttributeValue(String string, String string2) {
        this.asSOAPElement(CONTEXT_ATTRS);
        return this.getAttributeNS(string, string2);
    }

    public final void setMappingScope(MappingScope mappingScope) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeNamespaces(this);
        if (this.validMappingScope) {
            this.mappingScope = (MappingScope)mappingScope.clone();
            return;
        }
        if (mappingScope != null) {
            for (int i = 0; i < mappingScope.size(); ++i) {
                Mapping mapping = mappingScope.get(i);
                String string = XMLNS;
                if (mapping.getPrefix().length() != 0) {
                    string = string + ":" + mapping.getPrefix();
                }
                this.setAttributeNS("http://www.w3.org/2000/xmlns/", string, mapping.getNamespaceURI());
            }
        }
    }

    protected final void removeChildNode(Node node) {
        if (node instanceof SOAPElement) {
            this.removeChildElement((SOAPElement)node);
        } else {
            this.removeChild((org.w3c.dom.Node)node);
        }
    }

    protected void removeChildElement(SOAPElement sOAPElement) {
        this.asSOAPElement(CONTEXT_CONTENT);
        ProtectionChecker.protectionCheck_removeChildElement(this);
        Iterator iterator = this.getChildElements(sOAPElement.getNamespaceURI(), sOAPElement.getLocalName());
        while (iterator.hasNext()) {
            this.removeChild((org.w3c.dom.Node)iterator.next());
        }
    }

    public final String getLocalPart() {
        return this.getLocalName();
    }

    public final int getNumChildren() {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node = this.getFirstChild();
        int n = 0;
        for (org.w3c.dom.Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof CharacterData) continue;
            ++n;
        }
        return n;
    }

    public final SOAPElement getChildElement(int n) {
        this.asSOAPElement(CONTEXT_CONTENT);
        org.w3c.dom.Node node = this.getFirstChild();
        int n2 = -1;
        for (org.w3c.dom.Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof CharacterData)) {
                ++n2;
            }
            if (n2 != n) continue;
            return (SOAPElement)((Object)node2);
        }
        return null;
    }

    public final SOAPElement getChildElement(String string, String string2) throws SOAPException {
        Iterator iterator = this.getChildElements(string, string2);
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        if (iterator.hasNext()) {
            throw new SOAPException(Messages.getMessage("getChildElementErr00", string, string2));
        }
        return sOAPElement;
    }

    public final void output(SerializationContext serializationContext) throws Exception {
        this.outputImpl(serializationContext, true);
    }

    protected void outputImpl(SerializationContext serializationContext, boolean bl) throws Exception {
        Object object;
        this.soapFactory.setMessageContext(serializationContext.getMessageContext());
        if (this.deferredAttachment != null) {
            this.addSwaRefTextNode(this.deferredMimeType, this.deferredAttachment, serializationContext.getCurrentMessage());
            this.deferredAttachment = null;
        }
        if (this.getAlternateContent() != null) {
            this.altContent.serialize(serializationContext, bl);
            return;
        }
        MappingScope mappingScope = this._getMappingScope();
        if (bl) {
            mappingScope = this._getMappingScope(false, false);
            object = this.getMappingScopeForAncestorsNotWritten(serializationContext);
            mappingScope.setParent((MappingScope)object);
            mappingScope = mappingScope.flatten();
        }
        object = this.getValue();
        org.w3c.dom.Node node = this.getFirstChild();
        if (object != null && this.altContent == null && node != null && node.getNextSibling() == null) {
            serializationContext.getSerializationWriter().simpleElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope, (String)object);
        } else {
            serializationContext.getSerializationWriter().startElement(this.getQName(), this.getPrefix(), this.getSAXAttributes(), mappingScope);
            this.outputContentsImpl(serializationContext);
            if (this instanceof SOAPBody) {
                serializationContext.outputMultiRefs();
            }
            serializationContext.getSerializationWriter().endElement();
        }
    }

    protected void outputContentsImpl(SerializationContext serializationContext) throws Exception {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)((Object)node)).outputImpl(serializationContext, false);
                continue;
            }
            short s = node.getNodeType();
            String string = node.getNodeValue();
            if (s == 8) {
                serializationContext.getSerializationWriter().writeComment(string);
                continue;
            }
            if (string == null) continue;
            serializationContext.getSerializationWriter().writeSafeString(string);
        }
    }

    MappingScope getMappingScopeForAncestorsNotWritten(SerializationContext serializationContext) {
        MappingScope mappingScope = new MappingScope();
        SOAPElement sOAPElement = (SOAPElement)this.getParentElement();
        SerializationWriter serializationWriter = serializationContext.getSerializationWriter();
        if (sOAPElement != null && serializationWriter != null) {
            mappingScope = sOAPElement._getMappingScope();
            mappingScope = mappingScope.flatten();
            int n = 0;
            while (n < mappingScope.size()) {
                String string = mappingScope.get(n).getPrefix();
                String string2 = serializationWriter.getNamespaceURI(string);
                if (mappingScope.get(n).getNamespaceURI().equals(string2)) {
                    mappingScope.removeMappingForPrefix(string);
                    continue;
                }
                ++n;
            }
        }
        return mappingScope;
    }

    private final String getAsString(boolean bl) throws Exception {
        Object object;
        Object object2;
        Object object3;
        if (this.altContent != null && !bl && (object3 = this.altContent.getXMLString()) != null) {
            return object3;
        }
        object3 = null;
        StringWriter stringWriter = null;
        int n = 1024;
        if (this.altContent != null && (object2 = this.altContent.getContent()) instanceof WebServicesInputSource && (object = ((WebServicesInputSource)this.altContent.getContent()).getBytes()) != null) {
            n += ((byte[])object).length;
        }
        stringWriter = new StringWriter(n);
        object2 = this.soapFactory.getMessageContext();
        object3 = new SerializationContextImpl(stringWriter, (MessageContext)object2, false);
        if (bl) {
            this.output((SerializationContext)object3);
        } else {
            this.outputImpl((SerializationContext)object3, false);
        }
        stringWriter.close();
        object = stringWriter.getBuffer().toString();
        return object;
    }

    public final String toString() {
        return this.toXMLString(true);
    }

    public final void toEvents(PEventProcessor pEventProcessor) throws SAXException {
        this.asSOAPElement(CONTEXT_ATTRS);
        if (this.getAlternateContent() != null && this.altContent.hasToEvents()) {
            this.altContent.toEvents(pEventProcessor, this._getMappingScope(), this.getSAXAttributes());
            return;
        }
        String string = this.getLocalPart();
        String string2 = this.getPrefix();
        if (string2 != null && string2.length() != 0) {
            string = string2 + ":" + string;
        }
        pEventProcessor.startElement(this.getNamespaceURI(), this.getLocalPart(), string, this.getSAXAttributes(), this._getMappingScope(), this);
        this.toContainedEvents(pEventProcessor);
        pEventProcessor.endElement(this.getNamespaceURI(), this.getLocalPart(), string);
    }

    protected final void toContainedEvents(PEventProcessor pEventProcessor) throws SAXException {
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof SOAPElement) {
                ((SOAPElement)((Object)node)).toEvents(pEventProcessor);
                continue;
            }
            short s = node.getNodeType();
            String string = node.getNodeValue();
            if (s == 8) {
                pEventProcessor.comment(string.toCharArray(), 0, string.length());
                continue;
            }
            pEventProcessor.characters(string);
        }
    }

    public final Element getAsDOM() throws Exception {
        return this.getAsDOM(true);
    }

    public final Element getAsDOM(boolean bl) throws Exception {
        return this.getAsDocument(bl).getDocumentElement();
    }

    public final Document getAsDocument() throws Exception {
        return this.getAsDocument(true);
    }

    public final Document getAsDocument(boolean bl) throws Exception {
        String string = this.getAsString(bl);
        StringReader stringReader = new StringReader(string);
        Document document = XMLUtils.newDocument(new InputSource(stringReader));
        if (document == null) {
            throw new Exception(Messages.getMessage("noDoc00", string));
        }
        return document;
    }

    public void setAlternateContent(Object object) throws SOAPException {
        ProtectionChecker.protectionCheck_setAlternateContent(this);
        if (object == null) {
            if (this.altContent != null) {
                this.altContent.detach();
            }
            this.validMappingScope = false;
            return;
        }
        AlternateContentBase alternateContentBase = AlternateContentBase.create(object);
        if (alternateContentBase.affectsTagAttributes() || alternateContentBase.affectsTagQName()) {
            this.validMappingScope = false;
        }
        alternateContentBase.attach(this);
        Element element = this._getDOMElement();
        if (element != null && element.getOwnerDocument() != this.getOwnerDocument()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"setAlternateContent: immediate transformation because documents are different");
            }
            this.asSOAPElement(CONTEXT_TAG);
        }
    }

    protected final void asSOAPElement(int n) {
        if (this.inAsSOAPElement || this.getAlternateContent() == null || n == CONTEXT_TAG && !this.altContent.affectsTagQName() || n == CONTEXT_ATTRS && !this.altContent.affectsTagAttributes()) {
            return;
        }
        this._asSOAPElement(n);
    }

    protected final void _asSOAPElement(int n) {
        this.inAsSOAPElement = true;
        this.rebuildTagQName = this.altContent.affectsTagQName();
        AlternateContentBase alternateContentBase = this.altContent;
        this.rebuildAttributesAndMapping = alternateContentBase.affectsTagAttributes();
        boolean bl = alternateContentBase.hasToEvents();
        if (log.isDebugEnabled()) {
            log.debug((Object)("transforming to SOAPElement with alternate content " + alternateContentBase.getClass()));
        }
        DeserializationContext deserializationContext = this.soapFactory.getDeserializationContext();
        deserializationContext.createEventConverter(new WrapperProcessor(new NOOPProcessor()));
        P2DConverter p2DConverter = deserializationContext.getEventConverter();
        try {
            try {
                Object object;
                Object object2;
                boolean bl2;
                Object object3;
                this.removeChildren();
                String string = null;
                MappingScope mappingScope = null;
                InputSource inputSource = null;
                WebServicesParser webServicesParser = null;
                if (!bl) {
                    string = "<XXX>" + this.getAsString(true) + "</XXX>";
                    mappingScope = this._getStrippedMappingScope();
                    inputSource = new InputSource(new StringReader(string));
                    webServicesParser = (WebServicesParser)XMLUtils.getSAXParser();
                }
                SOAPBuilder sOAPBuilder = this.createBuilder();
                sOAPBuilder.setMyElement(this);
                if (string != null) {
                    for (object3 = (SOAPElement)this.getParentElement(); object3 != null && !(object3 instanceof SOAPBody); object3 = (SOAPElement)((SOAPElement)object3).getParentElement()) {
                    }
                    SOAPBody sOAPBody = object3 == null ? null : (SOAPBody)object3;
                    p2DConverter.pushDEventProcessor(new WrapperProcessor(new AsSOAPElementProcessor(sOAPBuilder, sOAPBody)));
                } else {
                    p2DConverter.pushDEventProcessor(new WrapperProcessor(sOAPBuilder));
                }
                object3 = this.soapFactory.getMessageContext();
                boolean bl3 = bl2 = object3 != null && ((MessageContext)object3).getProperty(MessageContext.SAAJ_TRANSFORMATION) == null && (((MessageContext)object3).isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION) || log.isDebugEnabled() || !((MessageContext)object3).isHighFidelity() && (((MessageContext)object3).isRequestPath() && ((MessageContext)object3).isServer() || !((MessageContext)object3).isRequestPath() && !((MessageContext)object3).isServer()));
                if (bl2) {
                    object2 = new RuntimeException(Messages.getMessage("saajtransform00", string));
                    if (((MessageContext)object3).isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION)) {
                        throw object2;
                    }
                    if (((MessageContext)object3).getProperty(MessageContext.SAAJ_TRANSFORMATION) == null) {
                        ((MessageContext)object3).setProperty(MessageContext.SAAJ_TRANSFORMATION, object2);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(object2);
                    }
                }
                object2 = (SAAJ12Document)((Object)this.getOwnerDocument());
                boolean bl4 = object2.getErrorChecking();
                object2.setErrorChecking(false);
                p2DConverter.startDocument();
                if (!bl) {
                    alternateContentBase.detach();
                    webServicesParser.parse(inputSource, (DefaultHandler)p2DConverter);
                } else {
                    MappingScope mappingScope2 = this._getMappingScope();
                    object = this.getSAXAttributes();
                    this.altContent = null;
                    alternateContentBase.toEvents(p2DConverter, mappingScope2, (Attributes)object);
                }
                p2DConverter.endDocument();
                object2.setErrorChecking(bl4);
                p2DConverter.popDEventProcessor();
                if (!bl) {
                    webServicesParser.setProperty("http://xml.org/sax/properties/lexical-handler", null);
                    webServicesParser.recycle();
                    if (mappingScope != null) {
                        for (int i = 0; i < mappingScope.size(); ++i) {
                            object = mappingScope.get(i);
                            String string2 = ((Mapping)object).getPrefix();
                            if (string2 == null || string2.length() == 0) {
                                string2 = XMLNS;
                            }
                            String string3 = this.getAttributeNS("http://www.w3.org/2000/xmlns/", string2);
                            if (!((Mapping)object).getNamespaceURI().equals(string3)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("removing namespace declaration for " + string2 + " with namespace " + string3));
                            }
                            this.removeAttributeNS("http://www.w3.org/2000/xmlns/", string2);
                        }
                    }
                }
                this.setProtect(this.isProtect);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.asSOAPElement", (String)"1675", (Object)this);
                throw new InternalException(exception);
            }
            Object var20_22 = null;
            this.inAsSOAPElement = false;
            this.rebuildTagQName = false;
            this.rebuildAttributesAndMapping = false;
            deserializationContext.freeEventConverter();
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            this.inAsSOAPElement = false;
            this.rebuildTagQName = false;
            this.rebuildAttributesAndMapping = false;
            deserializationContext.freeEventConverter();
            throw throwable;
        }
    }

    private MappingScope _getStrippedMappingScope() {
        MappingScope mappingScope = null;
        Element element = this._getDOMElement();
        if (element != null || !this.altContent.affectsTagAttributes()) {
            MappingScope mappingScope2 = this._getMappingScope();
            if (mappingScope2.getParent() != null) {
                mappingScope = mappingScope2.getParent().flatten();
            }
            if (mappingScope != null) {
                for (int i = 0; i < mappingScope2.size(); ++i) {
                    Mapping mapping = mappingScope2.get(i);
                    mappingScope.removeMappingForPrefix(mapping.getPrefix());
                }
            }
        } else if (this.getParentElement() != null) {
            mappingScope = ((SOAPElement)this.getParentElement())._getMappingScope();
            mappingScope = mappingScope.flatten();
        }
        return mappingScope;
    }

    public final boolean isInAsSOAPElement() {
        return this.inAsSOAPElement;
    }

    public final boolean rebuildTagQName() {
        return this.rebuildTagQName && this.inAsSOAPElement;
    }

    public final boolean rebuildAttributesAndMapping() {
        return this.rebuildAttributesAndMapping && this.inAsSOAPElement;
    }

    public final Object asObject() throws Exception {
        QName qName = this.getType();
        if (qName == null) {
            qName = QNameTable.createQName(this.namespaceURI, ">" + this.getLocalName());
        }
        try {
            return this.asObject(qName);
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("exception01", JavaUtils.stackToString(exception)));
            }
            return this;
        }
    }

    private void removeChildren() {
        while (this.getFirstChild() != null) {
            this.removeChildNode((Node)this.getFirstChild());
        }
    }

    public final Object asObject(QName qName) throws Exception {
        if (this.isObjectContent()) {
            return this.getAlternateContent();
        }
        Object object = this.convertToObject(qName);
        this.removeChildren();
        if (this.altContent != null) {
            this.altContent.detach();
        }
        this.setAlternateContent(object);
        return object;
    }

    protected final QName getType() {
        SOAPElement sOAPElement;
        String string;
        this.asSOAPElement(CONTEXT_ATTRS);
        Attributes attributes = this.getSAXAttributes();
        QName qName = AttributeUtils.getTypeFromAttributes(this.getNamespaceURI(), this.getLocalName(), attributes, this._getMappingScope());
        if (attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
            qName = Constants.SOAP_ARRAY;
        }
        if (qName == null && this.soapFactory.getDeserializationContext() != null && (string = AttributeUtils.getHref(attributes)) != null && (sOAPElement = this.soapFactory.getDeserializationContext().getHrefTable().getElementByHref(string)) != null) {
            qName = sOAPElement.getType();
        }
        return qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object convertToObject(QName qName) throws Exception {
        if (this.soapFactory.getDeserializationContext() == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer deserializer = this.soapFactory.getDeserializationContext().getDeserializer(null, qName);
        if (deserializer == null) {
            throw new Exception(Messages.getMessage("noDeser00", EMPTY_STRING + qName));
        }
        DeserializationContext deserializationContext = this.soapFactory.getDeserializationContext();
        deserializationContext.createEventConverter(new WrapperProcessor(deserializer));
        P2DConverter p2DConverter = deserializationContext.getEventConverter();
        try {
            this.toEvents(p2DConverter);
        }
        finally {
            deserializationContext.freeEventConverter();
        }
        return deserializer.getValue();
    }

    protected boolean isObjectContent() throws Exception {
        return this.altContent != null && this.altContent.isBusinessObject();
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBuilder();
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        if (string == null || string.length() == 0) {
            return new SOAPElement(null, string2, sOAPFactory);
        }
        return new SOAPElement(string, string2, sOAPFactory);
    }

    protected boolean isValidSAAJChild(org.w3c.dom.Node node) {
        Class<?> clazz = node.getClass();
        return (clazz.equals(SOAPElement.class) || clazz.equals(Text.class) || clazz.equals(Comment.class) || clazz.equals(SAAJ12Text.class)) && this.getOwnerDocument() == node.getOwnerDocument();
    }

    public final void setProtect(boolean bl) {
        this.isProtect = bl;
        if (this.getAlternateContent() == null) {
            for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof SOAPElement)) continue;
                SOAPElement sOAPElement = (SOAPElement)((Object)node);
                if (sOAPElement.isProtect == bl) continue;
                sOAPElement.setProtect(bl);
            }
        }
    }

    private final Node wrapChildDOMNode(org.w3c.dom.Node node) {
        if (node instanceof CharacterData) {
            String string = ((CharacterData)node).getNodeValue();
            if (SAAJ12Text.isCommentValue(string)) {
                return new Comment((SAAJ12Document)this.ownerDocument, string);
            }
            return new Text((SAAJ12Document)this.ownerDocument, string);
        }
        try {
            SOAPElement sOAPElement = this.createChildElement(node.getNamespaceURI(), node.getLocalName() == null || node.getLocalName().length() == 0 ? node.getNodeName() : node.getLocalName(), this.soapFactory);
            sOAPElement.setPrefix(node.getPrefix());
            sOAPElement.setAlternateContent(node);
            return sOAPElement;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.wrapChildDOMNode", (String)"2799", (Object)this);
            throw new RuntimeException(sOAPException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    public Object getAlternateContent() {
        return this.altContent == null ? null : this.altContent.getContent();
    }

    public final SOAPFactory getSOAPFactory() {
        return this.soapFactory;
    }

    public final IBMSOAPFactory getIBMSOAPFactory() {
        return this.getSOAPFactory();
    }

    public final void setQName(String string, String string2) {
        String string3 = SOAPElement.extractLocalNameFromQName(string2);
        this.namespaceURI = string;
        this.localName = string3;
        this.setPrefix(SOAPElement.extractPrefixFromQName(string2));
    }

    public final QName getQName() {
        return QNameTable.createQName(this.getNamespaceURI(), this.getLocalName());
    }

    public final void addAttribute(String string, String string2, String string3) {
        this.addAttribute(string, null, string2, string3);
    }

    public final void addAttribute(String string, String string2, String string3, String string4) {
        this.asSOAPElement(CONTEXT_ATTRS);
        ProtectionChecker.protectionCheck_changeAttributes(this);
        if (string == null) {
            this.setAttribute(string3, string4);
        } else {
            if (string2 == null || string2.length() == 0) {
                if (string.equals("http://www.w3.org/2000/xmlns/")) {
                    string2 = XMLNS;
                    if (string3.equals(XMLNS)) {
                        string2 = EMPTY_STRING;
                    }
                } else if (string2 == null) {
                    string2 = this._getMappingScope().getOrCreatePrefix(string, null, true);
                }
            }
            String string5 = string2.length() > 0 ? string2 + ":" + string3 : string3;
            this.setAttributeNS(string, string5, string4);
        }
    }

    public final Iterator getChildElements(String string, String string2) {
        this.asSOAPElement(CONTEXT_CONTENT);
        if (string == null) {
            string = EMPTY_STRING;
        }
        ArrayList<javax.xml.soap.SOAPElement> arrayList = new ArrayList<javax.xml.soap.SOAPElement>();
        for (org.w3c.dom.Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof javax.xml.soap.SOAPElement)) continue;
            javax.xml.soap.SOAPElement sOAPElement = (javax.xml.soap.SOAPElement)node;
            String string3 = sOAPElement.getNamespaceURI();
            String string4 = sOAPElement.getLocalName();
            if (string3 == null) {
                string3 = EMPTY_STRING;
            }
            if (string4 == null) {
                string4 = SOAPElement.extractLocalNameFromQName(sOAPElement.getNodeName());
            }
            if (!string.equals(string3) || !string2.equals(string4)) continue;
            arrayList.add(sOAPElement);
        }
        return arrayList.iterator();
    }

    private final Element _getDOMElement() {
        return this.altContent == null ? null : this.altContent.getDOMElement();
    }

    protected final SAAJ12Document getSAAJ12Document() {
        return (SAAJ12Document)this.ownerDocument;
    }

    final Attr importAttr(Attr attr) {
        Document document;
        Document document2 = this.getOwnerDocument();
        if (!document2.equals(document = attr.getOwnerDocument())) {
            attr = (Attr)document2.importNode(attr, true);
        }
        return attr;
    }

    protected final MappingScope _getMappingScope() {
        return this._getMappingScope(true, true);
    }

    protected final MappingScope _getMappingScope(boolean bl, boolean bl2) {
        this.asSOAPElement(CONTEXT_TAG);
        MappingScope mappingScope = this._getMappingScopeInternal(bl2);
        if (!bl) {
            mappingScope = (MappingScope)mappingScope.clone();
            mappingScope.setParent(null);
        }
        return mappingScope;
    }

    protected final MappingScope _getMappingScopeInternal(boolean bl) {
        SOAPElement sOAPElement;
        MappingScope mappingScope = null;
        mappingScope = this.validMappingScope ? this._getCachedMappingScope() : this._getDynamicMappingScope();
        MappingScope mappingScope2 = mappingScope;
        SOAPElement sOAPElement2 = this;
        while (sOAPElement2 != null) {
            sOAPElement = (SOAPElement)sOAPElement2.getParentElement();
            MappingScope mappingScope3 = null;
            if (sOAPElement != null) {
                mappingScope3 = sOAPElement.validMappingScope ? sOAPElement._getCachedMappingScope() : sOAPElement._getDynamicMappingScope();
            }
            mappingScope2.setParent(mappingScope3);
            sOAPElement2 = sOAPElement;
            mappingScope2 = mappingScope3;
        }
        if (bl) {
            sOAPElement = (SOAPElement)this.getParentElement();
            if (sOAPElement != null && sOAPElement.getParentElement() == null && this == sOAPElement.getFirstChild() && this == sOAPElement.getLastChild()) {
                sOAPElement._addImplicitNamespaces(mappingScope.getParent());
                sOAPElement._addImplicitNamespacesForAttrs(mappingScope.getParent());
            }
            this._addImplicitNamespaces(mappingScope);
            this._addImplicitNamespacesForAttrs(mappingScope);
        }
        return mappingScope;
    }

    protected final MappingScope _getCachedMappingScope() {
        MappingScope mappingScope;
        if (this.mappingScope == null) {
            this.mappingScope = new MappingScope();
        }
        if ((mappingScope = this.mappingScope).isReadOnly()) {
            mappingScope = (MappingScope)mappingScope.clone();
        }
        return mappingScope;
    }

    protected final MappingScope _getDynamicMappingScope() {
        MappingScope mappingScope = new MappingScope();
        NamedNodeMap namedNodeMap = this.getAttributes();
        boolean bl = true;
        for (int i = this.findIndex(XMLNS, namedNodeMap); i < namedNodeMap.getLength() && bl; ++i) {
            String string = ((Attr)namedNodeMap.item(i)).getNodeName();
            if (!string.startsWith(XMLNS)) {
                bl = false;
            }
            String string2 = ((Attr)namedNodeMap.item(i)).getNamespaceURI();
            String string3 = ((Attr)namedNodeMap.item(i)).getValue();
            if ("http://www.w3.org/2000/xmlns/" == string2 || "http://www.w3.org/2000/xmlns/".equals(string2)) {
                String string4 = namedNodeMap.item(i).getLocalName();
                if (string4.equals(XMLNS)) {
                    string4 = EMPTY_STRING;
                }
                mappingScope.addMapping(string3, string4);
                continue;
            }
            if (string == XMLNS || string.equals(XMLNS)) {
                mappingScope.addMapping(string3, EMPTY_STRING);
                continue;
            }
            if (!string.startsWith(XMLNS_COLON)) continue;
            mappingScope.addMapping(string3, string.substring(XMLNS_COLON.length()));
        }
        return mappingScope;
    }

    protected final void _addImplicitNamespaces(MappingScope mappingScope) {
        String string = this.getNamespaceURI();
        String string2 = this.getPrefix();
        boolean bl = false;
        if (string == null || string.length() == 0) {
            Mapping mapping = mappingScope.getMappingForPrefix(EMPTY_STRING, false);
            if (mapping != null && (mapping.getPrefix().length() != 0 || mapping.getNamespaceURI().length() != 0)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"adding implicit xmlns=\"\"");
                }
                mappingScope.addMapping(EMPTY_STRING, EMPTY_STRING);
                bl = true;
            }
        } else if (string2 == null) {
            Mapping mapping = mappingScope.getMappingForPrefix(EMPTY_STRING, false);
            if (mapping == null || mapping.getPrefix().length() != 0 || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding implicit xmlns=\"" + string + "\""));
                }
                mappingScope.addMapping(string, EMPTY_STRING);
                bl = true;
            }
        } else {
            Mapping mapping = mappingScope.getMappingForPrefix(string2, false);
            if (mapping == null || !mapping.getPrefix().equals(string2) || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding implicit xmlns:" + string2 + "=\"" + string + "\""));
                }
                mappingScope.addMapping(string, string2);
                bl = true;
            }
        }
        if (bl && !this.validMappingScope) {
            this.addNamespaceDeclaration(string2, string);
        }
    }

    protected final void _addImplicitNamespacesForAttrs(MappingScope mappingScope) {
        Attributes attributes = this.getSAXAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Mapping mapping;
            String string = attributes.getURI(i);
            if ("http://www.w3.org/2000/xmlns/" == string || "http://www.w3.org/2000/xmlns/".equals(string)) continue;
            boolean bl = false;
            if (string == null || string.length() == 0) continue;
            String string2 = EMPTY_STRING;
            int n = attributes.getQName(i).indexOf(58);
            if (n >= 0) {
                string2 = attributes.getQName(i).substring(0, n);
            }
            if (string2 == EMPTY_STRING) {
                mapping = mappingScope.getMappingForPrefix(EMPTY_STRING, false);
                if (mapping == null || mapping.getPrefix().length() != 0 || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding implicit xmlns=\"" + string + "\"" + " for attribute " + attributes.getQName(i)));
                    }
                    mappingScope.addMapping(string, EMPTY_STRING);
                    bl = true;
                }
            } else {
                mapping = mappingScope.getMappingForPrefix(string2, false);
                if (mapping == null || !mapping.getPrefix().equals(string2) || mapping.getNamespaceURI() != string && !mapping.getNamespaceURI().equals(string)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding implicit xmlns:" + string2 + "=\"" + string + "\"" + " for attribute " + attributes.getQName(i)));
                    }
                    mappingScope.addMapping(string, string2);
                    bl = true;
                }
            }
            if (!bl || this.validMappingScope) continue;
            this.addNamespaceDeclaration(string2, string);
        }
    }

    private void _invalidateMappingScope() {
        if (!this.validMappingScope) {
            return;
        }
        this.validMappingScope = false;
        this.setMappingScope(this.mappingScope);
        this.mappingScope = null;
    }

    private final int findIndex(String string, NamedNodeMap namedNodeMap) {
        int n = 0;
        int n2 = 0;
        int n3 = namedNodeMap.getLength() - 1;
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = string.compareTo(((Attr)namedNodeMap.item(n)).getNodeName());
            if (n4 == 0) {
                return n;
            }
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            n2 = n + 1;
        }
        if (n2 > n) {
            n = n2;
        } else if (n > namedNodeMap.getLength()) {
            n = namedNodeMap.getLength();
        }
        return n;
    }

    protected static String extractPrefixFromQName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    protected static String extractLocalNameFromQName(String string) {
        int n = string.indexOf(58);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public final String toXMLString() {
        return this.toXMLString(true);
    }

    public final String toXMLString(boolean bl) {
        try {
            return this.getAsString(bl);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toXMLString", (String)"3265", (Object)this);
            if (log.isDebugEnabled()) {
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            }
            throw new InternalException(exception);
        }
    }

    public InputSource toInputSource(boolean bl) throws SAXException {
        try {
            Object object;
            if (this.altContent != null && !bl && (object = this.altContent.getXMLInputSource()) != null) {
                return object;
            }
            object = this.toXMLString(bl);
            MessageContext messageContext = this.soapFactory.getMessageContext();
            Message message = messageContext != null ? messageContext.getCurrentMessage() : null;
            String string = message != null ? message.getCharacterEncoding() : null;
            byte[] byArray = SOAPPart.convertStringToBytes((String)object, string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            if (string != null) {
                inputSource.setEncoding(string);
            }
            return inputSource;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toInputSource", (String)"2999", (Object)this);
            throw new SAXException(exception);
        }
    }

    public javax.xml.soap.Name getNameFromText(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(58);
        String string2 = n == -1 ? EMPTY_STRING : string.substring(0, n);
        String string3 = n == -1 ? string : string.substring(n + 1);
        String string4 = this.getNamespaceURI(string2);
        if (string4 == null) {
            if (string2.length() > 0) {
                return null;
            }
            string4 = EMPTY_STRING;
        }
        return new Name(string4, string3, string2);
    }

    public String getTextFromName(javax.xml.soap.Name name2, boolean bl) {
        if (name2 == null) {
            return null;
        }
        String string = name2.getPrefix() == null ? EMPTY_STRING : name2.getPrefix();
        String string2 = name2.getURI() == null ? EMPTY_STRING : name2.getURI();
        String string3 = name2.getLocalName();
        if (bl) {
            string = string2.length() == 0 ? EMPTY_STRING : "ns" + string2.hashCode();
        }
        if (string2.length() == 0 && string.length() > 0) {
            return null;
        }
        String string4 = this.getNamespaceURI(string);
        if (!(string4 != null && string4.equals(string2) || string.length() == 0 && string4 == null && string2.length() == 0)) {
            this.addNamespaceDeclaration(string, string2);
        }
        if (string.length() == 0) {
            return string3;
        }
        return string + ":" + string3;
    }

    public javax.xml.soap.SOAPElement addSwaRefTextNode(String string, Object object) throws SOAPException {
        boolean bl;
        SOAPMessage sOAPMessage;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: addSwaRefTextNode(mimeType, attachment)");
        }
        MessageContext messageContext = this.soapFactory.getMessageContext();
        MessageContext messageContext2 = MessageContext.getCurrentThreadsContext();
        SOAPMessage sOAPMessage2 = sOAPMessage = messageContext != null ? messageContext.getMessage() : null;
        if (log.isDebugEnabled()) {
            if (messageContext != messageContext2) {
                log.debug((Object)"WARNING: This SOAPElement was created with a static SOAPFactory");
            }
            log.debug((Object)("msgContext.getMessage() is " + (sOAPMessage == null ? "null" : "not null")));
            log.debug((Object)("isServer=" + messageContext2.isServer()));
            log.debug((Object)("isInvokingTarget=" + messageContext2.isInvokingTarget()));
        }
        boolean bl2 = bl = sOAPMessage == null || messageContext != messageContext2 || messageContext.isServer() && messageContext.isInvokingTarget();
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a deferred attachment for " + string));
            }
            this.deferredMimeType = string;
            this.deferredAttachment = object;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: addSwaRefTextNode(mimeType, attachment)");
            }
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding an attachment on the message context for " + string));
        }
        javax.xml.soap.SOAPElement sOAPElement = this.addSwaRefTextNode(string, object, sOAPMessage);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: addSwaRefTextNode(mimeType, attachment)");
        }
        return sOAPElement;
    }

    private javax.xml.soap.SOAPElement addSwaRefTextNode(String string, Object object, SOAPMessage sOAPMessage) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: addSwaRefTextNode(mimeType, attachment, msg)");
            log.debug((Object)("mimeType=" + string));
        }
        DataHandler dataHandler = AttachmentUtils.dataHandlerForObject(string, object);
        Attachments attachments = ((Message)sOAPMessage).getAttachmentsImpl();
        try {
            Part part = attachments.createAttachmentPart(dataHandler);
            javax.xml.soap.SOAPElement sOAPElement = this.addTextNode(part.getContentIdRef());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: addSwaRefTextNode(mimeType, attachment, msg)");
            }
            return sOAPElement;
        }
        catch (WebServicesFault webServicesFault) {
            FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addSwaRefTextNode", (String)"2994", (Object)this);
            throw new SOAPException(webServicesFault.getMessage());
        }
    }

    public boolean isSwaRef() {
        try {
            this.getSwaRefAttachment();
            return true;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.isSwaRef", (String)"3026", (Object)this);
            return false;
        }
    }

    public Object getSwaRefAttachment() throws SOAPException {
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        MessageContext messageContext = this.soapFactory.getMessageContext();
        if (messageContext != null) {
            SOAPMessage sOAPMessage = messageContext.getMessage();
            return this.getSwaRefAttachment(sOAPMessage);
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    public Object getSwaRefAttachment(SOAPMessage sOAPMessage) throws SOAPException {
        String string;
        if (this.deferredAttachment != null) {
            return this.deferredAttachment;
        }
        if (sOAPMessage != null && (string = this.getValue()) != null) {
            Iterator iterator = sOAPMessage.getAttachments();
            while (iterator.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)iterator.next();
                if (!string.equals(attachmentPart.getContentIdRef())) continue;
                return AttachmentUtils.objectForDataHandler(attachmentPart.getDataHandler());
            }
        }
        throw new SOAPException(Messages.getMessage("notSwaRef00"));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.asSOAPElement(CONTEXT_TAG);
        this._invalidateMappingScope();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    class CEIterator
    implements Iterator {
        org.w3c.dom.Node parent;
        org.w3c.dom.Node prev;
        boolean first = true;
        boolean safeRemove = false;

        CEIterator(org.w3c.dom.Node node) {
            this.parent = node;
            this.prev = node;
        }

        public boolean hasNext() {
            if (this.prev == null) {
                return false;
            }
            if (this.first) {
                return this.prev.getFirstChild() != null;
            }
            return this.prev.getNextSibling() != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(Messages.getMessage("exception00"));
            }
            this.safeRemove = true;
            if (this.first) {
                this.prev = this.prev.getFirstChild();
                this.first = false;
            } else {
                this.prev = this.prev.getNextSibling();
            }
            return this.prev;
        }

        public void remove() {
            if (!this.safeRemove || this.prev == null) {
                throw new IllegalStateException(Messages.getMessage("exception00"));
            }
            this.safeRemove = false;
            org.w3c.dom.Node node = this.prev.getPreviousSibling();
            this.parent.removeChild(this.prev);
            if (node == null) {
                this.first = true;
                this.prev = this.parent;
            } else {
                this.prev = node;
            }
        }
    }
}

