/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Base64;
import com.ibm.ws.webservices.engine.utils.DOM2Writer;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.WebServicesParser;
import com.ibm.ws.webservices.engine.utils.WebServicesParserFactory;
import com.ibm.ws.webservices.engine.utils.XMLChar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static Log log = LogFactory.getLog(XMLUtils.class.getName());
    public static final String charEncoding = "ISO-8859-1";
    private static DocumentBuilderFactory dbf = XMLUtils.getDOMFactory();
    private static byte[] encodeTable = new byte[128];
    private static final char[] ReplacementText1;
    private static final char[] ReplacementText2;
    private static final char[] ReplacementText3;
    private static final char[] ReplacementText4;
    private static final char[] ReplacementText5;
    private static final char[] ReplacementText6;
    private static final char[] ReplacementText7;
    private static final char[] ReplacementText8;
    private static final char[][] replacementTextTable;
    private static final char[] nums;
    static WebServicesParserFactory parserFactory;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler;

    private static char[] expandCharArray(char[] cArray, int n) {
        char[] cArray2 = new char[Math.max(cArray.length * 2, n)];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    public static String xmlEncodeString(String string) {
        if (string == null) {
            return "";
        }
        return XMLUtils.xmlEncodeString(string, new char[string.length() * 2]);
    }

    public static String xmlEncodeString(String string, char[] cArray) {
        char c;
        int n;
        if (string == null) {
            return "";
        }
        int n2 = string.length();
        byte[] byArray = encodeTable;
        for (n = 0; n < n2 && (c = string.charAt(n)) <= '\u007f' && byArray[c] <= 0; ++n) {
        }
        if (n == n2) {
            return string;
        }
        return XMLUtils._xmlEncodeString(string.toCharArray(), n, cArray);
    }

    private static String _xmlEncodeString(char[] cArray, int n, char[] cArray2) {
        int n2 = cArray.length;
        int n3 = n;
        byte by = 0;
        int n4 = 0;
        int n5 = 0;
        char[] cArray3 = new char[8];
        if (n > 0) {
            System.arraycopy(cArray, 0, cArray2, 0, n);
            n4 += n;
        }
        while (n < n2) {
            char c = cArray[n];
            by = c > '\u007f' ? (byte)1 : encodeTable[c];
            if (by > 0) {
                if (n3 < n) {
                    n5 = n - n3;
                    if (cArray2.length < n4 + n5) {
                        cArray2 = XMLUtils.expandCharArray(cArray2, n4 + n5);
                    }
                    System.arraycopy(cArray, n3, cArray2, n4, n5);
                    n4 += n5;
                }
                n3 = n + 1;
                if (by == 1) {
                    cArray3[7] = 59;
                    int n6 = 7;
                    int n7 = 0;
                    for (int i = cArray[n]; i > 0; i /= 10) {
                        n7 = i % 10;
                        cArray3[--n6] = nums[n7];
                    }
                    if (cArray[n] < '\n') {
                        cArray3[--n6] = 48;
                    }
                    cArray3[--n6] = 35;
                    cArray3[--n6] = 38;
                    n5 = 8 - n6;
                    if (cArray2.length < n4 + n5) {
                        cArray2 = XMLUtils.expandCharArray(cArray2, n4 + n5);
                    }
                    System.arraycopy(cArray3, n6, cArray2, n4, n5);
                    n4 += n5;
                } else {
                    n5 = replacementTextTable[by].length;
                    if (cArray2.length < n4 + n5) {
                        cArray2 = XMLUtils.expandCharArray(cArray2, n4 + n5);
                    }
                    System.arraycopy(replacementTextTable[by], 0, cArray2, n4, n5);
                    n4 += n5;
                }
            }
            ++n;
        }
        if (n3 < n) {
            n5 = n - n3;
            if (cArray2.length < n4 + n5) {
                cArray2 = XMLUtils.expandCharArray(cArray2, n4 + n5);
            }
            System.arraycopy(cArray, n3, cArray2, n4, n5);
            n4 += n5;
        }
        return new String(cArray2, 0, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParserFactory initSAXFactory(boolean bl, boolean bl2) {
        if (parserFactory != null) {
            return parserFactory;
        }
        WebServicesParserFactory webServicesParserFactory = parserFactory = (WebServicesParserFactory)WebServicesParserFactory.newInstance();
        synchronized (webServicesParserFactory) {
            parserFactory.setNamespaceAware(bl);
            parserFactory.setValidating(bl2);
        }
        return parserFactory;
    }

    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.getDOMFactory", (String)"254");
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            documentBuilderFactory = null;
        }
        return documentBuilderFactory;
    }

    public static synchronized SAXParser getSAXParser() {
        try {
            SAXParserFactory sAXParserFactory = XMLUtils.initSAXFactory(true, false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            return sAXParser;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.getSAXParser", (String)"282");
            log.error((Object)Messages.getMessage("parserConfigurationException00", parserConfigurationException.toString()));
            return null;
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.getSAXParser", (String)"286");
            log.error((Object)Messages.getMessage("SAXException00", sAXException.toString()));
            return null;
        }
    }

    public static void releaseSAXParser(SAXParser sAXParser) {
        if (sAXParser instanceof WebServicesParser) {
            ((WebServicesParser)sAXParser).recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            return dbf.newDocumentBuilder().newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            documentBuilder = dbf.newDocumentBuilder();
        }
        documentBuilder.setErrorHandler(new ParserErrorHandler());
        return documentBuilder.parse(inputSource);
    }

    public static Document newDocument(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(new InputSource(inputStream));
    }

    public static Document newDocument(String string) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(string, null, null);
    }

    public static Document newDocument(String string, String string2, String string3) throws ParserConfigurationException, SAXException, IOException {
        InputSource inputSource = XMLUtils.getInputSourceFromURI(string, string2, string3);
        Document document = XMLUtils.newDocument(inputSource);
        if (inputSource.getByteStream() != null) {
            inputSource.getByteStream().close();
        } else if (inputSource.getCharacterStream() != null) {
            inputSource.getCharacterStream().close();
        }
        return document;
    }

    private static String privateElementToString(Element element, boolean bl) {
        return DOM2Writer.nodeToString(element, bl);
    }

    public static String ElementToString(Element element) {
        return XMLUtils.privateElementToString(element, true);
    }

    public static String DocumentToString(Document document) {
        return XMLUtils.privateElementToString(document.getDocumentElement(), false);
    }

    public static void privateElementToWriter(Element element, Writer writer, boolean bl, boolean bl2) {
        DOM2Writer.serializeAsXML(element, writer, bl, bl2);
    }

    public static void ElementToStream(Element element, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(element, outputStreamWriter, true, false);
    }

    public static void PrettyElementToStream(Element element, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(element, outputStreamWriter, true, true);
    }

    public static void ElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, false);
    }

    public static void PrettyElementToWriter(Element element, Writer writer) {
        XMLUtils.privateElementToWriter(element, writer, true, true);
    }

    public static void DocumentToStream(Document document, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), outputStreamWriter, false, false);
    }

    public static void PrettyDocumentToStream(Document document, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XMLUtils.privateElementToWriter(document.getDocumentElement(), outputStreamWriter, false, true);
    }

    public static void DocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, false);
    }

    public static void PrettyDocumentToWriter(Document document, Writer writer) {
        XMLUtils.privateElementToWriter(document.getDocumentElement(), writer, false, true);
    }

    public static Element StringToElement(String string, String string2, String string3) {
        try {
            Document document = XMLUtils.newDocument();
            Element element = document.createElementNS(string, string2);
            Text text = document.createTextNode(string3);
            element.appendChild(text);
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.StringToElement", (String)"475");
            throw new InternalException(parserConfigurationException);
        }
    }

    public static String getInnerXMLString(Element element) {
        String string = XMLUtils.ElementToString(element);
        int n = string.indexOf(">") + 1;
        int n2 = string.lastIndexOf("</");
        if (n2 > 0) {
            return string.substring(n, n2);
        }
        return null;
    }

    public static String getPrefix(String string, Node node) {
        while (node != null && node.getNodeType() == 1) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getName();
                if (!string2.startsWith("xmlns:") || !attr.getNodeValue().equals(string)) continue;
                return string2.substring(6);
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String string, Node node) {
        while (node != null && node.getNodeType() == 1) {
            Attr attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String string, Node node) {
        if (string == null || node == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = XMLUtils.getNamespace(string2, node);
            if (string3 == null) {
                return null;
            }
            return QNameTable.createQName(string3, string.substring(n + 1));
        }
        return QNameTable.createQName("", string);
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                }
            }
        }
        return stringBuffer.toString();
    }

    public static InputSource getInputSourceFromURI(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            try {
                File file = new File(string);
                return new InputSource(new FileInputStream(file));
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.getInputSourceFromURI", (String)"763");
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                return new InputSource(string);
            }
        }
        return new InputSource(string);
    }

    public static InputSource sourceToInputSource(Source source) {
        if (source instanceof SAXSource) {
            return ((SAXSource)source).getInputSource();
        }
        if (source instanceof DOMSource) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            Element element = (Element)node;
            XMLUtils.ElementToStream(element, byteArrayOutputStream);
            InputSource inputSource = new InputSource(source.getSystemId());
            inputSource.setByteStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            return inputSource;
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputSource inputSource = new InputSource(streamSource.getSystemId());
            inputSource.setByteStream(streamSource.getInputStream());
            inputSource.setCharacterStream(streamSource.getReader());
            inputSource.setPublicId(streamSource.getPublicId());
            return inputSource;
        }
        return XMLUtils.getInputSourceFromURI(source.getSystemId());
    }

    public static InputSource getInputSourceFromURI(String string, String string2, String string3) throws IOException, ProtocolException, UnsupportedEncodingException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            try {
                File file = new File(string);
                return new InputSource(new FileInputStream(file));
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.utils.XMLUtils.getInputSourceFromURI", (String)"835");
                log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                return new InputSource(string);
            }
        }
        if (string2 == null && uRL.getUserInfo() == null) {
            return new InputSource(string);
        }
        if (!uRL.getProtocol().startsWith("http")) {
            return new InputSource(string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (!(uRLConnection instanceof HttpURLConnection)) {
            return new InputSource(string);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        String string4 = uRL.getUserInfo();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setDefaultUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(false);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setUseCaches(false);
        String string5 = null;
        if (string4 != null) {
            string5 = string4;
        } else if (string2 != null) {
            String string6 = string5 = string3 == null ? string2 : string2 + ":" + string3;
        }
        if (string5 != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(string5.getBytes(charEncoding)));
        }
        String string7 = null;
        String string8 = null;
        boolean bl = false;
        if (string.startsWith("https")) {
            string7 = System.getProperty("https.proxyUserName");
            string8 = System.getProperty("https.proxyPassword");
            bl = true;
        } else if (string.startsWith("http")) {
            string7 = System.getProperty("http.proxyUserName");
            string8 = System.getProperty("http.proxyPassword");
            bl = true;
        }
        if (bl) {
            String string9 = new String(Base64.encode(new String(string7 + ":" + string8).getBytes()));
            httpURLConnection.setRequestProperty("Proxy-Authorization", "Basic " + string9);
        }
        httpURLConnection.connect();
        return new InputSource(httpURLConnection.getInputStream());
    }

    public static final String base64encode(byte[] byArray) {
        return new String(Base64.encode(byArray));
    }

    public static boolean isXMLWhitespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (XMLChar.isSpace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        XMLUtils.encodeTable[0] = 2;
        XMLUtils.encodeTable[12] = 1;
        XMLUtils.encodeTable[11] = 1;
        XMLUtils.encodeTable[8] = 1;
        XMLUtils.encodeTable[7] = 1;
        XMLUtils.encodeTable[6] = 1;
        XMLUtils.encodeTable[5] = 1;
        XMLUtils.encodeTable[4] = 1;
        XMLUtils.encodeTable[3] = 1;
        XMLUtils.encodeTable[2] = 1;
        XMLUtils.encodeTable[1] = 1;
        XMLUtils.encodeTable[13] = 3;
        XMLUtils.encodeTable[31] = 1;
        XMLUtils.encodeTable[30] = 1;
        XMLUtils.encodeTable[29] = 1;
        XMLUtils.encodeTable[28] = 1;
        XMLUtils.encodeTable[27] = 1;
        XMLUtils.encodeTable[26] = 1;
        XMLUtils.encodeTable[25] = 1;
        XMLUtils.encodeTable[24] = 1;
        XMLUtils.encodeTable[23] = 1;
        XMLUtils.encodeTable[22] = 1;
        XMLUtils.encodeTable[21] = 1;
        XMLUtils.encodeTable[20] = 1;
        XMLUtils.encodeTable[19] = 1;
        XMLUtils.encodeTable[18] = 1;
        XMLUtils.encodeTable[17] = 1;
        XMLUtils.encodeTable[16] = 1;
        XMLUtils.encodeTable[15] = 1;
        XMLUtils.encodeTable[14] = 1;
        XMLUtils.encodeTable[34] = 4;
        XMLUtils.encodeTable[38] = 5;
        XMLUtils.encodeTable[39] = 6;
        XMLUtils.encodeTable[60] = 7;
        XMLUtils.encodeTable[62] = 8;
        ReplacementText1 = new char[]{'&', '#'};
        ReplacementText2 = new char[]{'&', '#', '0', ';'};
        ReplacementText3 = new char[]{'&', '#', 'x', 'd', ';'};
        ReplacementText4 = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        ReplacementText5 = new char[]{'&', 'a', 'm', 'p', ';'};
        ReplacementText6 = new char[]{'&', 'a', 'p', 'o', 's', ';'};
        ReplacementText7 = new char[]{'&', 'l', 't', ';'};
        ReplacementText8 = new char[]{'&', 'g', 't', ';'};
        replacementTextTable = new char[][]{null, ReplacementText1, ReplacementText2, ReplacementText3, ReplacementText4, ReplacementText5, ReplacementText6, ReplacementText7, ReplacementText8};
        nums = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        parserFactory = null;
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler == null ? (class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler = XMLUtils.class$("com.ibm.ws.webservices.engine.utils.XMLUtils$ParserErrorHandler")) : class$com$ibm$ws$webservices$engine$utils$XMLUtils$ParserErrorHandler).getName());

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage("warning00", this.getParseExceptionInfo(sAXParseException)));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }
}

